/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link RawSubstanceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService RawSubstanceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultRawSubstanceServiceBatch
    extends
    BatchFluentHelperBasic<RawSubstanceServiceBatch, RawSubstanceServiceBatchChangeSet>
    implements
    RawSubstanceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultRawSubstanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRawSubstanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultRawSubstanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRawSubstanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultRawSubstanceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultRawSubstanceServiceBatchChangeSet(this, service);
    }

}
