/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate;

/**
 * Implementation of the {@link RawSubstanceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService RawSubstanceService}.
 *
 */
public class DefaultRawSubstanceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<RawSubstanceServiceBatch, RawSubstanceServiceBatchChangeSet>
    implements
    RawSubstanceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService service;

    @SuppressWarnings( "deprecation" )
    DefaultRawSubstanceServiceBatchChangeSet(
        @Nonnull final DefaultRawSubstanceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultRawSubstanceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createProduct( @Nonnull final Product product )
    {
        return addRequestCreate(service::createProduct, product);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet updateProduct( @Nonnull final Product product )
    {
        return addRequestUpdate(service::updateProduct, product);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestCreate(service::createProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet updateProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestUpdate(service::updateProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet deleteProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestDelete(service::deleteProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestCreate(service::createProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestUpdate(service::updateProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestCreate(service::createProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet updateProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestUpdate(service::updateProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestCreate(service::createProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet updateProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestUpdate(service::updateProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public RawSubstanceServiceBatchChangeSet createSpecAssignedMatlForKeyDate(
        @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate )
    {
        return addRequestCreate(service::createSpecAssignedMatlForKeyDate, specAssignedMatlForKeyDate);
    }

}
