/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RawSubstanceService RawSubstanceService}.
 *
 */
public interface RawSubstanceServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<RawSubstanceServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<RawSubstanceServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product Product} entity and
     * save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product Product} entity object
     *            that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet createProduct( @Nonnull final Product product );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product Product}
     * entity and save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.Product Product} entity object
     *            that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet updateProduct( @Nonnull final Product product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     *            ProductDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet createProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     *            ProductDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet updateProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     * ProductDescription} entity in the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription
     *            ProductDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet deleteProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant ProductPlant}
     * entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant ProductPlant}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant
     * ProductPlant} entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductPlant ProductPlant}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet
        createProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet
        updateProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet
        createProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet
        updateProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param specAssignedMatlForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate
     *            SpecAssignedMatlForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RawSubstanceServiceBatchChangeSet
        createSpecAssignedMatlForKeyDate( @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate );

}
