/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable.RawSubstanceSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance RawSubstance} to other entities.
 * Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods to compare
 * a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class RawSubstanceLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<RawSubstanceLink<ObjectT>, RawSubstance, ObjectT>
    implements
    RawSubstanceSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public RawSubstanceLink( final String fieldName )
    {
        super(fieldName);
    }

    private RawSubstanceLink( final EntityLink<RawSubstanceLink<ObjectT>, RawSubstance, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected RawSubstanceLink<ObjectT> translateLinkType(
        final EntityLink<RawSubstanceLink<ObjectT>, RawSubstance, ObjectT> link )
    {
        return new RawSubstanceLink<ObjectT>(link);
    }

}
