/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription ProductDescription}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.ProductDescriptionField
 * ProductDescriptionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.ProductDescriptionLink
 * ProductDescriptionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.ProductDescription#PRODUCT_DESCRIPTION
 * PRODUCT_DESCRIPTION}</li>
 * </ul>
 *
 */
public interface ProductDescriptionSelectable extends EntitySelectable<ProductDescription>
{

}
