/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance RawSubstance}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.RawSubstanceField
 * RawSubstanceField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.RawSubstanceLink
 * RawSubstanceLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_INTERNAL_ID
 * RAW_SUBSTANCE_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE
 * RAW_SUBSTANCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_AUTHZN_GROUP
 * RAW_SUBSTANCE_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CREATION_DATE
 * RAW_SUBSTANCE_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CREATED_BY_USER
 * RAW_SUBSTANCE_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CREATED_BY_USER_NAME
 * RAW_SUBSTANCE_CREATED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CHANGE_DATE
 * RAW_SUBSTANCE_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CHANGED_BY_USER
 * RAW_SUBSTANCE_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_CHANGED_BY_USER_NAME
 * RAW_SUBSTANCE_CHANGED_BY_USER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#RAW_SUBSTANCE_TYPE
 * RAW_SUBSTANCE_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#SPECIFICATION_CATEGORY
 * SPECIFICATION_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#SPECIFICATION_NOTE
 * SPECIFICATION_NOTE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#SPECIFICATION_HEADER_STATUS
 * SPECIFICATION_HEADER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#SPECIFICATION_HDR_STS_SCHEMA
 * SPECIFICATION_HDR_STS_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_ALLERGEN_COMP
 * TO_RAW_SUBSTANCE_ALLERGEN_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_AUTHZN_GROUP_TEXT
 * TO_RAW_SUBSTANCE_AUTHZN_GROUP_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_COMPONENT_TYPE
 * TO_RAW_SUBSTANCE_COMPONENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_CONVERSION_FACTOR
 * TO_RAW_SUBSTANCE_CONVERSION_FACTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_DENSITY
 * TO_RAW_SUBSTANCE_DENSITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_DIET_COMP
 * TO_RAW_SUBSTANCE_DIET_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_ESTIMATED_PRICE
 * TO_RAW_SUBSTANCE_ESTIMATED_PRICE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_GMO_COMP
 * TO_RAW_SUBSTANCE_GMO_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_IDENTIFIER
 * TO_RAW_SUBSTANCE_IDENTIFIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_MATL_ASSIGNMENT
 * TO_RAW_SUBSTANCE_MATL_ASSIGNMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_NEXT_STATUS
 * TO_RAW_SUBSTANCE_NEXT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_NTRNT_COMP
 * TO_RAW_SUBSTANCE_NTRNT_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_RELIGIOUS_COMP
 * TO_RAW_SUBSTANCE_RELIGIOUS_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_SCHEMA
 * TO_RAW_SUBSTANCE_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_STATUS_ATTRIBUTES
 * TO_RAW_SUBSTANCE_STATUS_ATTRIBUTES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_STD_COMP
 * TO_RAW_SUBSTANCE_STD_COMP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.RawSubstance#TO_RAW_SUBSTANCE_TOTAL_SOLID
 * TO_RAW_SUBSTANCE_TOTAL_SOLID}</li>
 * </ul>
 *
 */
public interface RawSubstanceSelectable extends EntitySelectable<RawSubstance>
{

}
