/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate
 * SpecAssignedMatlForKeyDate}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecAssignedMatlForKeyDateField
 * SpecAssignedMatlForKeyDateField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecAssignedMatlForKeyDateLink
 * SpecAssignedMatlForKeyDateLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_INTERNAL_ID
 * SPEC_MATERIAL_ASSGMT_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_CHANGE_STATE
 * SPEC_MATERIAL_ASSGMT_CHANGE_STATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#PLANT_NAME
 * PLANT_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_CHANGE_DATE
 * SPEC_MATERIAL_ASSGMT_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_CHANGE_NUMBER
 * SPEC_MATERIAL_ASSGMT_CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_CREATED_BY_USR
 * SPEC_MATERIAL_ASSGMT_CREATED_BY_USR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_CREATION_DATE
 * SPEC_MATERIAL_ASSGMT_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATERIAL_ASSGMT_IS_DELETED
 * SPEC_MATERIAL_ASSGMT_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATL_ASSGMT_LAST_CHANGED_BY_USR
 * SPEC_MATL_ASSGMT_LAST_CHANGED_BY_USR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATL_ASSGMT_VALDTY_END_DATE
 * SPEC_MATL_ASSGMT_VALDTY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPEC_MATL_ASSGMT_VALDTY_START_DATE
 * SPEC_MATL_ASSGMT_VALDTY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPECIFICATION_INTERNAL_ID
 * SPECIFICATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#TO_DESCRIPTION
 * TO_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#TO_PRODUCT
 * TO_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAssignedMatlForKeyDate#TO_PRODUCT_PLANT
 * TO_PRODUCT_PLANT}</li>
 * </ul>
 *
 */
public interface SpecAssignedMatlForKeyDateSelectable extends EntitySelectable<SpecAssignedMatlForKeyDate>
{

}
