/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAuthorizationGroupText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAuthorizationGroupText
 * SpecAuthorizationGroupText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecAuthorizationGroupTextField
 * SpecAuthorizationGroupTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecAuthorizationGroupTextLink
 * SpecAuthorizationGroupTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAuthorizationGroupText#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAuthorizationGroupText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecAuthorizationGroupText#SPECIFICATION_AUTHZN_GROUP_DESC
 * SPECIFICATION_AUTHZN_GROUP_DESC}</li>
 * </ul>
 *
 */
public interface SpecAuthorizationGroupTextSelectable extends EntitySelectable<SpecAuthorizationGroupText>
{

}
