/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst
 * SpecCharByValueAssgmtInst}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecCharByValueAssgmtInstField
 * SpecCharByValueAssgmtInstField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecCharByValueAssgmtInstLink
 * SpecCharByValueAssgmtInstLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPECIFICATION_INTERNAL_ID
 * SPECIFICATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_TYPE
 * SPEC_VAL_ASSGMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPECIFICATION_RATING
 * SPECIFICATION_RATING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPECIFICATION_VALIDITY_AREA
 * SPECIFICATION_VALIDITY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_HDR
 * SPEC_VAL_ASSGMT_HDR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT
 * SPEC_VAL_ASSGMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_IS_INHTNC_SOURCE
 * SPEC_VAL_ASSGMT_IS_INHTNC_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#INHTD_SPEC_VAL_ASSGMT_IS_TMP_CHGD
 * INHTD_SPEC_VAL_ASSGMT_IS_TMP_CHGD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#INHTD_SPEC_VAL_ASSGMT_IS_PERM_CHGD
 * INHTD_SPEC_VAL_ASSGMT_IS_PERM_CHGD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_INHERITANCE_TEMPLATE
 * SPEC_INHERITANCE_TEMPLATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_INHERITANCE_PARENT
 * SPEC_VAL_ASSGMT_INHERITANCE_PARENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_INHERITANCE_ROOT
 * SPEC_VAL_ASSGMT_INHERITANCE_ROOT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_ROOT_SPEC_INT_ID
 * SPEC_VAL_ASSGMT_ROOT_SPEC_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_SORT_SEQUENCE
 * SPEC_VAL_ASSGMT_SORT_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_UNIT_REF_DIMENSION
 * SPEC_VAL_ASSGMT_UNIT_REF_DIMENSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#VALUE_ASSIGNMENT_SOURCE
 * VALUE_ASSIGNMENT_SOURCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_USAGE_IS_EXCLUDED
 * SPEC_VAL_ASSGMT_USAGE_IS_EXCLUDED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_USAGE_IS_ACTIVE
 * SPEC_VAL_ASSGMT_USAGE_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPEC_VAL_ASSGMT_USAGE_IS_RELEVANT
 * SPEC_VAL_ASSGMT_USAGE_IS_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC
 * CHARACTERISTIC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_FORMAT
 * CHARACTERISTIC_FORMAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_VALUE
 * CHARACTERISTIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_DECIMAL_MINIMUM_VALUE
 * CHARC_DECIMAL_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_MINIMUM_VALUE_UNIT
 * CHARACTERISTIC_MINIMUM_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_DECIMAL_MAXIMUM_VALUE
 * CHARC_DECIMAL_MAXIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_MAXIMUM_VALUE_UNIT
 * CHARACTERISTIC_MAXIMUM_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_VALUE_DPNDCY_CODE
 * CHARACTERISTIC_VALUE_DPNDCY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_VALIDITY_START_DATE
 * CHARC_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_VALIDITY_END_DATE
 * CHARC_VALIDITY_END_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_IS_DELETED
 * CHARACTERISTIC_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_CURRENCY_MINIMUM_VALUE
 * CHARC_CURRENCY_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_FROM_AMOUNT
 * CHARC_FROM_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_TO_AMOUNT
 * CHARC_TO_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_VALUE_UNIT
 * CHARC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_DATE_MINIMUM_VALUE
 * CHARC_DATE_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_FROM_DATE
 * CHARC_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_TO_DATE
 * CHARC_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_TIME_MINIMUM_VALUE
 * CHARC_TIME_MINIMUM_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_FROM_TIME
 * CHARC_FROM_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARC_TO_TIME
 * CHARC_TO_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecCharByValueAssgmtInst#CHARACTERISTIC_INTERNAL_ID
 * CHARACTERISTIC_INTERNAL_ID}</li>
 * </ul>
 *
 */
public interface SpecCharByValueAssgmtInstSelectable extends EntitySelectable<SpecCharByValueAssgmtInst>
{

}
