/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier SpecIdentifier}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecIdentifierField
 * SpecIdentifierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecIdentifierLink SpecIdentifierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_INTERNAL_ID
 * SPEC_IDFG_DESC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_CHANGE_STATE
 * SPEC_IDFG_DESC_CHANGE_STATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPECIFICATION_INTERNAL_ID
 * SPECIFICATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_IS_DELETED
 * SPEC_IDFG_DESC_IS_DELETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_CREATED_BY_USER
 * SPEC_IDFG_DESC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_CREATION_DATE
 * SPEC_IDFG_DESC_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_LAST_CHANGED_BY_USER
 * SPEC_IDFG_DESC_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_LAST_CHANGE_DATE
 * SPEC_IDFG_DESC_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_SORT_SEQUENCE
 * SPEC_IDFG_DESC_SORT_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_CATEGORY
 * SPEC_IDFG_DESC_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_TYPE
 * SPEC_IDFG_DESC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_LANGUAGE
 * SPEC_IDFG_DESC_LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPEC_IDFG_DESC_TEXT
 * SPEC_IDFG_DESC_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecIdentifier#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * </ul>
 *
 */
public interface SpecIdentifierSelectable extends EntitySelectable<SpecIdentifier>
{

}
