/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus SpecStatusNextStatus}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecStatusNextStatusField
 * SpecStatusNextStatusField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecStatusNextStatusLink
 * SpecStatusNextStatusLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus#SPECIFICATION_HDR_STS_SCHEMA
 * SPECIFICATION_HDR_STS_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus#SPECIFICATION_HDR_STS_SCHEMA_FR_STS
 * SPECIFICATION_HDR_STS_SCHEMA_FR_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus#SPECIFICATION_HDR_STS_SCHEMA_TO_STS
 * SPECIFICATION_HDR_STS_SCHEMA_TO_STS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusNextStatus#TO_NEXT_STATUS_ATTRIBUTES
 * TO_NEXT_STATUS_ATTRIBUTES}</li>
 * </ul>
 *
 */
public interface SpecStatusNextStatusSelectable extends EntitySelectable<SpecStatusNextStatus>
{

}
