/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema SpecStatusSchema}. This
 * interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecStatusSchemaField
 * SpecStatusSchemaField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecStatusSchemaLink
 * SpecStatusSchemaLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema#SPECIFICATION_HDR_STS_SCHEMA
 * SPECIFICATION_HDR_STS_SCHEMA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecStatusSchema#SPECIFICATION_HDR_STS_DFLT_SCHEMA
 * SPECIFICATION_HDR_STS_DFLT_SCHEMA}</li>
 * </ul>
 *
 */
public interface SpecStatusSchemaSelectable extends EntitySelectable<SpecStatusSchema>
{

}
