/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp
 * SpecValAssgmtInstanceWthComp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.field.SpecValAssgmtInstanceWthCompField
 * SpecValAssgmtInstanceWthCompField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.link.SpecValAssgmtInstanceWthCompLink
 * SpecValAssgmtInstanceWthCompLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPECIFICATION_INTERNAL_ID
 * SPECIFICATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPEC_VAL_ASSGMT_TYPE
 * SPEC_VAL_ASSGMT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPECIFICATION_RATING
 * SPECIFICATION_RATING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPECIFICATION_VALIDITY_AREA
 * SPECIFICATION_VALIDITY_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMPONENT_SPECIFICATION_INT_ID
 * COMPONENT_SPECIFICATION_INT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMPONENT_SPECIFICATION
 * COMPONENT_SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_COMPONENT_TYPE
 * COMP_SPEC_COMPONENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_LOWER_LIMIT_OPERATOR
 * COMP_SPEC_LOWER_LIMIT_OPERATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_LOWER_LIMIT
 * COMP_SPEC_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_UPPER_LIMIT_OPERATOR
 * COMP_SPEC_UPPER_LIMIT_OPERATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_UPPER_LIMIT
 * COMP_SPEC_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_QUANTITY
 * COMP_SPEC_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_UNIT
 * COMP_SPEC_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_SORT_SEQUENCE
 * COMP_SPEC_SORT_SEQUENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#COMP_SPEC_EXCEPTION_CODE
 * COMP_SPEC_EXCEPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.rawsubstance.SpecValAssgmtInstanceWthComp#TO_SUBSTANCE_IDENTIFIER
 * TO_SUBSTANCE_IDENTIFIER}</li>
 * </ul>
 *
 */
public interface SpecValAssgmtInstanceWthCompSelectable extends EntitySelectable<SpecValAssgmtInstanceWthComp>
{

}
