/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.ProductStorageLocationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.ProductStorageLocationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Storage Location Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_ProductStorageLocationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProductStorageLocation extends VdmEntity<ProductStorageLocation>
{

    /**
     * Selector for all available fields of ProductStorageLocation.
     *
     */
    public final static ProductStorageLocationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Product" )
    @JsonProperty( "Product" )
    @Nullable
    @ODataField( odataName = "Product" )
    private String product;
    /**
     * Use with available fluent helpers to apply the <b>Product</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> PRODUCT =
        new ProductStorageLocationField<String>("Product");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> PLANT = new ProductStorageLocationField<String>("Plant");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @return Storage Location
     */
    @Key
    @SerializedName( "StorageLocation" )
    @JsonProperty( "StorageLocation" )
    @Nullable
    @ODataField( odataName = "StorageLocation" )
    private String storageLocation;
    /**
     * Use with available fluent helpers to apply the <b>StorageLocation</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> STORAGE_LOCATION =
        new ProductStorageLocationField<String>("StorageLocation");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageBin</b>
     * </p>
     *
     * @return Storage Bin
     */
    @SerializedName( "WarehouseStorageBin" )
    @JsonProperty( "WarehouseStorageBin" )
    @Nullable
    @ODataField( odataName = "WarehouseStorageBin" )
    private String warehouseStorageBin;
    /**
     * Use with available fluent helpers to apply the <b>WarehouseStorageBin</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> WAREHOUSE_STORAGE_BIN =
        new ProductStorageLocationField<String>("WarehouseStorageBin");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStatus</b>
     * </p>
     *
     * @return Maintenance status
     */
    @SerializedName( "MaintenanceStatus" )
    @JsonProperty( "MaintenanceStatus" )
    @Nullable
    @ODataField( odataName = "MaintenanceStatus" )
    private String maintenanceStatus;
    /**
     * Use with available fluent helpers to apply the <b>MaintenanceStatus</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> MAINTENANCE_STATUS =
        new ProductStorageLocationField<String>("MaintenanceStatus");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryBlockInd</b>
     * </p>
     *
     * @return Physical Inventory Blocking Indicator
     */
    @SerializedName( "PhysicalInventoryBlockInd" )
    @JsonProperty( "PhysicalInventoryBlockInd" )
    @Nullable
    @ODataField( odataName = "PhysicalInventoryBlockInd" )
    private String physicalInventoryBlockInd;
    /**
     * Use with available fluent helpers to apply the <b>PhysicalInventoryBlockInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> PHYSICAL_INVENTORY_BLOCK_IND =
        new ProductStorageLocationField<String>("PhysicalInventoryBlockInd");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<LocalDateTime> CREATION_DATE =
        new ProductStorageLocationField<LocalDateTime>("CreationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Flag Material for Deletion at Storage Location Level
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<Boolean> IS_MARKED_FOR_DELETION =
        new ProductStorageLocationField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DateOfLastPostedCntUnRstrcdStk</b>
     * </p>
     *
     * @return Date of Last Posted Count
     */
    @SerializedName( "DateOfLastPostedCntUnRstrcdStk" )
    @JsonProperty( "DateOfLastPostedCntUnRstrcdStk" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DateOfLastPostedCntUnRstrcdStk",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime dateOfLastPostedCntUnRstrcdStk;
    /**
     * Use with available fluent helpers to apply the <b>DateOfLastPostedCntUnRstrcdStk</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<LocalDateTime> DATE_OF_LAST_POSTED_CNT_UN_RSTRCD_STK =
        new ProductStorageLocationField<LocalDateTime>("DateOfLastPostedCntUnRstrcdStk");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventoryCorrectionFactor</b>
     * </p>
     *
     * @return Inventory Correction Factor
     */
    @SerializedName( "InventoryCorrectionFactor" )
    @JsonProperty( "InventoryCorrectionFactor" )
    @Nullable
    @ODataField( odataName = "InventoryCorrectionFactor" )
    private Double inventoryCorrectionFactor;
    /**
     * Use with available fluent helpers to apply the <b>InventoryCorrectionFactor</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<Double> INVENTORY_CORRECTION_FACTOR =
        new ProductStorageLocationField<Double>("InventoryCorrectionFactor");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryRestrictedUseStockInd</b>
     * </p>
     *
     * @return Physical inventory indicator for restricted-use stock
     */
    @SerializedName( "InvtryRestrictedUseStockInd" )
    @JsonProperty( "InvtryRestrictedUseStockInd" )
    @Nullable
    @ODataField( odataName = "InvtryRestrictedUseStockInd" )
    private String invtryRestrictedUseStockInd;
    /**
     * Use with available fluent helpers to apply the <b>InvtryRestrictedUseStockInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVTRY_RESTRICTED_USE_STOCK_IND =
        new ProductStorageLocationField<String>("InvtryRestrictedUseStockInd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryCurrentYearStockInd</b>
     * </p>
     *
     * @return Physical inventory indicator for whse stock in current year
     */
    @SerializedName( "InvtryCurrentYearStockInd" )
    @JsonProperty( "InvtryCurrentYearStockInd" )
    @Nullable
    @ODataField( odataName = "InvtryCurrentYearStockInd" )
    private String invtryCurrentYearStockInd;
    /**
     * Use with available fluent helpers to apply the <b>InvtryCurrentYearStockInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVTRY_CURRENT_YEAR_STOCK_IND =
        new ProductStorageLocationField<String>("InvtryCurrentYearStockInd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryQualInspCurrentYrStkInd</b>
     * </p>
     *
     * @return Phys. inventory ind. f. stock in qual. insp. in current year
     */
    @SerializedName( "InvtryQualInspCurrentYrStkInd" )
    @JsonProperty( "InvtryQualInspCurrentYrStkInd" )
    @Nullable
    @ODataField( odataName = "InvtryQualInspCurrentYrStkInd" )
    private String invtryQualInspCurrentYrStkInd;
    /**
     * Use with available fluent helpers to apply the <b>InvtryQualInspCurrentYrStkInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVTRY_QUAL_INSP_CURRENT_YR_STK_IND =
        new ProductStorageLocationField<String>("InvtryQualInspCurrentYrStkInd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InventoryBlockStockInd</b>
     * </p>
     *
     * @return Physical inventory indicator for blocked stock
     */
    @SerializedName( "InventoryBlockStockInd" )
    @JsonProperty( "InventoryBlockStockInd" )
    @Nullable
    @ODataField( odataName = "InventoryBlockStockInd" )
    private String inventoryBlockStockInd;
    /**
     * Use with available fluent helpers to apply the <b>InventoryBlockStockInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVENTORY_BLOCK_STOCK_IND =
        new ProductStorageLocationField<String>("InventoryBlockStockInd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryRestStockPrevPeriodInd</b>
     * </p>
     *
     * @return Physical inventory ind. for restricted-use stock, prev.pd
     */
    @SerializedName( "InvtryRestStockPrevPeriodInd" )
    @JsonProperty( "InvtryRestStockPrevPeriodInd" )
    @Nullable
    @ODataField( odataName = "InvtryRestStockPrevPeriodInd" )
    private String invtryRestStockPrevPeriodInd;
    /**
     * Use with available fluent helpers to apply the <b>InvtryRestStockPrevPeriodInd</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVTRY_REST_STOCK_PREV_PERIOD_IND =
        new ProductStorageLocationField<String>("InvtryRestStockPrevPeriodInd");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockPrevPeriod</b>
     * </p>
     *
     * @return Physical inventory indicator for stock in previous year
     */
    @SerializedName( "InventoryStockPrevPeriod" )
    @JsonProperty( "InventoryStockPrevPeriod" )
    @Nullable
    @ODataField( odataName = "InventoryStockPrevPeriod" )
    private String inventoryStockPrevPeriod;
    /**
     * Use with available fluent helpers to apply the <b>InventoryStockPrevPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVENTORY_STOCK_PREV_PERIOD =
        new ProductStorageLocationField<String>("InventoryStockPrevPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryStockQltyInspPrevPeriod</b>
     * </p>
     *
     * @return Phys. inventory ind. f. stock in qual. insp. in prev. period
     */
    @SerializedName( "InvtryStockQltyInspPrevPeriod" )
    @JsonProperty( "InvtryStockQltyInspPrevPeriod" )
    @Nullable
    @ODataField( odataName = "InvtryStockQltyInspPrevPeriod" )
    private String invtryStockQltyInspPrevPeriod;
    /**
     * Use with available fluent helpers to apply the <b>InvtryStockQltyInspPrevPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> INVTRY_STOCK_QLTY_INSP_PREV_PERIOD =
        new ProductStorageLocationField<String>("InvtryStockQltyInspPrevPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HasInvtryBlockStockPrevPeriod</b>
     * </p>
     *
     * @return Phys. inventory indicator for blocked stock in prev. period
     */
    @SerializedName( "HasInvtryBlockStockPrevPeriod" )
    @JsonProperty( "HasInvtryBlockStockPrevPeriod" )
    @Nullable
    @ODataField( odataName = "HasInvtryBlockStockPrevPeriod" )
    private String hasInvtryBlockStockPrevPeriod;
    /**
     * Use with available fluent helpers to apply the <b>HasInvtryBlockStockPrevPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> HAS_INVTRY_BLOCK_STOCK_PREV_PERIOD =
        new ProductStorageLocationField<String>("HasInvtryBlockStockPrevPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentPeriod</b>
     * </p>
     *
     * @return The fiscalYearCurrentPeriod contained in this entity.
     */
    @SerializedName( "FiscalYearCurrentPeriod" )
    @JsonProperty( "FiscalYearCurrentPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearCurrentPeriod" )
    private String fiscalYearCurrentPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearCurrentPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> FISCAL_YEAR_CURRENT_PERIOD =
        new ProductStorageLocationField<String>("FiscalYearCurrentPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalMonthCurrentPeriod</b>
     * </p>
     *
     * @return The fiscalMonthCurrentPeriod contained in this entity.
     */
    @SerializedName( "FiscalMonthCurrentPeriod" )
    @JsonProperty( "FiscalMonthCurrentPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalMonthCurrentPeriod" )
    private String fiscalMonthCurrentPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalMonthCurrentPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> FISCAL_MONTH_CURRENT_PERIOD =
        new ProductStorageLocationField<String>("FiscalMonthCurrentPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentInvtryPeriod</b>
     * </p>
     *
     * @return Fiscal year of current physical inventory indicator
     */
    @SerializedName( "FiscalYearCurrentInvtryPeriod" )
    @JsonProperty( "FiscalYearCurrentInvtryPeriod" )
    @Nullable
    @ODataField( odataName = "FiscalYearCurrentInvtryPeriod" )
    private String fiscalYearCurrentInvtryPeriod;
    /**
     * Use with available fluent helpers to apply the <b>FiscalYearCurrentInvtryPeriod</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> FISCAL_YEAR_CURRENT_INVTRY_PERIOD =
        new ProductStorageLocationField<String>("FiscalYearCurrentInvtryPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LeanWrhsManagementPickingArea</b>
     * </p>
     *
     * @return Picking area for lean WM
     */
    @SerializedName( "LeanWrhsManagementPickingArea" )
    @JsonProperty( "LeanWrhsManagementPickingArea" )
    @Nullable
    @ODataField( odataName = "LeanWrhsManagementPickingArea" )
    private String leanWrhsManagementPickingArea;
    /**
     * Use with available fluent helpers to apply the <b>LeanWrhsManagementPickingArea</b> field to query operations.
     *
     */
    public final static ProductStorageLocationField<String> LEAN_WRHS_MANAGEMENT_PICKING_AREA =
        new ProductStorageLocationField<String>("LeanWrhsManagementPickingArea");

    @Nonnull
    @Override
    public Class<ProductStorageLocation> getType()
    {
        return ProductStorageLocation.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Product</b>
     * </p>
     *
     * @param product
     *            Material Number
     */
    public void setProduct( @Nullable final String product )
    {
        rememberChangedField("Product", this.product);
        this.product = product;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>StorageLocation</b>
     * </p>
     *
     * @param storageLocation
     *            Storage Location
     */
    public void setStorageLocation( @Nullable final String storageLocation )
    {
        rememberChangedField("StorageLocation", this.storageLocation);
        this.storageLocation = storageLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>WarehouseStorageBin</b>
     * </p>
     *
     * @param warehouseStorageBin
     *            Storage Bin
     */
    public void setWarehouseStorageBin( @Nullable final String warehouseStorageBin )
    {
        rememberChangedField("WarehouseStorageBin", this.warehouseStorageBin);
        this.warehouseStorageBin = warehouseStorageBin;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>MaintenanceStatus</b>
     * </p>
     *
     * @param maintenanceStatus
     *            Maintenance status
     */
    public void setMaintenanceStatus( @Nullable final String maintenanceStatus )
    {
        rememberChangedField("MaintenanceStatus", this.maintenanceStatus);
        this.maintenanceStatus = maintenanceStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PhysicalInventoryBlockInd</b>
     * </p>
     *
     * @param physicalInventoryBlockInd
     *            Physical Inventory Blocking Indicator
     */
    public void setPhysicalInventoryBlockInd( @Nullable final String physicalInventoryBlockInd )
    {
        rememberChangedField("PhysicalInventoryBlockInd", this.physicalInventoryBlockInd);
        this.physicalInventoryBlockInd = physicalInventoryBlockInd;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Flag Material for Deletion at Storage Location Level
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DateOfLastPostedCntUnRstrcdStk</b>
     * </p>
     *
     * @param dateOfLastPostedCntUnRstrcdStk
     *            Date of Last Posted Count
     */
    public void setDateOfLastPostedCntUnRstrcdStk( @Nullable final LocalDateTime dateOfLastPostedCntUnRstrcdStk )
    {
        rememberChangedField("DateOfLastPostedCntUnRstrcdStk", this.dateOfLastPostedCntUnRstrcdStk);
        this.dateOfLastPostedCntUnRstrcdStk = dateOfLastPostedCntUnRstrcdStk;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InventoryCorrectionFactor</b>
     * </p>
     *
     * @param inventoryCorrectionFactor
     *            Inventory Correction Factor
     */
    public void setInventoryCorrectionFactor( @Nullable final Double inventoryCorrectionFactor )
    {
        rememberChangedField("InventoryCorrectionFactor", this.inventoryCorrectionFactor);
        this.inventoryCorrectionFactor = inventoryCorrectionFactor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryRestrictedUseStockInd</b>
     * </p>
     *
     * @param invtryRestrictedUseStockInd
     *            Physical inventory indicator for restricted-use stock
     */
    public void setInvtryRestrictedUseStockInd( @Nullable final String invtryRestrictedUseStockInd )
    {
        rememberChangedField("InvtryRestrictedUseStockInd", this.invtryRestrictedUseStockInd);
        this.invtryRestrictedUseStockInd = invtryRestrictedUseStockInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryCurrentYearStockInd</b>
     * </p>
     *
     * @param invtryCurrentYearStockInd
     *            Physical inventory indicator for whse stock in current year
     */
    public void setInvtryCurrentYearStockInd( @Nullable final String invtryCurrentYearStockInd )
    {
        rememberChangedField("InvtryCurrentYearStockInd", this.invtryCurrentYearStockInd);
        this.invtryCurrentYearStockInd = invtryCurrentYearStockInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryQualInspCurrentYrStkInd</b>
     * </p>
     *
     * @param invtryQualInspCurrentYrStkInd
     *            Phys. inventory ind. f. stock in qual. insp. in current year
     */
    public void setInvtryQualInspCurrentYrStkInd( @Nullable final String invtryQualInspCurrentYrStkInd )
    {
        rememberChangedField("InvtryQualInspCurrentYrStkInd", this.invtryQualInspCurrentYrStkInd);
        this.invtryQualInspCurrentYrStkInd = invtryQualInspCurrentYrStkInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InventoryBlockStockInd</b>
     * </p>
     *
     * @param inventoryBlockStockInd
     *            Physical inventory indicator for blocked stock
     */
    public void setInventoryBlockStockInd( @Nullable final String inventoryBlockStockInd )
    {
        rememberChangedField("InventoryBlockStockInd", this.inventoryBlockStockInd);
        this.inventoryBlockStockInd = inventoryBlockStockInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryRestStockPrevPeriodInd</b>
     * </p>
     *
     * @param invtryRestStockPrevPeriodInd
     *            Physical inventory ind. for restricted-use stock, prev.pd
     */
    public void setInvtryRestStockPrevPeriodInd( @Nullable final String invtryRestStockPrevPeriodInd )
    {
        rememberChangedField("InvtryRestStockPrevPeriodInd", this.invtryRestStockPrevPeriodInd);
        this.invtryRestStockPrevPeriodInd = invtryRestStockPrevPeriodInd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InventoryStockPrevPeriod</b>
     * </p>
     *
     * @param inventoryStockPrevPeriod
     *            Physical inventory indicator for stock in previous year
     */
    public void setInventoryStockPrevPeriod( @Nullable final String inventoryStockPrevPeriod )
    {
        rememberChangedField("InventoryStockPrevPeriod", this.inventoryStockPrevPeriod);
        this.inventoryStockPrevPeriod = inventoryStockPrevPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>InvtryStockQltyInspPrevPeriod</b>
     * </p>
     *
     * @param invtryStockQltyInspPrevPeriod
     *            Phys. inventory ind. f. stock in qual. insp. in prev. period
     */
    public void setInvtryStockQltyInspPrevPeriod( @Nullable final String invtryStockQltyInspPrevPeriod )
    {
        rememberChangedField("InvtryStockQltyInspPrevPeriod", this.invtryStockQltyInspPrevPeriod);
        this.invtryStockQltyInspPrevPeriod = invtryStockQltyInspPrevPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>HasInvtryBlockStockPrevPeriod</b>
     * </p>
     *
     * @param hasInvtryBlockStockPrevPeriod
     *            Phys. inventory indicator for blocked stock in prev. period
     */
    public void setHasInvtryBlockStockPrevPeriod( @Nullable final String hasInvtryBlockStockPrevPeriod )
    {
        rememberChangedField("HasInvtryBlockStockPrevPeriod", this.hasInvtryBlockStockPrevPeriod);
        this.hasInvtryBlockStockPrevPeriod = hasInvtryBlockStockPrevPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentPeriod</b>
     * </p>
     *
     * @param fiscalYearCurrentPeriod
     *            The fiscalYearCurrentPeriod to set.
     */
    public void setFiscalYearCurrentPeriod( @Nullable final String fiscalYearCurrentPeriod )
    {
        rememberChangedField("FiscalYearCurrentPeriod", this.fiscalYearCurrentPeriod);
        this.fiscalYearCurrentPeriod = fiscalYearCurrentPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FiscalMonthCurrentPeriod</b>
     * </p>
     *
     * @param fiscalMonthCurrentPeriod
     *            The fiscalMonthCurrentPeriod to set.
     */
    public void setFiscalMonthCurrentPeriod( @Nullable final String fiscalMonthCurrentPeriod )
    {
        rememberChangedField("FiscalMonthCurrentPeriod", this.fiscalMonthCurrentPeriod);
        this.fiscalMonthCurrentPeriod = fiscalMonthCurrentPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>FiscalYearCurrentInvtryPeriod</b>
     * </p>
     *
     * @param fiscalYearCurrentInvtryPeriod
     *            Fiscal year of current physical inventory indicator
     */
    public void setFiscalYearCurrentInvtryPeriod( @Nullable final String fiscalYearCurrentInvtryPeriod )
    {
        rememberChangedField("FiscalYearCurrentInvtryPeriod", this.fiscalYearCurrentInvtryPeriod);
        this.fiscalYearCurrentInvtryPeriod = fiscalYearCurrentInvtryPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LeanWrhsManagementPickingArea</b>
     * </p>
     *
     * @param leanWrhsManagementPickingArea
     *            Picking area for lean WM
     */
    public void setLeanWrhsManagementPickingArea( @Nullable final String leanWrhsManagementPickingArea )
    {
        rememberChangedField("LeanWrhsManagementPickingArea", this.leanWrhsManagementPickingArea);
        this.leanWrhsManagementPickingArea = leanWrhsManagementPickingArea;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_ProductStorageLocation";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Product", getProduct());
        result.put("Plant", getPlant());
        result.put("StorageLocation", getStorageLocation());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Product", getProduct());
        values.put("Plant", getPlant());
        values.put("StorageLocation", getStorageLocation());
        values.put("WarehouseStorageBin", getWarehouseStorageBin());
        values.put("MaintenanceStatus", getMaintenanceStatus());
        values.put("PhysicalInventoryBlockInd", getPhysicalInventoryBlockInd());
        values.put("CreationDate", getCreationDate());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("DateOfLastPostedCntUnRstrcdStk", getDateOfLastPostedCntUnRstrcdStk());
        values.put("InventoryCorrectionFactor", getInventoryCorrectionFactor());
        values.put("InvtryRestrictedUseStockInd", getInvtryRestrictedUseStockInd());
        values.put("InvtryCurrentYearStockInd", getInvtryCurrentYearStockInd());
        values.put("InvtryQualInspCurrentYrStkInd", getInvtryQualInspCurrentYrStkInd());
        values.put("InventoryBlockStockInd", getInventoryBlockStockInd());
        values.put("InvtryRestStockPrevPeriodInd", getInvtryRestStockPrevPeriodInd());
        values.put("InventoryStockPrevPeriod", getInventoryStockPrevPeriod());
        values.put("InvtryStockQltyInspPrevPeriod", getInvtryStockQltyInspPrevPeriod());
        values.put("HasInvtryBlockStockPrevPeriod", getHasInvtryBlockStockPrevPeriod());
        values.put("FiscalYearCurrentPeriod", getFiscalYearCurrentPeriod());
        values.put("FiscalMonthCurrentPeriod", getFiscalMonthCurrentPeriod());
        values.put("FiscalYearCurrentInvtryPeriod", getFiscalYearCurrentInvtryPeriod());
        values.put("LeanWrhsManagementPickingArea", getLeanWrhsManagementPickingArea());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Product") ) {
                final Object value = values.remove("Product");
                if( (value == null) || (!value.equals(getProduct())) ) {
                    setProduct(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("StorageLocation") ) {
                final Object value = values.remove("StorageLocation");
                if( (value == null) || (!value.equals(getStorageLocation())) ) {
                    setStorageLocation(((String) value));
                }
            }
            if( values.containsKey("WarehouseStorageBin") ) {
                final Object value = values.remove("WarehouseStorageBin");
                if( (value == null) || (!value.equals(getWarehouseStorageBin())) ) {
                    setWarehouseStorageBin(((String) value));
                }
            }
            if( values.containsKey("MaintenanceStatus") ) {
                final Object value = values.remove("MaintenanceStatus");
                if( (value == null) || (!value.equals(getMaintenanceStatus())) ) {
                    setMaintenanceStatus(((String) value));
                }
            }
            if( values.containsKey("PhysicalInventoryBlockInd") ) {
                final Object value = values.remove("PhysicalInventoryBlockInd");
                if( (value == null) || (!value.equals(getPhysicalInventoryBlockInd())) ) {
                    setPhysicalInventoryBlockInd(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("DateOfLastPostedCntUnRstrcdStk") ) {
                final Object value = values.remove("DateOfLastPostedCntUnRstrcdStk");
                if( (value == null) || (!value.equals(getDateOfLastPostedCntUnRstrcdStk())) ) {
                    setDateOfLastPostedCntUnRstrcdStk(((LocalDateTime) value));
                }
            }
            if( values.containsKey("InventoryCorrectionFactor") ) {
                final Object value = values.remove("InventoryCorrectionFactor");
                if( (value == null) || (!value.equals(getInventoryCorrectionFactor())) ) {
                    setInventoryCorrectionFactor(((Double) value));
                }
            }
            if( values.containsKey("InvtryRestrictedUseStockInd") ) {
                final Object value = values.remove("InvtryRestrictedUseStockInd");
                if( (value == null) || (!value.equals(getInvtryRestrictedUseStockInd())) ) {
                    setInvtryRestrictedUseStockInd(((String) value));
                }
            }
            if( values.containsKey("InvtryCurrentYearStockInd") ) {
                final Object value = values.remove("InvtryCurrentYearStockInd");
                if( (value == null) || (!value.equals(getInvtryCurrentYearStockInd())) ) {
                    setInvtryCurrentYearStockInd(((String) value));
                }
            }
            if( values.containsKey("InvtryQualInspCurrentYrStkInd") ) {
                final Object value = values.remove("InvtryQualInspCurrentYrStkInd");
                if( (value == null) || (!value.equals(getInvtryQualInspCurrentYrStkInd())) ) {
                    setInvtryQualInspCurrentYrStkInd(((String) value));
                }
            }
            if( values.containsKey("InventoryBlockStockInd") ) {
                final Object value = values.remove("InventoryBlockStockInd");
                if( (value == null) || (!value.equals(getInventoryBlockStockInd())) ) {
                    setInventoryBlockStockInd(((String) value));
                }
            }
            if( values.containsKey("InvtryRestStockPrevPeriodInd") ) {
                final Object value = values.remove("InvtryRestStockPrevPeriodInd");
                if( (value == null) || (!value.equals(getInvtryRestStockPrevPeriodInd())) ) {
                    setInvtryRestStockPrevPeriodInd(((String) value));
                }
            }
            if( values.containsKey("InventoryStockPrevPeriod") ) {
                final Object value = values.remove("InventoryStockPrevPeriod");
                if( (value == null) || (!value.equals(getInventoryStockPrevPeriod())) ) {
                    setInventoryStockPrevPeriod(((String) value));
                }
            }
            if( values.containsKey("InvtryStockQltyInspPrevPeriod") ) {
                final Object value = values.remove("InvtryStockQltyInspPrevPeriod");
                if( (value == null) || (!value.equals(getInvtryStockQltyInspPrevPeriod())) ) {
                    setInvtryStockQltyInspPrevPeriod(((String) value));
                }
            }
            if( values.containsKey("HasInvtryBlockStockPrevPeriod") ) {
                final Object value = values.remove("HasInvtryBlockStockPrevPeriod");
                if( (value == null) || (!value.equals(getHasInvtryBlockStockPrevPeriod())) ) {
                    setHasInvtryBlockStockPrevPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearCurrentPeriod") ) {
                final Object value = values.remove("FiscalYearCurrentPeriod");
                if( (value == null) || (!value.equals(getFiscalYearCurrentPeriod())) ) {
                    setFiscalYearCurrentPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalMonthCurrentPeriod") ) {
                final Object value = values.remove("FiscalMonthCurrentPeriod");
                if( (value == null) || (!value.equals(getFiscalMonthCurrentPeriod())) ) {
                    setFiscalMonthCurrentPeriod(((String) value));
                }
            }
            if( values.containsKey("FiscalYearCurrentInvtryPeriod") ) {
                final Object value = values.remove("FiscalYearCurrentInvtryPeriod");
                if( (value == null) || (!value.equals(getFiscalYearCurrentInvtryPeriod())) ) {
                    setFiscalYearCurrentInvtryPeriod(((String) value));
                }
            }
            if( values.containsKey("LeanWrhsManagementPickingArea") ) {
                final Object value = values.remove("LeanWrhsManagementPickingArea");
                if( (value == null) || (!value.equals(getLeanWrhsManagementPickingArea())) ) {
                    setLeanWrhsManagementPickingArea(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ProductStorageLocationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProductStorageLocationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProductStorageLocationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProductStorageLocationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

}
