/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.RealSubstanceField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.RealSubstanceLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.RealSubstanceSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Real Substance
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RealSubstanceType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RealSubstance extends VdmEntity<RealSubstance>
{

    /**
     * Selector for all available fields of RealSubstance.
     *
     */
    public final static RealSubstanceSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "RealSubstanceInternalID" )
    @JsonProperty( "RealSubstanceInternalID" )
    @Nullable
    @ODataField( odataName = "RealSubstanceInternalID" )
    private String realSubstanceInternalID;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceInternalID</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_INTERNAL_ID =
        new RealSubstanceField<String>("RealSubstanceInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstance</b>
     * </p>
     *
     * @return Specification
     */
    @SerializedName( "RealSubstance" )
    @JsonProperty( "RealSubstance" )
    @Nullable
    @ODataField( odataName = "RealSubstance" )
    private String realSubstance;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstance</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE = new RealSubstanceField<String>("RealSubstance");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceAuthznGroup</b>
     * </p>
     *
     * @return Description of Authorization Group
     */
    @SerializedName( "RealSubstanceAuthznGroup" )
    @JsonProperty( "RealSubstanceAuthznGroup" )
    @Nullable
    @ODataField( odataName = "RealSubstanceAuthznGroup" )
    private String realSubstanceAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceAuthznGroup</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_AUTHZN_GROUP =
        new RealSubstanceField<String>("RealSubstanceAuthznGroup");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "RealSubstanceCreationDate" )
    @JsonProperty( "RealSubstanceCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RealSubstanceCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime realSubstanceCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceCreationDate</b> field to query operations.
     *
     */
    public final static RealSubstanceField<LocalDateTime> REAL_SUBSTANCE_CREATION_DATE =
        new RealSubstanceField<LocalDateTime>("RealSubstanceCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreatedByUser</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "RealSubstanceCreatedByUser" )
    @JsonProperty( "RealSubstanceCreatedByUser" )
    @Nullable
    @ODataField( odataName = "RealSubstanceCreatedByUser" )
    private String realSubstanceCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceCreatedByUser</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_CREATED_BY_USER =
        new RealSubstanceField<String>("RealSubstanceCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreatedByUserName</b>
     * </p>
     *
     * @return Specification Header Created By Name
     */
    @SerializedName( "RealSubstanceCreatedByUserName" )
    @JsonProperty( "RealSubstanceCreatedByUserName" )
    @Nullable
    @ODataField( odataName = "RealSubstanceCreatedByUserName" )
    private String realSubstanceCreatedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceCreatedByUserName</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_CREATED_BY_USER_NAME =
        new RealSubstanceField<String>("RealSubstanceCreatedByUserName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangeDate</b>
     * </p>
     *
     * @return Changed On
     */
    @SerializedName( "RealSubstanceChangeDate" )
    @JsonProperty( "RealSubstanceChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RealSubstanceChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime realSubstanceChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceChangeDate</b> field to query operations.
     *
     */
    public final static RealSubstanceField<LocalDateTime> REAL_SUBSTANCE_CHANGE_DATE =
        new RealSubstanceField<LocalDateTime>("RealSubstanceChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "RealSubstanceChangedByUser" )
    @JsonProperty( "RealSubstanceChangedByUser" )
    @Nullable
    @ODataField( odataName = "RealSubstanceChangedByUser" )
    private String realSubstanceChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceChangedByUser</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_CHANGED_BY_USER =
        new RealSubstanceField<String>("RealSubstanceChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangedByUserName</b>
     * </p>
     *
     * @return Specification Changed By Name
     */
    @SerializedName( "RealSubstanceChangedByUserName" )
    @JsonProperty( "RealSubstanceChangedByUserName" )
    @Nullable
    @ODataField( odataName = "RealSubstanceChangedByUserName" )
    private String realSubstanceChangedByUserName;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceChangedByUserName</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_CHANGED_BY_USER_NAME =
        new RealSubstanceField<String>("RealSubstanceChangedByUserName");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "RealSubstanceType" )
    @JsonProperty( "RealSubstanceType" )
    @Nullable
    @ODataField( odataName = "RealSubstanceType" )
    private String realSubstanceType;
    /**
     * Use with available fluent helpers to apply the <b>RealSubstanceType</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> REAL_SUBSTANCE_TYPE =
        new RealSubstanceField<String>("RealSubstanceType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationCategory</b>
     * </p>
     *
     * @return Specification Category
     */
    @SerializedName( "SpecificationCategory" )
    @JsonProperty( "SpecificationCategory" )
    @Nullable
    @ODataField( odataName = "SpecificationCategory" )
    private String specificationCategory;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationCategory</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> SPECIFICATION_CATEGORY =
        new RealSubstanceField<String>("SpecificationCategory");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationNote</b>
     * </p>
     *
     * @return Note
     */
    @SerializedName( "SpecificationNote" )
    @JsonProperty( "SpecificationNote" )
    @Nullable
    @ODataField( odataName = "SpecificationNote" )
    private String specificationNote;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationNote</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> SPECIFICATION_NOTE =
        new RealSubstanceField<String>("SpecificationNote");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @return Status Identification
     */
    @SerializedName( "SpecificationHeaderStatus" )
    @JsonProperty( "SpecificationHeaderStatus" )
    @Nullable
    @ODataField( odataName = "SpecificationHeaderStatus" )
    private String specificationHeaderStatus;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHeaderStatus</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> SPECIFICATION_HEADER_STATUS =
        new RealSubstanceField<String>("SpecificationHeaderStatus");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @return Status Scheme
     */
    @SerializedName( "SpecificationHdrStsSchema" )
    @JsonProperty( "SpecificationHdrStsSchema" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchema" )
    private String specificationHdrStsSchema;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchema</b> field to query operations.
     *
     */
    public final static RealSubstanceField<String> SPECIFICATION_HDR_STS_SCHEMA =
        new RealSubstanceField<String>("SpecificationHdrStsSchema");
    /**
     * Navigation property <b>to_RealSubstanceAllergenComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceAllergenComp" )
    @JsonProperty( "to_RealSubstanceAllergenComp" )
    @ODataField( odataName = "to_RealSubstanceAllergenComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceAllergenComp;
    /**
     * Navigation property <b>to_RealSubstanceAuthznGroupText</b> for <b>RealSubstance</b> to multiple
     * <b>SpecAuthorizationGroupText</b>.
     *
     */
    @SerializedName( "to_RealSubstanceAuthznGroupText" )
    @JsonProperty( "to_RealSubstanceAuthznGroupText" )
    @ODataField( odataName = "to_RealSubstanceAuthznGroupText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecAuthorizationGroupText> toRealSubstanceAuthznGroupText;
    /**
     * Navigation property <b>to_RealSubstanceComponentType</b> for <b>RealSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RealSubstanceComponentType" )
    @JsonProperty( "to_RealSubstanceComponentType" )
    @ODataField( odataName = "to_RealSubstanceComponentType" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRealSubstanceComponentType;
    /**
     * Navigation property <b>to_RealSubstanceConversionFactor</b> for <b>RealSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RealSubstanceConversionFactor" )
    @JsonProperty( "to_RealSubstanceConversionFactor" )
    @ODataField( odataName = "to_RealSubstanceConversionFactor" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRealSubstanceConversionFactor;
    /**
     * Navigation property <b>to_RealSubstanceDensity</b> for <b>RealSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RealSubstanceDensity" )
    @JsonProperty( "to_RealSubstanceDensity" )
    @ODataField( odataName = "to_RealSubstanceDensity" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRealSubstanceDensity;
    /**
     * Navigation property <b>to_RealSubstanceDietComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceDietComp" )
    @JsonProperty( "to_RealSubstanceDietComp" )
    @ODataField( odataName = "to_RealSubstanceDietComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceDietComp;
    /**
     * Navigation property <b>to_RealSubstanceEstimatedPrice</b> for <b>RealSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RealSubstanceEstimatedPrice" )
    @JsonProperty( "to_RealSubstanceEstimatedPrice" )
    @ODataField( odataName = "to_RealSubstanceEstimatedPrice" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRealSubstanceEstimatedPrice;
    /**
     * Navigation property <b>to_RealSubstanceGMOComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceGMOComp" )
    @JsonProperty( "to_RealSubstanceGMOComp" )
    @ODataField( odataName = "to_RealSubstanceGMOComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceGMOComp;
    /**
     * Navigation property <b>to_RealSubstanceIdentifier</b> for <b>RealSubstance</b> to multiple <b>SpecIdentifier</b>.
     *
     */
    @SerializedName( "to_RealSubstanceIdentifier" )
    @JsonProperty( "to_RealSubstanceIdentifier" )
    @ODataField( odataName = "to_RealSubstanceIdentifier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecIdentifier> toRealSubstanceIdentifier;
    /**
     * Navigation property <b>to_RealSubstanceIngredientComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceIngredientComp" )
    @JsonProperty( "to_RealSubstanceIngredientComp" )
    @ODataField( odataName = "to_RealSubstanceIngredientComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceIngredientComp;
    /**
     * Navigation property <b>to_RealSubstanceMatlAssignment</b> for <b>RealSubstance</b> to multiple
     * <b>SpecAssignedMatlForKeyDate</b>.
     *
     */
    @SerializedName( "to_RealSubstanceMatlAssignment" )
    @JsonProperty( "to_RealSubstanceMatlAssignment" )
    @ODataField( odataName = "to_RealSubstanceMatlAssignment" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecAssignedMatlForKeyDate> toRealSubstanceMatlAssignment;
    /**
     * Navigation property <b>to_RealSubstanceNextStatus</b> for <b>RealSubstance</b> to multiple
     * <b>SpecStatusNextStatus</b>.
     *
     */
    @SerializedName( "to_RealSubstanceNextStatus" )
    @JsonProperty( "to_RealSubstanceNextStatus" )
    @ODataField( odataName = "to_RealSubstanceNextStatus" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusNextStatus> toRealSubstanceNextStatus;
    /**
     * Navigation property <b>to_RealSubstanceNtrntComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceNtrntComp" )
    @JsonProperty( "to_RealSubstanceNtrntComp" )
    @ODataField( odataName = "to_RealSubstanceNtrntComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceNtrntComp;
    /**
     * Navigation property <b>to_RealSubstanceReligiousComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceReligiousComp" )
    @JsonProperty( "to_RealSubstanceReligiousComp" )
    @ODataField( odataName = "to_RealSubstanceReligiousComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceReligiousComp;
    /**
     * Navigation property <b>to_RealSubstanceSchema</b> for <b>RealSubstance</b> to multiple <b>SpecStatusSchema</b>.
     *
     */
    @SerializedName( "to_RealSubstanceSchema" )
    @JsonProperty( "to_RealSubstanceSchema" )
    @ODataField( odataName = "to_RealSubstanceSchema" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusSchema> toRealSubstanceSchema;
    /**
     * Navigation property <b>to_RealSubstanceStatusAttributes</b> for <b>RealSubstance</b> to multiple
     * <b>SpecStatusAttributes</b>.
     *
     */
    @SerializedName( "to_RealSubstanceStatusAttributes" )
    @JsonProperty( "to_RealSubstanceStatusAttributes" )
    @ODataField( odataName = "to_RealSubstanceStatusAttributes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusAttributes> toRealSubstanceStatusAttributes;
    /**
     * Navigation property <b>to_RealSubstanceStdComp</b> for <b>RealSubstance</b> to multiple
     * <b>SpecValAssgmtInstanceWthComp</b>.
     *
     */
    @SerializedName( "to_RealSubstanceStdComp" )
    @JsonProperty( "to_RealSubstanceStdComp" )
    @ODataField( odataName = "to_RealSubstanceStdComp" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecValAssgmtInstanceWthComp> toRealSubstanceStdComp;
    /**
     * Navigation property <b>to_RealSubstanceTotalSolid</b> for <b>RealSubstance</b> to multiple
     * <b>SpecCharByValueAssgmtInst</b>.
     *
     */
    @SerializedName( "to_RealSubstanceTotalSolid" )
    @JsonProperty( "to_RealSubstanceTotalSolid" )
    @ODataField( odataName = "to_RealSubstanceTotalSolid" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecCharByValueAssgmtInst> toRealSubstanceTotalSolid;
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceAllergenComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_ALLERGEN_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceAllergenComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceAuthznGroupText</b> navigation property to
     * query operations.
     *
     */
    public final static RealSubstanceLink<SpecAuthorizationGroupText> TO_REAL_SUBSTANCE_AUTHZN_GROUP_TEXT =
        new RealSubstanceLink<SpecAuthorizationGroupText>("to_RealSubstanceAuthznGroupText");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceComponentType</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecCharByValueAssgmtInst> TO_REAL_SUBSTANCE_COMPONENT_TYPE =
        new RealSubstanceLink<SpecCharByValueAssgmtInst>("to_RealSubstanceComponentType");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceConversionFactor</b> navigation property to
     * query operations.
     *
     */
    public final static RealSubstanceLink<SpecCharByValueAssgmtInst> TO_REAL_SUBSTANCE_CONVERSION_FACTOR =
        new RealSubstanceLink<SpecCharByValueAssgmtInst>("to_RealSubstanceConversionFactor");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceDensity</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecCharByValueAssgmtInst> TO_REAL_SUBSTANCE_DENSITY =
        new RealSubstanceLink<SpecCharByValueAssgmtInst>("to_RealSubstanceDensity");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceDietComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_DIET_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceDietComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceEstimatedPrice</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecCharByValueAssgmtInst> TO_REAL_SUBSTANCE_ESTIMATED_PRICE =
        new RealSubstanceLink<SpecCharByValueAssgmtInst>("to_RealSubstanceEstimatedPrice");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceGMOComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_GMO_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceGMOComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceIdentifier</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecIdentifier> TO_REAL_SUBSTANCE_IDENTIFIER =
        new RealSubstanceLink<SpecIdentifier>("to_RealSubstanceIdentifier");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceIngredientComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_INGREDIENT_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceIngredientComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceMatlAssignment</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecAssignedMatlForKeyDate> TO_REAL_SUBSTANCE_MATL_ASSIGNMENT =
        new RealSubstanceLink<SpecAssignedMatlForKeyDate>("to_RealSubstanceMatlAssignment");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceNextStatus</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecStatusNextStatus> TO_REAL_SUBSTANCE_NEXT_STATUS =
        new RealSubstanceLink<SpecStatusNextStatus>("to_RealSubstanceNextStatus");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceNtrntComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_NTRNT_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceNtrntComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceReligiousComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_RELIGIOUS_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceReligiousComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceSchema</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecStatusSchema> TO_REAL_SUBSTANCE_SCHEMA =
        new RealSubstanceLink<SpecStatusSchema>("to_RealSubstanceSchema");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceStatusAttributes</b> navigation property to
     * query operations.
     *
     */
    public final static RealSubstanceLink<SpecStatusAttributes> TO_REAL_SUBSTANCE_STATUS_ATTRIBUTES =
        new RealSubstanceLink<SpecStatusAttributes>("to_RealSubstanceStatusAttributes");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceStdComp</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecValAssgmtInstanceWthComp> TO_REAL_SUBSTANCE_STD_COMP =
        new RealSubstanceLink<SpecValAssgmtInstanceWthComp>("to_RealSubstanceStdComp");
    /**
     * Use with available fluent helpers to apply the <b>to_RealSubstanceTotalSolid</b> navigation property to query
     * operations.
     *
     */
    public final static RealSubstanceLink<SpecCharByValueAssgmtInst> TO_REAL_SUBSTANCE_TOTAL_SOLID =
        new RealSubstanceLink<SpecCharByValueAssgmtInst>("to_RealSubstanceTotalSolid");

    @Nonnull
    @Override
    public Class<RealSubstance> getType()
    {
        return RealSubstance.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceInternalID</b>
     * </p>
     *
     * @param realSubstanceInternalID
     *            Sequential Number of Data Record
     */
    public void setRealSubstanceInternalID( @Nullable final String realSubstanceInternalID )
    {
        rememberChangedField("RealSubstanceInternalID", this.realSubstanceInternalID);
        this.realSubstanceInternalID = realSubstanceInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstance</b>
     * </p>
     *
     * @param realSubstance
     *            Specification
     */
    public void setRealSubstance( @Nullable final String realSubstance )
    {
        rememberChangedField("RealSubstance", this.realSubstance);
        this.realSubstance = realSubstance;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceAuthznGroup</b>
     * </p>
     *
     * @param realSubstanceAuthznGroup
     *            Description of Authorization Group
     */
    public void setRealSubstanceAuthznGroup( @Nullable final String realSubstanceAuthznGroup )
    {
        rememberChangedField("RealSubstanceAuthznGroup", this.realSubstanceAuthznGroup);
        this.realSubstanceAuthznGroup = realSubstanceAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreationDate</b>
     * </p>
     *
     * @param realSubstanceCreationDate
     *            Created On
     */
    public void setRealSubstanceCreationDate( @Nullable final LocalDateTime realSubstanceCreationDate )
    {
        rememberChangedField("RealSubstanceCreationDate", this.realSubstanceCreationDate);
        this.realSubstanceCreationDate = realSubstanceCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreatedByUser</b>
     * </p>
     *
     * @param realSubstanceCreatedByUser
     *            Created By
     */
    public void setRealSubstanceCreatedByUser( @Nullable final String realSubstanceCreatedByUser )
    {
        rememberChangedField("RealSubstanceCreatedByUser", this.realSubstanceCreatedByUser);
        this.realSubstanceCreatedByUser = realSubstanceCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceCreatedByUserName</b>
     * </p>
     *
     * @param realSubstanceCreatedByUserName
     *            Specification Header Created By Name
     */
    public void setRealSubstanceCreatedByUserName( @Nullable final String realSubstanceCreatedByUserName )
    {
        rememberChangedField("RealSubstanceCreatedByUserName", this.realSubstanceCreatedByUserName);
        this.realSubstanceCreatedByUserName = realSubstanceCreatedByUserName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangeDate</b>
     * </p>
     *
     * @param realSubstanceChangeDate
     *            Changed On
     */
    public void setRealSubstanceChangeDate( @Nullable final LocalDateTime realSubstanceChangeDate )
    {
        rememberChangedField("RealSubstanceChangeDate", this.realSubstanceChangeDate);
        this.realSubstanceChangeDate = realSubstanceChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangedByUser</b>
     * </p>
     *
     * @param realSubstanceChangedByUser
     *            Last Changed By
     */
    public void setRealSubstanceChangedByUser( @Nullable final String realSubstanceChangedByUser )
    {
        rememberChangedField("RealSubstanceChangedByUser", this.realSubstanceChangedByUser);
        this.realSubstanceChangedByUser = realSubstanceChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceChangedByUserName</b>
     * </p>
     *
     * @param realSubstanceChangedByUserName
     *            Specification Changed By Name
     */
    public void setRealSubstanceChangedByUserName( @Nullable final String realSubstanceChangedByUserName )
    {
        rememberChangedField("RealSubstanceChangedByUserName", this.realSubstanceChangedByUserName);
        this.realSubstanceChangedByUserName = realSubstanceChangedByUserName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RealSubstanceType</b>
     * </p>
     *
     * @param realSubstanceType
     *            Specification Type
     */
    public void setRealSubstanceType( @Nullable final String realSubstanceType )
    {
        rememberChangedField("RealSubstanceType", this.realSubstanceType);
        this.realSubstanceType = realSubstanceType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationCategory</b>
     * </p>
     *
     * @param specificationCategory
     *            Specification Category
     */
    public void setSpecificationCategory( @Nullable final String specificationCategory )
    {
        rememberChangedField("SpecificationCategory", this.specificationCategory);
        this.specificationCategory = specificationCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationNote</b>
     * </p>
     *
     * @param specificationNote
     *            Note
     */
    public void setSpecificationNote( @Nullable final String specificationNote )
    {
        rememberChangedField("SpecificationNote", this.specificationNote);
        this.specificationNote = specificationNote;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHeaderStatus</b>
     * </p>
     *
     * @param specificationHeaderStatus
     *            Status Identification
     */
    public void setSpecificationHeaderStatus( @Nullable final String specificationHeaderStatus )
    {
        rememberChangedField("SpecificationHeaderStatus", this.specificationHeaderStatus);
        this.specificationHeaderStatus = specificationHeaderStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     */
    public void setSpecificationHdrStsSchema( @Nullable final String specificationHdrStsSchema )
    {
        rememberChangedField("SpecificationHdrStsSchema", this.specificationHdrStsSchema);
        this.specificationHdrStsSchema = specificationHdrStsSchema;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RealSubstance";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RealSubstanceInternalID", getRealSubstanceInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RealSubstanceInternalID", getRealSubstanceInternalID());
        values.put("RealSubstance", getRealSubstance());
        values.put("RealSubstanceAuthznGroup", getRealSubstanceAuthznGroup());
        values.put("RealSubstanceCreationDate", getRealSubstanceCreationDate());
        values.put("RealSubstanceCreatedByUser", getRealSubstanceCreatedByUser());
        values.put("RealSubstanceCreatedByUserName", getRealSubstanceCreatedByUserName());
        values.put("RealSubstanceChangeDate", getRealSubstanceChangeDate());
        values.put("RealSubstanceChangedByUser", getRealSubstanceChangedByUser());
        values.put("RealSubstanceChangedByUserName", getRealSubstanceChangedByUserName());
        values.put("RealSubstanceType", getRealSubstanceType());
        values.put("SpecificationCategory", getSpecificationCategory());
        values.put("SpecificationNote", getSpecificationNote());
        values.put("SpecificationHeaderStatus", getSpecificationHeaderStatus());
        values.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RealSubstanceInternalID") ) {
                final Object value = values.remove("RealSubstanceInternalID");
                if( (value == null) || (!value.equals(getRealSubstanceInternalID())) ) {
                    setRealSubstanceInternalID(((String) value));
                }
            }
            if( values.containsKey("RealSubstance") ) {
                final Object value = values.remove("RealSubstance");
                if( (value == null) || (!value.equals(getRealSubstance())) ) {
                    setRealSubstance(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceAuthznGroup") ) {
                final Object value = values.remove("RealSubstanceAuthznGroup");
                if( (value == null) || (!value.equals(getRealSubstanceAuthznGroup())) ) {
                    setRealSubstanceAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceCreationDate") ) {
                final Object value = values.remove("RealSubstanceCreationDate");
                if( (value == null) || (!value.equals(getRealSubstanceCreationDate())) ) {
                    setRealSubstanceCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RealSubstanceCreatedByUser") ) {
                final Object value = values.remove("RealSubstanceCreatedByUser");
                if( (value == null) || (!value.equals(getRealSubstanceCreatedByUser())) ) {
                    setRealSubstanceCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceCreatedByUserName") ) {
                final Object value = values.remove("RealSubstanceCreatedByUserName");
                if( (value == null) || (!value.equals(getRealSubstanceCreatedByUserName())) ) {
                    setRealSubstanceCreatedByUserName(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceChangeDate") ) {
                final Object value = values.remove("RealSubstanceChangeDate");
                if( (value == null) || (!value.equals(getRealSubstanceChangeDate())) ) {
                    setRealSubstanceChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RealSubstanceChangedByUser") ) {
                final Object value = values.remove("RealSubstanceChangedByUser");
                if( (value == null) || (!value.equals(getRealSubstanceChangedByUser())) ) {
                    setRealSubstanceChangedByUser(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceChangedByUserName") ) {
                final Object value = values.remove("RealSubstanceChangedByUserName");
                if( (value == null) || (!value.equals(getRealSubstanceChangedByUserName())) ) {
                    setRealSubstanceChangedByUserName(((String) value));
                }
            }
            if( values.containsKey("RealSubstanceType") ) {
                final Object value = values.remove("RealSubstanceType");
                if( (value == null) || (!value.equals(getRealSubstanceType())) ) {
                    setRealSubstanceType(((String) value));
                }
            }
            if( values.containsKey("SpecificationCategory") ) {
                final Object value = values.remove("SpecificationCategory");
                if( (value == null) || (!value.equals(getSpecificationCategory())) ) {
                    setSpecificationCategory(((String) value));
                }
            }
            if( values.containsKey("SpecificationNote") ) {
                final Object value = values.remove("SpecificationNote");
                if( (value == null) || (!value.equals(getSpecificationNote())) ) {
                    setSpecificationNote(((String) value));
                }
            }
            if( values.containsKey("SpecificationHeaderStatus") ) {
                final Object value = values.remove("SpecificationHeaderStatus");
                if( (value == null) || (!value.equals(getSpecificationHeaderStatus())) ) {
                    setSpecificationHeaderStatus(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsSchema") ) {
                final Object value = values.remove("SpecificationHdrStsSchema");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchema())) ) {
                    setSpecificationHdrStsSchema(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RealSubstanceAllergenComp") ) {
                final Object value = (values).remove("to_RealSubstanceAllergenComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceAllergenComp == null ) {
                        toRealSubstanceAllergenComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceAllergenComp = Lists.newArrayList(toRealSubstanceAllergenComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceAllergenComp.size() > i ) {
                            entity = toRealSubstanceAllergenComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceAllergenComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceAuthznGroupText") ) {
                final Object value = (values).remove("to_RealSubstanceAuthznGroupText");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceAuthznGroupText == null ) {
                        toRealSubstanceAuthznGroupText = Lists.newArrayList();
                    } else {
                        toRealSubstanceAuthznGroupText = Lists.newArrayList(toRealSubstanceAuthznGroupText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecAuthorizationGroupText entity;
                        if( toRealSubstanceAuthznGroupText.size() > i ) {
                            entity = toRealSubstanceAuthznGroupText.get(i);
                        } else {
                            entity = new SpecAuthorizationGroupText();
                            toRealSubstanceAuthznGroupText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceComponentType") ) {
                final Object value = (values).remove("to_RealSubstanceComponentType");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceComponentType == null ) {
                        toRealSubstanceComponentType = Lists.newArrayList();
                    } else {
                        toRealSubstanceComponentType = Lists.newArrayList(toRealSubstanceComponentType);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRealSubstanceComponentType.size() > i ) {
                            entity = toRealSubstanceComponentType.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRealSubstanceComponentType.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceConversionFactor") ) {
                final Object value = (values).remove("to_RealSubstanceConversionFactor");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceConversionFactor == null ) {
                        toRealSubstanceConversionFactor = Lists.newArrayList();
                    } else {
                        toRealSubstanceConversionFactor = Lists.newArrayList(toRealSubstanceConversionFactor);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRealSubstanceConversionFactor.size() > i ) {
                            entity = toRealSubstanceConversionFactor.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRealSubstanceConversionFactor.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceDensity") ) {
                final Object value = (values).remove("to_RealSubstanceDensity");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceDensity == null ) {
                        toRealSubstanceDensity = Lists.newArrayList();
                    } else {
                        toRealSubstanceDensity = Lists.newArrayList(toRealSubstanceDensity);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRealSubstanceDensity.size() > i ) {
                            entity = toRealSubstanceDensity.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRealSubstanceDensity.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceDietComp") ) {
                final Object value = (values).remove("to_RealSubstanceDietComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceDietComp == null ) {
                        toRealSubstanceDietComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceDietComp = Lists.newArrayList(toRealSubstanceDietComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceDietComp.size() > i ) {
                            entity = toRealSubstanceDietComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceDietComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceEstimatedPrice") ) {
                final Object value = (values).remove("to_RealSubstanceEstimatedPrice");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceEstimatedPrice == null ) {
                        toRealSubstanceEstimatedPrice = Lists.newArrayList();
                    } else {
                        toRealSubstanceEstimatedPrice = Lists.newArrayList(toRealSubstanceEstimatedPrice);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRealSubstanceEstimatedPrice.size() > i ) {
                            entity = toRealSubstanceEstimatedPrice.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRealSubstanceEstimatedPrice.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceGMOComp") ) {
                final Object value = (values).remove("to_RealSubstanceGMOComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceGMOComp == null ) {
                        toRealSubstanceGMOComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceGMOComp = Lists.newArrayList(toRealSubstanceGMOComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceGMOComp.size() > i ) {
                            entity = toRealSubstanceGMOComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceGMOComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceIdentifier") ) {
                final Object value = (values).remove("to_RealSubstanceIdentifier");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceIdentifier == null ) {
                        toRealSubstanceIdentifier = Lists.newArrayList();
                    } else {
                        toRealSubstanceIdentifier = Lists.newArrayList(toRealSubstanceIdentifier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecIdentifier entity;
                        if( toRealSubstanceIdentifier.size() > i ) {
                            entity = toRealSubstanceIdentifier.get(i);
                        } else {
                            entity = new SpecIdentifier();
                            toRealSubstanceIdentifier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceIngredientComp") ) {
                final Object value = (values).remove("to_RealSubstanceIngredientComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceIngredientComp == null ) {
                        toRealSubstanceIngredientComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceIngredientComp = Lists.newArrayList(toRealSubstanceIngredientComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceIngredientComp.size() > i ) {
                            entity = toRealSubstanceIngredientComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceIngredientComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceMatlAssignment") ) {
                final Object value = (values).remove("to_RealSubstanceMatlAssignment");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceMatlAssignment == null ) {
                        toRealSubstanceMatlAssignment = Lists.newArrayList();
                    } else {
                        toRealSubstanceMatlAssignment = Lists.newArrayList(toRealSubstanceMatlAssignment);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecAssignedMatlForKeyDate entity;
                        if( toRealSubstanceMatlAssignment.size() > i ) {
                            entity = toRealSubstanceMatlAssignment.get(i);
                        } else {
                            entity = new SpecAssignedMatlForKeyDate();
                            toRealSubstanceMatlAssignment.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceNextStatus") ) {
                final Object value = (values).remove("to_RealSubstanceNextStatus");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceNextStatus == null ) {
                        toRealSubstanceNextStatus = Lists.newArrayList();
                    } else {
                        toRealSubstanceNextStatus = Lists.newArrayList(toRealSubstanceNextStatus);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusNextStatus entity;
                        if( toRealSubstanceNextStatus.size() > i ) {
                            entity = toRealSubstanceNextStatus.get(i);
                        } else {
                            entity = new SpecStatusNextStatus();
                            toRealSubstanceNextStatus.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceNtrntComp") ) {
                final Object value = (values).remove("to_RealSubstanceNtrntComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceNtrntComp == null ) {
                        toRealSubstanceNtrntComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceNtrntComp = Lists.newArrayList(toRealSubstanceNtrntComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceNtrntComp.size() > i ) {
                            entity = toRealSubstanceNtrntComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceNtrntComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceReligiousComp") ) {
                final Object value = (values).remove("to_RealSubstanceReligiousComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceReligiousComp == null ) {
                        toRealSubstanceReligiousComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceReligiousComp = Lists.newArrayList(toRealSubstanceReligiousComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceReligiousComp.size() > i ) {
                            entity = toRealSubstanceReligiousComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceReligiousComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceSchema") ) {
                final Object value = (values).remove("to_RealSubstanceSchema");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceSchema == null ) {
                        toRealSubstanceSchema = Lists.newArrayList();
                    } else {
                        toRealSubstanceSchema = Lists.newArrayList(toRealSubstanceSchema);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusSchema entity;
                        if( toRealSubstanceSchema.size() > i ) {
                            entity = toRealSubstanceSchema.get(i);
                        } else {
                            entity = new SpecStatusSchema();
                            toRealSubstanceSchema.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceStatusAttributes") ) {
                final Object value = (values).remove("to_RealSubstanceStatusAttributes");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceStatusAttributes == null ) {
                        toRealSubstanceStatusAttributes = Lists.newArrayList();
                    } else {
                        toRealSubstanceStatusAttributes = Lists.newArrayList(toRealSubstanceStatusAttributes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusAttributes entity;
                        if( toRealSubstanceStatusAttributes.size() > i ) {
                            entity = toRealSubstanceStatusAttributes.get(i);
                        } else {
                            entity = new SpecStatusAttributes();
                            toRealSubstanceStatusAttributes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceStdComp") ) {
                final Object value = (values).remove("to_RealSubstanceStdComp");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceStdComp == null ) {
                        toRealSubstanceStdComp = Lists.newArrayList();
                    } else {
                        toRealSubstanceStdComp = Lists.newArrayList(toRealSubstanceStdComp);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecValAssgmtInstanceWthComp entity;
                        if( toRealSubstanceStdComp.size() > i ) {
                            entity = toRealSubstanceStdComp.get(i);
                        } else {
                            entity = new SpecValAssgmtInstanceWthComp();
                            toRealSubstanceStdComp.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RealSubstanceTotalSolid") ) {
                final Object value = (values).remove("to_RealSubstanceTotalSolid");
                if( value instanceof Iterable ) {
                    if( toRealSubstanceTotalSolid == null ) {
                        toRealSubstanceTotalSolid = Lists.newArrayList();
                    } else {
                        toRealSubstanceTotalSolid = Lists.newArrayList(toRealSubstanceTotalSolid);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecCharByValueAssgmtInst entity;
                        if( toRealSubstanceTotalSolid.size() > i ) {
                            entity = toRealSubstanceTotalSolid.get(i);
                        } else {
                            entity = new SpecCharByValueAssgmtInst();
                            toRealSubstanceTotalSolid.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> RealSubstanceField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RealSubstanceField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RealSubstanceField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RealSubstanceField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRealSubstanceAllergenComp != null ) {
            (values).put("to_RealSubstanceAllergenComp", toRealSubstanceAllergenComp);
        }
        if( toRealSubstanceAuthznGroupText != null ) {
            (values).put("to_RealSubstanceAuthznGroupText", toRealSubstanceAuthznGroupText);
        }
        if( toRealSubstanceComponentType != null ) {
            (values).put("to_RealSubstanceComponentType", toRealSubstanceComponentType);
        }
        if( toRealSubstanceConversionFactor != null ) {
            (values).put("to_RealSubstanceConversionFactor", toRealSubstanceConversionFactor);
        }
        if( toRealSubstanceDensity != null ) {
            (values).put("to_RealSubstanceDensity", toRealSubstanceDensity);
        }
        if( toRealSubstanceDietComp != null ) {
            (values).put("to_RealSubstanceDietComp", toRealSubstanceDietComp);
        }
        if( toRealSubstanceEstimatedPrice != null ) {
            (values).put("to_RealSubstanceEstimatedPrice", toRealSubstanceEstimatedPrice);
        }
        if( toRealSubstanceGMOComp != null ) {
            (values).put("to_RealSubstanceGMOComp", toRealSubstanceGMOComp);
        }
        if( toRealSubstanceIdentifier != null ) {
            (values).put("to_RealSubstanceIdentifier", toRealSubstanceIdentifier);
        }
        if( toRealSubstanceIngredientComp != null ) {
            (values).put("to_RealSubstanceIngredientComp", toRealSubstanceIngredientComp);
        }
        if( toRealSubstanceMatlAssignment != null ) {
            (values).put("to_RealSubstanceMatlAssignment", toRealSubstanceMatlAssignment);
        }
        if( toRealSubstanceNextStatus != null ) {
            (values).put("to_RealSubstanceNextStatus", toRealSubstanceNextStatus);
        }
        if( toRealSubstanceNtrntComp != null ) {
            (values).put("to_RealSubstanceNtrntComp", toRealSubstanceNtrntComp);
        }
        if( toRealSubstanceReligiousComp != null ) {
            (values).put("to_RealSubstanceReligiousComp", toRealSubstanceReligiousComp);
        }
        if( toRealSubstanceSchema != null ) {
            (values).put("to_RealSubstanceSchema", toRealSubstanceSchema);
        }
        if( toRealSubstanceStatusAttributes != null ) {
            (values).put("to_RealSubstanceStatusAttributes", toRealSubstanceStatusAttributes);
        }
        if( toRealSubstanceStdComp != null ) {
            (values).put("to_RealSubstanceStdComp", toRealSubstanceStdComp);
        }
        if( toRealSubstanceTotalSolid != null ) {
            (values).put("to_RealSubstanceTotalSolid", toRealSubstanceTotalSolid);
        }
        return values;
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceAllergenComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceAllergenComp()
    {
        return fetchFieldAsList("to_RealSubstanceAllergenComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAllergenComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceAllergenCompOrFetch()
    {
        if( toRealSubstanceAllergenComp == null ) {
            toRealSubstanceAllergenComp = fetchRealSubstanceAllergenComp();
        }
        return toRealSubstanceAllergenComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceAllergenComp</b> is already loaded, the
     *         result will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceAllergenCompIfPresent()
    {
        return Option.of(toRealSubstanceAllergenComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAllergenComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceAllergenComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceAllergenComp == null ) {
            toRealSubstanceAllergenComp = Lists.newArrayList();
        }
        toRealSubstanceAllergenComp.clear();
        toRealSubstanceAllergenComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceAllergenComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAllergenComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceAllergenComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceAllergenComp == null ) {
            toRealSubstanceAllergenComp = Lists.newArrayList();
        }
        toRealSubstanceAllergenComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecAuthorizationGroupText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceAuthznGroupText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecAuthorizationGroupText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAuthorizationGroupText> fetchRealSubstanceAuthznGroupText()
    {
        return fetchFieldAsList("to_RealSubstanceAuthznGroupText", SpecAuthorizationGroupText.class);
    }

    /**
     * Retrieval of associated <b>SpecAuthorizationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAuthznGroupText</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecAuthorizationGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAuthorizationGroupText> getRealSubstanceAuthznGroupTextOrFetch()
    {
        if( toRealSubstanceAuthznGroupText == null ) {
            toRealSubstanceAuthznGroupText = fetchRealSubstanceAuthznGroupText();
        }
        return toRealSubstanceAuthznGroupText;
    }

    /**
     * Retrieval of associated <b>SpecAuthorizationGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceAuthznGroupText</b> is already loaded, the
     *         result will contain the <b>SpecAuthorizationGroupText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecAuthorizationGroupText>> getRealSubstanceAuthznGroupTextIfPresent()
    {
        return Option.of(toRealSubstanceAuthznGroupText);
    }

    /**
     * Overwrites the list of associated <b>SpecAuthorizationGroupText</b> entities for the loaded navigation property
     * <b>to_RealSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAuthznGroupText</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecAuthorizationGroupText</b> entities.
     */
    public void setRealSubstanceAuthznGroupText( @Nonnull final List<SpecAuthorizationGroupText> value )
    {
        if( toRealSubstanceAuthznGroupText == null ) {
            toRealSubstanceAuthznGroupText = Lists.newArrayList();
        }
        toRealSubstanceAuthznGroupText.clear();
        toRealSubstanceAuthznGroupText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecAuthorizationGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceAuthznGroupText</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceAuthznGroupText</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecAuthorizationGroupText</b> entities.
     */
    public void addRealSubstanceAuthznGroupText( SpecAuthorizationGroupText... entity )
    {
        if( toRealSubstanceAuthznGroupText == null ) {
            toRealSubstanceAuthznGroupText = Lists.newArrayList();
        }
        toRealSubstanceAuthznGroupText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RealSubstanceComponentType</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRealSubstanceComponentType()
    {
        return fetchFieldAsList("to_RealSubstanceComponentType", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceComponentType</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRealSubstanceComponentTypeOrFetch()
    {
        if( toRealSubstanceComponentType == null ) {
            toRealSubstanceComponentType = fetchRealSubstanceComponentType();
        }
        return toRealSubstanceComponentType;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceComponentType</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceComponentType</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRealSubstanceComponentTypeIfPresent()
    {
        return Option.of(toRealSubstanceComponentType);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RealSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceComponentType</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRealSubstanceComponentType( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRealSubstanceComponentType == null ) {
            toRealSubstanceComponentType = Lists.newArrayList();
        }
        toRealSubstanceComponentType.clear();
        toRealSubstanceComponentType.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceComponentType</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceComponentType</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRealSubstanceComponentType( SpecCharByValueAssgmtInst... entity )
    {
        if( toRealSubstanceComponentType == null ) {
            toRealSubstanceComponentType = Lists.newArrayList();
        }
        toRealSubstanceComponentType.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RealSubstanceConversionFactor</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRealSubstanceConversionFactor()
    {
        return fetchFieldAsList("to_RealSubstanceConversionFactor", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceConversionFactor</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRealSubstanceConversionFactorOrFetch()
    {
        if( toRealSubstanceConversionFactor == null ) {
            toRealSubstanceConversionFactor = fetchRealSubstanceConversionFactor();
        }
        return toRealSubstanceConversionFactor;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceConversionFactor</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRealSubstanceConversionFactorIfPresent()
    {
        return Option.of(toRealSubstanceConversionFactor);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RealSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceConversionFactor</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRealSubstanceConversionFactor( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRealSubstanceConversionFactor == null ) {
            toRealSubstanceConversionFactor = Lists.newArrayList();
        }
        toRealSubstanceConversionFactor.clear();
        toRealSubstanceConversionFactor.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceConversionFactor</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceConversionFactor</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRealSubstanceConversionFactor( SpecCharByValueAssgmtInst... entity )
    {
        if( toRealSubstanceConversionFactor == null ) {
            toRealSubstanceConversionFactor = Lists.newArrayList();
        }
        toRealSubstanceConversionFactor.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RealSubstanceDensity</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRealSubstanceDensity()
    {
        return fetchFieldAsList("to_RealSubstanceDensity", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDensity</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRealSubstanceDensityOrFetch()
    {
        if( toRealSubstanceDensity == null ) {
            toRealSubstanceDensity = fetchRealSubstanceDensity();
        }
        return toRealSubstanceDensity;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceDensity</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceDensity</b> is already loaded, the result
     *         will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRealSubstanceDensityIfPresent()
    {
        return Option.of(toRealSubstanceDensity);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RealSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDensity</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRealSubstanceDensity( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRealSubstanceDensity == null ) {
            toRealSubstanceDensity = Lists.newArrayList();
        }
        toRealSubstanceDensity.clear();
        toRealSubstanceDensity.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceDensity</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDensity</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRealSubstanceDensity( SpecCharByValueAssgmtInst... entity )
    {
        if( toRealSubstanceDensity == null ) {
            toRealSubstanceDensity = Lists.newArrayList();
        }
        toRealSubstanceDensity.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceDietComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceDietComp()
    {
        return fetchFieldAsList("to_RealSubstanceDietComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDietComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceDietCompOrFetch()
    {
        if( toRealSubstanceDietComp == null ) {
            toRealSubstanceDietComp = fetchRealSubstanceDietComp();
        }
        return toRealSubstanceDietComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceDietComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceDietComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceDietCompIfPresent()
    {
        return Option.of(toRealSubstanceDietComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDietComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceDietComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceDietComp == null ) {
            toRealSubstanceDietComp = Lists.newArrayList();
        }
        toRealSubstanceDietComp.clear();
        toRealSubstanceDietComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceDietComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceDietComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceDietComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceDietComp == null ) {
            toRealSubstanceDietComp = Lists.newArrayList();
        }
        toRealSubstanceDietComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RealSubstanceEstimatedPrice</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRealSubstanceEstimatedPrice()
    {
        return fetchFieldAsList("to_RealSubstanceEstimatedPrice", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceEstimatedPrice</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRealSubstanceEstimatedPriceOrFetch()
    {
        if( toRealSubstanceEstimatedPrice == null ) {
            toRealSubstanceEstimatedPrice = fetchRealSubstanceEstimatedPrice();
        }
        return toRealSubstanceEstimatedPrice;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceEstimatedPrice</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRealSubstanceEstimatedPriceIfPresent()
    {
        return Option.of(toRealSubstanceEstimatedPrice);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RealSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceEstimatedPrice</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRealSubstanceEstimatedPrice( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRealSubstanceEstimatedPrice == null ) {
            toRealSubstanceEstimatedPrice = Lists.newArrayList();
        }
        toRealSubstanceEstimatedPrice.clear();
        toRealSubstanceEstimatedPrice.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceEstimatedPrice</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceEstimatedPrice</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRealSubstanceEstimatedPrice( SpecCharByValueAssgmtInst... entity )
    {
        if( toRealSubstanceEstimatedPrice == null ) {
            toRealSubstanceEstimatedPrice = Lists.newArrayList();
        }
        toRealSubstanceEstimatedPrice.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceGMOComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceGMOComp()
    {
        return fetchFieldAsList("to_RealSubstanceGMOComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceGMOComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceGMOCompOrFetch()
    {
        if( toRealSubstanceGMOComp == null ) {
            toRealSubstanceGMOComp = fetchRealSubstanceGMOComp();
        }
        return toRealSubstanceGMOComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceGMOComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceGMOComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceGMOCompIfPresent()
    {
        return Option.of(toRealSubstanceGMOComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceGMOComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceGMOComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceGMOComp == null ) {
            toRealSubstanceGMOComp = Lists.newArrayList();
        }
        toRealSubstanceGMOComp.clear();
        toRealSubstanceGMOComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceGMOComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceGMOComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceGMOComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceGMOComp == null ) {
            toRealSubstanceGMOComp = Lists.newArrayList();
        }
        toRealSubstanceGMOComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecIdentifier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RealSubstanceIdentifier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecIdentifier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> fetchRealSubstanceIdentifier()
    {
        return fetchFieldAsList("to_RealSubstanceIdentifier", SpecIdentifier.class);
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RealSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIdentifier</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecIdentifier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> getRealSubstanceIdentifierOrFetch()
    {
        if( toRealSubstanceIdentifier == null ) {
            toRealSubstanceIdentifier = fetchRealSubstanceIdentifier();
        }
        return toRealSubstanceIdentifier;
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RealSubstanceIdentifier</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceIdentifier</b> is already loaded, the
     *         result will contain the <b>SpecIdentifier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecIdentifier>> getRealSubstanceIdentifierIfPresent()
    {
        return Option.of(toRealSubstanceIdentifier);
    }

    /**
     * Overwrites the list of associated <b>SpecIdentifier</b> entities for the loaded navigation property
     * <b>to_RealSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIdentifier</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecIdentifier</b> entities.
     */
    public void setRealSubstanceIdentifier( @Nonnull final List<SpecIdentifier> value )
    {
        if( toRealSubstanceIdentifier == null ) {
            toRealSubstanceIdentifier = Lists.newArrayList();
        }
        toRealSubstanceIdentifier.clear();
        toRealSubstanceIdentifier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecIdentifier</b> entities. This corresponds to the OData navigation
     * property <b>to_RealSubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIdentifier</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecIdentifier</b> entities.
     */
    public void addRealSubstanceIdentifier( SpecIdentifier... entity )
    {
        if( toRealSubstanceIdentifier == null ) {
            toRealSubstanceIdentifier = Lists.newArrayList();
        }
        toRealSubstanceIdentifier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceIngredientComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceIngredientComp()
    {
        return fetchFieldAsList("to_RealSubstanceIngredientComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceIngredientComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIngredientComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceIngredientCompOrFetch()
    {
        if( toRealSubstanceIngredientComp == null ) {
            toRealSubstanceIngredientComp = fetchRealSubstanceIngredientComp();
        }
        return toRealSubstanceIngredientComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceIngredientComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceIngredientComp</b> is already loaded, the
     *         result will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceIngredientCompIfPresent()
    {
        return Option.of(toRealSubstanceIngredientComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceIngredientComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIngredientComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceIngredientComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceIngredientComp == null ) {
            toRealSubstanceIngredientComp = Lists.newArrayList();
        }
        toRealSubstanceIngredientComp.clear();
        toRealSubstanceIngredientComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceIngredientComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceIngredientComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceIngredientComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceIngredientComp == null ) {
            toRealSubstanceIngredientComp = Lists.newArrayList();
        }
        toRealSubstanceIngredientComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecAssignedMatlForKeyDate</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceMatlAssignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecAssignedMatlForKeyDate</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAssignedMatlForKeyDate> fetchRealSubstanceMatlAssignment()
    {
        return fetchFieldAsList("to_RealSubstanceMatlAssignment", SpecAssignedMatlForKeyDate.class);
    }

    /**
     * Retrieval of associated <b>SpecAssignedMatlForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceMatlAssignment</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecAssignedMatlForKeyDate</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecAssignedMatlForKeyDate> getRealSubstanceMatlAssignmentOrFetch()
    {
        if( toRealSubstanceMatlAssignment == null ) {
            toRealSubstanceMatlAssignment = fetchRealSubstanceMatlAssignment();
        }
        return toRealSubstanceMatlAssignment;
    }

    /**
     * Retrieval of associated <b>SpecAssignedMatlForKeyDate</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceMatlAssignment</b> is already loaded, the
     *         result will contain the <b>SpecAssignedMatlForKeyDate</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecAssignedMatlForKeyDate>> getRealSubstanceMatlAssignmentIfPresent()
    {
        return Option.of(toRealSubstanceMatlAssignment);
    }

    /**
     * Overwrites the list of associated <b>SpecAssignedMatlForKeyDate</b> entities for the loaded navigation property
     * <b>to_RealSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceMatlAssignment</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecAssignedMatlForKeyDate</b> entities.
     */
    public void setRealSubstanceMatlAssignment( @Nonnull final List<SpecAssignedMatlForKeyDate> value )
    {
        if( toRealSubstanceMatlAssignment == null ) {
            toRealSubstanceMatlAssignment = Lists.newArrayList();
        }
        toRealSubstanceMatlAssignment.clear();
        toRealSubstanceMatlAssignment.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecAssignedMatlForKeyDate</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceMatlAssignment</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceMatlAssignment</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecAssignedMatlForKeyDate</b> entities.
     */
    public void addRealSubstanceMatlAssignment( SpecAssignedMatlForKeyDate... entity )
    {
        if( toRealSubstanceMatlAssignment == null ) {
            toRealSubstanceMatlAssignment = Lists.newArrayList();
        }
        toRealSubstanceMatlAssignment.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusNextStatus</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RealSubstanceNextStatus</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusNextStatus</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusNextStatus> fetchRealSubstanceNextStatus()
    {
        return fetchFieldAsList("to_RealSubstanceNextStatus", SpecStatusNextStatus.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusNextStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNextStatus</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusNextStatus</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusNextStatus> getRealSubstanceNextStatusOrFetch()
    {
        if( toRealSubstanceNextStatus == null ) {
            toRealSubstanceNextStatus = fetchRealSubstanceNextStatus();
        }
        return toRealSubstanceNextStatus;
    }

    /**
     * Retrieval of associated <b>SpecStatusNextStatus</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceNextStatus</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceNextStatus</b> is already loaded, the
     *         result will contain the <b>SpecStatusNextStatus</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusNextStatus>> getRealSubstanceNextStatusIfPresent()
    {
        return Option.of(toRealSubstanceNextStatus);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusNextStatus</b> entities for the loaded navigation property
     * <b>to_RealSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNextStatus</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusNextStatus</b> entities.
     */
    public void setRealSubstanceNextStatus( @Nonnull final List<SpecStatusNextStatus> value )
    {
        if( toRealSubstanceNextStatus == null ) {
            toRealSubstanceNextStatus = Lists.newArrayList();
        }
        toRealSubstanceNextStatus.clear();
        toRealSubstanceNextStatus.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusNextStatus</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceNextStatus</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNextStatus</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusNextStatus</b> entities.
     */
    public void addRealSubstanceNextStatus( SpecStatusNextStatus... entity )
    {
        if( toRealSubstanceNextStatus == null ) {
            toRealSubstanceNextStatus = Lists.newArrayList();
        }
        toRealSubstanceNextStatus.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceNtrntComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceNtrntComp()
    {
        return fetchFieldAsList("to_RealSubstanceNtrntComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNtrntComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceNtrntCompOrFetch()
    {
        if( toRealSubstanceNtrntComp == null ) {
            toRealSubstanceNtrntComp = fetchRealSubstanceNtrntComp();
        }
        return toRealSubstanceNtrntComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceNtrntComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceNtrntCompIfPresent()
    {
        return Option.of(toRealSubstanceNtrntComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNtrntComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceNtrntComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceNtrntComp == null ) {
            toRealSubstanceNtrntComp = Lists.newArrayList();
        }
        toRealSubstanceNtrntComp.clear();
        toRealSubstanceNtrntComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceNtrntComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceNtrntComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceNtrntComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceNtrntComp == null ) {
            toRealSubstanceNtrntComp = Lists.newArrayList();
        }
        toRealSubstanceNtrntComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceReligiousComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceReligiousComp()
    {
        return fetchFieldAsList("to_RealSubstanceReligiousComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceReligiousComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceReligiousCompOrFetch()
    {
        if( toRealSubstanceReligiousComp == null ) {
            toRealSubstanceReligiousComp = fetchRealSubstanceReligiousComp();
        }
        return toRealSubstanceReligiousComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceReligiousComp</b> is already loaded, the
     *         result will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceReligiousCompIfPresent()
    {
        return Option.of(toRealSubstanceReligiousComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceReligiousComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceReligiousComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceReligiousComp == null ) {
            toRealSubstanceReligiousComp = Lists.newArrayList();
        }
        toRealSubstanceReligiousComp.clear();
        toRealSubstanceReligiousComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceReligiousComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceReligiousComp</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceReligiousComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceReligiousComp == null ) {
            toRealSubstanceReligiousComp = Lists.newArrayList();
        }
        toRealSubstanceReligiousComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusSchema</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RealSubstanceSchema</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusSchema</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusSchema> fetchRealSubstanceSchema()
    {
        return fetchFieldAsList("to_RealSubstanceSchema", SpecStatusSchema.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusSchema</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RealSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceSchema</b> of a queried <b>RealSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusSchema</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusSchema> getRealSubstanceSchemaOrFetch()
    {
        if( toRealSubstanceSchema == null ) {
            toRealSubstanceSchema = fetchRealSubstanceSchema();
        }
        return toRealSubstanceSchema;
    }

    /**
     * Retrieval of associated <b>SpecStatusSchema</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RealSubstanceSchema</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceSchema</b> is already loaded, the result
     *         will contain the <b>SpecStatusSchema</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusSchema>> getRealSubstanceSchemaIfPresent()
    {
        return Option.of(toRealSubstanceSchema);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusSchema</b> entities for the loaded navigation property
     * <b>to_RealSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceSchema</b> of a queried <b>RealSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusSchema</b> entities.
     */
    public void setRealSubstanceSchema( @Nonnull final List<SpecStatusSchema> value )
    {
        if( toRealSubstanceSchema == null ) {
            toRealSubstanceSchema = Lists.newArrayList();
        }
        toRealSubstanceSchema.clear();
        toRealSubstanceSchema.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusSchema</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceSchema</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceSchema</b> of a queried <b>RealSubstance</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusSchema</b> entities.
     */
    public void addRealSubstanceSchema( SpecStatusSchema... entity )
    {
        if( toRealSubstanceSchema == null ) {
            toRealSubstanceSchema = Lists.newArrayList();
        }
        toRealSubstanceSchema.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecStatusAttributes</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RealSubstanceStatusAttributes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusAttributes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> fetchRealSubstanceStatusAttributes()
    {
        return fetchFieldAsList("to_RealSubstanceStatusAttributes", SpecStatusAttributes.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStatusAttributes</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusAttributes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> getRealSubstanceStatusAttributesOrFetch()
    {
        if( toRealSubstanceStatusAttributes == null ) {
            toRealSubstanceStatusAttributes = fetchRealSubstanceStatusAttributes();
        }
        return toRealSubstanceStatusAttributes;
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceStatusAttributes</b> is already loaded, the
     *         result will contain the <b>SpecStatusAttributes</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusAttributes>> getRealSubstanceStatusAttributesIfPresent()
    {
        return Option.of(toRealSubstanceStatusAttributes);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusAttributes</b> entities for the loaded navigation property
     * <b>to_RealSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStatusAttributes</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusAttributes</b> entities.
     */
    public void setRealSubstanceStatusAttributes( @Nonnull final List<SpecStatusAttributes> value )
    {
        if( toRealSubstanceStatusAttributes == null ) {
            toRealSubstanceStatusAttributes = Lists.newArrayList();
        }
        toRealSubstanceStatusAttributes.clear();
        toRealSubstanceStatusAttributes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusAttributes</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStatusAttributes</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusAttributes</b> entities.
     */
    public void addRealSubstanceStatusAttributes( SpecStatusAttributes... entity )
    {
        if( toRealSubstanceStatusAttributes == null ) {
            toRealSubstanceStatusAttributes = Lists.newArrayList();
        }
        toRealSubstanceStatusAttributes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecValAssgmtInstanceWthComp</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RealSubstanceStdComp</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecValAssgmtInstanceWthComp</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> fetchRealSubstanceStdComp()
    {
        return fetchFieldAsList("to_RealSubstanceStdComp", SpecValAssgmtInstanceWthComp.class);
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStdComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecValAssgmtInstanceWthComp</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecValAssgmtInstanceWthComp> getRealSubstanceStdCompOrFetch()
    {
        if( toRealSubstanceStdComp == null ) {
            toRealSubstanceStdComp = fetchRealSubstanceStdComp();
        }
        return toRealSubstanceStdComp;
    }

    /**
     * Retrieval of associated <b>SpecValAssgmtInstanceWthComp</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceStdComp</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceStdComp</b> is already loaded, the result
     *         will contain the <b>SpecValAssgmtInstanceWthComp</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecValAssgmtInstanceWthComp>> getRealSubstanceStdCompIfPresent()
    {
        return Option.of(toRealSubstanceStdComp);
    }

    /**
     * Overwrites the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities for the loaded navigation property
     * <b>to_RealSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStdComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void setRealSubstanceStdComp( @Nonnull final List<SpecValAssgmtInstanceWthComp> value )
    {
        if( toRealSubstanceStdComp == null ) {
            toRealSubstanceStdComp = Lists.newArrayList();
        }
        toRealSubstanceStdComp.clear();
        toRealSubstanceStdComp.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecValAssgmtInstanceWthComp</b> entities. This corresponds to the
     * OData navigation property <b>to_RealSubstanceStdComp</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceStdComp</b> of a queried <b>RealSubstance</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecValAssgmtInstanceWthComp</b> entities.
     */
    public void addRealSubstanceStdComp( SpecValAssgmtInstanceWthComp... entity )
    {
        if( toRealSubstanceStdComp == null ) {
            toRealSubstanceStdComp = Lists.newArrayList();
        }
        toRealSubstanceStdComp.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SpecCharByValueAssgmtInst</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RealSubstanceTotalSolid</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecCharByValueAssgmtInst</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> fetchRealSubstanceTotalSolid()
    {
        return fetchFieldAsList("to_RealSubstanceTotalSolid", SpecCharByValueAssgmtInst.class);
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceTotalSolid</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecCharByValueAssgmtInst</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecCharByValueAssgmtInst> getRealSubstanceTotalSolidOrFetch()
    {
        if( toRealSubstanceTotalSolid == null ) {
            toRealSubstanceTotalSolid = fetchRealSubstanceTotalSolid();
        }
        return toRealSubstanceTotalSolid;
    }

    /**
     * Retrieval of associated <b>SpecCharByValueAssgmtInst</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RealSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property for an entity <b>RealSubstance</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RealSubstanceTotalSolid</b> is already loaded, the
     *         result will contain the <b>SpecCharByValueAssgmtInst</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecCharByValueAssgmtInst>> getRealSubstanceTotalSolidIfPresent()
    {
        return Option.of(toRealSubstanceTotalSolid);
    }

    /**
     * Overwrites the list of associated <b>SpecCharByValueAssgmtInst</b> entities for the loaded navigation property
     * <b>to_RealSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceTotalSolid</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void setRealSubstanceTotalSolid( @Nonnull final List<SpecCharByValueAssgmtInst> value )
    {
        if( toRealSubstanceTotalSolid == null ) {
            toRealSubstanceTotalSolid = Lists.newArrayList();
        }
        toRealSubstanceTotalSolid.clear();
        toRealSubstanceTotalSolid.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecCharByValueAssgmtInst</b> entities. This corresponds to the OData
     * navigation property <b>to_RealSubstanceTotalSolid</b>.
     * <p>
     * If the navigation property <b>to_RealSubstanceTotalSolid</b> of a queried <b>RealSubstance</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecCharByValueAssgmtInst</b> entities.
     */
    public void addRealSubstanceTotalSolid( SpecCharByValueAssgmtInst... entity )
    {
        if( toRealSubstanceTotalSolid == null ) {
            toRealSubstanceTotalSolid = Lists.newArrayList();
        }
        toRealSubstanceTotalSolid.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RealSubstance instances.
     *
     */
    public final static class RealSubstanceBuilder
    {

        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceAllergenComp = Lists.newArrayList();
        private List<SpecAuthorizationGroupText> toRealSubstanceAuthznGroupText = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRealSubstanceComponentType = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRealSubstanceConversionFactor = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRealSubstanceDensity = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceDietComp = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRealSubstanceEstimatedPrice = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceGMOComp = Lists.newArrayList();
        private List<SpecIdentifier> toRealSubstanceIdentifier = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceIngredientComp = Lists.newArrayList();
        private List<SpecAssignedMatlForKeyDate> toRealSubstanceMatlAssignment = Lists.newArrayList();
        private List<SpecStatusNextStatus> toRealSubstanceNextStatus = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceNtrntComp = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceReligiousComp = Lists.newArrayList();
        private List<SpecStatusSchema> toRealSubstanceSchema = Lists.newArrayList();
        private List<SpecStatusAttributes> toRealSubstanceStatusAttributes = Lists.newArrayList();
        private List<SpecValAssgmtInstanceWthComp> toRealSubstanceStdComp = Lists.newArrayList();
        private List<SpecCharByValueAssgmtInst> toRealSubstanceTotalSolid = Lists.newArrayList();

        private RealSubstance.RealSubstanceBuilder toRealSubstanceAllergenComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceAllergenComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceAllergenComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceAllergenComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceAllergenComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceAuthznGroupText(
            final List<SpecAuthorizationGroupText> value )
        {
            toRealSubstanceAuthznGroupText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceAuthznGroupText</b> for <b>RealSubstance</b> to multiple
         * <b>SpecAuthorizationGroupText</b>.
         *
         * @param value
         *            The SpecAuthorizationGroupTexts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceAuthznGroupText( SpecAuthorizationGroupText... value )
        {
            return toRealSubstanceAuthznGroupText(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceComponentType(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRealSubstanceComponentType.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceComponentType</b> for <b>RealSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceComponentType( SpecCharByValueAssgmtInst... value )
        {
            return toRealSubstanceComponentType(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceConversionFactor(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRealSubstanceConversionFactor.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceConversionFactor</b> for <b>RealSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceConversionFactor( SpecCharByValueAssgmtInst... value )
        {
            return toRealSubstanceConversionFactor(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceDensity( final List<SpecCharByValueAssgmtInst> value )
        {
            toRealSubstanceDensity.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceDensity</b> for <b>RealSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceDensity( SpecCharByValueAssgmtInst... value )
        {
            return toRealSubstanceDensity(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceDietComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceDietComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceDietComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceDietComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceDietComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceEstimatedPrice(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRealSubstanceEstimatedPrice.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceEstimatedPrice</b> for <b>RealSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceEstimatedPrice( SpecCharByValueAssgmtInst... value )
        {
            return toRealSubstanceEstimatedPrice(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceGMOComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceGMOComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceGMOComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceGMOComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceGMOComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceIdentifier( final List<SpecIdentifier> value )
        {
            toRealSubstanceIdentifier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceIdentifier</b> for <b>RealSubstance</b> to multiple
         * <b>SpecIdentifier</b>.
         *
         * @param value
         *            The SpecIdentifiers to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceIdentifier( SpecIdentifier... value )
        {
            return toRealSubstanceIdentifier(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceIngredientComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceIngredientComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceIngredientComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceIngredientComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceIngredientComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceMatlAssignment(
            final List<SpecAssignedMatlForKeyDate> value )
        {
            toRealSubstanceMatlAssignment.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceMatlAssignment</b> for <b>RealSubstance</b> to multiple
         * <b>SpecAssignedMatlForKeyDate</b>.
         *
         * @param value
         *            The SpecAssignedMatlForKeyDates to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceMatlAssignment( SpecAssignedMatlForKeyDate... value )
        {
            return toRealSubstanceMatlAssignment(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceNextStatus( final List<SpecStatusNextStatus> value )
        {
            toRealSubstanceNextStatus.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceNextStatus</b> for <b>RealSubstance</b> to multiple
         * <b>SpecStatusNextStatus</b>.
         *
         * @param value
         *            The SpecStatusNextStatuss to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceNextStatus( SpecStatusNextStatus... value )
        {
            return toRealSubstanceNextStatus(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceNtrntComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceNtrntComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceNtrntComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceNtrntComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceNtrntComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceReligiousComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceReligiousComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceReligiousComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceReligiousComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceReligiousComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceSchema( final List<SpecStatusSchema> value )
        {
            toRealSubstanceSchema.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceSchema</b> for <b>RealSubstance</b> to multiple
         * <b>SpecStatusSchema</b>.
         *
         * @param value
         *            The SpecStatusSchemas to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceSchema( SpecStatusSchema... value )
        {
            return toRealSubstanceSchema(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceStatusAttributes(
            final List<SpecStatusAttributes> value )
        {
            toRealSubstanceStatusAttributes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceStatusAttributes</b> for <b>RealSubstance</b> to multiple
         * <b>SpecStatusAttributes</b>.
         *
         * @param value
         *            The SpecStatusAttributess to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceStatusAttributes( SpecStatusAttributes... value )
        {
            return toRealSubstanceStatusAttributes(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceStdComp(
            final List<SpecValAssgmtInstanceWthComp> value )
        {
            toRealSubstanceStdComp.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceStdComp</b> for <b>RealSubstance</b> to multiple
         * <b>SpecValAssgmtInstanceWthComp</b>.
         *
         * @param value
         *            The SpecValAssgmtInstanceWthComps to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceStdComp( SpecValAssgmtInstanceWthComp... value )
        {
            return toRealSubstanceStdComp(Lists.newArrayList(value));
        }

        private RealSubstance.RealSubstanceBuilder toRealSubstanceTotalSolid(
            final List<SpecCharByValueAssgmtInst> value )
        {
            toRealSubstanceTotalSolid.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RealSubstanceTotalSolid</b> for <b>RealSubstance</b> to multiple
         * <b>SpecCharByValueAssgmtInst</b>.
         *
         * @param value
         *            The SpecCharByValueAssgmtInsts to build this RealSubstance with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RealSubstance.RealSubstanceBuilder realSubstanceTotalSolid( SpecCharByValueAssgmtInst... value )
        {
            return toRealSubstanceTotalSolid(Lists.newArrayList(value));
        }

    }

}
