/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.RealSubstanceSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance RealSubstance} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class RealSubstanceByKeyFluentHelper
    extends
    FluentHelperByKey<RealSubstanceByKeyFluentHelper, RealSubstance, RealSubstanceSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.RealSubstance RealSubstance} entity with
     * the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method on
     * the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code RealSubstance}
     * @param servicePath
     *            Service path to be used to fetch a single {@code RealSubstance}
     * @param realSubstanceInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public RealSubstanceByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String realSubstanceInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("RealSubstanceInternalID", realSubstanceInternalID);
    }

    @Override
    @Nonnull
    protected Class<RealSubstance> getEntityClass()
    {
        return RealSubstance.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
