/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.SpecAssignedMatlForKeyDateField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.SpecAssignedMatlForKeyDateLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.SpecAssignedMatlForKeyDateOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecAssignedMatlForKeyDateSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Specification Assigned Material For Key Date
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecAssignedMatlForKeyDateType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecAssignedMatlForKeyDate extends VdmEntity<SpecAssignedMatlForKeyDate>
{

    /**
     * Selector for all available fields of SpecAssignedMatlForKeyDate.
     *
     */
    public final static SpecAssignedMatlForKeyDateSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "SpecMaterialAssgmtInternalID" )
    @JsonProperty( "SpecMaterialAssgmtInternalID" )
    @Nullable
    @ODataField( odataName = "SpecMaterialAssgmtInternalID" )
    private String specMaterialAssgmtInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtInternalID</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPEC_MATERIAL_ASSGMT_INTERNAL_ID =
        new SpecAssignedMatlForKeyDateField<String>("SpecMaterialAssgmtInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeState</b>
     * </p>
     *
     * @return Sequential Number of the Change State
     */
    @Key
    @SerializedName( "SpecMaterialAssgmtChangeState" )
    @JsonProperty( "SpecMaterialAssgmtChangeState" )
    @Nullable
    @ODataField( odataName = "SpecMaterialAssgmtChangeState" )
    private String specMaterialAssgmtChangeState;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtChangeState</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPEC_MATERIAL_ASSGMT_CHANGE_STATE =
        new SpecAssignedMatlForKeyDateField<String>("SpecMaterialAssgmtChangeState");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> MATERIAL =
        new SpecAssignedMatlForKeyDateField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> PLANT =
        new SpecAssignedMatlForKeyDateField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @return Plant Name
     */
    @SerializedName( "PlantName" )
    @JsonProperty( "PlantName" )
    @Nullable
    @ODataField( odataName = "PlantName" )
    private String plantName;
    /**
     * Use with available fluent helpers to apply the <b>PlantName</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> PLANT_NAME =
        new SpecAssignedMatlForKeyDateField<String>("PlantName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeDate</b>
     * </p>
     *
     * @return Last Changed On
     */
    @SerializedName( "SpecMaterialAssgmtChangeDate" )
    @JsonProperty( "SpecMaterialAssgmtChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecMaterialAssgmtChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specMaterialAssgmtChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtChangeDate</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<LocalDateTime> SPEC_MATERIAL_ASSGMT_CHANGE_DATE =
        new SpecAssignedMatlForKeyDateField<LocalDateTime>("SpecMaterialAssgmtChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "SpecMaterialAssgmtChangeNumber" )
    @JsonProperty( "SpecMaterialAssgmtChangeNumber" )
    @Nullable
    @ODataField( odataName = "SpecMaterialAssgmtChangeNumber" )
    private String specMaterialAssgmtChangeNumber;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtChangeNumber</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPEC_MATERIAL_ASSGMT_CHANGE_NUMBER =
        new SpecAssignedMatlForKeyDateField<String>("SpecMaterialAssgmtChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtCreatedByUsr</b>
     * </p>
     *
     * @return Created By
     */
    @SerializedName( "SpecMaterialAssgmtCreatedByUsr" )
    @JsonProperty( "SpecMaterialAssgmtCreatedByUsr" )
    @Nullable
    @ODataField( odataName = "SpecMaterialAssgmtCreatedByUsr" )
    private String specMaterialAssgmtCreatedByUsr;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtCreatedByUsr</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPEC_MATERIAL_ASSGMT_CREATED_BY_USR =
        new SpecAssignedMatlForKeyDateField<String>("SpecMaterialAssgmtCreatedByUsr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtCreationDate</b>
     * </p>
     *
     * @return Created On
     */
    @SerializedName( "SpecMaterialAssgmtCreationDate" )
    @JsonProperty( "SpecMaterialAssgmtCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecMaterialAssgmtCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specMaterialAssgmtCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtCreationDate</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<LocalDateTime> SPEC_MATERIAL_ASSGMT_CREATION_DATE =
        new SpecAssignedMatlForKeyDateField<LocalDateTime>("SpecMaterialAssgmtCreationDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "SpecMaterialAssgmtIsDeleted" )
    @JsonProperty( "SpecMaterialAssgmtIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecMaterialAssgmtIsDeleted" )
    private Boolean specMaterialAssgmtIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>SpecMaterialAssgmtIsDeleted</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<Boolean> SPEC_MATERIAL_ASSGMT_IS_DELETED =
        new SpecAssignedMatlForKeyDateField<Boolean>("SpecMaterialAssgmtIsDeleted");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtLastChangedByUsr</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "SpecMatlAssgmtLastChangedByUsr" )
    @JsonProperty( "SpecMatlAssgmtLastChangedByUsr" )
    @Nullable
    @ODataField( odataName = "SpecMatlAssgmtLastChangedByUsr" )
    private String specMatlAssgmtLastChangedByUsr;
    /**
     * Use with available fluent helpers to apply the <b>SpecMatlAssgmtLastChangedByUsr</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPEC_MATL_ASSGMT_LAST_CHANGED_BY_USR =
        new SpecAssignedMatlForKeyDateField<String>("SpecMatlAssgmtLastChangedByUsr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtValdtyEndDate</b>
     * </p>
     *
     * @return Valid-To Date
     */
    @SerializedName( "SpecMatlAssgmtValdtyEndDate" )
    @JsonProperty( "SpecMatlAssgmtValdtyEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecMatlAssgmtValdtyEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specMatlAssgmtValdtyEndDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecMatlAssgmtValdtyEndDate</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<LocalDateTime> SPEC_MATL_ASSGMT_VALDTY_END_DATE =
        new SpecAssignedMatlForKeyDateField<LocalDateTime>("SpecMatlAssgmtValdtyEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtValdtyStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "SpecMatlAssgmtValdtyStartDate" )
    @JsonProperty( "SpecMatlAssgmtValdtyStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SpecMatlAssgmtValdtyStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime specMatlAssgmtValdtyStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SpecMatlAssgmtValdtyStartDate</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<LocalDateTime> SPEC_MATL_ASSGMT_VALDTY_START_DATE =
        new SpecAssignedMatlForKeyDateField<LocalDateTime>("SpecMatlAssgmtValdtyStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecificationInternalID" )
    @JsonProperty( "SpecificationInternalID" )
    @Nullable
    @ODataField( odataName = "SpecificationInternalID" )
    private String specificationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationInternalID</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPECIFICATION_INTERNAL_ID =
        new SpecAssignedMatlForKeyDateField<String>("SpecificationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "SpecificationAuthznGroup" )
    @JsonProperty( "SpecificationAuthznGroup" )
    @Nullable
    @ODataField( odataName = "SpecificationAuthznGroup" )
    private String specificationAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationAuthznGroup</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPECIFICATION_AUTHZN_GROUP =
        new SpecAssignedMatlForKeyDateField<String>("SpecificationAuthznGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateField<String> SPECIFICATION_TYPE =
        new SpecAssignedMatlForKeyDateField<String>("SpecificationType");
    /**
     * Navigation property <b>to_Description</b> for <b>SpecAssignedMatlForKeyDate</b> to multiple
     * <b>ProductDescription</b>.
     *
     */
    @SerializedName( "to_Description" )
    @JsonProperty( "to_Description" )
    @ODataField( odataName = "to_Description" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProductDescription> toDescription;
    /**
     * Navigation property <b>to_Product</b> for <b>SpecAssignedMatlForKeyDate</b> to single <b>Product</b>.
     *
     */
    @SerializedName( "to_Product" )
    @JsonProperty( "to_Product" )
    @ODataField( odataName = "to_Product" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Product toProduct;
    /**
     * Navigation property <b>to_ProductPlant</b> for <b>SpecAssignedMatlForKeyDate</b> to single <b>ProductPlant</b>.
     *
     */
    @SerializedName( "to_ProductPlant" )
    @JsonProperty( "to_ProductPlant" )
    @ODataField( odataName = "to_ProductPlant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ProductPlant toProductPlant;
    /**
     * Use with available fluent helpers to apply the <b>to_Description</b> navigation property to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateLink<ProductDescription> TO_DESCRIPTION =
        new SpecAssignedMatlForKeyDateLink<ProductDescription>("to_Description");
    /**
     * Use with available fluent helpers to apply the <b>to_Product</b> navigation property to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateOneToOneLink<Product> TO_PRODUCT =
        new SpecAssignedMatlForKeyDateOneToOneLink<Product>("to_Product");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductPlant</b> navigation property to query operations.
     *
     */
    public final static SpecAssignedMatlForKeyDateOneToOneLink<ProductPlant> TO_PRODUCT_PLANT =
        new SpecAssignedMatlForKeyDateOneToOneLink<ProductPlant>("to_ProductPlant");

    @Nonnull
    @Override
    public Class<SpecAssignedMatlForKeyDate> getType()
    {
        return SpecAssignedMatlForKeyDate.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtInternalID</b>
     * </p>
     *
     * @param specMaterialAssgmtInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecMaterialAssgmtInternalID( @Nullable final String specMaterialAssgmtInternalID )
    {
        rememberChangedField("SpecMaterialAssgmtInternalID", this.specMaterialAssgmtInternalID);
        this.specMaterialAssgmtInternalID = specMaterialAssgmtInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeState</b>
     * </p>
     *
     * @param specMaterialAssgmtChangeState
     *            Sequential Number of the Change State
     */
    public void setSpecMaterialAssgmtChangeState( @Nullable final String specMaterialAssgmtChangeState )
    {
        rememberChangedField("SpecMaterialAssgmtChangeState", this.specMaterialAssgmtChangeState);
        this.specMaterialAssgmtChangeState = specMaterialAssgmtChangeState;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>PlantName</b>
     * </p>
     *
     * @param plantName
     *            Plant Name
     */
    public void setPlantName( @Nullable final String plantName )
    {
        rememberChangedField("PlantName", this.plantName);
        this.plantName = plantName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeDate</b>
     * </p>
     *
     * @param specMaterialAssgmtChangeDate
     *            Last Changed On
     */
    public void setSpecMaterialAssgmtChangeDate( @Nullable final LocalDateTime specMaterialAssgmtChangeDate )
    {
        rememberChangedField("SpecMaterialAssgmtChangeDate", this.specMaterialAssgmtChangeDate);
        this.specMaterialAssgmtChangeDate = specMaterialAssgmtChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtChangeNumber</b>
     * </p>
     *
     * @param specMaterialAssgmtChangeNumber
     *            Change Number
     */
    public void setSpecMaterialAssgmtChangeNumber( @Nullable final String specMaterialAssgmtChangeNumber )
    {
        rememberChangedField("SpecMaterialAssgmtChangeNumber", this.specMaterialAssgmtChangeNumber);
        this.specMaterialAssgmtChangeNumber = specMaterialAssgmtChangeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtCreatedByUsr</b>
     * </p>
     *
     * @param specMaterialAssgmtCreatedByUsr
     *            Created By
     */
    public void setSpecMaterialAssgmtCreatedByUsr( @Nullable final String specMaterialAssgmtCreatedByUsr )
    {
        rememberChangedField("SpecMaterialAssgmtCreatedByUsr", this.specMaterialAssgmtCreatedByUsr);
        this.specMaterialAssgmtCreatedByUsr = specMaterialAssgmtCreatedByUsr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtCreationDate</b>
     * </p>
     *
     * @param specMaterialAssgmtCreationDate
     *            Created On
     */
    public void setSpecMaterialAssgmtCreationDate( @Nullable final LocalDateTime specMaterialAssgmtCreationDate )
    {
        rememberChangedField("SpecMaterialAssgmtCreationDate", this.specMaterialAssgmtCreationDate);
        this.specMaterialAssgmtCreationDate = specMaterialAssgmtCreationDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecMaterialAssgmtIsDeleted</b>
     * </p>
     *
     * @param specMaterialAssgmtIsDeleted
     *            Deletion Indicator
     */
    public void setSpecMaterialAssgmtIsDeleted( @Nullable final Boolean specMaterialAssgmtIsDeleted )
    {
        rememberChangedField("SpecMaterialAssgmtIsDeleted", this.specMaterialAssgmtIsDeleted);
        this.specMaterialAssgmtIsDeleted = specMaterialAssgmtIsDeleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtLastChangedByUsr</b>
     * </p>
     *
     * @param specMatlAssgmtLastChangedByUsr
     *            Last Changed By
     */
    public void setSpecMatlAssgmtLastChangedByUsr( @Nullable final String specMatlAssgmtLastChangedByUsr )
    {
        rememberChangedField("SpecMatlAssgmtLastChangedByUsr", this.specMatlAssgmtLastChangedByUsr);
        this.specMatlAssgmtLastChangedByUsr = specMatlAssgmtLastChangedByUsr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtValdtyEndDate</b>
     * </p>
     *
     * @param specMatlAssgmtValdtyEndDate
     *            Valid-To Date
     */
    public void setSpecMatlAssgmtValdtyEndDate( @Nullable final LocalDateTime specMatlAssgmtValdtyEndDate )
    {
        rememberChangedField("SpecMatlAssgmtValdtyEndDate", this.specMatlAssgmtValdtyEndDate);
        this.specMatlAssgmtValdtyEndDate = specMatlAssgmtValdtyEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SpecMatlAssgmtValdtyStartDate</b>
     * </p>
     *
     * @param specMatlAssgmtValdtyStartDate
     *            Valid-From Date
     */
    public void setSpecMatlAssgmtValdtyStartDate( @Nullable final LocalDateTime specMatlAssgmtValdtyStartDate )
    {
        rememberChangedField("SpecMatlAssgmtValdtyStartDate", this.specMatlAssgmtValdtyStartDate);
        this.specMatlAssgmtValdtyStartDate = specMatlAssgmtValdtyStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @param specificationInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecificationInternalID( @Nullable final String specificationInternalID )
    {
        rememberChangedField("SpecificationInternalID", this.specificationInternalID);
        this.specificationInternalID = specificationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     */
    public void setSpecificationAuthznGroup( @Nullable final String specificationAuthznGroup )
    {
        rememberChangedField("SpecificationAuthznGroup", this.specificationAuthznGroup);
        this.specificationAuthznGroup = specificationAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Specification Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecAssignedMatlForKeyDate";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecMaterialAssgmtInternalID", getSpecMaterialAssgmtInternalID());
        result.put("SpecMaterialAssgmtChangeState", getSpecMaterialAssgmtChangeState());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecMaterialAssgmtInternalID", getSpecMaterialAssgmtInternalID());
        values.put("SpecMaterialAssgmtChangeState", getSpecMaterialAssgmtChangeState());
        values.put("Material", getMaterial());
        values.put("Plant", getPlant());
        values.put("PlantName", getPlantName());
        values.put("SpecMaterialAssgmtChangeDate", getSpecMaterialAssgmtChangeDate());
        values.put("SpecMaterialAssgmtChangeNumber", getSpecMaterialAssgmtChangeNumber());
        values.put("SpecMaterialAssgmtCreatedByUsr", getSpecMaterialAssgmtCreatedByUsr());
        values.put("SpecMaterialAssgmtCreationDate", getSpecMaterialAssgmtCreationDate());
        values.put("SpecMaterialAssgmtIsDeleted", getSpecMaterialAssgmtIsDeleted());
        values.put("SpecMatlAssgmtLastChangedByUsr", getSpecMatlAssgmtLastChangedByUsr());
        values.put("SpecMatlAssgmtValdtyEndDate", getSpecMatlAssgmtValdtyEndDate());
        values.put("SpecMatlAssgmtValdtyStartDate", getSpecMatlAssgmtValdtyStartDate());
        values.put("SpecificationInternalID", getSpecificationInternalID());
        values.put("SpecificationAuthznGroup", getSpecificationAuthznGroup());
        values.put("SpecificationType", getSpecificationType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecMaterialAssgmtInternalID") ) {
                final Object value = values.remove("SpecMaterialAssgmtInternalID");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtInternalID())) ) {
                    setSpecMaterialAssgmtInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtChangeState") ) {
                final Object value = values.remove("SpecMaterialAssgmtChangeState");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtChangeState())) ) {
                    setSpecMaterialAssgmtChangeState(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("PlantName") ) {
                final Object value = values.remove("PlantName");
                if( (value == null) || (!value.equals(getPlantName())) ) {
                    setPlantName(((String) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtChangeDate") ) {
                final Object value = values.remove("SpecMaterialAssgmtChangeDate");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtChangeDate())) ) {
                    setSpecMaterialAssgmtChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtChangeNumber") ) {
                final Object value = values.remove("SpecMaterialAssgmtChangeNumber");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtChangeNumber())) ) {
                    setSpecMaterialAssgmtChangeNumber(((String) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtCreatedByUsr") ) {
                final Object value = values.remove("SpecMaterialAssgmtCreatedByUsr");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtCreatedByUsr())) ) {
                    setSpecMaterialAssgmtCreatedByUsr(((String) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtCreationDate") ) {
                final Object value = values.remove("SpecMaterialAssgmtCreationDate");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtCreationDate())) ) {
                    setSpecMaterialAssgmtCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecMaterialAssgmtIsDeleted") ) {
                final Object value = values.remove("SpecMaterialAssgmtIsDeleted");
                if( (value == null) || (!value.equals(getSpecMaterialAssgmtIsDeleted())) ) {
                    setSpecMaterialAssgmtIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("SpecMatlAssgmtLastChangedByUsr") ) {
                final Object value = values.remove("SpecMatlAssgmtLastChangedByUsr");
                if( (value == null) || (!value.equals(getSpecMatlAssgmtLastChangedByUsr())) ) {
                    setSpecMatlAssgmtLastChangedByUsr(((String) value));
                }
            }
            if( values.containsKey("SpecMatlAssgmtValdtyEndDate") ) {
                final Object value = values.remove("SpecMatlAssgmtValdtyEndDate");
                if( (value == null) || (!value.equals(getSpecMatlAssgmtValdtyEndDate())) ) {
                    setSpecMatlAssgmtValdtyEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecMatlAssgmtValdtyStartDate") ) {
                final Object value = values.remove("SpecMatlAssgmtValdtyStartDate");
                if( (value == null) || (!value.equals(getSpecMatlAssgmtValdtyStartDate())) ) {
                    setSpecMatlAssgmtValdtyStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SpecificationInternalID") ) {
                final Object value = values.remove("SpecificationInternalID");
                if( (value == null) || (!value.equals(getSpecificationInternalID())) ) {
                    setSpecificationInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecificationAuthznGroup") ) {
                final Object value = values.remove("SpecificationAuthznGroup");
                if( (value == null) || (!value.equals(getSpecificationAuthznGroup())) ) {
                    setSpecificationAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Description") ) {
                final Object value = (values).remove("to_Description");
                if( value instanceof Iterable ) {
                    if( toDescription == null ) {
                        toDescription = Lists.newArrayList();
                    } else {
                        toDescription = Lists.newArrayList(toDescription);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProductDescription entity;
                        if( toDescription.size() > i ) {
                            entity = toDescription.get(i);
                        } else {
                            entity = new ProductDescription();
                            toDescription.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Product") ) {
                final Object value = (values).remove("to_Product");
                if( value instanceof Map ) {
                    if( toProduct == null ) {
                        toProduct = new Product();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProduct.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ProductPlant") ) {
                final Object value = (values).remove("to_ProductPlant");
                if( value instanceof Map ) {
                    if( toProductPlant == null ) {
                        toProductPlant = new ProductPlant();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toProductPlant.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SpecAssignedMatlForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SpecAssignedMatlForKeyDateField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecAssignedMatlForKeyDateField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecAssignedMatlForKeyDateField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDescription != null ) {
            (values).put("to_Description", toDescription);
        }
        if( toProduct != null ) {
            (values).put("to_Product", toProduct);
        }
        if( toProductPlant != null ) {
            (values).put("to_ProductPlant", toProductPlant);
        }
        return values;
    }

    /**
     * Fetches the <b>ProductDescription</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_Description</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProductDescription</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductDescription> fetchDescription()
    {
        return fetchFieldAsList("to_Description", ProductDescription.class);
    }

    /**
     * Retrieval of associated <b>ProductDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>SpecAssignedMatlForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductDescription</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProductDescription> getDescriptionOrFetch()
    {
        if( toDescription == null ) {
            toDescription = fetchDescription();
        }
        return toDescription;
    }

    /**
     * Retrieval of associated <b>ProductDescription</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property for an entity <b>SpecAssignedMatlForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Description</b> is already loaded, the result will
     *         contain the <b>ProductDescription</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProductDescription>> getDescriptionIfPresent()
    {
        return Option.of(toDescription);
    }

    /**
     * Overwrites the list of associated <b>ProductDescription</b> entities for the loaded navigation property
     * <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>SpecAssignedMatlForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProductDescription</b> entities.
     */
    public void setDescription( @Nonnull final List<ProductDescription> value )
    {
        if( toDescription == null ) {
            toDescription = Lists.newArrayList();
        }
        toDescription.clear();
        toDescription.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProductDescription</b> entities. This corresponds to the OData
     * navigation property <b>to_Description</b>.
     * <p>
     * If the navigation property <b>to_Description</b> of a queried <b>SpecAssignedMatlForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProductDescription</b> entities.
     */
    public void addDescription( ProductDescription... entity )
    {
        if( toDescription == null ) {
            toDescription = Lists.newArrayList();
        }
        toDescription.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Product</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Product</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Product</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Product fetchProduct()
    {
        return fetchFieldAsSingle("to_Product", Product.class);
    }

    /**
     * Retrieval of associated <b>Product</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Product</b>.
     * <p>
     * If the navigation property <b>to_Product</b> of a queried <b>SpecAssignedMatlForKeyDate</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Product</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Product getProductOrFetch()
    {
        if( toProduct == null ) {
            toProduct = fetchProduct();
        }
        return toProduct;
    }

    /**
     * Retrieval of associated <b>Product</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Product</b>.
     * <p>
     * If the navigation property for an entity <b>SpecAssignedMatlForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Product</b> is already loaded, the result will contain
     *         the <b>Product</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Product> getProductIfPresent()
    {
        return Option.of(toProduct);
    }

    /**
     * Overwrites the associated <b>Product</b> entity for the loaded navigation property <b>to_Product</b>.
     *
     * @param value
     *            New <b>Product</b> entity.
     */
    public void setProduct( final Product value )
    {
        toProduct = value;
    }

    /**
     * Fetches the <b>ProductPlant</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ProductPlant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ProductPlant</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductPlant fetchProductPlant()
    {
        return fetchFieldAsSingle("to_ProductPlant", ProductPlant.class);
    }

    /**
     * Retrieval of associated <b>ProductPlant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProductPlant</b>.
     * <p>
     * If the navigation property <b>to_ProductPlant</b> of a queried <b>SpecAssignedMatlForKeyDate</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProductPlant</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ProductPlant getProductPlantOrFetch()
    {
        if( toProductPlant == null ) {
            toProductPlant = fetchProductPlant();
        }
        return toProductPlant;
    }

    /**
     * Retrieval of associated <b>ProductPlant</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_ProductPlant</b>.
     * <p>
     * If the navigation property for an entity <b>SpecAssignedMatlForKeyDate</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductPlant</b> is already loaded, the result will
     *         contain the <b>ProductPlant</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ProductPlant> getProductPlantIfPresent()
    {
        return Option.of(toProductPlant);
    }

    /**
     * Overwrites the associated <b>ProductPlant</b> entity for the loaded navigation property <b>to_ProductPlant</b>.
     *
     * @param value
     *            New <b>ProductPlant</b> entity.
     */
    public void setProductPlant( final ProductPlant value )
    {
        toProductPlant = value;
    }

    /**
     * Helper class to allow for fluent creation of SpecAssignedMatlForKeyDate instances.
     *
     */
    public final static class SpecAssignedMatlForKeyDateBuilder
    {

        private List<ProductDescription> toDescription = Lists.newArrayList();
        private Product toProduct;
        private ProductPlant toProductPlant;

        private SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder toDescription(
            final List<ProductDescription> value )
        {
            toDescription.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Description</b> for <b>SpecAssignedMatlForKeyDate</b> to multiple
         * <b>ProductDescription</b>.
         *
         * @param value
         *            The ProductDescriptions to build this SpecAssignedMatlForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder description( ProductDescription... value )
        {
            return toDescription(Lists.newArrayList(value));
        }

        private SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder toProduct( final Product value )
        {
            toProduct = value;
            return this;
        }

        /**
         * Navigation property <b>to_Product</b> for <b>SpecAssignedMatlForKeyDate</b> to single <b>Product</b>.
         *
         * @param value
         *            The Product to build this SpecAssignedMatlForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder product( final Product value )
        {
            return toProduct(value);
        }

        private SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder toProductPlant( final ProductPlant value )
        {
            toProductPlant = value;
            return this;
        }

        /**
         * Navigation property <b>to_ProductPlant</b> for <b>SpecAssignedMatlForKeyDate</b> to single
         * <b>ProductPlant</b>.
         *
         * @param value
         *            The ProductPlant to build this SpecAssignedMatlForKeyDate with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SpecAssignedMatlForKeyDate.SpecAssignedMatlForKeyDateBuilder productPlant( final ProductPlant value )
        {
            return toProductPlant(value);
        }

    }

}
