/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.SpecCharByValueAssgmtInstField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecCharByValueAssgmtInstSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Specification Characteristic By Value Assignment Instance
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecCharByValueAssgmtInstType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecCharByValueAssgmtInst extends VdmEntity<SpecCharByValueAssgmtInst>
{

    /**
     * Selector for all available fields of SpecCharByValueAssgmtInst.
     *
     */
    public final static SpecCharByValueAssgmtInstSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "SpecificationInternalID" )
    @JsonProperty( "SpecificationInternalID" )
    @Nullable
    @ODataField( odataName = "SpecificationInternalID" )
    private String specificationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationInternalID</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPECIFICATION_INTERNAL_ID =
        new SpecCharByValueAssgmtInstField<String>("SpecificationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtType</b>
     * </p>
     *
     * @return Value Assignment Type
     */
    @Key
    @SerializedName( "SpecValAssgmtType" )
    @JsonProperty( "SpecValAssgmtType" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtType" )
    private String specValAssgmtType;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtType</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_TYPE =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationRating</b>
     * </p>
     *
     * @return Rating
     */
    @Key
    @SerializedName( "SpecificationRating" )
    @JsonProperty( "SpecificationRating" )
    @Nullable
    @ODataField( odataName = "SpecificationRating" )
    private String specificationRating;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationRating</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPECIFICATION_RATING =
        new SpecCharByValueAssgmtInstField<String>("SpecificationRating");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationValidityArea</b>
     * </p>
     *
     * @return Validity Area
     */
    @Key
    @SerializedName( "SpecificationValidityArea" )
    @JsonProperty( "SpecificationValidityArea" )
    @Nullable
    @ODataField( odataName = "SpecificationValidityArea" )
    private String specificationValidityArea;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationValidityArea</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPECIFICATION_VALIDITY_AREA =
        new SpecCharByValueAssgmtInstField<String>("SpecificationValidityArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtHdr</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecValAssgmtHdr" )
    @JsonProperty( "SpecValAssgmtHdr" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtHdr" )
    private String specValAssgmtHdr;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtHdr</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_HDR =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtHdr");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmt</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecValAssgmt" )
    @JsonProperty( "SpecValAssgmt" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmt" )
    private String specValAssgmt;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmt</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmt");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtIsInhtncSource</b>
     * </p>
     *
     * @return Truth Value
     */
    @SerializedName( "SpecValAssgmtIsInhtncSource" )
    @JsonProperty( "SpecValAssgmtIsInhtncSource" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecValAssgmtIsInhtncSource" )
    private Boolean specValAssgmtIsInhtncSource;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtIsInhtncSource</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> SPEC_VAL_ASSGMT_IS_INHTNC_SOURCE =
        new SpecCharByValueAssgmtInstField<Boolean>("SpecValAssgmtIsInhtncSource");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InhtdSpecValAssgmtIsTmpChgd</b>
     * </p>
     *
     * @return Indicator for Temporary Inheritance Overwriting
     */
    @SerializedName( "InhtdSpecValAssgmtIsTmpChgd" )
    @JsonProperty( "InhtdSpecValAssgmtIsTmpChgd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InhtdSpecValAssgmtIsTmpChgd" )
    private Boolean inhtdSpecValAssgmtIsTmpChgd;
    /**
     * Use with available fluent helpers to apply the <b>InhtdSpecValAssgmtIsTmpChgd</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> INHTD_SPEC_VAL_ASSGMT_IS_TMP_CHGD =
        new SpecCharByValueAssgmtInstField<Boolean>("InhtdSpecValAssgmtIsTmpChgd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InhtdSpecValAssgmtIsPermChgd</b>
     * </p>
     *
     * @return Indicator for Permanent Inheritance Overwriting
     */
    @SerializedName( "InhtdSpecValAssgmtIsPermChgd" )
    @JsonProperty( "InhtdSpecValAssgmtIsPermChgd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "InhtdSpecValAssgmtIsPermChgd" )
    private Boolean inhtdSpecValAssgmtIsPermChgd;
    /**
     * Use with available fluent helpers to apply the <b>InhtdSpecValAssgmtIsPermChgd</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> INHTD_SPEC_VAL_ASSGMT_IS_PERM_CHGD =
        new SpecCharByValueAssgmtInstField<Boolean>("InhtdSpecValAssgmtIsPermChgd");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecInheritanceTemplate</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecInheritanceTemplate" )
    @JsonProperty( "SpecInheritanceTemplate" )
    @Nullable
    @ODataField( odataName = "SpecInheritanceTemplate" )
    private String specInheritanceTemplate;
    /**
     * Use with available fluent helpers to apply the <b>SpecInheritanceTemplate</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_INHERITANCE_TEMPLATE =
        new SpecCharByValueAssgmtInstField<String>("SpecInheritanceTemplate");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtInheritanceParent</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecValAssgmtInheritanceParent" )
    @JsonProperty( "SpecValAssgmtInheritanceParent" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtInheritanceParent" )
    private String specValAssgmtInheritanceParent;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtInheritanceParent</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_INHERITANCE_PARENT =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtInheritanceParent");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtInheritanceRoot</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecValAssgmtInheritanceRoot" )
    @JsonProperty( "SpecValAssgmtInheritanceRoot" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtInheritanceRoot" )
    private String specValAssgmtInheritanceRoot;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtInheritanceRoot</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_INHERITANCE_ROOT =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtInheritanceRoot");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtRootSpecIntID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @SerializedName( "SpecValAssgmtRootSpecIntID" )
    @JsonProperty( "SpecValAssgmtRootSpecIntID" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtRootSpecIntID" )
    private String specValAssgmtRootSpecIntID;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtRootSpecIntID</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_ROOT_SPEC_INT_ID =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtRootSpecIntID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtSortSequence</b>
     * </p>
     *
     * @return Sort Order
     */
    @SerializedName( "SpecValAssgmtSortSequence" )
    @JsonProperty( "SpecValAssgmtSortSequence" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtSortSequence" )
    private String specValAssgmtSortSequence;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtSortSequence</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_SORT_SEQUENCE =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtSortSequence");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUnitRefDimension</b>
     * </p>
     *
     * @return Reference Value for Component Specification
     */
    @SerializedName( "SpecValAssgmtUnitRefDimension" )
    @JsonProperty( "SpecValAssgmtUnitRefDimension" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtUnitRefDimension" )
    private String specValAssgmtUnitRefDimension;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtUnitRefDimension</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPEC_VAL_ASSGMT_UNIT_REF_DIMENSION =
        new SpecCharByValueAssgmtInstField<String>("SpecValAssgmtUnitRefDimension");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValueAssignmentSource</b>
     * </p>
     *
     * @return The valueAssignmentSource contained in this entity.
     */
    @SerializedName( "ValueAssignmentSource" )
    @JsonProperty( "ValueAssignmentSource" )
    @Nullable
    @ODataField( odataName = "ValueAssignmentSource" )
    private String valueAssignmentSource;
    /**
     * Use with available fluent helpers to apply the <b>ValueAssignmentSource</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> VALUE_ASSIGNMENT_SOURCE =
        new SpecCharByValueAssgmtInstField<String>("ValueAssignmentSource");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsExcluded</b>
     * </p>
     *
     * @return Validity Area is Excluded
     */
    @SerializedName( "SpecValAssgmtUsageIsExcluded" )
    @JsonProperty( "SpecValAssgmtUsageIsExcluded" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecValAssgmtUsageIsExcluded" )
    private Boolean specValAssgmtUsageIsExcluded;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtUsageIsExcluded</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> SPEC_VAL_ASSGMT_USAGE_IS_EXCLUDED =
        new SpecCharByValueAssgmtInstField<Boolean>("SpecValAssgmtUsageIsExcluded");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsActive</b>
     * </p>
     *
     * @return Activate Usage
     */
    @SerializedName( "SpecValAssgmtUsageIsActive" )
    @JsonProperty( "SpecValAssgmtUsageIsActive" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecValAssgmtUsageIsActive" )
    private Boolean specValAssgmtUsageIsActive;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtUsageIsActive</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> SPEC_VAL_ASSGMT_USAGE_IS_ACTIVE =
        new SpecCharByValueAssgmtInstField<Boolean>("SpecValAssgmtUsageIsActive");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsRelevant</b>
     * </p>
     *
     * @return Relevant Change Has Been Made
     */
    @SerializedName( "SpecValAssgmtUsageIsRelevant" )
    @JsonProperty( "SpecValAssgmtUsageIsRelevant" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "SpecValAssgmtUsageIsRelevant" )
    private Boolean specValAssgmtUsageIsRelevant;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtUsageIsRelevant</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> SPEC_VAL_ASSGMT_USAGE_IS_RELEVANT =
        new SpecCharByValueAssgmtInstField<Boolean>("SpecValAssgmtUsageIsRelevant");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "SpecificationAuthznGroup" )
    @JsonProperty( "SpecificationAuthznGroup" )
    @Nullable
    @ODataField( odataName = "SpecificationAuthznGroup" )
    private String specificationAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationAuthznGroup</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPECIFICATION_AUTHZN_GROUP =
        new SpecCharByValueAssgmtInstField<String>("SpecificationAuthznGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> SPECIFICATION_TYPE =
        new SpecCharByValueAssgmtInstField<String>("SpecificationType");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @return Characteristic Name
     */
    @SerializedName( "Characteristic" )
    @JsonProperty( "Characteristic" )
    @Nullable
    @ODataField( odataName = "Characteristic" )
    private String characteristic;
    /**
     * Use with available fluent helpers to apply the <b>Characteristic</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC =
        new SpecCharByValueAssgmtInstField<String>("Characteristic");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicFormat</b>
     * </p>
     *
     * @return Data type of characteristic
     */
    @SerializedName( "CharacteristicFormat" )
    @JsonProperty( "CharacteristicFormat" )
    @Nullable
    @ODataField( odataName = "CharacteristicFormat" )
    private String characteristicFormat;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicFormat</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_FORMAT =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicFormat");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharacteristicValue" )
    @JsonProperty( "CharacteristicValue" )
    @Nullable
    @ODataField( odataName = "CharacteristicValue" )
    private String characteristicValue;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_VALUE =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicValue");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimalMinimumValue</b>
     * </p>
     *
     * @return Lower Boundary for Numeric Field
     */
    @SerializedName( "CharcDecimalMinimumValue" )
    @JsonProperty( "CharcDecimalMinimumValue" )
    @Nullable
    @ODataField( odataName = "CharcDecimalMinimumValue" )
    private BigDecimal charcDecimalMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcDecimalMinimumValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<BigDecimal> CHARC_DECIMAL_MINIMUM_VALUE =
        new SpecCharByValueAssgmtInstField<BigDecimal>("CharcDecimalMinimumValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicMinimumValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharacteristicMinimumValueUnit" )
    @JsonProperty( "CharacteristicMinimumValueUnit" )
    @Nullable
    @ODataField( odataName = "CharacteristicMinimumValueUnit" )
    private String characteristicMinimumValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicMinimumValueUnit</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_MINIMUM_VALUE_UNIT =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicMinimumValueUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimalMaximumValue</b>
     * </p>
     *
     * @return Upper Boundary for Numeric Field
     */
    @SerializedName( "CharcDecimalMaximumValue" )
    @JsonProperty( "CharcDecimalMaximumValue" )
    @Nullable
    @ODataField( odataName = "CharcDecimalMaximumValue" )
    private BigDecimal charcDecimalMaximumValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcDecimalMaximumValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<BigDecimal> CHARC_DECIMAL_MAXIMUM_VALUE =
        new SpecCharByValueAssgmtInstField<BigDecimal>("CharcDecimalMaximumValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicMaximumValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharacteristicMaximumValueUnit" )
    @JsonProperty( "CharacteristicMaximumValueUnit" )
    @Nullable
    @ODataField( odataName = "CharacteristicMaximumValueUnit" )
    private String characteristicMaximumValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicMaximumValueUnit</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_MAXIMUM_VALUE_UNIT =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicMaximumValueUnit");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicValueDpndcyCode</b>
     * </p>
     *
     * @return Code for value dependency
     */
    @SerializedName( "CharacteristicValueDpndcyCode" )
    @JsonProperty( "CharacteristicValueDpndcyCode" )
    @Nullable
    @ODataField( odataName = "CharacteristicValueDpndcyCode" )
    private String characteristicValueDpndcyCode;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicValueDpndcyCode</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_VALUE_DPNDCY_CODE =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicValueDpndcyCode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date
     */
    @SerializedName( "CharcValidityStartDate" )
    @JsonProperty( "CharcValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcValidityStartDate</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalDateTime> CHARC_VALIDITY_START_DATE =
        new SpecCharByValueAssgmtInstField<LocalDateTime>("CharcValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcValidityEndDate</b>
     * </p>
     *
     * @return Valid-to date
     */
    @SerializedName( "CharcValidityEndDate" )
    @JsonProperty( "CharcValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcValidityEndDate</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalDateTime> CHARC_VALIDITY_END_DATE =
        new SpecCharByValueAssgmtInstField<LocalDateTime>("CharcValidityEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicIsDeleted</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "CharacteristicIsDeleted" )
    @JsonProperty( "CharacteristicIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "CharacteristicIsDeleted" )
    private Boolean characteristicIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicIsDeleted</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<Boolean> CHARACTERISTIC_IS_DELETED =
        new SpecCharByValueAssgmtInstField<Boolean>("CharacteristicIsDeleted");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcCurrencyMinimumValue</b>
     * </p>
     *
     * @return Lower Boundary for Currency Field
     */
    @SerializedName( "CharcCurrencyMinimumValue" )
    @JsonProperty( "CharcCurrencyMinimumValue" )
    @Nullable
    @ODataField( odataName = "CharcCurrencyMinimumValue" )
    private BigDecimal charcCurrencyMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcCurrencyMinimumValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<BigDecimal> CHARC_CURRENCY_MINIMUM_VALUE =
        new SpecCharByValueAssgmtInstField<BigDecimal>("CharcCurrencyMinimumValue");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @return Lower Boundary for Currency Field
     */
    @SerializedName( "CharcFromAmount" )
    @JsonProperty( "CharcFromAmount" )
    @Nullable
    @ODataField( odataName = "CharcFromAmount" )
    private BigDecimal charcFromAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromAmount</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<BigDecimal> CHARC_FROM_AMOUNT =
        new SpecCharByValueAssgmtInstField<BigDecimal>("CharcFromAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @return Upper Boundary for Currency Field
     */
    @SerializedName( "CharcToAmount" )
    @JsonProperty( "CharcToAmount" )
    @Nullable
    @ODataField( odataName = "CharcToAmount" )
    private BigDecimal charcToAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcToAmount</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<BigDecimal> CHARC_TO_AMOUNT =
        new SpecCharByValueAssgmtInstField<BigDecimal>("CharcToAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CURRENCY =
        new SpecCharByValueAssgmtInstField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcValueUnit" )
    @JsonProperty( "CharcValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcValueUnit" )
    private String charcValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueUnit</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARC_VALUE_UNIT =
        new SpecCharByValueAssgmtInstField<String>("CharcValueUnit");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcDateMinimumValue</b>
     * </p>
     *
     * @return Lower Boundary for Date-Interval
     */
    @SerializedName( "CharcDateMinimumValue" )
    @JsonProperty( "CharcDateMinimumValue" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcDateMinimumValue",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcDateMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcDateMinimumValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalDateTime> CHARC_DATE_MINIMUM_VALUE =
        new SpecCharByValueAssgmtInstField<LocalDateTime>("CharcDateMinimumValue");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @return Lower Boundary for Date-Interval
     */
    @SerializedName( "CharcFromDate" )
    @JsonProperty( "CharcFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcFromDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDate</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalDateTime> CHARC_FROM_DATE =
        new SpecCharByValueAssgmtInstField<LocalDateTime>("CharcFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @return Upper Boundary for Date-Interval
     */
    @SerializedName( "CharcToDate" )
    @JsonProperty( "CharcToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcToDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDate</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalDateTime> CHARC_TO_DATE =
        new SpecCharByValueAssgmtInstField<LocalDateTime>("CharcToDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcTimeMinimumValue</b>
     * </p>
     *
     * @return Lower Boundary for Time-Interval
     */
    @SerializedName( "CharcTimeMinimumValue" )
    @JsonProperty( "CharcTimeMinimumValue" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcTimeMinimumValue",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcTimeMinimumValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcTimeMinimumValue</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalTime> CHARC_TIME_MINIMUM_VALUE =
        new SpecCharByValueAssgmtInstField<LocalTime>("CharcTimeMinimumValue");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @return Lower Boundary for Time-Interval
     */
    @SerializedName( "CharcFromTime" )
    @JsonProperty( "CharcFromTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcFromTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromTime</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalTime> CHARC_FROM_TIME =
        new SpecCharByValueAssgmtInstField<LocalTime>("CharcFromTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @return Upper Boundary for Time-Interval
     */
    @SerializedName( "CharcToTime" )
    @JsonProperty( "CharcToTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcToTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcToTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcToTime</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<LocalTime> CHARC_TO_TIME =
        new SpecCharByValueAssgmtInstField<LocalTime>("CharcToTime");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @SerializedName( "CharacteristicInternalID" )
    @JsonProperty( "CharacteristicInternalID" )
    @Nullable
    @ODataField( odataName = "CharacteristicInternalID" )
    private String characteristicInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicInternalID</b> field to query operations.
     *
     */
    public final static SpecCharByValueAssgmtInstField<String> CHARACTERISTIC_INTERNAL_ID =
        new SpecCharByValueAssgmtInstField<String>("CharacteristicInternalID");

    @Nonnull
    @Override
    public Class<SpecCharByValueAssgmtInst> getType()
    {
        return SpecCharByValueAssgmtInst.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @param specificationInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecificationInternalID( @Nullable final String specificationInternalID )
    {
        rememberChangedField("SpecificationInternalID", this.specificationInternalID);
        this.specificationInternalID = specificationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtType</b>
     * </p>
     *
     * @param specValAssgmtType
     *            Value Assignment Type
     */
    public void setSpecValAssgmtType( @Nullable final String specValAssgmtType )
    {
        rememberChangedField("SpecValAssgmtType", this.specValAssgmtType);
        this.specValAssgmtType = specValAssgmtType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationRating</b>
     * </p>
     *
     * @param specificationRating
     *            Rating
     */
    public void setSpecificationRating( @Nullable final String specificationRating )
    {
        rememberChangedField("SpecificationRating", this.specificationRating);
        this.specificationRating = specificationRating;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationValidityArea</b>
     * </p>
     *
     * @param specificationValidityArea
     *            Validity Area
     */
    public void setSpecificationValidityArea( @Nullable final String specificationValidityArea )
    {
        rememberChangedField("SpecificationValidityArea", this.specificationValidityArea);
        this.specificationValidityArea = specificationValidityArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtHdr</b>
     * </p>
     *
     * @param specValAssgmtHdr
     *            Sequential Number of Data Record
     */
    public void setSpecValAssgmtHdr( @Nullable final String specValAssgmtHdr )
    {
        rememberChangedField("SpecValAssgmtHdr", this.specValAssgmtHdr);
        this.specValAssgmtHdr = specValAssgmtHdr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmt</b>
     * </p>
     *
     * @param specValAssgmt
     *            Sequential Number of Data Record
     */
    public void setSpecValAssgmt( @Nullable final String specValAssgmt )
    {
        rememberChangedField("SpecValAssgmt", this.specValAssgmt);
        this.specValAssgmt = specValAssgmt;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtIsInhtncSource</b>
     * </p>
     *
     * @param specValAssgmtIsInhtncSource
     *            Truth Value
     */
    public void setSpecValAssgmtIsInhtncSource( @Nullable final Boolean specValAssgmtIsInhtncSource )
    {
        rememberChangedField("SpecValAssgmtIsInhtncSource", this.specValAssgmtIsInhtncSource);
        this.specValAssgmtIsInhtncSource = specValAssgmtIsInhtncSource;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InhtdSpecValAssgmtIsTmpChgd</b>
     * </p>
     *
     * @param inhtdSpecValAssgmtIsTmpChgd
     *            Indicator for Temporary Inheritance Overwriting
     */
    public void setInhtdSpecValAssgmtIsTmpChgd( @Nullable final Boolean inhtdSpecValAssgmtIsTmpChgd )
    {
        rememberChangedField("InhtdSpecValAssgmtIsTmpChgd", this.inhtdSpecValAssgmtIsTmpChgd);
        this.inhtdSpecValAssgmtIsTmpChgd = inhtdSpecValAssgmtIsTmpChgd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>InhtdSpecValAssgmtIsPermChgd</b>
     * </p>
     *
     * @param inhtdSpecValAssgmtIsPermChgd
     *            Indicator for Permanent Inheritance Overwriting
     */
    public void setInhtdSpecValAssgmtIsPermChgd( @Nullable final Boolean inhtdSpecValAssgmtIsPermChgd )
    {
        rememberChangedField("InhtdSpecValAssgmtIsPermChgd", this.inhtdSpecValAssgmtIsPermChgd);
        this.inhtdSpecValAssgmtIsPermChgd = inhtdSpecValAssgmtIsPermChgd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecInheritanceTemplate</b>
     * </p>
     *
     * @param specInheritanceTemplate
     *            Sequential Number of Data Record
     */
    public void setSpecInheritanceTemplate( @Nullable final String specInheritanceTemplate )
    {
        rememberChangedField("SpecInheritanceTemplate", this.specInheritanceTemplate);
        this.specInheritanceTemplate = specInheritanceTemplate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtInheritanceParent</b>
     * </p>
     *
     * @param specValAssgmtInheritanceParent
     *            Sequential Number of Data Record
     */
    public void setSpecValAssgmtInheritanceParent( @Nullable final String specValAssgmtInheritanceParent )
    {
        rememberChangedField("SpecValAssgmtInheritanceParent", this.specValAssgmtInheritanceParent);
        this.specValAssgmtInheritanceParent = specValAssgmtInheritanceParent;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtInheritanceRoot</b>
     * </p>
     *
     * @param specValAssgmtInheritanceRoot
     *            Sequential Number of Data Record
     */
    public void setSpecValAssgmtInheritanceRoot( @Nullable final String specValAssgmtInheritanceRoot )
    {
        rememberChangedField("SpecValAssgmtInheritanceRoot", this.specValAssgmtInheritanceRoot);
        this.specValAssgmtInheritanceRoot = specValAssgmtInheritanceRoot;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtRootSpecIntID</b>
     * </p>
     *
     * @param specValAssgmtRootSpecIntID
     *            Sequential Number of Data Record
     */
    public void setSpecValAssgmtRootSpecIntID( @Nullable final String specValAssgmtRootSpecIntID )
    {
        rememberChangedField("SpecValAssgmtRootSpecIntID", this.specValAssgmtRootSpecIntID);
        this.specValAssgmtRootSpecIntID = specValAssgmtRootSpecIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtSortSequence</b>
     * </p>
     *
     * @param specValAssgmtSortSequence
     *            Sort Order
     */
    public void setSpecValAssgmtSortSequence( @Nullable final String specValAssgmtSortSequence )
    {
        rememberChangedField("SpecValAssgmtSortSequence", this.specValAssgmtSortSequence);
        this.specValAssgmtSortSequence = specValAssgmtSortSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUnitRefDimension</b>
     * </p>
     *
     * @param specValAssgmtUnitRefDimension
     *            Reference Value for Component Specification
     */
    public void setSpecValAssgmtUnitRefDimension( @Nullable final String specValAssgmtUnitRefDimension )
    {
        rememberChangedField("SpecValAssgmtUnitRefDimension", this.specValAssgmtUnitRefDimension);
        this.specValAssgmtUnitRefDimension = specValAssgmtUnitRefDimension;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ValueAssignmentSource</b>
     * </p>
     *
     * @param valueAssignmentSource
     *            The valueAssignmentSource to set.
     */
    public void setValueAssignmentSource( @Nullable final String valueAssignmentSource )
    {
        rememberChangedField("ValueAssignmentSource", this.valueAssignmentSource);
        this.valueAssignmentSource = valueAssignmentSource;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsExcluded</b>
     * </p>
     *
     * @param specValAssgmtUsageIsExcluded
     *            Validity Area is Excluded
     */
    public void setSpecValAssgmtUsageIsExcluded( @Nullable final Boolean specValAssgmtUsageIsExcluded )
    {
        rememberChangedField("SpecValAssgmtUsageIsExcluded", this.specValAssgmtUsageIsExcluded);
        this.specValAssgmtUsageIsExcluded = specValAssgmtUsageIsExcluded;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsActive</b>
     * </p>
     *
     * @param specValAssgmtUsageIsActive
     *            Activate Usage
     */
    public void setSpecValAssgmtUsageIsActive( @Nullable final Boolean specValAssgmtUsageIsActive )
    {
        rememberChangedField("SpecValAssgmtUsageIsActive", this.specValAssgmtUsageIsActive);
        this.specValAssgmtUsageIsActive = specValAssgmtUsageIsActive;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtUsageIsRelevant</b>
     * </p>
     *
     * @param specValAssgmtUsageIsRelevant
     *            Relevant Change Has Been Made
     */
    public void setSpecValAssgmtUsageIsRelevant( @Nullable final Boolean specValAssgmtUsageIsRelevant )
    {
        rememberChangedField("SpecValAssgmtUsageIsRelevant", this.specValAssgmtUsageIsRelevant);
        this.specValAssgmtUsageIsRelevant = specValAssgmtUsageIsRelevant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     */
    public void setSpecificationAuthznGroup( @Nullable final String specificationAuthznGroup )
    {
        rememberChangedField("SpecificationAuthznGroup", this.specificationAuthznGroup);
        this.specificationAuthznGroup = specificationAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Specification Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Characteristic</b>
     * </p>
     *
     * @param characteristic
     *            Characteristic Name
     */
    public void setCharacteristic( @Nullable final String characteristic )
    {
        rememberChangedField("Characteristic", this.characteristic);
        this.characteristic = characteristic;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicFormat</b>
     * </p>
     *
     * @param characteristicFormat
     *            Data type of characteristic
     */
    public void setCharacteristicFormat( @Nullable final String characteristicFormat )
    {
        rememberChangedField("CharacteristicFormat", this.characteristicFormat);
        this.characteristicFormat = characteristicFormat;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicValue</b>
     * </p>
     *
     * @param characteristicValue
     *            Characteristic Value
     */
    public void setCharacteristicValue( @Nullable final String characteristicValue )
    {
        rememberChangedField("CharacteristicValue", this.characteristicValue);
        this.characteristicValue = characteristicValue;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimalMinimumValue</b>
     * </p>
     *
     * @param charcDecimalMinimumValue
     *            Lower Boundary for Numeric Field
     */
    public void setCharcDecimalMinimumValue( @Nullable final BigDecimal charcDecimalMinimumValue )
    {
        rememberChangedField("CharcDecimalMinimumValue", this.charcDecimalMinimumValue);
        this.charcDecimalMinimumValue = charcDecimalMinimumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicMinimumValueUnit</b>
     * </p>
     *
     * @param characteristicMinimumValueUnit
     *            Unit of Measurement
     */
    public void setCharacteristicMinimumValueUnit( @Nullable final String characteristicMinimumValueUnit )
    {
        rememberChangedField("CharacteristicMinimumValueUnit", this.characteristicMinimumValueUnit);
        this.characteristicMinimumValueUnit = characteristicMinimumValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcDecimalMaximumValue</b>
     * </p>
     *
     * @param charcDecimalMaximumValue
     *            Upper Boundary for Numeric Field
     */
    public void setCharcDecimalMaximumValue( @Nullable final BigDecimal charcDecimalMaximumValue )
    {
        rememberChangedField("CharcDecimalMaximumValue", this.charcDecimalMaximumValue);
        this.charcDecimalMaximumValue = charcDecimalMaximumValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicMaximumValueUnit</b>
     * </p>
     *
     * @param characteristicMaximumValueUnit
     *            Unit of Measurement
     */
    public void setCharacteristicMaximumValueUnit( @Nullable final String characteristicMaximumValueUnit )
    {
        rememberChangedField("CharacteristicMaximumValueUnit", this.characteristicMaximumValueUnit);
        this.characteristicMaximumValueUnit = characteristicMaximumValueUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicValueDpndcyCode</b>
     * </p>
     *
     * @param characteristicValueDpndcyCode
     *            Code for value dependency
     */
    public void setCharacteristicValueDpndcyCode( @Nullable final String characteristicValueDpndcyCode )
    {
        rememberChangedField("CharacteristicValueDpndcyCode", this.characteristicValueDpndcyCode);
        this.characteristicValueDpndcyCode = characteristicValueDpndcyCode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcValidityStartDate</b>
     * </p>
     *
     * @param charcValidityStartDate
     *            Valid-From Date
     */
    public void setCharcValidityStartDate( @Nullable final LocalDateTime charcValidityStartDate )
    {
        rememberChangedField("CharcValidityStartDate", this.charcValidityStartDate);
        this.charcValidityStartDate = charcValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcValidityEndDate</b>
     * </p>
     *
     * @param charcValidityEndDate
     *            Valid-to date
     */
    public void setCharcValidityEndDate( @Nullable final LocalDateTime charcValidityEndDate )
    {
        rememberChangedField("CharcValidityEndDate", this.charcValidityEndDate);
        this.charcValidityEndDate = charcValidityEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicIsDeleted</b>
     * </p>
     *
     * @param characteristicIsDeleted
     *            Deletion Indicator
     */
    public void setCharacteristicIsDeleted( @Nullable final Boolean characteristicIsDeleted )
    {
        rememberChangedField("CharacteristicIsDeleted", this.characteristicIsDeleted);
        this.characteristicIsDeleted = characteristicIsDeleted;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcCurrencyMinimumValue</b>
     * </p>
     *
     * @param charcCurrencyMinimumValue
     *            Lower Boundary for Currency Field
     */
    public void setCharcCurrencyMinimumValue( @Nullable final BigDecimal charcCurrencyMinimumValue )
    {
        rememberChangedField("CharcCurrencyMinimumValue", this.charcCurrencyMinimumValue);
        this.charcCurrencyMinimumValue = charcCurrencyMinimumValue;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @param charcFromAmount
     *            Lower Boundary for Currency Field
     */
    public void setCharcFromAmount( @Nullable final BigDecimal charcFromAmount )
    {
        rememberChangedField("CharcFromAmount", this.charcFromAmount);
        this.charcFromAmount = charcFromAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @param charcToAmount
     *            Upper Boundary for Currency Field
     */
    public void setCharcToAmount( @Nullable final BigDecimal charcToAmount )
    {
        rememberChangedField("CharcToAmount", this.charcToAmount);
        this.charcToAmount = charcToAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueUnit</b>
     * </p>
     *
     * @param charcValueUnit
     *            Unit of Measurement
     */
    public void setCharcValueUnit( @Nullable final String charcValueUnit )
    {
        rememberChangedField("CharcValueUnit", this.charcValueUnit);
        this.charcValueUnit = charcValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcDateMinimumValue</b>
     * </p>
     *
     * @param charcDateMinimumValue
     *            Lower Boundary for Date-Interval
     */
    public void setCharcDateMinimumValue( @Nullable final LocalDateTime charcDateMinimumValue )
    {
        rememberChangedField("CharcDateMinimumValue", this.charcDateMinimumValue);
        this.charcDateMinimumValue = charcDateMinimumValue;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @param charcFromDate
     *            Lower Boundary for Date-Interval
     */
    public void setCharcFromDate( @Nullable final LocalDateTime charcFromDate )
    {
        rememberChangedField("CharcFromDate", this.charcFromDate);
        this.charcFromDate = charcFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @param charcToDate
     *            Upper Boundary for Date-Interval
     */
    public void setCharcToDate( @Nullable final LocalDateTime charcToDate )
    {
        rememberChangedField("CharcToDate", this.charcToDate);
        this.charcToDate = charcToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcTimeMinimumValue</b>
     * </p>
     *
     * @param charcTimeMinimumValue
     *            Lower Boundary for Time-Interval
     */
    public void setCharcTimeMinimumValue( @Nullable final LocalTime charcTimeMinimumValue )
    {
        rememberChangedField("CharcTimeMinimumValue", this.charcTimeMinimumValue);
        this.charcTimeMinimumValue = charcTimeMinimumValue;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @param charcFromTime
     *            Lower Boundary for Time-Interval
     */
    public void setCharcFromTime( @Nullable final LocalTime charcFromTime )
    {
        rememberChangedField("CharcFromTime", this.charcFromTime);
        this.charcFromTime = charcFromTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @param charcToTime
     *            Upper Boundary for Time-Interval
     */
    public void setCharcToTime( @Nullable final LocalTime charcToTime )
    {
        rememberChangedField("CharcToTime", this.charcToTime);
        this.charcToTime = charcToTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicInternalID</b>
     * </p>
     *
     * @param characteristicInternalID
     *            Characteristic Internal ID
     */
    public void setCharacteristicInternalID( @Nullable final String characteristicInternalID )
    {
        rememberChangedField("CharacteristicInternalID", this.characteristicInternalID);
        this.characteristicInternalID = characteristicInternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecCharByValueAssgmtInst";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecificationInternalID", getSpecificationInternalID());
        result.put("SpecValAssgmtType", getSpecValAssgmtType());
        result.put("SpecificationRating", getSpecificationRating());
        result.put("SpecificationValidityArea", getSpecificationValidityArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecificationInternalID", getSpecificationInternalID());
        values.put("SpecValAssgmtType", getSpecValAssgmtType());
        values.put("SpecificationRating", getSpecificationRating());
        values.put("SpecificationValidityArea", getSpecificationValidityArea());
        values.put("SpecValAssgmtHdr", getSpecValAssgmtHdr());
        values.put("SpecValAssgmt", getSpecValAssgmt());
        values.put("SpecValAssgmtIsInhtncSource", getSpecValAssgmtIsInhtncSource());
        values.put("InhtdSpecValAssgmtIsTmpChgd", getInhtdSpecValAssgmtIsTmpChgd());
        values.put("InhtdSpecValAssgmtIsPermChgd", getInhtdSpecValAssgmtIsPermChgd());
        values.put("SpecInheritanceTemplate", getSpecInheritanceTemplate());
        values.put("SpecValAssgmtInheritanceParent", getSpecValAssgmtInheritanceParent());
        values.put("SpecValAssgmtInheritanceRoot", getSpecValAssgmtInheritanceRoot());
        values.put("SpecValAssgmtRootSpecIntID", getSpecValAssgmtRootSpecIntID());
        values.put("SpecValAssgmtSortSequence", getSpecValAssgmtSortSequence());
        values.put("SpecValAssgmtUnitRefDimension", getSpecValAssgmtUnitRefDimension());
        values.put("ValueAssignmentSource", getValueAssignmentSource());
        values.put("SpecValAssgmtUsageIsExcluded", getSpecValAssgmtUsageIsExcluded());
        values.put("SpecValAssgmtUsageIsActive", getSpecValAssgmtUsageIsActive());
        values.put("SpecValAssgmtUsageIsRelevant", getSpecValAssgmtUsageIsRelevant());
        values.put("SpecificationAuthznGroup", getSpecificationAuthznGroup());
        values.put("SpecificationType", getSpecificationType());
        values.put("Characteristic", getCharacteristic());
        values.put("CharacteristicFormat", getCharacteristicFormat());
        values.put("CharacteristicValue", getCharacteristicValue());
        values.put("CharcDecimalMinimumValue", getCharcDecimalMinimumValue());
        values.put("CharacteristicMinimumValueUnit", getCharacteristicMinimumValueUnit());
        values.put("CharcDecimalMaximumValue", getCharcDecimalMaximumValue());
        values.put("CharacteristicMaximumValueUnit", getCharacteristicMaximumValueUnit());
        values.put("CharacteristicValueDpndcyCode", getCharacteristicValueDpndcyCode());
        values.put("CharcValidityStartDate", getCharcValidityStartDate());
        values.put("CharcValidityEndDate", getCharcValidityEndDate());
        values.put("CharacteristicIsDeleted", getCharacteristicIsDeleted());
        values.put("CharcCurrencyMinimumValue", getCharcCurrencyMinimumValue());
        values.put("CharcFromAmount", getCharcFromAmount());
        values.put("CharcToAmount", getCharcToAmount());
        values.put("Currency", getCurrency());
        values.put("CharcValueUnit", getCharcValueUnit());
        values.put("CharcDateMinimumValue", getCharcDateMinimumValue());
        values.put("CharcFromDate", getCharcFromDate());
        values.put("CharcToDate", getCharcToDate());
        values.put("CharcTimeMinimumValue", getCharcTimeMinimumValue());
        values.put("CharcFromTime", getCharcFromTime());
        values.put("CharcToTime", getCharcToTime());
        values.put("CharacteristicInternalID", getCharacteristicInternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecificationInternalID") ) {
                final Object value = values.remove("SpecificationInternalID");
                if( (value == null) || (!value.equals(getSpecificationInternalID())) ) {
                    setSpecificationInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtType") ) {
                final Object value = values.remove("SpecValAssgmtType");
                if( (value == null) || (!value.equals(getSpecValAssgmtType())) ) {
                    setSpecValAssgmtType(((String) value));
                }
            }
            if( values.containsKey("SpecificationRating") ) {
                final Object value = values.remove("SpecificationRating");
                if( (value == null) || (!value.equals(getSpecificationRating())) ) {
                    setSpecificationRating(((String) value));
                }
            }
            if( values.containsKey("SpecificationValidityArea") ) {
                final Object value = values.remove("SpecificationValidityArea");
                if( (value == null) || (!value.equals(getSpecificationValidityArea())) ) {
                    setSpecificationValidityArea(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtHdr") ) {
                final Object value = values.remove("SpecValAssgmtHdr");
                if( (value == null) || (!value.equals(getSpecValAssgmtHdr())) ) {
                    setSpecValAssgmtHdr(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmt") ) {
                final Object value = values.remove("SpecValAssgmt");
                if( (value == null) || (!value.equals(getSpecValAssgmt())) ) {
                    setSpecValAssgmt(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtIsInhtncSource") ) {
                final Object value = values.remove("SpecValAssgmtIsInhtncSource");
                if( (value == null) || (!value.equals(getSpecValAssgmtIsInhtncSource())) ) {
                    setSpecValAssgmtIsInhtncSource(((Boolean) value));
                }
            }
            if( values.containsKey("InhtdSpecValAssgmtIsTmpChgd") ) {
                final Object value = values.remove("InhtdSpecValAssgmtIsTmpChgd");
                if( (value == null) || (!value.equals(getInhtdSpecValAssgmtIsTmpChgd())) ) {
                    setInhtdSpecValAssgmtIsTmpChgd(((Boolean) value));
                }
            }
            if( values.containsKey("InhtdSpecValAssgmtIsPermChgd") ) {
                final Object value = values.remove("InhtdSpecValAssgmtIsPermChgd");
                if( (value == null) || (!value.equals(getInhtdSpecValAssgmtIsPermChgd())) ) {
                    setInhtdSpecValAssgmtIsPermChgd(((Boolean) value));
                }
            }
            if( values.containsKey("SpecInheritanceTemplate") ) {
                final Object value = values.remove("SpecInheritanceTemplate");
                if( (value == null) || (!value.equals(getSpecInheritanceTemplate())) ) {
                    setSpecInheritanceTemplate(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtInheritanceParent") ) {
                final Object value = values.remove("SpecValAssgmtInheritanceParent");
                if( (value == null) || (!value.equals(getSpecValAssgmtInheritanceParent())) ) {
                    setSpecValAssgmtInheritanceParent(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtInheritanceRoot") ) {
                final Object value = values.remove("SpecValAssgmtInheritanceRoot");
                if( (value == null) || (!value.equals(getSpecValAssgmtInheritanceRoot())) ) {
                    setSpecValAssgmtInheritanceRoot(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtRootSpecIntID") ) {
                final Object value = values.remove("SpecValAssgmtRootSpecIntID");
                if( (value == null) || (!value.equals(getSpecValAssgmtRootSpecIntID())) ) {
                    setSpecValAssgmtRootSpecIntID(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtSortSequence") ) {
                final Object value = values.remove("SpecValAssgmtSortSequence");
                if( (value == null) || (!value.equals(getSpecValAssgmtSortSequence())) ) {
                    setSpecValAssgmtSortSequence(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtUnitRefDimension") ) {
                final Object value = values.remove("SpecValAssgmtUnitRefDimension");
                if( (value == null) || (!value.equals(getSpecValAssgmtUnitRefDimension())) ) {
                    setSpecValAssgmtUnitRefDimension(((String) value));
                }
            }
            if( values.containsKey("ValueAssignmentSource") ) {
                final Object value = values.remove("ValueAssignmentSource");
                if( (value == null) || (!value.equals(getValueAssignmentSource())) ) {
                    setValueAssignmentSource(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtUsageIsExcluded") ) {
                final Object value = values.remove("SpecValAssgmtUsageIsExcluded");
                if( (value == null) || (!value.equals(getSpecValAssgmtUsageIsExcluded())) ) {
                    setSpecValAssgmtUsageIsExcluded(((Boolean) value));
                }
            }
            if( values.containsKey("SpecValAssgmtUsageIsActive") ) {
                final Object value = values.remove("SpecValAssgmtUsageIsActive");
                if( (value == null) || (!value.equals(getSpecValAssgmtUsageIsActive())) ) {
                    setSpecValAssgmtUsageIsActive(((Boolean) value));
                }
            }
            if( values.containsKey("SpecValAssgmtUsageIsRelevant") ) {
                final Object value = values.remove("SpecValAssgmtUsageIsRelevant");
                if( (value == null) || (!value.equals(getSpecValAssgmtUsageIsRelevant())) ) {
                    setSpecValAssgmtUsageIsRelevant(((Boolean) value));
                }
            }
            if( values.containsKey("SpecificationAuthznGroup") ) {
                final Object value = values.remove("SpecificationAuthznGroup");
                if( (value == null) || (!value.equals(getSpecificationAuthznGroup())) ) {
                    setSpecificationAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
            if( values.containsKey("Characteristic") ) {
                final Object value = values.remove("Characteristic");
                if( (value == null) || (!value.equals(getCharacteristic())) ) {
                    setCharacteristic(((String) value));
                }
            }
            if( values.containsKey("CharacteristicFormat") ) {
                final Object value = values.remove("CharacteristicFormat");
                if( (value == null) || (!value.equals(getCharacteristicFormat())) ) {
                    setCharacteristicFormat(((String) value));
                }
            }
            if( values.containsKey("CharacteristicValue") ) {
                final Object value = values.remove("CharacteristicValue");
                if( (value == null) || (!value.equals(getCharacteristicValue())) ) {
                    setCharacteristicValue(((String) value));
                }
            }
            if( values.containsKey("CharcDecimalMinimumValue") ) {
                final Object value = values.remove("CharcDecimalMinimumValue");
                if( (value == null) || (!value.equals(getCharcDecimalMinimumValue())) ) {
                    setCharcDecimalMinimumValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharacteristicMinimumValueUnit") ) {
                final Object value = values.remove("CharacteristicMinimumValueUnit");
                if( (value == null) || (!value.equals(getCharacteristicMinimumValueUnit())) ) {
                    setCharacteristicMinimumValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcDecimalMaximumValue") ) {
                final Object value = values.remove("CharcDecimalMaximumValue");
                if( (value == null) || (!value.equals(getCharcDecimalMaximumValue())) ) {
                    setCharcDecimalMaximumValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharacteristicMaximumValueUnit") ) {
                final Object value = values.remove("CharacteristicMaximumValueUnit");
                if( (value == null) || (!value.equals(getCharacteristicMaximumValueUnit())) ) {
                    setCharacteristicMaximumValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharacteristicValueDpndcyCode") ) {
                final Object value = values.remove("CharacteristicValueDpndcyCode");
                if( (value == null) || (!value.equals(getCharacteristicValueDpndcyCode())) ) {
                    setCharacteristicValueDpndcyCode(((String) value));
                }
            }
            if( values.containsKey("CharcValidityStartDate") ) {
                final Object value = values.remove("CharcValidityStartDate");
                if( (value == null) || (!value.equals(getCharcValidityStartDate())) ) {
                    setCharcValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcValidityEndDate") ) {
                final Object value = values.remove("CharcValidityEndDate");
                if( (value == null) || (!value.equals(getCharcValidityEndDate())) ) {
                    setCharcValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharacteristicIsDeleted") ) {
                final Object value = values.remove("CharacteristicIsDeleted");
                if( (value == null) || (!value.equals(getCharacteristicIsDeleted())) ) {
                    setCharacteristicIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("CharcCurrencyMinimumValue") ) {
                final Object value = values.remove("CharcCurrencyMinimumValue");
                if( (value == null) || (!value.equals(getCharcCurrencyMinimumValue())) ) {
                    setCharcCurrencyMinimumValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcFromAmount") ) {
                final Object value = values.remove("CharcFromAmount");
                if( (value == null) || (!value.equals(getCharcFromAmount())) ) {
                    setCharcFromAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToAmount") ) {
                final Object value = values.remove("CharcToAmount");
                if( (value == null) || (!value.equals(getCharcToAmount())) ) {
                    setCharcToAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("CharcValueUnit") ) {
                final Object value = values.remove("CharcValueUnit");
                if( (value == null) || (!value.equals(getCharcValueUnit())) ) {
                    setCharcValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcDateMinimumValue") ) {
                final Object value = values.remove("CharcDateMinimumValue");
                if( (value == null) || (!value.equals(getCharcDateMinimumValue())) ) {
                    setCharcDateMinimumValue(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcFromDate") ) {
                final Object value = values.remove("CharcFromDate");
                if( (value == null) || (!value.equals(getCharcFromDate())) ) {
                    setCharcFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcToDate") ) {
                final Object value = values.remove("CharcToDate");
                if( (value == null) || (!value.equals(getCharcToDate())) ) {
                    setCharcToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcTimeMinimumValue") ) {
                final Object value = values.remove("CharcTimeMinimumValue");
                if( (value == null) || (!value.equals(getCharcTimeMinimumValue())) ) {
                    setCharcTimeMinimumValue(((LocalTime) value));
                }
            }
            if( values.containsKey("CharcFromTime") ) {
                final Object value = values.remove("CharcFromTime");
                if( (value == null) || (!value.equals(getCharcFromTime())) ) {
                    setCharcFromTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharcToTime") ) {
                final Object value = values.remove("CharcToTime");
                if( (value == null) || (!value.equals(getCharcToTime())) ) {
                    setCharcToTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharacteristicInternalID") ) {
                final Object value = values.remove("CharacteristicInternalID");
                if( (value == null) || (!value.equals(getCharacteristicInternalID())) ) {
                    setCharacteristicInternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SpecCharByValueAssgmtInstField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecCharByValueAssgmtInstField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecCharByValueAssgmtInstField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecCharByValueAssgmtInstField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

}
