/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecIdentifierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier SpecIdentifier} entity using
 * key fields. This fluent helper allows methods which modify the underlying query to be called before executing the
 * query itself.
 *
 */
public class SpecIdentifierByKeyFluentHelper
    extends
    FluentHelperByKey<SpecIdentifierByKeyFluentHelper, SpecIdentifier, SpecIdentifierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecIdentifier SpecIdentifier} entity
     * with the provided key field values. To perform execution, call the {@link #executeRequest executeRequest} method
     * on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecIdentifier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecIdentifier}
     * @param specIdfgDescInternalID
     *            Sequential Number of Data Record
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specIdfgDescChangeState
     *            Sequential Number of the Change State
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public SpecIdentifierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specIdfgDescInternalID,
        final String specIdfgDescChangeState )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecIdfgDescInternalID", specIdfgDescInternalID);
        this.key.put("SpecIdfgDescChangeState", specIdfgDescChangeState);
    }

    @Override
    @Nonnull
    protected Class<SpecIdentifier> getEntityClass()
    {
        return SpecIdentifier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
