/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecStatusAttributesSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes SpecStatusAttributes}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SpecStatusAttributesByKeyFluentHelper
    extends
    FluentHelperByKey<SpecStatusAttributesByKeyFluentHelper, SpecStatusAttributes, SpecStatusAttributesSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes
     * SpecStatusAttributes} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecStatusAttributes}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecStatusAttributes}
     * @param specificationHeaderStatus
     *            Status Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationHdrStsAttribute
     *            Attribute per Object Type
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public SpecStatusAttributesByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specificationHeaderStatus,
        final String specificationHdrStsAttribute )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecificationHeaderStatus", specificationHeaderStatus);
        this.key.put("SpecificationHdrStsAttribute", specificationHdrStsAttribute);
    }

    @Override
    @Nonnull
    protected Class<SpecStatusAttributes> getEntityClass()
    {
        return SpecStatusAttributes.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
