/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.SpecStatusNextStatusField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.SpecStatusNextStatusLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecStatusNextStatusSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Specification Next Status
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecStatusNextStatusType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecStatusNextStatus extends VdmEntity<SpecStatusNextStatus>
{

    /**
     * Selector for all available fields of SpecStatusNextStatus.
     *
     */
    public final static SpecStatusNextStatusSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @return Status Scheme
     */
    @Key
    @SerializedName( "SpecificationHdrStsSchema" )
    @JsonProperty( "SpecificationHdrStsSchema" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchema" )
    private String specificationHdrStsSchema;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchema</b> field to query operations.
     *
     */
    public final static SpecStatusNextStatusField<String> SPECIFICATION_HDR_STS_SCHEMA =
        new SpecStatusNextStatusField<String>("SpecificationHdrStsSchema");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchemaFrSts</b>
     * </p>
     *
     * @return Status Identification
     */
    @Key
    @SerializedName( "SpecificationHdrStsSchemaFrSts" )
    @JsonProperty( "SpecificationHdrStsSchemaFrSts" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchemaFrSts" )
    private String specificationHdrStsSchemaFrSts;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchemaFrSts</b> field to query operations.
     *
     */
    public final static SpecStatusNextStatusField<String> SPECIFICATION_HDR_STS_SCHEMA_FR_STS =
        new SpecStatusNextStatusField<String>("SpecificationHdrStsSchemaFrSts");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchemaToSts</b>
     * </p>
     *
     * @return Status To
     */
    @Key
    @SerializedName( "SpecificationHdrStsSchemaToSts" )
    @JsonProperty( "SpecificationHdrStsSchemaToSts" )
    @Nullable
    @ODataField( odataName = "SpecificationHdrStsSchemaToSts" )
    private String specificationHdrStsSchemaToSts;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationHdrStsSchemaToSts</b> field to query operations.
     *
     */
    public final static SpecStatusNextStatusField<String> SPECIFICATION_HDR_STS_SCHEMA_TO_STS =
        new SpecStatusNextStatusField<String>("SpecificationHdrStsSchemaToSts");
    /**
     * Navigation property <b>to_NextStatusAttributes</b> for <b>SpecStatusNextStatus</b> to multiple
     * <b>SpecStatusAttributes</b>.
     *
     */
    @SerializedName( "to_NextStatusAttributes" )
    @JsonProperty( "to_NextStatusAttributes" )
    @ODataField( odataName = "to_NextStatusAttributes" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecStatusAttributes> toNextStatusAttributes;
    /**
     * Use with available fluent helpers to apply the <b>to_NextStatusAttributes</b> navigation property to query
     * operations.
     *
     */
    public final static SpecStatusNextStatusLink<SpecStatusAttributes> TO_NEXT_STATUS_ATTRIBUTES =
        new SpecStatusNextStatusLink<SpecStatusAttributes>("to_NextStatusAttributes");

    @Nonnull
    @Override
    public Class<SpecStatusNextStatus> getType()
    {
        return SpecStatusNextStatus.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchema</b>
     * </p>
     *
     * @param specificationHdrStsSchema
     *            Status Scheme
     */
    public void setSpecificationHdrStsSchema( @Nullable final String specificationHdrStsSchema )
    {
        rememberChangedField("SpecificationHdrStsSchema", this.specificationHdrStsSchema);
        this.specificationHdrStsSchema = specificationHdrStsSchema;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchemaFrSts</b>
     * </p>
     *
     * @param specificationHdrStsSchemaFrSts
     *            Status Identification
     */
    public void setSpecificationHdrStsSchemaFrSts( @Nullable final String specificationHdrStsSchemaFrSts )
    {
        rememberChangedField("SpecificationHdrStsSchemaFrSts", this.specificationHdrStsSchemaFrSts);
        this.specificationHdrStsSchemaFrSts = specificationHdrStsSchemaFrSts;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationHdrStsSchemaToSts</b>
     * </p>
     *
     * @param specificationHdrStsSchemaToSts
     *            Status To
     */
    public void setSpecificationHdrStsSchemaToSts( @Nullable final String specificationHdrStsSchemaToSts )
    {
        rememberChangedField("SpecificationHdrStsSchemaToSts", this.specificationHdrStsSchemaToSts);
        this.specificationHdrStsSchemaToSts = specificationHdrStsSchemaToSts;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecStatusNextStatus";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        result.put("SpecificationHdrStsSchemaFrSts", getSpecificationHdrStsSchemaFrSts());
        result.put("SpecificationHdrStsSchemaToSts", getSpecificationHdrStsSchemaToSts());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecificationHdrStsSchema", getSpecificationHdrStsSchema());
        values.put("SpecificationHdrStsSchemaFrSts", getSpecificationHdrStsSchemaFrSts());
        values.put("SpecificationHdrStsSchemaToSts", getSpecificationHdrStsSchemaToSts());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecificationHdrStsSchema") ) {
                final Object value = values.remove("SpecificationHdrStsSchema");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchema())) ) {
                    setSpecificationHdrStsSchema(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsSchemaFrSts") ) {
                final Object value = values.remove("SpecificationHdrStsSchemaFrSts");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchemaFrSts())) ) {
                    setSpecificationHdrStsSchemaFrSts(((String) value));
                }
            }
            if( values.containsKey("SpecificationHdrStsSchemaToSts") ) {
                final Object value = values.remove("SpecificationHdrStsSchemaToSts");
                if( (value == null) || (!value.equals(getSpecificationHdrStsSchemaToSts())) ) {
                    setSpecificationHdrStsSchemaToSts(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_NextStatusAttributes") ) {
                final Object value = (values).remove("to_NextStatusAttributes");
                if( value instanceof Iterable ) {
                    if( toNextStatusAttributes == null ) {
                        toNextStatusAttributes = Lists.newArrayList();
                    } else {
                        toNextStatusAttributes = Lists.newArrayList(toNextStatusAttributes);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecStatusAttributes entity;
                        if( toNextStatusAttributes.size() > i ) {
                            entity = toNextStatusAttributes.get(i);
                        } else {
                            entity = new SpecStatusAttributes();
                            toNextStatusAttributes.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SpecStatusNextStatusField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SpecStatusNextStatusField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecStatusNextStatusField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecStatusNextStatusField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toNextStatusAttributes != null ) {
            (values).put("to_NextStatusAttributes", toNextStatusAttributes);
        }
        return values;
    }

    /**
     * Fetches the <b>SpecStatusAttributes</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_NextStatusAttributes</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecStatusAttributes</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> fetchNextStatusAttributes()
    {
        return fetchFieldAsList("to_NextStatusAttributes", SpecStatusAttributes.class);
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_NextStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_NextStatusAttributes</b> of a queried <b>SpecStatusNextStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecStatusAttributes</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecStatusAttributes> getNextStatusAttributesOrFetch()
    {
        if( toNextStatusAttributes == null ) {
            toNextStatusAttributes = fetchNextStatusAttributes();
        }
        return toNextStatusAttributes;
    }

    /**
     * Retrieval of associated <b>SpecStatusAttributes</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_NextStatusAttributes</b>.
     * <p>
     * If the navigation property for an entity <b>SpecStatusNextStatus</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_NextStatusAttributes</b> is already loaded, the result
     *         will contain the <b>SpecStatusAttributes</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecStatusAttributes>> getNextStatusAttributesIfPresent()
    {
        return Option.of(toNextStatusAttributes);
    }

    /**
     * Overwrites the list of associated <b>SpecStatusAttributes</b> entities for the loaded navigation property
     * <b>to_NextStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_NextStatusAttributes</b> of a queried <b>SpecStatusNextStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecStatusAttributes</b> entities.
     */
    public void setNextStatusAttributes( @Nonnull final List<SpecStatusAttributes> value )
    {
        if( toNextStatusAttributes == null ) {
            toNextStatusAttributes = Lists.newArrayList();
        }
        toNextStatusAttributes.clear();
        toNextStatusAttributes.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecStatusAttributes</b> entities. This corresponds to the OData
     * navigation property <b>to_NextStatusAttributes</b>.
     * <p>
     * If the navigation property <b>to_NextStatusAttributes</b> of a queried <b>SpecStatusNextStatus</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecStatusAttributes</b> entities.
     */
    public void addNextStatusAttributes( SpecStatusAttributes... entity )
    {
        if( toNextStatusAttributes == null ) {
            toNextStatusAttributes = Lists.newArrayList();
        }
        toNextStatusAttributes.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SpecStatusNextStatus instances.
     *
     */
    public final static class SpecStatusNextStatusBuilder
    {

        private List<SpecStatusAttributes> toNextStatusAttributes = Lists.newArrayList();

        private SpecStatusNextStatus.SpecStatusNextStatusBuilder toNextStatusAttributes(
            final List<SpecStatusAttributes> value )
        {
            toNextStatusAttributes.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_NextStatusAttributes</b> for <b>SpecStatusNextStatus</b> to multiple
         * <b>SpecStatusAttributes</b>.
         *
         * @param value
         *            The SpecStatusAttributess to build this SpecStatusNextStatus with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SpecStatusNextStatus.SpecStatusNextStatusBuilder nextStatusAttributes( SpecStatusAttributes... value )
        {
            return toNextStatusAttributes(Lists.newArrayList(value));
        }

    }

}
