/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecStatusNextStatusSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus SpecStatusNextStatus}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SpecStatusNextStatusByKeyFluentHelper
    extends
    FluentHelperByKey<SpecStatusNextStatusByKeyFluentHelper, SpecStatusNextStatus, SpecStatusNextStatusSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusNextStatus
     * SpecStatusNextStatus} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SpecStatusNextStatus}
     * @param specificationHdrStsSchema
     *            Status Scheme
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param specificationHdrStsSchemaToSts
     *            Status To
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code SpecStatusNextStatus}
     * @param specificationHdrStsSchemaFrSts
     *            Status Identification
     *            <p>
     *            Constraints: Not nullable, Maximum length: 20
     *            </p>
     */
    public SpecStatusNextStatusByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String specificationHdrStsSchema,
        final String specificationHdrStsSchemaFrSts,
        final String specificationHdrStsSchemaToSts )
    {
        super(servicePath, entityCollection);
        this.key.put("SpecificationHdrStsSchema", specificationHdrStsSchema);
        this.key.put("SpecificationHdrStsSchemaFrSts", specificationHdrStsSchemaFrSts);
        this.key.put("SpecificationHdrStsSchemaToSts", specificationHdrStsSchemaToSts);
    }

    @Override
    @Nonnull
    protected Class<SpecStatusNextStatus> getEntityClass()
    {
        return SpecStatusNextStatus.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
