/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.SpecValAssgmtInstanceWthCompField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.SpecValAssgmtInstanceWthCompLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable.SpecValAssgmtInstanceWthCompSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Specification Value Assignment Instance with Composition
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_SpecValAssgmtInstanceWthCompType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SpecValAssgmtInstanceWthComp extends VdmEntity<SpecValAssgmtInstanceWthComp>
{

    /**
     * Selector for all available fields of SpecValAssgmtInstanceWthComp.
     *
     */
    public final static SpecValAssgmtInstanceWthCompSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @return Sequential Number of Data Record
     */
    @Key
    @SerializedName( "SpecificationInternalID" )
    @JsonProperty( "SpecificationInternalID" )
    @Nullable
    @ODataField( odataName = "SpecificationInternalID" )
    private String specificationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationInternalID</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPECIFICATION_INTERNAL_ID =
        new SpecValAssgmtInstanceWthCompField<String>("SpecificationInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtType</b>
     * </p>
     *
     * @return Value Assignment Type
     */
    @Key
    @SerializedName( "SpecValAssgmtType" )
    @JsonProperty( "SpecValAssgmtType" )
    @Nullable
    @ODataField( odataName = "SpecValAssgmtType" )
    private String specValAssgmtType;
    /**
     * Use with available fluent helpers to apply the <b>SpecValAssgmtType</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPEC_VAL_ASSGMT_TYPE =
        new SpecValAssgmtInstanceWthCompField<String>("SpecValAssgmtType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationRating</b>
     * </p>
     *
     * @return Rating
     */
    @Key
    @SerializedName( "SpecificationRating" )
    @JsonProperty( "SpecificationRating" )
    @Nullable
    @ODataField( odataName = "SpecificationRating" )
    private String specificationRating;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationRating</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPECIFICATION_RATING =
        new SpecValAssgmtInstanceWthCompField<String>("SpecificationRating");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationValidityArea</b>
     * </p>
     *
     * @return Validity Area
     */
    @Key
    @SerializedName( "SpecificationValidityArea" )
    @JsonProperty( "SpecificationValidityArea" )
    @Nullable
    @ODataField( odataName = "SpecificationValidityArea" )
    private String specificationValidityArea;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationValidityArea</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPECIFICATION_VALIDITY_AREA =
        new SpecValAssgmtInstanceWthCompField<String>("SpecificationValidityArea");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSpecificationIntID</b>
     * </p>
     *
     * @return Reference to Specification Header of a Component
     */
    @Key
    @SerializedName( "ComponentSpecificationIntID" )
    @JsonProperty( "ComponentSpecificationIntID" )
    @Nullable
    @ODataField( odataName = "ComponentSpecificationIntID" )
    private String componentSpecificationIntID;
    /**
     * Use with available fluent helpers to apply the <b>ComponentSpecificationIntID</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMPONENT_SPECIFICATION_INT_ID =
        new SpecValAssgmtInstanceWthCompField<String>("ComponentSpecificationIntID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSpecification</b>
     * </p>
     *
     * @return Specification
     */
    @SerializedName( "ComponentSpecification" )
    @JsonProperty( "ComponentSpecification" )
    @Nullable
    @ODataField( odataName = "ComponentSpecification" )
    private String componentSpecification;
    /**
     * Use with available fluent helpers to apply the <b>ComponentSpecification</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMPONENT_SPECIFICATION =
        new SpecValAssgmtInstanceWthCompField<String>("ComponentSpecification");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecComponentType</b>
     * </p>
     *
     * @return Component Type
     */
    @SerializedName( "CompSpecComponentType" )
    @JsonProperty( "CompSpecComponentType" )
    @Nullable
    @ODataField( odataName = "CompSpecComponentType" )
    private String compSpecComponentType;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecComponentType</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_COMPONENT_TYPE =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecComponentType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecLowerLimitOperator</b>
     * </p>
     *
     * @return Operator for Lower Limit
     */
    @SerializedName( "CompSpecLowerLimitOperator" )
    @JsonProperty( "CompSpecLowerLimitOperator" )
    @Nullable
    @ODataField( odataName = "CompSpecLowerLimitOperator" )
    private String compSpecLowerLimitOperator;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecLowerLimitOperator</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_LOWER_LIMIT_OPERATOR =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecLowerLimitOperator");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecLowerLimit</b>
     * </p>
     *
     * @return Lower Limit of a Component Proportion
     */
    @SerializedName( "CompSpecLowerLimit" )
    @JsonProperty( "CompSpecLowerLimit" )
    @Nullable
    @ODataField( odataName = "CompSpecLowerLimit" )
    private BigDecimal compSpecLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecLowerLimit</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<BigDecimal> COMP_SPEC_LOWER_LIMIT =
        new SpecValAssgmtInstanceWthCompField<BigDecimal>("CompSpecLowerLimit");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUpperLimitOperator</b>
     * </p>
     *
     * @return Operator for Upper Limit
     */
    @SerializedName( "CompSpecUpperLimitOperator" )
    @JsonProperty( "CompSpecUpperLimitOperator" )
    @Nullable
    @ODataField( odataName = "CompSpecUpperLimitOperator" )
    private String compSpecUpperLimitOperator;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecUpperLimitOperator</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_UPPER_LIMIT_OPERATOR =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecUpperLimitOperator");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUpperLimit</b>
     * </p>
     *
     * @return Upper limit of a component proportion
     */
    @SerializedName( "CompSpecUpperLimit" )
    @JsonProperty( "CompSpecUpperLimit" )
    @Nullable
    @ODataField( odataName = "CompSpecUpperLimit" )
    private BigDecimal compSpecUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecUpperLimit</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<BigDecimal> COMP_SPEC_UPPER_LIMIT =
        new SpecValAssgmtInstanceWthCompField<BigDecimal>("CompSpecUpperLimit");
    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecQuantity</b>
     * </p>
     *
     * @return Target Value or Actual Value of a Component
     */
    @SerializedName( "CompSpecQuantity" )
    @JsonProperty( "CompSpecQuantity" )
    @Nullable
    @ODataField( odataName = "CompSpecQuantity" )
    private BigDecimal compSpecQuantity;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecQuantity</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<BigDecimal> COMP_SPEC_QUANTITY =
        new SpecValAssgmtInstanceWthCompField<BigDecimal>("CompSpecQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUnit</b>
     * </p>
     *
     * @return Unit for Quantity Specification
     */
    @SerializedName( "CompSpecUnit" )
    @JsonProperty( "CompSpecUnit" )
    @Nullable
    @ODataField( odataName = "CompSpecUnit" )
    private String compSpecUnit;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecUnit</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_UNIT =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecSortSequence</b>
     * </p>
     *
     * @return Sort Order
     */
    @SerializedName( "CompSpecSortSequence" )
    @JsonProperty( "CompSpecSortSequence" )
    @Nullable
    @ODataField( odataName = "CompSpecSortSequence" )
    private String compSpecSortSequence;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecSortSequence</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_SORT_SEQUENCE =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecSortSequence");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecExceptionCode</b>
     * </p>
     *
     * @return Exception Value of a Component
     */
    @SerializedName( "CompSpecExceptionCode" )
    @JsonProperty( "CompSpecExceptionCode" )
    @Nullable
    @ODataField( odataName = "CompSpecExceptionCode" )
    private String compSpecExceptionCode;
    /**
     * Use with available fluent helpers to apply the <b>CompSpecExceptionCode</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> COMP_SPEC_EXCEPTION_CODE =
        new SpecValAssgmtInstanceWthCompField<String>("CompSpecExceptionCode");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "SpecificationAuthznGroup" )
    @JsonProperty( "SpecificationAuthznGroup" )
    @Nullable
    @ODataField( odataName = "SpecificationAuthznGroup" )
    private String specificationAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationAuthznGroup</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPECIFICATION_AUTHZN_GROUP =
        new SpecValAssgmtInstanceWthCompField<String>("SpecificationAuthznGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompField<String> SPECIFICATION_TYPE =
        new SpecValAssgmtInstanceWthCompField<String>("SpecificationType");
    /**
     * Navigation property <b>to_SubstanceIdentifier</b> for <b>SpecValAssgmtInstanceWthComp</b> to multiple
     * <b>SpecIdentifier</b>.
     *
     */
    @SerializedName( "to_SubstanceIdentifier" )
    @JsonProperty( "to_SubstanceIdentifier" )
    @ODataField( odataName = "to_SubstanceIdentifier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SpecIdentifier> toSubstanceIdentifier;
    /**
     * Use with available fluent helpers to apply the <b>to_SubstanceIdentifier</b> navigation property to query
     * operations.
     *
     */
    public final static SpecValAssgmtInstanceWthCompLink<SpecIdentifier> TO_SUBSTANCE_IDENTIFIER =
        new SpecValAssgmtInstanceWthCompLink<SpecIdentifier>("to_SubstanceIdentifier");

    @Nonnull
    @Override
    public Class<SpecValAssgmtInstanceWthComp> getType()
    {
        return SpecValAssgmtInstanceWthComp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @param specificationInternalID
     *            Sequential Number of Data Record
     */
    public void setSpecificationInternalID( @Nullable final String specificationInternalID )
    {
        rememberChangedField("SpecificationInternalID", this.specificationInternalID);
        this.specificationInternalID = specificationInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SpecValAssgmtType</b>
     * </p>
     *
     * @param specValAssgmtType
     *            Value Assignment Type
     */
    public void setSpecValAssgmtType( @Nullable final String specValAssgmtType )
    {
        rememberChangedField("SpecValAssgmtType", this.specValAssgmtType);
        this.specValAssgmtType = specValAssgmtType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationRating</b>
     * </p>
     *
     * @param specificationRating
     *            Rating
     */
    public void setSpecificationRating( @Nullable final String specificationRating )
    {
        rememberChangedField("SpecificationRating", this.specificationRating);
        this.specificationRating = specificationRating;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationValidityArea</b>
     * </p>
     *
     * @param specificationValidityArea
     *            Validity Area
     */
    public void setSpecificationValidityArea( @Nullable final String specificationValidityArea )
    {
        rememberChangedField("SpecificationValidityArea", this.specificationValidityArea);
        this.specificationValidityArea = specificationValidityArea;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSpecificationIntID</b>
     * </p>
     *
     * @param componentSpecificationIntID
     *            Reference to Specification Header of a Component
     */
    public void setComponentSpecificationIntID( @Nullable final String componentSpecificationIntID )
    {
        rememberChangedField("ComponentSpecificationIntID", this.componentSpecificationIntID);
        this.componentSpecificationIntID = componentSpecificationIntID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ComponentSpecification</b>
     * </p>
     *
     * @param componentSpecification
     *            Specification
     */
    public void setComponentSpecification( @Nullable final String componentSpecification )
    {
        rememberChangedField("ComponentSpecification", this.componentSpecification);
        this.componentSpecification = componentSpecification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecComponentType</b>
     * </p>
     *
     * @param compSpecComponentType
     *            Component Type
     */
    public void setCompSpecComponentType( @Nullable final String compSpecComponentType )
    {
        rememberChangedField("CompSpecComponentType", this.compSpecComponentType);
        this.compSpecComponentType = compSpecComponentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecLowerLimitOperator</b>
     * </p>
     *
     * @param compSpecLowerLimitOperator
     *            Operator for Lower Limit
     */
    public void setCompSpecLowerLimitOperator( @Nullable final String compSpecLowerLimitOperator )
    {
        rememberChangedField("CompSpecLowerLimitOperator", this.compSpecLowerLimitOperator);
        this.compSpecLowerLimitOperator = compSpecLowerLimitOperator;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecLowerLimit</b>
     * </p>
     *
     * @param compSpecLowerLimit
     *            Lower Limit of a Component Proportion
     */
    public void setCompSpecLowerLimit( @Nullable final BigDecimal compSpecLowerLimit )
    {
        rememberChangedField("CompSpecLowerLimit", this.compSpecLowerLimit);
        this.compSpecLowerLimit = compSpecLowerLimit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUpperLimitOperator</b>
     * </p>
     *
     * @param compSpecUpperLimitOperator
     *            Operator for Upper Limit
     */
    public void setCompSpecUpperLimitOperator( @Nullable final String compSpecUpperLimitOperator )
    {
        rememberChangedField("CompSpecUpperLimitOperator", this.compSpecUpperLimitOperator);
        this.compSpecUpperLimitOperator = compSpecUpperLimitOperator;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUpperLimit</b>
     * </p>
     *
     * @param compSpecUpperLimit
     *            Upper limit of a component proportion
     */
    public void setCompSpecUpperLimit( @Nullable final BigDecimal compSpecUpperLimit )
    {
        rememberChangedField("CompSpecUpperLimit", this.compSpecUpperLimit);
        this.compSpecUpperLimit = compSpecUpperLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 10, Scale: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecQuantity</b>
     * </p>
     *
     * @param compSpecQuantity
     *            Target Value or Actual Value of a Component
     */
    public void setCompSpecQuantity( @Nullable final BigDecimal compSpecQuantity )
    {
        rememberChangedField("CompSpecQuantity", this.compSpecQuantity);
        this.compSpecQuantity = compSpecQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecUnit</b>
     * </p>
     *
     * @param compSpecUnit
     *            Unit for Quantity Specification
     */
    public void setCompSpecUnit( @Nullable final String compSpecUnit )
    {
        rememberChangedField("CompSpecUnit", this.compSpecUnit);
        this.compSpecUnit = compSpecUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecSortSequence</b>
     * </p>
     *
     * @param compSpecSortSequence
     *            Sort Order
     */
    public void setCompSpecSortSequence( @Nullable final String compSpecSortSequence )
    {
        rememberChangedField("CompSpecSortSequence", this.compSpecSortSequence);
        this.compSpecSortSequence = compSpecSortSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>CompSpecExceptionCode</b>
     * </p>
     *
     * @param compSpecExceptionCode
     *            Exception Value of a Component
     */
    public void setCompSpecExceptionCode( @Nullable final String compSpecExceptionCode )
    {
        rememberChangedField("CompSpecExceptionCode", this.compSpecExceptionCode);
        this.compSpecExceptionCode = compSpecExceptionCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     */
    public void setSpecificationAuthznGroup( @Nullable final String specificationAuthznGroup )
    {
        rememberChangedField("SpecificationAuthznGroup", this.specificationAuthznGroup);
        this.specificationAuthznGroup = specificationAuthznGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Specification Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_SpecValAssgmtInstanceWthComp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SpecificationInternalID", getSpecificationInternalID());
        result.put("SpecValAssgmtType", getSpecValAssgmtType());
        result.put("SpecificationRating", getSpecificationRating());
        result.put("SpecificationValidityArea", getSpecificationValidityArea());
        result.put("ComponentSpecificationIntID", getComponentSpecificationIntID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SpecificationInternalID", getSpecificationInternalID());
        values.put("SpecValAssgmtType", getSpecValAssgmtType());
        values.put("SpecificationRating", getSpecificationRating());
        values.put("SpecificationValidityArea", getSpecificationValidityArea());
        values.put("ComponentSpecificationIntID", getComponentSpecificationIntID());
        values.put("ComponentSpecification", getComponentSpecification());
        values.put("CompSpecComponentType", getCompSpecComponentType());
        values.put("CompSpecLowerLimitOperator", getCompSpecLowerLimitOperator());
        values.put("CompSpecLowerLimit", getCompSpecLowerLimit());
        values.put("CompSpecUpperLimitOperator", getCompSpecUpperLimitOperator());
        values.put("CompSpecUpperLimit", getCompSpecUpperLimit());
        values.put("CompSpecQuantity", getCompSpecQuantity());
        values.put("CompSpecUnit", getCompSpecUnit());
        values.put("CompSpecSortSequence", getCompSpecSortSequence());
        values.put("CompSpecExceptionCode", getCompSpecExceptionCode());
        values.put("SpecificationAuthznGroup", getSpecificationAuthznGroup());
        values.put("SpecificationType", getSpecificationType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SpecificationInternalID") ) {
                final Object value = values.remove("SpecificationInternalID");
                if( (value == null) || (!value.equals(getSpecificationInternalID())) ) {
                    setSpecificationInternalID(((String) value));
                }
            }
            if( values.containsKey("SpecValAssgmtType") ) {
                final Object value = values.remove("SpecValAssgmtType");
                if( (value == null) || (!value.equals(getSpecValAssgmtType())) ) {
                    setSpecValAssgmtType(((String) value));
                }
            }
            if( values.containsKey("SpecificationRating") ) {
                final Object value = values.remove("SpecificationRating");
                if( (value == null) || (!value.equals(getSpecificationRating())) ) {
                    setSpecificationRating(((String) value));
                }
            }
            if( values.containsKey("SpecificationValidityArea") ) {
                final Object value = values.remove("SpecificationValidityArea");
                if( (value == null) || (!value.equals(getSpecificationValidityArea())) ) {
                    setSpecificationValidityArea(((String) value));
                }
            }
            if( values.containsKey("ComponentSpecificationIntID") ) {
                final Object value = values.remove("ComponentSpecificationIntID");
                if( (value == null) || (!value.equals(getComponentSpecificationIntID())) ) {
                    setComponentSpecificationIntID(((String) value));
                }
            }
            if( values.containsKey("ComponentSpecification") ) {
                final Object value = values.remove("ComponentSpecification");
                if( (value == null) || (!value.equals(getComponentSpecification())) ) {
                    setComponentSpecification(((String) value));
                }
            }
            if( values.containsKey("CompSpecComponentType") ) {
                final Object value = values.remove("CompSpecComponentType");
                if( (value == null) || (!value.equals(getCompSpecComponentType())) ) {
                    setCompSpecComponentType(((String) value));
                }
            }
            if( values.containsKey("CompSpecLowerLimitOperator") ) {
                final Object value = values.remove("CompSpecLowerLimitOperator");
                if( (value == null) || (!value.equals(getCompSpecLowerLimitOperator())) ) {
                    setCompSpecLowerLimitOperator(((String) value));
                }
            }
            if( values.containsKey("CompSpecLowerLimit") ) {
                final Object value = values.remove("CompSpecLowerLimit");
                if( (value == null) || (!value.equals(getCompSpecLowerLimit())) ) {
                    setCompSpecLowerLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompSpecUpperLimitOperator") ) {
                final Object value = values.remove("CompSpecUpperLimitOperator");
                if( (value == null) || (!value.equals(getCompSpecUpperLimitOperator())) ) {
                    setCompSpecUpperLimitOperator(((String) value));
                }
            }
            if( values.containsKey("CompSpecUpperLimit") ) {
                final Object value = values.remove("CompSpecUpperLimit");
                if( (value == null) || (!value.equals(getCompSpecUpperLimit())) ) {
                    setCompSpecUpperLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompSpecQuantity") ) {
                final Object value = values.remove("CompSpecQuantity");
                if( (value == null) || (!value.equals(getCompSpecQuantity())) ) {
                    setCompSpecQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("CompSpecUnit") ) {
                final Object value = values.remove("CompSpecUnit");
                if( (value == null) || (!value.equals(getCompSpecUnit())) ) {
                    setCompSpecUnit(((String) value));
                }
            }
            if( values.containsKey("CompSpecSortSequence") ) {
                final Object value = values.remove("CompSpecSortSequence");
                if( (value == null) || (!value.equals(getCompSpecSortSequence())) ) {
                    setCompSpecSortSequence(((String) value));
                }
            }
            if( values.containsKey("CompSpecExceptionCode") ) {
                final Object value = values.remove("CompSpecExceptionCode");
                if( (value == null) || (!value.equals(getCompSpecExceptionCode())) ) {
                    setCompSpecExceptionCode(((String) value));
                }
            }
            if( values.containsKey("SpecificationAuthznGroup") ) {
                final Object value = values.remove("SpecificationAuthznGroup");
                if( (value == null) || (!value.equals(getSpecificationAuthznGroup())) ) {
                    setSpecificationAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_SubstanceIdentifier") ) {
                final Object value = (values).remove("to_SubstanceIdentifier");
                if( value instanceof Iterable ) {
                    if( toSubstanceIdentifier == null ) {
                        toSubstanceIdentifier = Lists.newArrayList();
                    } else {
                        toSubstanceIdentifier = Lists.newArrayList(toSubstanceIdentifier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SpecIdentifier entity;
                        if( toSubstanceIdentifier.size() > i ) {
                            entity = toSubstanceIdentifier.get(i);
                        } else {
                            entity = new SpecIdentifier();
                            toSubstanceIdentifier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SpecValAssgmtInstanceWthCompField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new SpecValAssgmtInstanceWthCompField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SpecValAssgmtInstanceWthCompField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SpecValAssgmtInstanceWthCompField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toSubstanceIdentifier != null ) {
            (values).put("to_SubstanceIdentifier", toSubstanceIdentifier);
        }
        return values;
    }

    /**
     * Fetches the <b>SpecIdentifier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_SubstanceIdentifier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SpecIdentifier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> fetchSubstanceIdentifier()
    {
        return fetchFieldAsList("to_SubstanceIdentifier", SpecIdentifier.class);
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_SubstanceIdentifier</b> of a queried <b>SpecValAssgmtInstanceWthComp</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SpecIdentifier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SpecIdentifier> getSubstanceIdentifierOrFetch()
    {
        if( toSubstanceIdentifier == null ) {
            toSubstanceIdentifier = fetchSubstanceIdentifier();
        }
        return toSubstanceIdentifier;
    }

    /**
     * Retrieval of associated <b>SpecIdentifier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_SubstanceIdentifier</b>.
     * <p>
     * If the navigation property for an entity <b>SpecValAssgmtInstanceWthComp</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_SubstanceIdentifier</b> is already loaded, the result
     *         will contain the <b>SpecIdentifier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SpecIdentifier>> getSubstanceIdentifierIfPresent()
    {
        return Option.of(toSubstanceIdentifier);
    }

    /**
     * Overwrites the list of associated <b>SpecIdentifier</b> entities for the loaded navigation property
     * <b>to_SubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_SubstanceIdentifier</b> of a queried <b>SpecValAssgmtInstanceWthComp</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SpecIdentifier</b> entities.
     */
    public void setSubstanceIdentifier( @Nonnull final List<SpecIdentifier> value )
    {
        if( toSubstanceIdentifier == null ) {
            toSubstanceIdentifier = Lists.newArrayList();
        }
        toSubstanceIdentifier.clear();
        toSubstanceIdentifier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SpecIdentifier</b> entities. This corresponds to the OData navigation
     * property <b>to_SubstanceIdentifier</b>.
     * <p>
     * If the navigation property <b>to_SubstanceIdentifier</b> of a queried <b>SpecValAssgmtInstanceWthComp</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SpecIdentifier</b> entities.
     */
    public void addSubstanceIdentifier( SpecIdentifier... entity )
    {
        if( toSubstanceIdentifier == null ) {
            toSubstanceIdentifier = Lists.newArrayList();
        }
        toSubstanceIdentifier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SpecValAssgmtInstanceWthComp instances.
     *
     */
    public final static class SpecValAssgmtInstanceWthCompBuilder
    {

        private List<SpecIdentifier> toSubstanceIdentifier = Lists.newArrayList();

        private SpecValAssgmtInstanceWthComp.SpecValAssgmtInstanceWthCompBuilder toSubstanceIdentifier(
            final List<SpecIdentifier> value )
        {
            toSubstanceIdentifier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_SubstanceIdentifier</b> for <b>SpecValAssgmtInstanceWthComp</b> to multiple
         * <b>SpecIdentifier</b>.
         *
         * @param value
         *            The SpecIdentifiers to build this SpecValAssgmtInstanceWthComp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SpecValAssgmtInstanceWthComp.SpecValAssgmtInstanceWthCompBuilder substanceIdentifier(
            SpecIdentifier... value )
        {
            return toSubstanceIdentifier(Lists.newArrayList(value));
        }

    }

}
