/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link RealSubstanceServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService RealSubstanceService}, allowing you to
 * create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultRealSubstanceServiceBatch
    extends
    BatchFluentHelperBasic<RealSubstanceServiceBatch, RealSubstanceServiceBatchChangeSet>
    implements
    RealSubstanceServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultRealSubstanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRealSubstanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultRealSubstanceServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRealSubstanceServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultRealSubstanceServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultRealSubstanceServiceBatchChangeSet(this, service);
    }

}
