/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate;

/**
 * Implementation of the {@link RealSubstanceServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService RealSubstanceService}.
 *
 */
public class DefaultRealSubstanceServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<RealSubstanceServiceBatch, RealSubstanceServiceBatchChangeSet>
    implements
    RealSubstanceServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService service;

    @SuppressWarnings( "deprecation" )
    DefaultRealSubstanceServiceBatchChangeSet(
        @Nonnull final DefaultRealSubstanceServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultRealSubstanceServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createProduct( @Nonnull final Product product )
    {
        return addRequestCreate(service::createProduct, product);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet updateProduct( @Nonnull final Product product )
    {
        return addRequestUpdate(service::updateProduct, product);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestCreate(service::createProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet updateProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestUpdate(service::updateProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet deleteProductDescription(
        @Nonnull final ProductDescription productDescription )
    {
        return addRequestDelete(service::deleteProductDescription, productDescription);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestCreate(service::createProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant )
    {
        return addRequestUpdate(service::updateProductPlant, productPlant);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestCreate(service::createProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet updateProductSalesDelivery(
        @Nonnull final ProductSalesDelivery productSalesDelivery )
    {
        return addRequestUpdate(service::updateProductSalesDelivery, productSalesDelivery);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestCreate(service::createProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet updateProductStorageLocation(
        @Nonnull final ProductStorageLocation productStorageLocation )
    {
        return addRequestUpdate(service::updateProductStorageLocation, productStorageLocation);
    }

    @Nonnull
    @Override
    public RealSubstanceServiceBatchChangeSet createSpecAssignedMatlForKeyDate(
        @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate )
    {
        return addRequestCreate(service::createSpecAssignedMatlForKeyDate, specAssignedMatlForKeyDate);
    }

}
