/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RealSubstanceService RealSubstanceService}.
 *
 */
public interface RealSubstanceServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<RealSubstanceServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<RealSubstanceServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity and
     * save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity
     *            object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet createProduct( @Nonnull final Product product );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product}
     * entity and save it to the S/4HANA system.
     *
     * @param product
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product} entity
     *            object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet updateProduct( @Nonnull final Product product );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet createProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity and save it to the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet updateProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     * ProductDescription} entity in the S/4HANA system.
     *
     * @param productDescription
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductDescription
     *            ProductDescription} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet deleteProductDescription( @Nonnull final ProductDescription productDescription );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     * entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet createProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant
     * ProductPlant} entity and save it to the S/4HANA system.
     *
     * @param productPlant
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet updateProductPlant( @Nonnull final ProductPlant productPlant );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet
        createProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     * ProductSalesDelivery} entity and save it to the S/4HANA system.
     *
     * @param productSalesDelivery
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductSalesDelivery
     *            ProductSalesDelivery} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet
        updateProductSalesDelivery( @Nonnull final ProductSalesDelivery productSalesDelivery );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet
        createProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     * ProductStorageLocation} entity and save it to the S/4HANA system.
     *
     * @param productStorageLocation
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductStorageLocation
     *            ProductStorageLocation} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet
        updateProductStorageLocation( @Nonnull final ProductStorageLocation productStorageLocation );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     * SpecAssignedMatlForKeyDate} entity and save it to the S/4HANA system.
     *
     * @param specAssignedMatlForKeyDate
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecAssignedMatlForKeyDate
     *            SpecAssignedMatlForKeyDate} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RealSubstanceServiceBatchChangeSet
        createSpecAssignedMatlForKeyDate( @Nonnull final SpecAssignedMatlForKeyDate specAssignedMatlForKeyDate );

}
