/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant ProductPlant}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.ProductPlantField
 * ProductPlantField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.ProductPlantLink
 * ProductPlantLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PLANT PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PURCHASING_GROUP
 * PURCHASING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#REGION_OF_ORIGIN
 * REGION_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCTION_INVTRY_MANAGED_LOC
 * PRODUCTION_INVTRY_MANAGED_LOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PROFILE_CODE
 * PROFILE_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PROFILE_VALIDITY_START_DATE
 * PROFILE_VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#AVAILABILITY_CHECK_TYPE
 * AVAILABILITY_CHECK_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#FISCAL_YEAR_VARIANT
 * FISCAL_YEAR_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PERIOD_TYPE
 * PERIOD_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#COMMODITY COMMODITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#GOODS_RECEIPT_DURATION
 * GOODS_RECEIPT_DURATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MAINTENANCE_STATUS_NAME
 * MAINTENANCE_STATUS_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MRP_TYPE MRP_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MRP_RESPONSIBLE
 * MRP_RESPONSIBLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#ABC_INDICATOR
 * ABC_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MINIMUM_LOT_SIZE_QUANTITY
 * MINIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MAXIMUM_LOT_SIZE_QUANTITY
 * MAXIMUM_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#FIXED_LOT_SIZE_QUANTITY
 * FIXED_LOT_SIZE_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#CONSUMPTION_TAX_CTRL_CODE
 * CONSUMPTION_TAX_CTRL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#IS_CO_PRODUCT
 * IS_CO_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT_IS_CONFIGURABLE
 * PRODUCT_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#STOCK_DETERMINATION_GROUP
 * STOCK_DETERMINATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#STOCK_IN_TRANSFER_QUANTITY
 * STOCK_IN_TRANSFER_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#STOCK_IN_TRANSIT_QUANTITY
 * STOCK_IN_TRANSIT_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#HAS_POST_TO_INSPECTION_STOCK
 * HAS_POST_TO_INSPECTION_STOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#IS_BATCH_MANAGEMENT_REQUIRED
 * IS_BATCH_MANAGEMENT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#IS_NEGATIVE_STOCK_ALLOWED
 * IS_NEGATIVE_STOCK_ALLOWED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#GOODS_RECEIPT_BLOCKED_STOCK_QTY
 * GOODS_RECEIPT_BLOCKED_STOCK_QTY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#HAS_CONSIGNMENT_CTRL
 * HAS_CONSIGNMENT_CTRL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#FISCAL_YEAR_CURRENT_PERIOD
 * FISCAL_YEAR_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#FISCAL_MONTH_CURRENT_PERIOD
 * FISCAL_MONTH_CURRENT_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PROCUREMENT_TYPE
 * PROCUREMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#IS_INTERNAL_BATCH_MANAGED
 * IS_INTERNAL_BATCH_MANAGED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT_CFOP_CATEGORY
 * PRODUCT_CFOP_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT_IS_EXCISE_TAX_RELEVANT
 * PRODUCT_IS_EXCISE_TAX_RELEVANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#CONFIGURABLE_PRODUCT
 * CONFIGURABLE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#GOODS_ISSUE_UNIT
 * GOODS_ISSUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#MATERIAL_FREIGHT_GROUP
 * MATERIAL_FREIGHT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#ORIGINAL_BATCH_REFERENCE_MATERIAL
 * ORIGINAL_BATCH_REFERENCE_MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#ORIGL_BATCH_MANAGEMENT_IS_REQUIRED
 * ORIGL_BATCH_MANAGEMENT_IS_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT_IS_CRITICAL_PRT
 * PRODUCT_IS_CRITICAL_PRT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#PRODUCT_LOGISTICS_HANDLING_GROUP
 * PRODUCT_LOGISTICS_HANDLING_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.ProductPlant#TO_STORAGE_LOCATION
 * TO_STORAGE_LOCATION}</li>
 * </ul>
 *
 */
public interface ProductPlantSelectable extends EntitySelectable<ProductPlant>
{

}
