/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product Product}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.ProductField ProductField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.ProductLink ProductLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_TYPE PRODUCT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CROSS_PLANT_STATUS
 * CROSS_PLANT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CROSS_PLANT_STATUS_VALIDITY_DATE
 * CROSS_PLANT_STATUS_VALIDITY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CREATION_DATE
 * CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CREATED_BY_USER
 * CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#LAST_CHANGE_DATE
 * LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#LAST_CHANGED_BY_USER
 * LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#LAST_CHANGE_DATE_TIME
 * LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#IS_MARKED_FOR_DELETION
 * IS_MARKED_FOR_DELETION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_OLD_ID
 * PRODUCT_OLD_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#GROSS_WEIGHT GROSS_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PURCHASE_ORDER_QUANTITY_UNIT
 * PURCHASE_ORDER_QUANTITY_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#SOURCE_OF_SUPPLY
 * SOURCE_OF_SUPPLY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#WEIGHT_UNIT WEIGHT_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#NET_WEIGHT NET_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#COUNTRY_OF_ORIGIN
 * COUNTRY_OF_ORIGIN}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#COMPETITOR_ID
 * COMPETITOR_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_GROUP
 * PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#BASE_UNIT BASE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#ITEM_CATEGORY_GROUP
 * ITEM_CATEGORY_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_HIERARCHY
 * PRODUCT_HIERARCHY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#DIVISION DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#VARBL_PUR_ORD_UNIT_IS_ACTIVE
 * VARBL_PUR_ORD_UNIT_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#VOLUME_UNIT VOLUME_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MATERIAL_VOLUME
 * MATERIAL_VOLUME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#ANP_CODE ANP_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#BRAND BRAND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PROCUREMENT_RULE
 * PROCUREMENT_RULE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#VALIDITY_START_DATE
 * VALIDITY_START_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#LOW_LEVEL_CODE
 * LOW_LEVEL_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD
 * PROD_NO_IN_GEN_PROD_IN_PREPACK_PROD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#SERIAL_IDENTIFIER_ASSGMT_PROFILE
 * SERIAL_IDENTIFIER_ASSGMT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#SIZE_OR_DIMENSION_TEXT
 * SIZE_OR_DIMENSION_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#INDUSTRY_STANDARD_NAME
 * INDUSTRY_STANDARD_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_STANDARD_ID
 * PRODUCT_STANDARD_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#INTERNATIONAL_ARTICLE_NUMBER_CAT
 * INTERNATIONAL_ARTICLE_NUMBER_CAT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_IS_CONFIGURABLE
 * PRODUCT_IS_CONFIGURABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#IS_BATCH_MANAGEMENT_REQUIRED
 * IS_BATCH_MANAGEMENT_REQUIRED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#EXTERNAL_PRODUCT_GROUP
 * EXTERNAL_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CROSS_PLANT_CONFIGURABLE_PRODUCT
 * CROSS_PLANT_CONFIGURABLE_PRODUCT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#SERIAL_NO_EXPLICITNESS_LEVEL
 * SERIAL_NO_EXPLICITNESS_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PRODUCT_MANUFACTURER_NUMBER
 * PRODUCT_MANUFACTURER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MANUFACTURER_NUMBER
 * MANUFACTURER_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MANUFACTURER_PART_PROFILE
 * MANUFACTURER_PART_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#QLTY_MGMT_IN_PROCMT_IS_ACTIVE
 * QLTY_MGMT_IN_PROCMT_IS_ACTIVE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#INDUSTRY_SECTOR
 * INDUSTRY_SECTOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#CHANGE_NUMBER
 * CHANGE_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MATERIAL_REVISION_LEVEL
 * MATERIAL_REVISION_LEVEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#HANDLING_INDICATOR
 * HANDLING_INDICATOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#WAREHOUSE_PRODUCT_GROUP
 * WAREHOUSE_PRODUCT_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#WAREHOUSE_STORAGE_CONDITION
 * WAREHOUSE_STORAGE_CONDITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#STANDARD_HANDLING_UNIT_TYPE
 * STANDARD_HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#SERIAL_NUMBER_PROFILE
 * SERIAL_NUMBER_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#ADJUSTMENT_PROFILE
 * ADJUSTMENT_PROFILE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#PREFERRED_UNIT_OF_MEASURE
 * PREFERRED_UNIT_OF_MEASURE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#IS_PILFERABLE
 * IS_PILFERABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#IS_RELEVANT_FOR_HZDS_SUBSTANCES
 * IS_RELEVANT_FOR_HZDS_SUBSTANCES}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#QUARANTINE_PERIOD
 * QUARANTINE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#TIME_UNIT_FOR_QUARANTINE_PERIOD
 * TIME_UNIT_FOR_QUARANTINE_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#QUALITY_INSPECTION_GROUP
 * QUALITY_INSPECTION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#AUTHORIZATION_GROUP
 * AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#DOCUMENT_IS_CREATED_BY_CAD
 * DOCUMENT_IS_CREATED_BY_CAD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#HANDLING_UNIT_TYPE
 * HANDLING_UNIT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#HAS_VARIABLE_TARE_WEIGHT
 * HAS_VARIABLE_TARE_WEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MAXIMUM_PACKAGING_LENGTH
 * MAXIMUM_PACKAGING_LENGTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MAXIMUM_PACKAGING_WIDTH
 * MAXIMUM_PACKAGING_WIDTH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#MAXIMUM_PACKAGING_HEIGHT
 * MAXIMUM_PACKAGING_HEIGHT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#UNIT_FOR_MAX_PACKAGING_DIMENSIONS
 * UNIT_FOR_MAX_PACKAGING_DIMENSIONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#TO_DESCRIPTION
 * TO_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#TO_PLANT TO_PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.Product#TO_SALES_DELIVERY
 * TO_SALES_DELIVERY}</li>
 * </ul>
 *
 */
public interface ProductSelectable extends EntitySelectable<Product>
{

}
