/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes SpecStatusAttributes}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.field.SpecStatusAttributesField
 * SpecStatusAttributesField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.link.SpecStatusAttributesLink
 * SpecStatusAttributesLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes#SPECIFICATION_HEADER_STATUS
 * SPECIFICATION_HEADER_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.realsubstance.SpecStatusAttributes#SPECIFICATION_HDR_STS_ATTRIBUTE
 * SPECIFICATION_HDR_STS_ATTRIBUTE}</li>
 * </ul>
 *
 */
public interface SpecStatusAttributesSelectable extends EntitySelectable<SpecStatusAttributes>
{

}
