/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecProcEquipRqmtCharcField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecProcEquipRqmtCharcLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecProcEquipRqmtCharcSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Equipment Requirement Characteristic Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecProcEquipRqmtCharcType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecProcEquipRqmtCharc extends VdmEntity<RecProcEquipRqmtCharc>
{

    /**
     * Selector for all available fields of RecProcEquipRqmtCharc.
     *
     */
    public final static RecProcEquipRqmtCharcSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @return Equipment Requirement GUID
     */
    @Key
    @SerializedName( "RecipeProcessEquipRqmtUUID" )
    @JsonProperty( "RecipeProcessEquipRqmtUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtUUID" )
    private UUID recipeProcessEquipRqmtUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtUUID</b> field to query operations.
     *
     */
    public final static RecProcEquipRqmtCharcField<UUID> RECIPE_PROCESS_EQUIP_RQMT_UUID =
        new RecProcEquipRqmtCharcField<UUID>("RecipeProcessEquipRqmtUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static RecProcEquipRqmtCharcField<String> CHARC_INTERNAL_ID =
        new RecProcEquipRqmtCharcField<String>("CharcInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @Key
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static RecProcEquipRqmtCharcField<String> CLASS_TYPE =
        new RecProcEquipRqmtCharcField<String>("ClassType");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static RecProcEquipRqmtCharcField<LocalDateTime> KEY_DATE =
        new RecProcEquipRqmtCharcField<LocalDateTime>("KeyDate");
    /**
     * Navigation property <b>to_Valuation</b> for <b>RecProcEquipRqmtCharc</b> to multiple
     * <b>RecProcEquipRqmtCharcValue</b>.
     *
     */
    @SerializedName( "to_Valuation" )
    @JsonProperty( "to_Valuation" )
    @ODataField( odataName = "to_Valuation" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcEquipRqmtCharcValue> toValuation;
    /**
     * Use with available fluent helpers to apply the <b>to_Valuation</b> navigation property to query operations.
     *
     */
    public final static RecProcEquipRqmtCharcLink<RecProcEquipRqmtCharcValue> TO_VALUATION =
        new RecProcEquipRqmtCharcLink<RecProcEquipRqmtCharcValue>("to_Valuation");

    @Nonnull
    @Override
    public Class<RecProcEquipRqmtCharc> getType()
    {
        return RecProcEquipRqmtCharc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     */
    public void setRecipeProcessEquipRqmtUUID( @Nullable final UUID recipeProcessEquipRqmtUUID )
    {
        rememberChangedField("RecipeProcessEquipRqmtUUID", this.recipeProcessEquipRqmtUUID);
        this.recipeProcessEquipRqmtUUID = recipeProcessEquipRqmtUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecProcEquipRqmtCharc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessEquipRqmtUUID", getRecipeProcessEquipRqmtUUID());
        result.put("CharcInternalID", getCharcInternalID());
        result.put("ClassType", getClassType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RecipeProcessEquipRqmtUUID", getRecipeProcessEquipRqmtUUID());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("ClassType", getClassType());
        values.put("KeyDate", getKeyDate());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RecipeProcessEquipRqmtUUID") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtUUID");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtUUID())) ) {
                    setRecipeProcessEquipRqmtUUID(((UUID) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Valuation") ) {
                final Object value = (values).remove("to_Valuation");
                if( value instanceof Iterable ) {
                    if( toValuation == null ) {
                        toValuation = Lists.newArrayList();
                    } else {
                        toValuation = Lists.newArrayList(toValuation);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcEquipRqmtCharcValue entity;
                        if( toValuation.size() > i ) {
                            entity = toValuation.get(i);
                        } else {
                            entity = new RecProcEquipRqmtCharcValue();
                            toValuation.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecProcEquipRqmtCharcField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecProcEquipRqmtCharcField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecProcEquipRqmtCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecProcEquipRqmtCharcField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toValuation != null ) {
            (values).put("to_Valuation", toValuation);
        }
        return values;
    }

    /**
     * Fetches the <b>RecProcEquipRqmtCharcValue</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_Valuation</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcEquipRqmtCharcValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtCharcValue> fetchValuation()
    {
        return fetchFieldAsList("to_Valuation", RecProcEquipRqmtCharcValue.class);
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtCharcValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Valuation</b>.
     * <p>
     * If the navigation property <b>to_Valuation</b> of a queried <b>RecProcEquipRqmtCharc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcEquipRqmtCharcValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtCharcValue> getValuationOrFetch()
    {
        if( toValuation == null ) {
            toValuation = fetchValuation();
        }
        return toValuation;
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtCharcValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Valuation</b>.
     * <p>
     * If the navigation property for an entity <b>RecProcEquipRqmtCharc</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Valuation</b> is already loaded, the result will contain
     *         the <b>RecProcEquipRqmtCharcValue</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcEquipRqmtCharcValue>> getValuationIfPresent()
    {
        return Option.of(toValuation);
    }

    /**
     * Overwrites the list of associated <b>RecProcEquipRqmtCharcValue</b> entities for the loaded navigation property
     * <b>to_Valuation</b>.
     * <p>
     * If the navigation property <b>to_Valuation</b> of a queried <b>RecProcEquipRqmtCharc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcEquipRqmtCharcValue</b> entities.
     */
    public void setValuation( @Nonnull final List<RecProcEquipRqmtCharcValue> value )
    {
        if( toValuation == null ) {
            toValuation = Lists.newArrayList();
        }
        toValuation.clear();
        toValuation.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcEquipRqmtCharcValue</b> entities. This corresponds to the OData
     * navigation property <b>to_Valuation</b>.
     * <p>
     * If the navigation property <b>to_Valuation</b> of a queried <b>RecProcEquipRqmtCharc</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcEquipRqmtCharcValue</b> entities.
     */
    public void addValuation( RecProcEquipRqmtCharcValue... entity )
    {
        if( toValuation == null ) {
            toValuation = Lists.newArrayList();
        }
        toValuation.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecProcEquipRqmtCharc instances.
     *
     */
    public final static class RecProcEquipRqmtCharcBuilder
    {

        private List<RecProcEquipRqmtCharcValue> toValuation = Lists.newArrayList();

        private RecProcEquipRqmtCharc.RecProcEquipRqmtCharcBuilder toValuation(
            final List<RecProcEquipRqmtCharcValue> value )
        {
            toValuation.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Valuation</b> for <b>RecProcEquipRqmtCharc</b> to multiple
         * <b>RecProcEquipRqmtCharcValue</b>.
         *
         * @param value
         *            The RecProcEquipRqmtCharcValues to build this RecProcEquipRqmtCharc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecProcEquipRqmtCharc.RecProcEquipRqmtCharcBuilder valuation( RecProcEquipRqmtCharcValue... value )
        {
            return toValuation(Lists.newArrayList(value));
        }

    }

}
