/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecProcEquipRqmtClassSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
 * RecProcEquipRqmtClass} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class RecProcEquipRqmtClassByKeyFluentHelper
    extends
    FluentHelperByKey<RecProcEquipRqmtClassByKeyFluentHelper, RecProcEquipRqmtClass, RecProcEquipRqmtClassSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClass
     * RecProcEquipRqmtClass} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code RecProcEquipRqmtClass}
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code RecProcEquipRqmtClass}
     */
    public RecProcEquipRqmtClassByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID recipeProcessEquipRqmtUUID,
        final String classInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("RecipeProcessEquipRqmtUUID", recipeProcessEquipRqmtUUID);
        this.key.put("ClassInternalID", classInternalID);
    }

    @Override
    @Nonnull
    protected Class<RecProcEquipRqmtClass> getEntityClass()
    {
        return RecProcEquipRqmtClass.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
