/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecProcEquipRqmtClassCharcSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
 * RecProcEquipRqmtClassCharc} entity using key fields. This fluent helper allows methods which modify the underlying
 * query to be called before executing the query itself.
 *
 */
public class RecProcEquipRqmtClassCharcByKeyFluentHelper
    extends
    FluentHelperByKey<RecProcEquipRqmtClassCharcByKeyFluentHelper, RecProcEquipRqmtClassCharc, RecProcEquipRqmtClassCharcSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
     * RecProcEquipRqmtClassCharc} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code RecProcEquipRqmtClassCharc}
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param charcInternalID
     *            Characteristic Internal ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param classInternalID
     *            Internal Class Number
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code RecProcEquipRqmtClassCharc}
     */
    public RecProcEquipRqmtClassCharcByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID recipeProcessEquipRqmtUUID,
        final String classInternalID,
        final String charcInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("RecipeProcessEquipRqmtUUID", recipeProcessEquipRqmtUUID);
        this.key.put("ClassInternalID", classInternalID);
        this.key.put("CharcInternalID", charcInternalID);
    }

    @Override
    @Nonnull
    protected Class<RecProcEquipRqmtClassCharc> getEntityClass()
    {
        return RecProcEquipRqmtClassCharc.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
