/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecProcParamValClassField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecProcParamValClassLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecProcParamValClassSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Process Parameter Value Class Assignments
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecProcParamValClassType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecProcParamValClass extends VdmEntity<RecProcParamValClass>
{

    /**
     * Selector for all available fields of RecProcParamValClass.
     *
     */
    public final static RecProcParamValClassSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @return Process Parameter Value Key
     */
    @Key
    @SerializedName( "RecipeProcessParamValUUID" )
    @JsonProperty( "RecipeProcessParamValUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamValUUID" )
    private UUID recipeProcessParamValUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamValUUID</b> field to query operations.
     *
     */
    public final static RecProcParamValClassField<UUID> RECIPE_PROCESS_PARAM_VAL_UUID =
        new RecProcParamValClassField<UUID>("RecipeProcessParamValUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static RecProcParamValClassField<String> CLASS_INTERNAL_ID =
        new RecProcParamValClassField<String>("ClassInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static RecProcParamValClassField<LocalDateTime> KEY_DATE =
        new RecProcParamValClassField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static RecProcParamValClassField<String> CLASS_TYPE =
        new RecProcParamValClassField<String>("ClassType");
    /**
     * Navigation property <b>to_Characteristics</b> for <b>RecProcParamValClass</b> to multiple
     * <b>RecProcParamValClassCharc</b>.
     *
     */
    @SerializedName( "to_Characteristics" )
    @JsonProperty( "to_Characteristics" )
    @ODataField( odataName = "to_Characteristics" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcParamValClassCharc> toCharacteristics;
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristics</b> navigation property to query operations.
     *
     */
    public final static RecProcParamValClassLink<RecProcParamValClassCharc> TO_CHARACTERISTICS =
        new RecProcParamValClassLink<RecProcParamValClassCharc>("to_Characteristics");

    @Nonnull
    @Override
    public Class<RecProcParamValClass> getType()
    {
        return RecProcParamValClass.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     */
    public void setRecipeProcessParamValUUID( @Nullable final UUID recipeProcessParamValUUID )
    {
        rememberChangedField("RecipeProcessParamValUUID", this.recipeProcessParamValUUID);
        this.recipeProcessParamValUUID = recipeProcessParamValUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecProcParamValClass";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        result.put("ClassInternalID", getClassInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        values.put("ClassInternalID", getClassInternalID());
        values.put("KeyDate", getKeyDate());
        values.put("ClassType", getClassType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RecipeProcessParamValUUID") ) {
                final Object value = values.remove("RecipeProcessParamValUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamValUUID())) ) {
                    setRecipeProcessParamValUUID(((UUID) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Characteristics") ) {
                final Object value = (values).remove("to_Characteristics");
                if( value instanceof Iterable ) {
                    if( toCharacteristics == null ) {
                        toCharacteristics = Lists.newArrayList();
                    } else {
                        toCharacteristics = Lists.newArrayList(toCharacteristics);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcParamValClassCharc entity;
                        if( toCharacteristics.size() > i ) {
                            entity = toCharacteristics.get(i);
                        } else {
                            entity = new RecProcParamValClassCharc();
                            toCharacteristics.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecProcParamValClassField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecProcParamValClassField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecProcParamValClassField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecProcParamValClassField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharacteristics != null ) {
            (values).put("to_Characteristics", toCharacteristics);
        }
        return values;
    }

    /**
     * Fetches the <b>RecProcParamValClassCharc</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Characteristics</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcParamValClassCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValClassCharc> fetchCharacteristics()
    {
        return fetchFieldAsList("to_Characteristics", RecProcParamValClassCharc.class);
    }

    /**
     * Retrieval of associated <b>RecProcParamValClassCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>RecProcParamValClass</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcParamValClassCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValClassCharc> getCharacteristicsOrFetch()
    {
        if( toCharacteristics == null ) {
            toCharacteristics = fetchCharacteristics();
        }
        return toCharacteristics;
    }

    /**
     * Retrieval of associated <b>RecProcParamValClassCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property for an entity <b>RecProcParamValClass</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristics</b> is already loaded, the result will
     *         contain the <b>RecProcParamValClassCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcParamValClassCharc>> getCharacteristicsIfPresent()
    {
        return Option.of(toCharacteristics);
    }

    /**
     * Overwrites the list of associated <b>RecProcParamValClassCharc</b> entities for the loaded navigation property
     * <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>RecProcParamValClass</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcParamValClassCharc</b> entities.
     */
    public void setCharacteristics( @Nonnull final List<RecProcParamValClassCharc> value )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.clear();
        toCharacteristics.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcParamValClassCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>RecProcParamValClass</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcParamValClassCharc</b> entities.
     */
    public void addCharacteristics( RecProcParamValClassCharc... entity )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecProcParamValClass instances.
     *
     */
    public final static class RecProcParamValClassBuilder
    {

        private List<RecProcParamValClassCharc> toCharacteristics = Lists.newArrayList();

        private RecProcParamValClass.RecProcParamValClassBuilder toCharacteristics(
            final List<RecProcParamValClassCharc> value )
        {
            toCharacteristics.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristics</b> for <b>RecProcParamValClass</b> to multiple
         * <b>RecProcParamValClassCharc</b>.
         *
         * @param value
         *            The RecProcParamValClassCharcs to build this RecProcParamValClass with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecProcParamValClass.RecProcParamValClassBuilder characteristics( RecProcParamValClassCharc... value )
        {
            return toCharacteristics(Lists.newArrayList(value));
        }

    }

}
