/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Header Data
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Recipe extends VdmEntity<Recipe>
{

    /**
     * Selector for all available fields of Recipe.
     *
     */
    public final static RecipeSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeField<Boolean> DELETE_MC = new RecipeField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeField<Boolean> UPDATE_MC = new RecipeField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @Key
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeField<UUID> RECIPE_UUID = new RecipeField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID_Text</b>
     * </p>
     *
     * @return Recipe Description
     */
    @SerializedName( "RecipeUUID_Text" )
    @JsonProperty( "RecipeUUID_Text" )
    @Nullable
    @ODataField( odataName = "RecipeUUID_Text" )
    private String recipeUUID_Text;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID_Text</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_UUID_TEXT = new RecipeField<String>("RecipeUUID_Text");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUniqueID</b>
     * </p>
     *
     * @return Recipe GUID in character format used in FRW linkage
     */
    @SerializedName( "RecipeUniqueID" )
    @JsonProperty( "RecipeUniqueID" )
    @Nullable
    @ODataField( odataName = "RecipeUniqueID" )
    private String recipeUniqueID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUniqueID</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_UNIQUE_ID = new RecipeField<String>("RecipeUniqueID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE = new RecipeField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimaryOutputInternalID</b>
     * </p>
     *
     * @return Specification Key
     */
    @SerializedName( "RecipePrimaryOutputInternalID" )
    @JsonProperty( "RecipePrimaryOutputInternalID" )
    @Nullable
    @ODataField( odataName = "RecipePrimaryOutputInternalID" )
    private String recipePrimaryOutputInternalID;
    /**
     * Use with available fluent helpers to apply the <b>RecipePrimaryOutputInternalID</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_PRIMARY_OUTPUT_INTERNAL_ID =
        new RecipeField<String>("RecipePrimaryOutputInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimaryOutput</b>
     * </p>
     *
     * @return Primary Output ID
     */
    @SerializedName( "RecipePrimaryOutput" )
    @JsonProperty( "RecipePrimaryOutput" )
    @Nullable
    @ODataField( odataName = "RecipePrimaryOutput" )
    private String recipePrimaryOutput;
    /**
     * Use with available fluent helpers to apply the <b>RecipePrimaryOutput</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_PRIMARY_OUTPUT = new RecipeField<String>("RecipePrimaryOutput");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeAlternativeNumber</b>
     * </p>
     *
     * @return Alternative Recipe Identifier
     */
    @SerializedName( "RecipeAlternativeNumber" )
    @JsonProperty( "RecipeAlternativeNumber" )
    @Nullable
    @ODataField( odataName = "RecipeAlternativeNumber" )
    private String recipeAlternativeNumber;
    /**
     * Use with available fluent helpers to apply the <b>RecipeAlternativeNumber</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_ALTERNATIVE_NUMBER =
        new RecipeField<String>("RecipeAlternativeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeVersionNumber</b>
     * </p>
     *
     * @return Recipe Version
     */
    @SerializedName( "RecipeVersionNumber" )
    @JsonProperty( "RecipeVersionNumber" )
    @Nullable
    @ODataField( odataName = "RecipeVersionNumber" )
    private String recipeVersionNumber;
    /**
     * Use with available fluent helpers to apply the <b>RecipeVersionNumber</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_VERSION_NUMBER = new RecipeField<String>("RecipeVersionNumber");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeType</b>
     * </p>
     *
     * @return Recipe Type
     */
    @SerializedName( "RecipeType" )
    @JsonProperty( "RecipeType" )
    @Nullable
    @ODataField( odataName = "RecipeType" )
    private String recipeType;
    /**
     * Use with available fluent helpers to apply the <b>RecipeType</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_TYPE = new RecipeField<String>("RecipeType");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RecipePurpose</b>
     * </p>
     *
     * @return Recipe Purpose
     */
    @SerializedName( "RecipePurpose" )
    @JsonProperty( "RecipePurpose" )
    @Nullable
    @ODataField( odataName = "RecipePurpose" )
    private String recipePurpose;
    /**
     * Use with available fluent helpers to apply the <b>RecipePurpose</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_PURPOSE = new RecipeField<String>("RecipePurpose");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeStatus</b>
     * </p>
     *
     * @return Recipe Status
     */
    @SerializedName( "RecipeStatus" )
    @JsonProperty( "RecipeStatus" )
    @Nullable
    @ODataField( odataName = "RecipeStatus" )
    private String recipeStatus;
    /**
     * Use with available fluent helpers to apply the <b>RecipeStatus</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_STATUS = new RecipeField<String>("RecipeStatus");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeStatusSchema</b>
     * </p>
     *
     * @return Status Scheme
     */
    @SerializedName( "RecipeStatusSchema" )
    @JsonProperty( "RecipeStatusSchema" )
    @Nullable
    @ODataField( odataName = "RecipeStatusSchema" )
    private String recipeStatusSchema;
    /**
     * Use with available fluent helpers to apply the <b>RecipeStatusSchema</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_STATUS_SCHEMA = new RecipeField<String>("RecipeStatusSchema");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipeAuthorizationGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "RecipeAuthorizationGroup" )
    @JsonProperty( "RecipeAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "RecipeAuthorizationGroup" )
    private String recipeAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>RecipeAuthorizationGroup</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_AUTHORIZATION_GROUP =
        new RecipeField<String>("RecipeAuthorizationGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaUUID</b>
     * </p>
     *
     * @return Formula GUID
     */
    @SerializedName( "RcpFmlaUUID" )
    @JsonProperty( "RcpFmlaUUID" )
    @Nullable
    @ODataField( odataName = "RcpFmlaUUID" )
    private UUID rcpFmlaUUID;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaUUID</b> field to query operations.
     *
     */
    public final static RecipeField<UUID> RCP_FMLA_UUID = new RecipeField<UUID>("RcpFmlaUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @return Process GUID
     */
    @SerializedName( "RecipeProcessUUID" )
    @JsonProperty( "RecipeProcessUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessUUID" )
    private UUID recipeProcessUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessUUID</b> field to query operations.
     *
     */
    public final static RecipeField<UUID> RECIPE_PROCESS_UUID = new RecipeField<UUID>("RecipeProcessUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityStartDate</b>
     * </p>
     *
     * @return Valid-From Date of a Recipe
     */
    @SerializedName( "RecipeValidityStartDate" )
    @JsonProperty( "RecipeValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime recipeValidityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>RecipeValidityStartDate</b> field to query operations.
     *
     */
    public final static RecipeField<LocalDateTime> RECIPE_VALIDITY_START_DATE =
        new RecipeField<LocalDateTime>("RecipeValidityStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityEndDate</b>
     * </p>
     *
     * @return Valid-To Date of a Recipe
     */
    @SerializedName( "RecipeValidityEndDate" )
    @JsonProperty( "RecipeValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime recipeValidityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>RecipeValidityEndDate</b> field to query operations.
     *
     */
    public final static RecipeField<LocalDateTime> RECIPE_VALIDITY_END_DATE =
        new RecipeField<LocalDateTime>("RecipeValidityEndDate");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityMinQuantity</b>
     * </p>
     *
     * @return Quantity From
     */
    @SerializedName( "RecipeValidityMinQuantity" )
    @JsonProperty( "RecipeValidityMinQuantity" )
    @Nullable
    @ODataField( odataName = "RecipeValidityMinQuantity" )
    private BigDecimal recipeValidityMinQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RecipeValidityMinQuantity</b> field to query operations.
     *
     */
    public final static RecipeField<BigDecimal> RECIPE_VALIDITY_MIN_QUANTITY =
        new RecipeField<BigDecimal>("RecipeValidityMinQuantity");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityMaxQuantity</b>
     * </p>
     *
     * @return Quantity To
     */
    @SerializedName( "RecipeValidityMaxQuantity" )
    @JsonProperty( "RecipeValidityMaxQuantity" )
    @Nullable
    @ODataField( odataName = "RecipeValidityMaxQuantity" )
    private BigDecimal recipeValidityMaxQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RecipeValidityMaxQuantity</b> field to query operations.
     *
     */
    public final static RecipeField<BigDecimal> RECIPE_VALIDITY_MAX_QUANTITY =
        new RecipeField<BigDecimal>("RecipeValidityMaxQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "RecipeValidityUnit" )
    @JsonProperty( "RecipeValidityUnit" )
    @Nullable
    @ODataField( odataName = "RecipeValidityUnit" )
    private String recipeValidityUnit;
    /**
     * Use with available fluent helpers to apply the <b>RecipeValidityUnit</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_VALIDITY_UNIT = new RecipeField<String>("RecipeValidityUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static RecipeField<String> PLANT = new RecipeField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipeCreatedByUser</b>
     * </p>
     *
     * @return User Who Created Object (Item)
     */
    @SerializedName( "RecipeCreatedByUser" )
    @JsonProperty( "RecipeCreatedByUser" )
    @Nullable
    @ODataField( odataName = "RecipeCreatedByUser" )
    private String recipeCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RecipeCreatedByUser</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_CREATED_BY_USER = new RecipeField<String>("RecipeCreatedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangedByUser</b>
     * </p>
     *
     * @return User Who Last Changed Object
     */
    @SerializedName( "RecipeLastChangedByUser" )
    @JsonProperty( "RecipeLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "RecipeLastChangedByUser" )
    private String recipeLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangedByUser</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_LAST_CHANGED_BY_USER =
        new RecipeField<String>("RecipeLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeCreationDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeCreationDateTime" )
    @JsonProperty( "RecipeCreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeCreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeCreationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeCreationDateTime</b> field to query operations.
     *
     */
    public final static RecipeField<ZonedDateTime> RECIPE_CREATION_DATE_TIME =
        new RecipeField<ZonedDateTime>("RecipeCreationDateTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeIsDeleted</b>
     * </p>
     *
     * @return Marked for Deletion
     */
    @SerializedName( "RecipeIsDeleted" )
    @JsonProperty( "RecipeIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeIsDeleted" )
    private Boolean recipeIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>RecipeIsDeleted</b> field to query operations.
     *
     */
    public final static RecipeField<Boolean> RECIPE_IS_DELETED = new RecipeField<Boolean>("RecipeIsDeleted");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeIsArchived</b>
     * </p>
     *
     * @return Marked for Archiving
     */
    @SerializedName( "RecipeIsArchived" )
    @JsonProperty( "RecipeIsArchived" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeIsArchived" )
    private Boolean recipeIsArchived;
    /**
     * Use with available fluent helpers to apply the <b>RecipeIsArchived</b> field to query operations.
     *
     */
    public final static RecipeField<Boolean> RECIPE_IS_ARCHIVED = new RecipeField<Boolean>("RecipeIsArchived");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimOutpAuthznGrp</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "RecipePrimOutpAuthznGrp" )
    @JsonProperty( "RecipePrimOutpAuthznGrp" )
    @Nullable
    @ODataField( odataName = "RecipePrimOutpAuthznGrp" )
    private String recipePrimOutpAuthznGrp;
    /**
     * Use with available fluent helpers to apply the <b>RecipePrimOutpAuthznGrp</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_PRIM_OUTP_AUTHZN_GRP =
        new RecipeField<String>("RecipePrimOutpAuthznGrp");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimOutpSpecType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "RecipePrimOutpSpecType" )
    @JsonProperty( "RecipePrimOutpSpecType" )
    @Nullable
    @ODataField( odataName = "RecipePrimOutpSpecType" )
    private String recipePrimOutpSpecType;
    /**
     * Use with available fluent helpers to apply the <b>RecipePrimOutpSpecType</b> field to query operations.
     *
     */
    public final static RecipeField<String> RECIPE_PRIM_OUTP_SPEC_TYPE =
        new RecipeField<String>("RecipePrimOutpSpecType");
    /**
     * Navigation property <b>to_Characteristics</b> for <b>Recipe</b> to multiple <b>RecipeCharc</b>.
     *
     */
    @SerializedName( "to_Characteristics" )
    @JsonProperty( "to_Characteristics" )
    @ODataField( odataName = "to_Characteristics" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeCharc> toCharacteristics;
    /**
     * Navigation property <b>to_Classification</b> for <b>Recipe</b> to multiple <b>RecipeClass</b>.
     *
     */
    @SerializedName( "to_Classification" )
    @JsonProperty( "to_Classification" )
    @ODataField( odataName = "to_Classification" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeClass> toClassification;
    /**
     * Navigation property <b>to_FormulaItem</b> for <b>Recipe</b> to multiple <b>RecipeFormulaItem</b>.
     *
     */
    @SerializedName( "to_FormulaItem" )
    @JsonProperty( "to_FormulaItem" )
    @ODataField( odataName = "to_FormulaItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeFormulaItem> toFormulaItem;
    /**
     * Navigation property <b>to_RecipeProcessElement</b> for <b>Recipe</b> to multiple <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElement" )
    @JsonProperty( "to_RecipeProcessElement" )
    @ODataField( odataName = "to_RecipeProcessElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessElement> toRecipeProcessElement;
    /**
     * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>Recipe</b> to multiple <b>RecipeProcessEquipRqmt</b>.
     *
     */
    @SerializedName( "to_RecipeProcessEquipRqmt" )
    @JsonProperty( "to_RecipeProcessEquipRqmt" )
    @ODataField( odataName = "to_RecipeProcessEquipRqmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessEquipRqmt> toRecipeProcessEquipRqmt;
    /**
     * Navigation property <b>to_RecipeProcessParamValue</b> for <b>Recipe</b> to multiple
     * <b>RecipeProcessParamValue</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamValue" )
    @JsonProperty( "to_RecipeProcessParamValue" )
    @ODataField( odataName = "to_RecipeProcessParamValue" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessParamValue> toRecipeProcessParamValue;
    /**
     * Navigation property <b>to_RecipeText</b> for <b>Recipe</b> to multiple <b>RecipeText</b>.
     *
     */
    @SerializedName( "to_RecipeText" )
    @JsonProperty( "to_RecipeText" )
    @ODataField( odataName = "to_RecipeText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeText> toRecipeText;
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristics</b> navigation property to query operations.
     *
     */
    public final static RecipeLink<RecipeCharc> TO_CHARACTERISTICS = new RecipeLink<RecipeCharc>("to_Characteristics");
    /**
     * Use with available fluent helpers to apply the <b>to_Classification</b> navigation property to query operations.
     *
     */
    public final static RecipeLink<RecipeClass> TO_CLASSIFICATION = new RecipeLink<RecipeClass>("to_Classification");
    /**
     * Use with available fluent helpers to apply the <b>to_FormulaItem</b> navigation property to query operations.
     *
     */
    public final static RecipeLink<RecipeFormulaItem> TO_FORMULA_ITEM =
        new RecipeLink<RecipeFormulaItem>("to_FormulaItem");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElement</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT =
        new RecipeLink<RecipeProcessElement>("to_RecipeProcessElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessEquipRqmt</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeLink<RecipeProcessEquipRqmt> TO_RECIPE_PROCESS_EQUIP_RQMT =
        new RecipeLink<RecipeProcessEquipRqmt>("to_RecipeProcessEquipRqmt");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamValue</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeLink<RecipeProcessParamValue> TO_RECIPE_PROCESS_PARAM_VALUE =
        new RecipeLink<RecipeProcessParamValue>("to_RecipeProcessParamValue");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeText</b> navigation property to query operations.
     *
     */
    public final static RecipeLink<RecipeText> TO_RECIPE_TEXT = new RecipeLink<RecipeText>("to_RecipeText");

    @Nonnull
    @Override
    public Class<Recipe> getType()
    {
        return Recipe.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID_Text</b>
     * </p>
     *
     * @param recipeUUID_Text
     *            Recipe Description
     */
    public void setRecipeUUID_Text( @Nullable final String recipeUUID_Text )
    {
        rememberChangedField("RecipeUUID_Text", this.recipeUUID_Text);
        this.recipeUUID_Text = recipeUUID_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUniqueID</b>
     * </p>
     *
     * @param recipeUniqueID
     *            Recipe GUID in character format used in FRW linkage
     */
    public void setRecipeUniqueID( @Nullable final String recipeUniqueID )
    {
        rememberChangedField("RecipeUniqueID", this.recipeUniqueID);
        this.recipeUniqueID = recipeUniqueID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimaryOutputInternalID</b>
     * </p>
     *
     * @param recipePrimaryOutputInternalID
     *            Specification Key
     */
    public void setRecipePrimaryOutputInternalID( @Nullable final String recipePrimaryOutputInternalID )
    {
        rememberChangedField("RecipePrimaryOutputInternalID", this.recipePrimaryOutputInternalID);
        this.recipePrimaryOutputInternalID = recipePrimaryOutputInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimaryOutput</b>
     * </p>
     *
     * @param recipePrimaryOutput
     *            Primary Output ID
     */
    public void setRecipePrimaryOutput( @Nullable final String recipePrimaryOutput )
    {
        rememberChangedField("RecipePrimaryOutput", this.recipePrimaryOutput);
        this.recipePrimaryOutput = recipePrimaryOutput;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeAlternativeNumber</b>
     * </p>
     *
     * @param recipeAlternativeNumber
     *            Alternative Recipe Identifier
     */
    public void setRecipeAlternativeNumber( @Nullable final String recipeAlternativeNumber )
    {
        rememberChangedField("RecipeAlternativeNumber", this.recipeAlternativeNumber);
        this.recipeAlternativeNumber = recipeAlternativeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeVersionNumber</b>
     * </p>
     *
     * @param recipeVersionNumber
     *            Recipe Version
     */
    public void setRecipeVersionNumber( @Nullable final String recipeVersionNumber )
    {
        rememberChangedField("RecipeVersionNumber", this.recipeVersionNumber);
        this.recipeVersionNumber = recipeVersionNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeType</b>
     * </p>
     *
     * @param recipeType
     *            Recipe Type
     */
    public void setRecipeType( @Nullable final String recipeType )
    {
        rememberChangedField("RecipeType", this.recipeType);
        this.recipeType = recipeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RecipePurpose</b>
     * </p>
     *
     * @param recipePurpose
     *            Recipe Purpose
     */
    public void setRecipePurpose( @Nullable final String recipePurpose )
    {
        rememberChangedField("RecipePurpose", this.recipePurpose);
        this.recipePurpose = recipePurpose;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeStatus</b>
     * </p>
     *
     * @param recipeStatus
     *            Recipe Status
     */
    public void setRecipeStatus( @Nullable final String recipeStatus )
    {
        rememberChangedField("RecipeStatus", this.recipeStatus);
        this.recipeStatus = recipeStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeStatusSchema</b>
     * </p>
     *
     * @param recipeStatusSchema
     *            Status Scheme
     */
    public void setRecipeStatusSchema( @Nullable final String recipeStatusSchema )
    {
        rememberChangedField("RecipeStatusSchema", this.recipeStatusSchema);
        this.recipeStatusSchema = recipeStatusSchema;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipeAuthorizationGroup</b>
     * </p>
     *
     * @param recipeAuthorizationGroup
     *            Recipe Authorization Group
     */
    public void setRecipeAuthorizationGroup( @Nullable final String recipeAuthorizationGroup )
    {
        rememberChangedField("RecipeAuthorizationGroup", this.recipeAuthorizationGroup);
        this.recipeAuthorizationGroup = recipeAuthorizationGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaUUID</b>
     * </p>
     *
     * @param rcpFmlaUUID
     *            Formula GUID
     */
    public void setRcpFmlaUUID( @Nullable final UUID rcpFmlaUUID )
    {
        rememberChangedField("RcpFmlaUUID", this.rcpFmlaUUID);
        this.rcpFmlaUUID = rcpFmlaUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @param recipeProcessUUID
     *            Process GUID
     */
    public void setRecipeProcessUUID( @Nullable final UUID recipeProcessUUID )
    {
        rememberChangedField("RecipeProcessUUID", this.recipeProcessUUID);
        this.recipeProcessUUID = recipeProcessUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityStartDate</b>
     * </p>
     *
     * @param recipeValidityStartDate
     *            Valid-From Date of a Recipe
     */
    public void setRecipeValidityStartDate( @Nullable final LocalDateTime recipeValidityStartDate )
    {
        rememberChangedField("RecipeValidityStartDate", this.recipeValidityStartDate);
        this.recipeValidityStartDate = recipeValidityStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityEndDate</b>
     * </p>
     *
     * @param recipeValidityEndDate
     *            Valid-To Date of a Recipe
     */
    public void setRecipeValidityEndDate( @Nullable final LocalDateTime recipeValidityEndDate )
    {
        rememberChangedField("RecipeValidityEndDate", this.recipeValidityEndDate);
        this.recipeValidityEndDate = recipeValidityEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityMinQuantity</b>
     * </p>
     *
     * @param recipeValidityMinQuantity
     *            Quantity From
     */
    public void setRecipeValidityMinQuantity( @Nullable final BigDecimal recipeValidityMinQuantity )
    {
        rememberChangedField("RecipeValidityMinQuantity", this.recipeValidityMinQuantity);
        this.recipeValidityMinQuantity = recipeValidityMinQuantity;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityMaxQuantity</b>
     * </p>
     *
     * @param recipeValidityMaxQuantity
     *            Quantity To
     */
    public void setRecipeValidityMaxQuantity( @Nullable final BigDecimal recipeValidityMaxQuantity )
    {
        rememberChangedField("RecipeValidityMaxQuantity", this.recipeValidityMaxQuantity);
        this.recipeValidityMaxQuantity = recipeValidityMaxQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeValidityUnit</b>
     * </p>
     *
     * @param recipeValidityUnit
     *            Unit of Measure
     */
    public void setRecipeValidityUnit( @Nullable final String recipeValidityUnit )
    {
        rememberChangedField("RecipeValidityUnit", this.recipeValidityUnit);
        this.recipeValidityUnit = recipeValidityUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipeCreatedByUser</b>
     * </p>
     *
     * @param recipeCreatedByUser
     *            User Who Created Object (Item)
     */
    public void setRecipeCreatedByUser( @Nullable final String recipeCreatedByUser )
    {
        rememberChangedField("RecipeCreatedByUser", this.recipeCreatedByUser);
        this.recipeCreatedByUser = recipeCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangedByUser</b>
     * </p>
     *
     * @param recipeLastChangedByUser
     *            User Who Last Changed Object
     */
    public void setRecipeLastChangedByUser( @Nullable final String recipeLastChangedByUser )
    {
        rememberChangedField("RecipeLastChangedByUser", this.recipeLastChangedByUser);
        this.recipeLastChangedByUser = recipeLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeCreationDateTime</b>
     * </p>
     *
     * @param recipeCreationDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeCreationDateTime( @Nullable final ZonedDateTime recipeCreationDateTime )
    {
        rememberChangedField("RecipeCreationDateTime", this.recipeCreationDateTime);
        this.recipeCreationDateTime = recipeCreationDateTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeIsDeleted</b>
     * </p>
     *
     * @param recipeIsDeleted
     *            Marked for Deletion
     */
    public void setRecipeIsDeleted( @Nullable final Boolean recipeIsDeleted )
    {
        rememberChangedField("RecipeIsDeleted", this.recipeIsDeleted);
        this.recipeIsDeleted = recipeIsDeleted;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeIsArchived</b>
     * </p>
     *
     * @param recipeIsArchived
     *            Marked for Archiving
     */
    public void setRecipeIsArchived( @Nullable final Boolean recipeIsArchived )
    {
        rememberChangedField("RecipeIsArchived", this.recipeIsArchived);
        this.recipeIsArchived = recipeIsArchived;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimOutpAuthznGrp</b>
     * </p>
     *
     * @param recipePrimOutpAuthznGrp
     *            Recipe Authorization Group
     */
    public void setRecipePrimOutpAuthznGrp( @Nullable final String recipePrimOutpAuthznGrp )
    {
        rememberChangedField("RecipePrimOutpAuthznGrp", this.recipePrimOutpAuthznGrp);
        this.recipePrimOutpAuthznGrp = recipePrimOutpAuthznGrp;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipePrimOutpSpecType</b>
     * </p>
     *
     * @param recipePrimOutpSpecType
     *            Specification Type
     */
    public void setRecipePrimOutpSpecType( @Nullable final String recipePrimOutpSpecType )
    {
        rememberChangedField("RecipePrimOutpSpecType", this.recipePrimOutpSpecType);
        this.recipePrimOutpSpecType = recipePrimOutpSpecType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Recipe";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeUUID", getRecipeUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("RecipeUUID_Text", getRecipeUUID_Text());
        values.put("RecipeUniqueID", getRecipeUniqueID());
        values.put("Recipe", getRecipe());
        values.put("RecipePrimaryOutputInternalID", getRecipePrimaryOutputInternalID());
        values.put("RecipePrimaryOutput", getRecipePrimaryOutput());
        values.put("RecipeAlternativeNumber", getRecipeAlternativeNumber());
        values.put("RecipeVersionNumber", getRecipeVersionNumber());
        values.put("RecipeType", getRecipeType());
        values.put("RecipePurpose", getRecipePurpose());
        values.put("RecipeStatus", getRecipeStatus());
        values.put("RecipeStatusSchema", getRecipeStatusSchema());
        values.put("RecipeAuthorizationGroup", getRecipeAuthorizationGroup());
        values.put("RcpFmlaUUID", getRcpFmlaUUID());
        values.put("RecipeProcessUUID", getRecipeProcessUUID());
        values.put("RecipeValidityStartDate", getRecipeValidityStartDate());
        values.put("RecipeValidityEndDate", getRecipeValidityEndDate());
        values.put("RecipeValidityMinQuantity", getRecipeValidityMinQuantity());
        values.put("RecipeValidityMaxQuantity", getRecipeValidityMaxQuantity());
        values.put("RecipeValidityUnit", getRecipeValidityUnit());
        values.put("Plant", getPlant());
        values.put("RecipeCreatedByUser", getRecipeCreatedByUser());
        values.put("RecipeLastChangedByUser", getRecipeLastChangedByUser());
        values.put("RecipeCreationDateTime", getRecipeCreationDateTime());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("RecipeIsDeleted", getRecipeIsDeleted());
        values.put("RecipeIsArchived", getRecipeIsArchived());
        values.put("RecipePrimOutpAuthznGrp", getRecipePrimOutpAuthznGrp());
        values.put("RecipePrimOutpSpecType", getRecipePrimOutpSpecType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeUUID_Text") ) {
                final Object value = values.remove("RecipeUUID_Text");
                if( (value == null) || (!value.equals(getRecipeUUID_Text())) ) {
                    setRecipeUUID_Text(((String) value));
                }
            }
            if( values.containsKey("RecipeUniqueID") ) {
                final Object value = values.remove("RecipeUniqueID");
                if( (value == null) || (!value.equals(getRecipeUniqueID())) ) {
                    setRecipeUniqueID(((String) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RecipePrimaryOutputInternalID") ) {
                final Object value = values.remove("RecipePrimaryOutputInternalID");
                if( (value == null) || (!value.equals(getRecipePrimaryOutputInternalID())) ) {
                    setRecipePrimaryOutputInternalID(((String) value));
                }
            }
            if( values.containsKey("RecipePrimaryOutput") ) {
                final Object value = values.remove("RecipePrimaryOutput");
                if( (value == null) || (!value.equals(getRecipePrimaryOutput())) ) {
                    setRecipePrimaryOutput(((String) value));
                }
            }
            if( values.containsKey("RecipeAlternativeNumber") ) {
                final Object value = values.remove("RecipeAlternativeNumber");
                if( (value == null) || (!value.equals(getRecipeAlternativeNumber())) ) {
                    setRecipeAlternativeNumber(((String) value));
                }
            }
            if( values.containsKey("RecipeVersionNumber") ) {
                final Object value = values.remove("RecipeVersionNumber");
                if( (value == null) || (!value.equals(getRecipeVersionNumber())) ) {
                    setRecipeVersionNumber(((String) value));
                }
            }
            if( values.containsKey("RecipeType") ) {
                final Object value = values.remove("RecipeType");
                if( (value == null) || (!value.equals(getRecipeType())) ) {
                    setRecipeType(((String) value));
                }
            }
            if( values.containsKey("RecipePurpose") ) {
                final Object value = values.remove("RecipePurpose");
                if( (value == null) || (!value.equals(getRecipePurpose())) ) {
                    setRecipePurpose(((String) value));
                }
            }
            if( values.containsKey("RecipeStatus") ) {
                final Object value = values.remove("RecipeStatus");
                if( (value == null) || (!value.equals(getRecipeStatus())) ) {
                    setRecipeStatus(((String) value));
                }
            }
            if( values.containsKey("RecipeStatusSchema") ) {
                final Object value = values.remove("RecipeStatusSchema");
                if( (value == null) || (!value.equals(getRecipeStatusSchema())) ) {
                    setRecipeStatusSchema(((String) value));
                }
            }
            if( values.containsKey("RecipeAuthorizationGroup") ) {
                final Object value = values.remove("RecipeAuthorizationGroup");
                if( (value == null) || (!value.equals(getRecipeAuthorizationGroup())) ) {
                    setRecipeAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaUUID") ) {
                final Object value = values.remove("RcpFmlaUUID");
                if( (value == null) || (!value.equals(getRcpFmlaUUID())) ) {
                    setRcpFmlaUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessUUID") ) {
                final Object value = values.remove("RecipeProcessUUID");
                if( (value == null) || (!value.equals(getRecipeProcessUUID())) ) {
                    setRecipeProcessUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeValidityStartDate") ) {
                final Object value = values.remove("RecipeValidityStartDate");
                if( (value == null) || (!value.equals(getRecipeValidityStartDate())) ) {
                    setRecipeValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RecipeValidityEndDate") ) {
                final Object value = values.remove("RecipeValidityEndDate");
                if( (value == null) || (!value.equals(getRecipeValidityEndDate())) ) {
                    setRecipeValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("RecipeValidityMinQuantity") ) {
                final Object value = values.remove("RecipeValidityMinQuantity");
                if( (value == null) || (!value.equals(getRecipeValidityMinQuantity())) ) {
                    setRecipeValidityMinQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecipeValidityMaxQuantity") ) {
                final Object value = values.remove("RecipeValidityMaxQuantity");
                if( (value == null) || (!value.equals(getRecipeValidityMaxQuantity())) ) {
                    setRecipeValidityMaxQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RecipeValidityUnit") ) {
                final Object value = values.remove("RecipeValidityUnit");
                if( (value == null) || (!value.equals(getRecipeValidityUnit())) ) {
                    setRecipeValidityUnit(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("RecipeCreatedByUser") ) {
                final Object value = values.remove("RecipeCreatedByUser");
                if( (value == null) || (!value.equals(getRecipeCreatedByUser())) ) {
                    setRecipeCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangedByUser") ) {
                final Object value = values.remove("RecipeLastChangedByUser");
                if( (value == null) || (!value.equals(getRecipeLastChangedByUser())) ) {
                    setRecipeLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("RecipeCreationDateTime") ) {
                final Object value = values.remove("RecipeCreationDateTime");
                if( (value == null) || (!value.equals(getRecipeCreationDateTime())) ) {
                    setRecipeCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeIsDeleted") ) {
                final Object value = values.remove("RecipeIsDeleted");
                if( (value == null) || (!value.equals(getRecipeIsDeleted())) ) {
                    setRecipeIsDeleted(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeIsArchived") ) {
                final Object value = values.remove("RecipeIsArchived");
                if( (value == null) || (!value.equals(getRecipeIsArchived())) ) {
                    setRecipeIsArchived(((Boolean) value));
                }
            }
            if( values.containsKey("RecipePrimOutpAuthznGrp") ) {
                final Object value = values.remove("RecipePrimOutpAuthznGrp");
                if( (value == null) || (!value.equals(getRecipePrimOutpAuthznGrp())) ) {
                    setRecipePrimOutpAuthznGrp(((String) value));
                }
            }
            if( values.containsKey("RecipePrimOutpSpecType") ) {
                final Object value = values.remove("RecipePrimOutpSpecType");
                if( (value == null) || (!value.equals(getRecipePrimOutpSpecType())) ) {
                    setRecipePrimOutpSpecType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Characteristics") ) {
                final Object value = (values).remove("to_Characteristics");
                if( value instanceof Iterable ) {
                    if( toCharacteristics == null ) {
                        toCharacteristics = Lists.newArrayList();
                    } else {
                        toCharacteristics = Lists.newArrayList(toCharacteristics);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeCharc entity;
                        if( toCharacteristics.size() > i ) {
                            entity = toCharacteristics.get(i);
                        } else {
                            entity = new RecipeCharc();
                            toCharacteristics.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Classification") ) {
                final Object value = (values).remove("to_Classification");
                if( value instanceof Iterable ) {
                    if( toClassification == null ) {
                        toClassification = Lists.newArrayList();
                    } else {
                        toClassification = Lists.newArrayList(toClassification);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeClass entity;
                        if( toClassification.size() > i ) {
                            entity = toClassification.get(i);
                        } else {
                            entity = new RecipeClass();
                            toClassification.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_FormulaItem") ) {
                final Object value = (values).remove("to_FormulaItem");
                if( value instanceof Iterable ) {
                    if( toFormulaItem == null ) {
                        toFormulaItem = Lists.newArrayList();
                    } else {
                        toFormulaItem = Lists.newArrayList(toFormulaItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeFormulaItem entity;
                        if( toFormulaItem.size() > i ) {
                            entity = toFormulaItem.get(i);
                        } else {
                            entity = new RecipeFormulaItem();
                            toFormulaItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessElement") ) {
                final Object value = (values).remove("to_RecipeProcessElement");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessElement == null ) {
                        toRecipeProcessElement = Lists.newArrayList();
                    } else {
                        toRecipeProcessElement = Lists.newArrayList(toRecipeProcessElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessElement entity;
                        if( toRecipeProcessElement.size() > i ) {
                            entity = toRecipeProcessElement.get(i);
                        } else {
                            entity = new RecipeProcessElement();
                            toRecipeProcessElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessEquipRqmt") ) {
                final Object value = (values).remove("to_RecipeProcessEquipRqmt");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessEquipRqmt == null ) {
                        toRecipeProcessEquipRqmt = Lists.newArrayList();
                    } else {
                        toRecipeProcessEquipRqmt = Lists.newArrayList(toRecipeProcessEquipRqmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessEquipRqmt entity;
                        if( toRecipeProcessEquipRqmt.size() > i ) {
                            entity = toRecipeProcessEquipRqmt.get(i);
                        } else {
                            entity = new RecipeProcessEquipRqmt();
                            toRecipeProcessEquipRqmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessParamValue") ) {
                final Object value = (values).remove("to_RecipeProcessParamValue");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessParamValue == null ) {
                        toRecipeProcessParamValue = Lists.newArrayList();
                    } else {
                        toRecipeProcessParamValue = Lists.newArrayList(toRecipeProcessParamValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessParamValue entity;
                        if( toRecipeProcessParamValue.size() > i ) {
                            entity = toRecipeProcessParamValue.get(i);
                        } else {
                            entity = new RecipeProcessParamValue();
                            toRecipeProcessParamValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeText") ) {
                final Object value = (values).remove("to_RecipeText");
                if( value instanceof Iterable ) {
                    if( toRecipeText == null ) {
                        toRecipeText = Lists.newArrayList();
                    } else {
                        toRecipeText = Lists.newArrayList(toRecipeText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeText entity;
                        if( toRecipeText.size() > i ) {
                            entity = toRecipeText.get(i);
                        } else {
                            entity = new RecipeText();
                            toRecipeText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> RecipeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCharacteristics != null ) {
            (values).put("to_Characteristics", toCharacteristics);
        }
        if( toClassification != null ) {
            (values).put("to_Classification", toClassification);
        }
        if( toFormulaItem != null ) {
            (values).put("to_FormulaItem", toFormulaItem);
        }
        if( toRecipeProcessElement != null ) {
            (values).put("to_RecipeProcessElement", toRecipeProcessElement);
        }
        if( toRecipeProcessEquipRqmt != null ) {
            (values).put("to_RecipeProcessEquipRqmt", toRecipeProcessEquipRqmt);
        }
        if( toRecipeProcessParamValue != null ) {
            (values).put("to_RecipeProcessParamValue", toRecipeProcessParamValue);
        }
        if( toRecipeText != null ) {
            (values).put("to_RecipeText", toRecipeText);
        }
        return values;
    }

    /**
     * Fetches the <b>RecipeCharc</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeCharc</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeCharc> fetchCharacteristics()
    {
        return fetchFieldAsList("to_Characteristics", RecipeCharc.class);
    }

    /**
     * Retrieval of associated <b>RecipeCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeCharc> getCharacteristicsOrFetch()
    {
        if( toCharacteristics == null ) {
            toCharacteristics = fetchCharacteristics();
        }
        return toCharacteristics;
    }

    /**
     * Retrieval of associated <b>RecipeCharc</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristics</b> is already loaded, the result will
     *         contain the <b>RecipeCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeCharc>> getCharacteristicsIfPresent()
    {
        return Option.of(toCharacteristics);
    }

    /**
     * Overwrites the list of associated <b>RecipeCharc</b> entities for the loaded navigation property
     * <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeCharc</b> entities.
     */
    public void setCharacteristics( @Nonnull final List<RecipeCharc> value )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.clear();
        toCharacteristics.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeCharc</b> entities. This corresponds to the OData navigation
     * property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeCharc</b> entities.
     */
    public void addCharacteristics( RecipeCharc... entity )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeClass</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Classification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeClass</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeClass> fetchClassification()
    {
        return fetchFieldAsList("to_Classification", RecipeClass.class);
    }

    /**
     * Retrieval of associated <b>RecipeClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeClass> getClassificationOrFetch()
    {
        if( toClassification == null ) {
            toClassification = fetchClassification();
        }
        return toClassification;
    }

    /**
     * Retrieval of associated <b>RecipeClass</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Classification</b> is already loaded, the result will
     *         contain the <b>RecipeClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeClass>> getClassificationIfPresent()
    {
        return Option.of(toClassification);
    }

    /**
     * Overwrites the list of associated <b>RecipeClass</b> entities for the loaded navigation property
     * <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeClass</b> entities.
     */
    public void setClassification( @Nonnull final List<RecipeClass> value )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.clear();
        toClassification.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeClass</b> entities. This corresponds to the OData navigation
     * property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeClass</b> entities.
     */
    public void addClassification( RecipeClass... entity )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeFormulaItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FormulaItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeFormulaItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeFormulaItem> fetchFormulaItem()
    {
        return fetchFieldAsList("to_FormulaItem", RecipeFormulaItem.class);
    }

    /**
     * Retrieval of associated <b>RecipeFormulaItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeFormulaItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeFormulaItem> getFormulaItemOrFetch()
    {
        if( toFormulaItem == null ) {
            toFormulaItem = fetchFormulaItem();
        }
        return toFormulaItem;
    }

    /**
     * Retrieval of associated <b>RecipeFormulaItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FormulaItem</b> is already loaded, the result will
     *         contain the <b>RecipeFormulaItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeFormulaItem>> getFormulaItemIfPresent()
    {
        return Option.of(toFormulaItem);
    }

    /**
     * Overwrites the list of associated <b>RecipeFormulaItem</b> entities for the loaded navigation property
     * <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeFormulaItem</b> entities.
     */
    public void setFormulaItem( @Nonnull final List<RecipeFormulaItem> value )
    {
        if( toFormulaItem == null ) {
            toFormulaItem = Lists.newArrayList();
        }
        toFormulaItem.clear();
        toFormulaItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeFormulaItem</b> entities. This corresponds to the OData
     * navigation property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeFormulaItem</b> entities.
     */
    public void addFormulaItem( RecipeFormulaItem... entity )
    {
        if( toFormulaItem == null ) {
            toFormulaItem = Lists.newArrayList();
        }
        toFormulaItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElement> fetchRecipeProcessElement()
    {
        return fetchFieldAsList("to_RecipeProcessElement", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElement> getRecipeProcessElementOrFetch()
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = fetchRecipeProcessElement();
        }
        return toRecipeProcessElement;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElement</b> is already loaded, the result
     *         will contain the <b>RecipeProcessElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessElement>> getRecipeProcessElementIfPresent()
    {
        return Option.of(toRecipeProcessElement);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessElement</b> entities for the loaded navigation property
     * <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessElement</b> entities.
     */
    public void setRecipeProcessElement( @Nonnull final List<RecipeProcessElement> value )
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = Lists.newArrayList();
        }
        toRecipeProcessElement.clear();
        toRecipeProcessElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessElement</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessElement</b> entities.
     */
    public void addRecipeProcessElement( RecipeProcessElement... entity )
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = Lists.newArrayList();
        }
        toRecipeProcessElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessEquipRqmt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessEquipRqmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmt> fetchRecipeProcessEquipRqmt()
    {
        return fetchFieldAsList("to_RecipeProcessEquipRqmt", RecipeProcessEquipRqmt.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessEquipRqmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmt> getRecipeProcessEquipRqmtOrFetch()
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = fetchRecipeProcessEquipRqmt();
        }
        return toRecipeProcessEquipRqmt;
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessEquipRqmt</b> is already loaded, the result
     *         will contain the <b>RecipeProcessEquipRqmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessEquipRqmt>> getRecipeProcessEquipRqmtIfPresent()
    {
        return Option.of(toRecipeProcessEquipRqmt);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessEquipRqmt</b> entities for the loaded navigation property
     * <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessEquipRqmt</b> entities.
     */
    public void setRecipeProcessEquipRqmt( @Nonnull final List<RecipeProcessEquipRqmt> value )
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmt.clear();
        toRecipeProcessEquipRqmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessEquipRqmt</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessEquipRqmt</b> entities.
     */
    public void addRecipeProcessEquipRqmt( RecipeProcessEquipRqmt... entity )
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessParamValue</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessParamValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> fetchRecipeProcessParamValue()
    {
        return fetchFieldAsList("to_RecipeProcessParamValue", RecipeProcessParamValue.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> getRecipeProcessParamValueOrFetch()
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = fetchRecipeProcessParamValue();
        }
        return toRecipeProcessParamValue;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamValue</b> is already loaded, the
     *         result will contain the <b>RecipeProcessParamValue</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessParamValue>> getRecipeProcessParamValueIfPresent()
    {
        return Option.of(toRecipeProcessParamValue);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessParamValue</b> entities for the loaded navigation property
     * <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessParamValue</b> entities.
     */
    public void setRecipeProcessParamValue( @Nonnull final List<RecipeProcessParamValue> value )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.clear();
        toRecipeProcessParamValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessParamValue</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessParamValue</b> entities.
     */
    public void addRecipeProcessParamValue( RecipeProcessParamValue... entity )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_RecipeText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeText> fetchRecipeText()
    {
        return fetchFieldAsList("to_RecipeText", RecipeText.class);
    }

    /**
     * Retrieval of associated <b>RecipeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RecipeText</b>.
     * <p>
     * If the navigation property <b>to_RecipeText</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeText> getRecipeTextOrFetch()
    {
        if( toRecipeText == null ) {
            toRecipeText = fetchRecipeText();
        }
        return toRecipeText;
    }

    /**
     * Retrieval of associated <b>RecipeText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_RecipeText</b>.
     * <p>
     * If the navigation property for an entity <b>Recipe</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeText</b> is already loaded, the result will
     *         contain the <b>RecipeText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeText>> getRecipeTextIfPresent()
    {
        return Option.of(toRecipeText);
    }

    /**
     * Overwrites the list of associated <b>RecipeText</b> entities for the loaded navigation property
     * <b>to_RecipeText</b>.
     * <p>
     * If the navigation property <b>to_RecipeText</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeText</b> entities.
     */
    public void setRecipeText( @Nonnull final List<RecipeText> value )
    {
        if( toRecipeText == null ) {
            toRecipeText = Lists.newArrayList();
        }
        toRecipeText.clear();
        toRecipeText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeText</b> entities. This corresponds to the OData navigation
     * property <b>to_RecipeText</b>.
     * <p>
     * If the navigation property <b>to_RecipeText</b> of a queried <b>Recipe</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeText</b> entities.
     */
    public void addRecipeText( RecipeText... entity )
    {
        if( toRecipeText == null ) {
            toRecipeText = Lists.newArrayList();
        }
        toRecipeText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Recipe instances.
     *
     */
    public final static class RecipeBuilder
    {

        private List<RecipeCharc> toCharacteristics = Lists.newArrayList();
        private List<RecipeClass> toClassification = Lists.newArrayList();
        private List<RecipeFormulaItem> toFormulaItem = Lists.newArrayList();
        private List<RecipeProcessElement> toRecipeProcessElement = Lists.newArrayList();
        private List<RecipeProcessEquipRqmt> toRecipeProcessEquipRqmt = Lists.newArrayList();
        private List<RecipeProcessParamValue> toRecipeProcessParamValue = Lists.newArrayList();
        private List<RecipeText> toRecipeText = Lists.newArrayList();

        private Recipe.RecipeBuilder toCharacteristics( final List<RecipeCharc> value )
        {
            toCharacteristics.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristics</b> for <b>Recipe</b> to multiple <b>RecipeCharc</b>.
         *
         * @param value
         *            The RecipeCharcs to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder characteristics( RecipeCharc... value )
        {
            return toCharacteristics(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toClassification( final List<RecipeClass> value )
        {
            toClassification.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Classification</b> for <b>Recipe</b> to multiple <b>RecipeClass</b>.
         *
         * @param value
         *            The RecipeClasss to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder classification( RecipeClass... value )
        {
            return toClassification(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toFormulaItem( final List<RecipeFormulaItem> value )
        {
            toFormulaItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FormulaItem</b> for <b>Recipe</b> to multiple <b>RecipeFormulaItem</b>.
         *
         * @param value
         *            The RecipeFormulaItems to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder formulaItem( RecipeFormulaItem... value )
        {
            return toFormulaItem(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toRecipeProcessElement( final List<RecipeProcessElement> value )
        {
            toRecipeProcessElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElement</b> for <b>Recipe</b> to multiple <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElements to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder recipeProcessElement( RecipeProcessElement... value )
        {
            return toRecipeProcessElement(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toRecipeProcessEquipRqmt( final List<RecipeProcessEquipRqmt> value )
        {
            toRecipeProcessEquipRqmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>Recipe</b> to multiple
         * <b>RecipeProcessEquipRqmt</b>.
         *
         * @param value
         *            The RecipeProcessEquipRqmts to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder recipeProcessEquipRqmt( RecipeProcessEquipRqmt... value )
        {
            return toRecipeProcessEquipRqmt(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toRecipeProcessParamValue( final List<RecipeProcessParamValue> value )
        {
            toRecipeProcessParamValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamValue</b> for <b>Recipe</b> to multiple
         * <b>RecipeProcessParamValue</b>.
         *
         * @param value
         *            The RecipeProcessParamValues to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder recipeProcessParamValue( RecipeProcessParamValue... value )
        {
            return toRecipeProcessParamValue(Lists.newArrayList(value));
        }

        private Recipe.RecipeBuilder toRecipeText( final List<RecipeText> value )
        {
            toRecipeText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeText</b> for <b>Recipe</b> to multiple <b>RecipeText</b>.
         *
         * @param value
         *            The RecipeTexts to build this Recipe with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Recipe.RecipeBuilder recipeText( RecipeText... value )
        {
            return toRecipeText(Lists.newArrayList(value));
        }

    }

}
