/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeFormulaItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeFormulaItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeFormulaItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Formula Items
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeFormulaItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeFormulaItem extends VdmEntity<RecipeFormulaItem>
{

    /**
     * Selector for all available fields of RecipeFormulaItem.
     *
     */
    public final static RecipeFormulaItemSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<Boolean> DELETE_MC = new RecipeFormulaItemField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<Boolean> UPDATE_MC = new RecipeFormulaItemField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUUID</b>
     * </p>
     *
     * @return Formula Item GUID
     */
    @Key
    @SerializedName( "RcpFmlaItemUUID" )
    @JsonProperty( "RcpFmlaItemUUID" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemUUID" )
    private UUID rcpFmlaItemUUID;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RCP_FMLA_ITEM_UUID =
        new RecipeFormulaItemField<UUID>("RcpFmlaItemUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaUUID</b>
     * </p>
     *
     * @return Formula GUID
     */
    @SerializedName( "RcpFmlaUUID" )
    @JsonProperty( "RcpFmlaUUID" )
    @Nullable
    @ODataField( odataName = "RcpFmlaUUID" )
    private UUID rcpFmlaUUID;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RCP_FMLA_UUID = new RecipeFormulaItemField<UUID>("RcpFmlaUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemPosition</b>
     * </p>
     *
     * @return Number of a Formula Item
     */
    @SerializedName( "RcpFmlaItemPosition" )
    @JsonProperty( "RcpFmlaItemPosition" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemPosition" )
    private String rcpFmlaItemPosition;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemPosition</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_POSITION =
        new RecipeFormulaItemField<String>("RcpFmlaItemPosition");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemType</b>
     * </p>
     *
     * @return Formula Item Type
     */
    @SerializedName( "RcpFmlaItemType" )
    @JsonProperty( "RcpFmlaItemType" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemType" )
    private String rcpFmlaItemType;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemType</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_TYPE =
        new RecipeFormulaItemField<String>("RcpFmlaItemType");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @return Specification Key
     */
    @SerializedName( "SpecificationInternalID" )
    @JsonProperty( "SpecificationInternalID" )
    @Nullable
    @ODataField( odataName = "SpecificationInternalID" )
    private String specificationInternalID;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationInternalID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> SPECIFICATION_INTERNAL_ID =
        new RecipeFormulaItemField<String>("SpecificationInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Specification</b>
     * </p>
     *
     * @return Specification
     */
    @SerializedName( "Specification" )
    @JsonProperty( "Specification" )
    @Nullable
    @ODataField( odataName = "Specification" )
    private String specification;
    /**
     * Use with available fluent helpers to apply the <b>Specification</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> SPECIFICATION =
        new RecipeFormulaItemField<String>("Specification");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> MATERIAL = new RecipeFormulaItemField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemComponentType</b>
     * </p>
     *
     * @return Component Type of Formula Item
     */
    @SerializedName( "RcpFmlaItemComponentType" )
    @JsonProperty( "RcpFmlaItemComponentType" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemComponentType" )
    private String rcpFmlaItemComponentType;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemComponentType</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_COMPONENT_TYPE =
        new RecipeFormulaItemField<String>("RcpFmlaItemComponentType");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemLowerLimit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "RcpFmlaItemLowerLimit" )
    @JsonProperty( "RcpFmlaItemLowerLimit" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemLowerLimit" )
    private BigDecimal rcpFmlaItemLowerLimit;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemLowerLimit</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_LOWER_LIMIT =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemLowerLimit");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUpperLimit</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "RcpFmlaItemUpperLimit" )
    @JsonProperty( "RcpFmlaItemUpperLimit" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemUpperLimit" )
    private BigDecimal rcpFmlaItemUpperLimit;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemUpperLimit</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_UPPER_LIMIT =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemUpperLimit");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemQuantity</b>
     * </p>
     *
     * @return Quantity
     */
    @SerializedName( "RcpFmlaItemQuantity" )
    @JsonProperty( "RcpFmlaItemQuantity" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemQuantity" )
    private BigDecimal rcpFmlaItemQuantity;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemQuantity</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_QUANTITY =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemQuantity");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "RcpFmlaItemUnit" )
    @JsonProperty( "RcpFmlaItemUnit" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemUnit" )
    private String rcpFmlaItemUnit;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemUnit</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_UNIT =
        new RecipeFormulaItemField<String>("RcpFmlaItemUnit");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemExceptionCode</b>
     * </p>
     *
     * @return Exception Value
     */
    @SerializedName( "RcpFmlaItemExceptionCode" )
    @JsonProperty( "RcpFmlaItemExceptionCode" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemExceptionCode" )
    private String rcpFmlaItemExceptionCode;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemExceptionCode</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_EXCEPTION_CODE =
        new RecipeFormulaItemField<String>("RcpFmlaItemExceptionCode");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemScrapInPercent</b>
     * </p>
     *
     * @return Scrap Factor for Formula Item
     */
    @SerializedName( "RcpFmlaItemScrapInPercent" )
    @JsonProperty( "RcpFmlaItemScrapInPercent" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemScrapInPercent" )
    private BigDecimal rcpFmlaItemScrapInPercent;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemScrapInPercent</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_SCRAP_IN_PERCENT =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemScrapInPercent");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemOverrunInPercent</b>
     * </p>
     *
     * @return Scrap Factor for Formula Item
     */
    @SerializedName( "RcpFmlaItemOverrunInPercent" )
    @JsonProperty( "RcpFmlaItemOverrunInPercent" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemOverrunInPercent" )
    private BigDecimal rcpFmlaItemOverrunInPercent;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemOverrunInPercent</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_OVERRUN_IN_PERCENT =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemOverrunInPercent");
    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemQuantityInKilogram</b>
     * </p>
     *
     * @return Absolute Mass (As Float)
     */
    @SerializedName( "RcpFmlaItemQuantityInKilogram" )
    @JsonProperty( "RcpFmlaItemQuantityInKilogram" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemQuantityInKilogram" )
    private BigDecimal rcpFmlaItemQuantityInKilogram;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemQuantityInKilogram</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<BigDecimal> RCP_FMLA_ITEM_QUANTITY_IN_KILOGRAM =
        new RecipeFormulaItemField<BigDecimal>("RcpFmlaItemQuantityInKilogram");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemIsSelectedForCalc</b>
     * </p>
     *
     * @return Calculate Quantity
     */
    @SerializedName( "RcpFmlaItemIsSelectedForCalc" )
    @JsonProperty( "RcpFmlaItemIsSelectedForCalc" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemIsSelectedForCalc" )
    private String rcpFmlaItemIsSelectedForCalc;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemIsSelectedForCalc</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_IS_SELECTED_FOR_CALC =
        new RecipeFormulaItemField<String>("RcpFmlaItemIsSelectedForCalc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemExplosionRecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RcpFmlaItemExplosionRecipeUUID" )
    @JsonProperty( "RcpFmlaItemExplosionRecipeUUID" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemExplosionRecipeUUID" )
    private UUID rcpFmlaItemExplosionRecipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemExplosionRecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RCP_FMLA_ITEM_EXPLOSION_RECIPE_UUID =
        new RecipeFormulaItemField<UUID>("RcpFmlaItemExplosionRecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemIsBalancingItem</b>
     * </p>
     *
     * @return Balancing Item
     */
    @SerializedName( "RcpFmlaItemIsBalancingItem" )
    @JsonProperty( "RcpFmlaItemIsBalancingItem" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemIsBalancingItem" )
    private String rcpFmlaItemIsBalancingItem;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemIsBalancingItem</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_IS_BALANCING_ITEM =
        new RecipeFormulaItemField<String>("RcpFmlaItemIsBalancingItem");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecipeFmlaItemAltvIsUsed</b>
     * </p>
     *
     * @return Alternative Item Used for Calculation
     */
    @SerializedName( "RecipeFmlaItemAltvIsUsed" )
    @JsonProperty( "RecipeFmlaItemAltvIsUsed" )
    @Nullable
    @ODataField( odataName = "RecipeFmlaItemAltvIsUsed" )
    private String recipeFmlaItemAltvIsUsed;
    /**
     * Use with available fluent helpers to apply the <b>RecipeFmlaItemAltvIsUsed</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RECIPE_FMLA_ITEM_ALTV_IS_USED =
        new RecipeFormulaItemField<String>("RecipeFmlaItemAltvIsUsed");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RECIPE_UUID = new RecipeFormulaItemField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @return Specification Type
     */
    @SerializedName( "SpecificationType" )
    @JsonProperty( "SpecificationType" )
    @Nullable
    @ODataField( odataName = "SpecificationType" )
    private String specificationType;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationType</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> SPECIFICATION_TYPE =
        new RecipeFormulaItemField<String>("SpecificationType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @return Recipe Authorization Group
     */
    @SerializedName( "SpecificationAuthznGroup" )
    @JsonProperty( "SpecificationAuthznGroup" )
    @Nullable
    @ODataField( odataName = "SpecificationAuthznGroup" )
    private String specificationAuthznGroup;
    /**
     * Use with available fluent helpers to apply the <b>SpecificationAuthznGroup</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> SPECIFICATION_AUTHZN_GROUP =
        new RecipeFormulaItemField<String>("SpecificationAuthznGroup");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @return Process Element GUID
     */
    @SerializedName( "RecipeProcessElementUUID" )
    @JsonProperty( "RecipeProcessElementUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementUUID" )
    private UUID recipeProcessElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RECIPE_PROCESS_ELEMENT_UUID =
        new RecipeFormulaItemField<UUID>("RecipeProcessElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStageUUID</b>
     * </p>
     *
     * @return Process Element GUID
     */
    @SerializedName( "RecipeProcessStageUUID" )
    @JsonProperty( "RecipeProcessStageUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStageUUID" )
    private UUID recipeProcessStageUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStageUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RECIPE_PROCESS_STAGE_UUID =
        new RecipeFormulaItemField<UUID>("RecipeProcessStageUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationUUID</b>
     * </p>
     *
     * @return The recipeProcessOperationUUID contained in this entity.
     */
    @SerializedName( "RecipeProcessOperationUUID" )
    @JsonProperty( "RecipeProcessOperationUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationUUID" )
    private UUID recipeProcessOperationUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RECIPE_PROCESS_OPERATION_UUID =
        new RecipeFormulaItemField<UUID>("RecipeProcessOperationUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionUUID</b>
     * </p>
     *
     * @return The recipeProcessActionUUID contained in this entity.
     */
    @SerializedName( "RecipeProcessActionUUID" )
    @JsonProperty( "RecipeProcessActionUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionUUID" )
    private UUID recipeProcessActionUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionUUID</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<UUID> RECIPE_PROCESS_ACTION_UUID =
        new RecipeFormulaItemField<UUID>("RecipeProcessActionUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessStagePosNmbr" )
    @JsonProperty( "RecipeProcessStagePosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStagePosNmbr" )
    private String recipeProcessStagePosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStagePosNmbr</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RECIPE_PROCESS_STAGE_POS_NMBR =
        new RecipeFormulaItemField<String>("RecipeProcessStagePosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessOperationPosNmbr" )
    @JsonProperty( "RecipeProcessOperationPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationPosNmbr" )
    private String recipeProcessOperationPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RECIPE_PROCESS_OPERATION_POS_NMBR =
        new RecipeFormulaItemField<String>("RecipeProcessOperationPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessActionPosNmbr" )
    @JsonProperty( "RecipeProcessActionPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionPosNmbr" )
    private String recipeProcessActionPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RECIPE_PROCESS_ACTION_POS_NMBR =
        new RecipeFormulaItemField<String>("RecipeProcessActionPosNmbr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeFormulaItemField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RECIPE = new RecipeFormulaItemField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemAlternativeItemPos</b>
     * </p>
     *
     * @return Number of Formula Item
     */
    @SerializedName( "RcpFmlaItemAlternativeItemPos" )
    @JsonProperty( "RcpFmlaItemAlternativeItemPos" )
    @Nullable
    @ODataField( odataName = "RcpFmlaItemAlternativeItemPos" )
    private String rcpFmlaItemAlternativeItemPos;
    /**
     * Use with available fluent helpers to apply the <b>RcpFmlaItemAlternativeItemPos</b> field to query operations.
     *
     */
    public final static RecipeFormulaItemField<String> RCP_FMLA_ITEM_ALTERNATIVE_ITEM_POS =
        new RecipeFormulaItemField<String>("RcpFmlaItemAlternativeItemPos");
    /**
     * Navigation property <b>to_Recipe</b> for <b>RecipeFormulaItem</b> to single <b>Recipe</b>.
     *
     */
    @SerializedName( "to_Recipe" )
    @JsonProperty( "to_Recipe" )
    @ODataField( odataName = "to_Recipe" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Recipe toRecipe;
    /**
     * Navigation property <b>to_ExplosionRecipe</b> for <b>RecipeFormulaItem</b> to single <b>Recipe</b>.
     *
     */
    @SerializedName( "to_ExplosionRecipe" )
    @JsonProperty( "to_ExplosionRecipe" )
    @ODataField( odataName = "to_ExplosionRecipe" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Recipe toExplosionRecipe;
    /**
     * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeFormulaItem</b> to single
     * <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElement" )
    @JsonProperty( "to_RecipeProcessElement" )
    @ODataField( odataName = "to_RecipeProcessElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessElement toRecipeProcessElement;
    /**
     * Use with available fluent helpers to apply the <b>to_Recipe</b> navigation property to query operations.
     *
     */
    public final static RecipeFormulaItemOneToOneLink<Recipe> TO_RECIPE =
        new RecipeFormulaItemOneToOneLink<Recipe>("to_Recipe");
    /**
     * Use with available fluent helpers to apply the <b>to_ExplosionRecipe</b> navigation property to query operations.
     *
     */
    public final static RecipeFormulaItemOneToOneLink<Recipe> TO_EXPLOSION_RECIPE =
        new RecipeFormulaItemOneToOneLink<Recipe>("to_ExplosionRecipe");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElement</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeFormulaItemOneToOneLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT =
        new RecipeFormulaItemOneToOneLink<RecipeProcessElement>("to_RecipeProcessElement");

    @Nonnull
    @Override
    public Class<RecipeFormulaItem> getType()
    {
        return RecipeFormulaItem.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUUID</b>
     * </p>
     *
     * @param rcpFmlaItemUUID
     *            Formula Item GUID
     */
    public void setRcpFmlaItemUUID( @Nullable final UUID rcpFmlaItemUUID )
    {
        rememberChangedField("RcpFmlaItemUUID", this.rcpFmlaItemUUID);
        this.rcpFmlaItemUUID = rcpFmlaItemUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaUUID</b>
     * </p>
     *
     * @param rcpFmlaUUID
     *            Formula GUID
     */
    public void setRcpFmlaUUID( @Nullable final UUID rcpFmlaUUID )
    {
        rememberChangedField("RcpFmlaUUID", this.rcpFmlaUUID);
        this.rcpFmlaUUID = rcpFmlaUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemPosition</b>
     * </p>
     *
     * @param rcpFmlaItemPosition
     *            Number of a Formula Item
     */
    public void setRcpFmlaItemPosition( @Nullable final String rcpFmlaItemPosition )
    {
        rememberChangedField("RcpFmlaItemPosition", this.rcpFmlaItemPosition);
        this.rcpFmlaItemPosition = rcpFmlaItemPosition;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemType</b>
     * </p>
     *
     * @param rcpFmlaItemType
     *            Formula Item Type
     */
    public void setRcpFmlaItemType( @Nullable final String rcpFmlaItemType )
    {
        rememberChangedField("RcpFmlaItemType", this.rcpFmlaItemType);
        this.rcpFmlaItemType = rcpFmlaItemType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationInternalID</b>
     * </p>
     *
     * @param specificationInternalID
     *            Specification Key
     */
    public void setSpecificationInternalID( @Nullable final String specificationInternalID )
    {
        rememberChangedField("SpecificationInternalID", this.specificationInternalID);
        this.specificationInternalID = specificationInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>Specification</b>
     * </p>
     *
     * @param specification
     *            Specification
     */
    public void setSpecification( @Nullable final String specification )
    {
        rememberChangedField("Specification", this.specification);
        this.specification = specification;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemComponentType</b>
     * </p>
     *
     * @param rcpFmlaItemComponentType
     *            Component Type of Formula Item
     */
    public void setRcpFmlaItemComponentType( @Nullable final String rcpFmlaItemComponentType )
    {
        rememberChangedField("RcpFmlaItemComponentType", this.rcpFmlaItemComponentType);
        this.rcpFmlaItemComponentType = rcpFmlaItemComponentType;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemLowerLimit</b>
     * </p>
     *
     * @param rcpFmlaItemLowerLimit
     *            Quantity
     */
    public void setRcpFmlaItemLowerLimit( @Nullable final BigDecimal rcpFmlaItemLowerLimit )
    {
        rememberChangedField("RcpFmlaItemLowerLimit", this.rcpFmlaItemLowerLimit);
        this.rcpFmlaItemLowerLimit = rcpFmlaItemLowerLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUpperLimit</b>
     * </p>
     *
     * @param rcpFmlaItemUpperLimit
     *            Quantity
     */
    public void setRcpFmlaItemUpperLimit( @Nullable final BigDecimal rcpFmlaItemUpperLimit )
    {
        rememberChangedField("RcpFmlaItemUpperLimit", this.rcpFmlaItemUpperLimit);
        this.rcpFmlaItemUpperLimit = rcpFmlaItemUpperLimit;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemQuantity</b>
     * </p>
     *
     * @param rcpFmlaItemQuantity
     *            Quantity
     */
    public void setRcpFmlaItemQuantity( @Nullable final BigDecimal rcpFmlaItemQuantity )
    {
        rememberChangedField("RcpFmlaItemQuantity", this.rcpFmlaItemQuantity);
        this.rcpFmlaItemQuantity = rcpFmlaItemQuantity;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemUnit</b>
     * </p>
     *
     * @param rcpFmlaItemUnit
     *            Unit of Measure
     */
    public void setRcpFmlaItemUnit( @Nullable final String rcpFmlaItemUnit )
    {
        rememberChangedField("RcpFmlaItemUnit", this.rcpFmlaItemUnit);
        this.rcpFmlaItemUnit = rcpFmlaItemUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemExceptionCode</b>
     * </p>
     *
     * @param rcpFmlaItemExceptionCode
     *            Exception Value
     */
    public void setRcpFmlaItemExceptionCode( @Nullable final String rcpFmlaItemExceptionCode )
    {
        rememberChangedField("RcpFmlaItemExceptionCode", this.rcpFmlaItemExceptionCode);
        this.rcpFmlaItemExceptionCode = rcpFmlaItemExceptionCode;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemScrapInPercent</b>
     * </p>
     *
     * @param rcpFmlaItemScrapInPercent
     *            Scrap Factor for Formula Item
     */
    public void setRcpFmlaItemScrapInPercent( @Nullable final BigDecimal rcpFmlaItemScrapInPercent )
    {
        rememberChangedField("RcpFmlaItemScrapInPercent", this.rcpFmlaItemScrapInPercent);
        this.rcpFmlaItemScrapInPercent = rcpFmlaItemScrapInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemOverrunInPercent</b>
     * </p>
     *
     * @param rcpFmlaItemOverrunInPercent
     *            Scrap Factor for Formula Item
     */
    public void setRcpFmlaItemOverrunInPercent( @Nullable final BigDecimal rcpFmlaItemOverrunInPercent )
    {
        rememberChangedField("RcpFmlaItemOverrunInPercent", this.rcpFmlaItemOverrunInPercent);
        this.rcpFmlaItemOverrunInPercent = rcpFmlaItemOverrunInPercent;
    }

    /**
     * Constraints: Not nullable, Precision: 34, Scale: 6
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemQuantityInKilogram</b>
     * </p>
     *
     * @param rcpFmlaItemQuantityInKilogram
     *            Absolute Mass (As Float)
     */
    public void setRcpFmlaItemQuantityInKilogram( @Nullable final BigDecimal rcpFmlaItemQuantityInKilogram )
    {
        rememberChangedField("RcpFmlaItemQuantityInKilogram", this.rcpFmlaItemQuantityInKilogram);
        this.rcpFmlaItemQuantityInKilogram = rcpFmlaItemQuantityInKilogram;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemIsSelectedForCalc</b>
     * </p>
     *
     * @param rcpFmlaItemIsSelectedForCalc
     *            Calculate Quantity
     */
    public void setRcpFmlaItemIsSelectedForCalc( @Nullable final String rcpFmlaItemIsSelectedForCalc )
    {
        rememberChangedField("RcpFmlaItemIsSelectedForCalc", this.rcpFmlaItemIsSelectedForCalc);
        this.rcpFmlaItemIsSelectedForCalc = rcpFmlaItemIsSelectedForCalc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemExplosionRecipeUUID</b>
     * </p>
     *
     * @param rcpFmlaItemExplosionRecipeUUID
     *            Common Recipe GUID
     */
    public void setRcpFmlaItemExplosionRecipeUUID( @Nullable final UUID rcpFmlaItemExplosionRecipeUUID )
    {
        rememberChangedField("RcpFmlaItemExplosionRecipeUUID", this.rcpFmlaItemExplosionRecipeUUID);
        this.rcpFmlaItemExplosionRecipeUUID = rcpFmlaItemExplosionRecipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemIsBalancingItem</b>
     * </p>
     *
     * @param rcpFmlaItemIsBalancingItem
     *            Balancing Item
     */
    public void setRcpFmlaItemIsBalancingItem( @Nullable final String rcpFmlaItemIsBalancingItem )
    {
        rememberChangedField("RcpFmlaItemIsBalancingItem", this.rcpFmlaItemIsBalancingItem);
        this.rcpFmlaItemIsBalancingItem = rcpFmlaItemIsBalancingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecipeFmlaItemAltvIsUsed</b>
     * </p>
     *
     * @param recipeFmlaItemAltvIsUsed
     *            Alternative Item Used for Calculation
     */
    public void setRecipeFmlaItemAltvIsUsed( @Nullable final String recipeFmlaItemAltvIsUsed )
    {
        rememberChangedField("RecipeFmlaItemAltvIsUsed", this.recipeFmlaItemAltvIsUsed);
        this.recipeFmlaItemAltvIsUsed = recipeFmlaItemAltvIsUsed;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationType</b>
     * </p>
     *
     * @param specificationType
     *            Specification Type
     */
    public void setSpecificationType( @Nullable final String specificationType )
    {
        rememberChangedField("SpecificationType", this.specificationType);
        this.specificationType = specificationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SpecificationAuthznGroup</b>
     * </p>
     *
     * @param specificationAuthznGroup
     *            Recipe Authorization Group
     */
    public void setSpecificationAuthznGroup( @Nullable final String specificationAuthznGroup )
    {
        rememberChangedField("SpecificationAuthznGroup", this.specificationAuthznGroup);
        this.specificationAuthznGroup = specificationAuthznGroup;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     */
    public void setRecipeProcessElementUUID( @Nullable final UUID recipeProcessElementUUID )
    {
        rememberChangedField("RecipeProcessElementUUID", this.recipeProcessElementUUID);
        this.recipeProcessElementUUID = recipeProcessElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStageUUID</b>
     * </p>
     *
     * @param recipeProcessStageUUID
     *            Process Element GUID
     */
    public void setRecipeProcessStageUUID( @Nullable final UUID recipeProcessStageUUID )
    {
        rememberChangedField("RecipeProcessStageUUID", this.recipeProcessStageUUID);
        this.recipeProcessStageUUID = recipeProcessStageUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationUUID</b>
     * </p>
     *
     * @param recipeProcessOperationUUID
     *            The recipeProcessOperationUUID to set.
     */
    public void setRecipeProcessOperationUUID( @Nullable final UUID recipeProcessOperationUUID )
    {
        rememberChangedField("RecipeProcessOperationUUID", this.recipeProcessOperationUUID);
        this.recipeProcessOperationUUID = recipeProcessOperationUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionUUID</b>
     * </p>
     *
     * @param recipeProcessActionUUID
     *            The recipeProcessActionUUID to set.
     */
    public void setRecipeProcessActionUUID( @Nullable final UUID recipeProcessActionUUID )
    {
        rememberChangedField("RecipeProcessActionUUID", this.recipeProcessActionUUID);
        this.recipeProcessActionUUID = recipeProcessActionUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @param recipeProcessStagePosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessStagePosNmbr( @Nullable final String recipeProcessStagePosNmbr )
    {
        rememberChangedField("RecipeProcessStagePosNmbr", this.recipeProcessStagePosNmbr);
        this.recipeProcessStagePosNmbr = recipeProcessStagePosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @param recipeProcessOperationPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessOperationPosNmbr( @Nullable final String recipeProcessOperationPosNmbr )
    {
        rememberChangedField("RecipeProcessOperationPosNmbr", this.recipeProcessOperationPosNmbr);
        this.recipeProcessOperationPosNmbr = recipeProcessOperationPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @param recipeProcessActionPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessActionPosNmbr( @Nullable final String recipeProcessActionPosNmbr )
    {
        rememberChangedField("RecipeProcessActionPosNmbr", this.recipeProcessActionPosNmbr);
        this.recipeProcessActionPosNmbr = recipeProcessActionPosNmbr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RcpFmlaItemAlternativeItemPos</b>
     * </p>
     *
     * @param rcpFmlaItemAlternativeItemPos
     *            Number of Formula Item
     */
    public void setRcpFmlaItemAlternativeItemPos( @Nullable final String rcpFmlaItemAlternativeItemPos )
    {
        rememberChangedField("RcpFmlaItemAlternativeItemPos", this.rcpFmlaItemAlternativeItemPos);
        this.rcpFmlaItemAlternativeItemPos = rcpFmlaItemAlternativeItemPos;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeFormulaItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RcpFmlaItemUUID", getRcpFmlaItemUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RcpFmlaItemUUID", getRcpFmlaItemUUID());
        values.put("RcpFmlaUUID", getRcpFmlaUUID());
        values.put("RcpFmlaItemPosition", getRcpFmlaItemPosition());
        values.put("RcpFmlaItemType", getRcpFmlaItemType());
        values.put("SpecificationInternalID", getSpecificationInternalID());
        values.put("Specification", getSpecification());
        values.put("Material", getMaterial());
        values.put("RcpFmlaItemComponentType", getRcpFmlaItemComponentType());
        values.put("RcpFmlaItemLowerLimit", getRcpFmlaItemLowerLimit());
        values.put("RcpFmlaItemUpperLimit", getRcpFmlaItemUpperLimit());
        values.put("RcpFmlaItemQuantity", getRcpFmlaItemQuantity());
        values.put("RcpFmlaItemUnit", getRcpFmlaItemUnit());
        values.put("RcpFmlaItemExceptionCode", getRcpFmlaItemExceptionCode());
        values.put("RcpFmlaItemScrapInPercent", getRcpFmlaItemScrapInPercent());
        values.put("RcpFmlaItemOverrunInPercent", getRcpFmlaItemOverrunInPercent());
        values.put("RcpFmlaItemQuantityInKilogram", getRcpFmlaItemQuantityInKilogram());
        values.put("RcpFmlaItemIsSelectedForCalc", getRcpFmlaItemIsSelectedForCalc());
        values.put("RcpFmlaItemExplosionRecipeUUID", getRcpFmlaItemExplosionRecipeUUID());
        values.put("RcpFmlaItemIsBalancingItem", getRcpFmlaItemIsBalancingItem());
        values.put("RecipeFmlaItemAltvIsUsed", getRecipeFmlaItemAltvIsUsed());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("SpecificationType", getSpecificationType());
        values.put("SpecificationAuthznGroup", getSpecificationAuthznGroup());
        values.put("RecipeProcessElementUUID", getRecipeProcessElementUUID());
        values.put("RecipeProcessStageUUID", getRecipeProcessStageUUID());
        values.put("RecipeProcessOperationUUID", getRecipeProcessOperationUUID());
        values.put("RecipeProcessActionUUID", getRecipeProcessActionUUID());
        values.put("RecipeProcessStagePosNmbr", getRecipeProcessStagePosNmbr());
        values.put("RecipeProcessOperationPosNmbr", getRecipeProcessOperationPosNmbr());
        values.put("RecipeProcessActionPosNmbr", getRecipeProcessActionPosNmbr());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("Recipe", getRecipe());
        values.put("RcpFmlaItemAlternativeItemPos", getRcpFmlaItemAlternativeItemPos());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RcpFmlaItemUUID") ) {
                final Object value = values.remove("RcpFmlaItemUUID");
                if( (value == null) || (!value.equals(getRcpFmlaItemUUID())) ) {
                    setRcpFmlaItemUUID(((UUID) value));
                }
            }
            if( values.containsKey("RcpFmlaUUID") ) {
                final Object value = values.remove("RcpFmlaUUID");
                if( (value == null) || (!value.equals(getRcpFmlaUUID())) ) {
                    setRcpFmlaUUID(((UUID) value));
                }
            }
            if( values.containsKey("RcpFmlaItemPosition") ) {
                final Object value = values.remove("RcpFmlaItemPosition");
                if( (value == null) || (!value.equals(getRcpFmlaItemPosition())) ) {
                    setRcpFmlaItemPosition(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemType") ) {
                final Object value = values.remove("RcpFmlaItemType");
                if( (value == null) || (!value.equals(getRcpFmlaItemType())) ) {
                    setRcpFmlaItemType(((String) value));
                }
            }
            if( values.containsKey("SpecificationInternalID") ) {
                final Object value = values.remove("SpecificationInternalID");
                if( (value == null) || (!value.equals(getSpecificationInternalID())) ) {
                    setSpecificationInternalID(((String) value));
                }
            }
            if( values.containsKey("Specification") ) {
                final Object value = values.remove("Specification");
                if( (value == null) || (!value.equals(getSpecification())) ) {
                    setSpecification(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemComponentType") ) {
                final Object value = values.remove("RcpFmlaItemComponentType");
                if( (value == null) || (!value.equals(getRcpFmlaItemComponentType())) ) {
                    setRcpFmlaItemComponentType(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemLowerLimit") ) {
                final Object value = values.remove("RcpFmlaItemLowerLimit");
                if( (value == null) || (!value.equals(getRcpFmlaItemLowerLimit())) ) {
                    setRcpFmlaItemLowerLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemUpperLimit") ) {
                final Object value = values.remove("RcpFmlaItemUpperLimit");
                if( (value == null) || (!value.equals(getRcpFmlaItemUpperLimit())) ) {
                    setRcpFmlaItemUpperLimit(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemQuantity") ) {
                final Object value = values.remove("RcpFmlaItemQuantity");
                if( (value == null) || (!value.equals(getRcpFmlaItemQuantity())) ) {
                    setRcpFmlaItemQuantity(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemUnit") ) {
                final Object value = values.remove("RcpFmlaItemUnit");
                if( (value == null) || (!value.equals(getRcpFmlaItemUnit())) ) {
                    setRcpFmlaItemUnit(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemExceptionCode") ) {
                final Object value = values.remove("RcpFmlaItemExceptionCode");
                if( (value == null) || (!value.equals(getRcpFmlaItemExceptionCode())) ) {
                    setRcpFmlaItemExceptionCode(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemScrapInPercent") ) {
                final Object value = values.remove("RcpFmlaItemScrapInPercent");
                if( (value == null) || (!value.equals(getRcpFmlaItemScrapInPercent())) ) {
                    setRcpFmlaItemScrapInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemOverrunInPercent") ) {
                final Object value = values.remove("RcpFmlaItemOverrunInPercent");
                if( (value == null) || (!value.equals(getRcpFmlaItemOverrunInPercent())) ) {
                    setRcpFmlaItemOverrunInPercent(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemQuantityInKilogram") ) {
                final Object value = values.remove("RcpFmlaItemQuantityInKilogram");
                if( (value == null) || (!value.equals(getRcpFmlaItemQuantityInKilogram())) ) {
                    setRcpFmlaItemQuantityInKilogram(((BigDecimal) value));
                }
            }
            if( values.containsKey("RcpFmlaItemIsSelectedForCalc") ) {
                final Object value = values.remove("RcpFmlaItemIsSelectedForCalc");
                if( (value == null) || (!value.equals(getRcpFmlaItemIsSelectedForCalc())) ) {
                    setRcpFmlaItemIsSelectedForCalc(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemExplosionRecipeUUID") ) {
                final Object value = values.remove("RcpFmlaItemExplosionRecipeUUID");
                if( (value == null) || (!value.equals(getRcpFmlaItemExplosionRecipeUUID())) ) {
                    setRcpFmlaItemExplosionRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("RcpFmlaItemIsBalancingItem") ) {
                final Object value = values.remove("RcpFmlaItemIsBalancingItem");
                if( (value == null) || (!value.equals(getRcpFmlaItemIsBalancingItem())) ) {
                    setRcpFmlaItemIsBalancingItem(((String) value));
                }
            }
            if( values.containsKey("RecipeFmlaItemAltvIsUsed") ) {
                final Object value = values.remove("RecipeFmlaItemAltvIsUsed");
                if( (value == null) || (!value.equals(getRecipeFmlaItemAltvIsUsed())) ) {
                    setRecipeFmlaItemAltvIsUsed(((String) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("SpecificationType") ) {
                final Object value = values.remove("SpecificationType");
                if( (value == null) || (!value.equals(getSpecificationType())) ) {
                    setSpecificationType(((String) value));
                }
            }
            if( values.containsKey("SpecificationAuthznGroup") ) {
                final Object value = values.remove("SpecificationAuthznGroup");
                if( (value == null) || (!value.equals(getSpecificationAuthznGroup())) ) {
                    setSpecificationAuthznGroup(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessElementUUID") ) {
                final Object value = values.remove("RecipeProcessElementUUID");
                if( (value == null) || (!value.equals(getRecipeProcessElementUUID())) ) {
                    setRecipeProcessElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessStageUUID") ) {
                final Object value = values.remove("RecipeProcessStageUUID");
                if( (value == null) || (!value.equals(getRecipeProcessStageUUID())) ) {
                    setRecipeProcessStageUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationUUID") ) {
                final Object value = values.remove("RecipeProcessOperationUUID");
                if( (value == null) || (!value.equals(getRecipeProcessOperationUUID())) ) {
                    setRecipeProcessOperationUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessActionUUID") ) {
                final Object value = values.remove("RecipeProcessActionUUID");
                if( (value == null) || (!value.equals(getRecipeProcessActionUUID())) ) {
                    setRecipeProcessActionUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessStagePosNmbr") ) {
                final Object value = values.remove("RecipeProcessStagePosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessStagePosNmbr())) ) {
                    setRecipeProcessStagePosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationPosNmbr") ) {
                final Object value = values.remove("RecipeProcessOperationPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessOperationPosNmbr())) ) {
                    setRecipeProcessOperationPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessActionPosNmbr") ) {
                final Object value = values.remove("RecipeProcessActionPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessActionPosNmbr())) ) {
                    setRecipeProcessActionPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RcpFmlaItemAlternativeItemPos") ) {
                final Object value = values.remove("RcpFmlaItemAlternativeItemPos");
                if( (value == null) || (!value.equals(getRcpFmlaItemAlternativeItemPos())) ) {
                    setRcpFmlaItemAlternativeItemPos(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Recipe") ) {
                final Object value = (values).remove("to_Recipe");
                if( value instanceof Map ) {
                    if( toRecipe == null ) {
                        toRecipe = new Recipe();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipe.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_ExplosionRecipe") ) {
                final Object value = (values).remove("to_ExplosionRecipe");
                if( value instanceof Map ) {
                    if( toExplosionRecipe == null ) {
                        toExplosionRecipe = new Recipe();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toExplosionRecipe.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessElement") ) {
                final Object value = (values).remove("to_RecipeProcessElement");
                if( value instanceof Map ) {
                    if( toRecipeProcessElement == null ) {
                        toRecipeProcessElement = new RecipeProcessElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessElement.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeFormulaItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeFormulaItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeFormulaItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeFormulaItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipe != null ) {
            (values).put("to_Recipe", toRecipe);
        }
        if( toExplosionRecipe != null ) {
            (values).put("to_ExplosionRecipe", toExplosionRecipe);
        }
        if( toRecipeProcessElement != null ) {
            (values).put("to_RecipeProcessElement", toRecipeProcessElement);
        }
        return values;
    }

    /**
     * Fetches the <b>Recipe</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Recipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Recipe</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe fetchRecipe()
    {
        return fetchFieldAsSingle("to_Recipe", Recipe.class);
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property <b>to_Recipe</b> of a queried <b>RecipeFormulaItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Recipe</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe getRecipeOrFetch()
    {
        if( toRecipe == null ) {
            toRecipe = fetchRecipe();
        }
        return toRecipe;
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeFormulaItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Recipe</b> is already loaded, the result will contain
     *         the <b>Recipe</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Recipe> getRecipeIfPresent()
    {
        return Option.of(toRecipe);
    }

    /**
     * Overwrites the associated <b>Recipe</b> entity for the loaded navigation property <b>to_Recipe</b>.
     *
     * @param value
     *            New <b>Recipe</b> entity.
     */
    public void setRecipe( final Recipe value )
    {
        toRecipe = value;
    }

    /**
     * Fetches the <b>Recipe</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_ExplosionRecipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Recipe</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe fetchExplosionRecipe()
    {
        return fetchFieldAsSingle("to_ExplosionRecipe", Recipe.class);
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_ExplosionRecipe</b>.
     * <p>
     * If the navigation property <b>to_ExplosionRecipe</b> of a queried <b>RecipeFormulaItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Recipe</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe getExplosionRecipeOrFetch()
    {
        if( toExplosionRecipe == null ) {
            toExplosionRecipe = fetchExplosionRecipe();
        }
        return toExplosionRecipe;
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_ExplosionRecipe</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeFormulaItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ExplosionRecipe</b> is already loaded, the result will
     *         contain the <b>Recipe</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Recipe> getExplosionRecipeIfPresent()
    {
        return Option.of(toExplosionRecipe);
    }

    /**
     * Overwrites the associated <b>Recipe</b> entity for the loaded navigation property <b>to_ExplosionRecipe</b>.
     *
     * @param value
     *            New <b>Recipe</b> entity.
     */
    public void setExplosionRecipe( final Recipe value )
    {
        toExplosionRecipe = value;
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessElement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement fetchRecipeProcessElement()
    {
        return fetchFieldAsSingle("to_RecipeProcessElement", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>RecipeFormulaItem</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement getRecipeProcessElementOrFetch()
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = fetchRecipeProcessElement();
        }
        return toRecipeProcessElement;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeFormulaItem</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElement</b> is already loaded, the result
     *         will contain the <b>RecipeProcessElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessElement> getRecipeProcessElementIfPresent()
    {
        return Option.of(toRecipeProcessElement);
    }

    /**
     * Overwrites the associated <b>RecipeProcessElement</b> entity for the loaded navigation property
     * <b>to_RecipeProcessElement</b>.
     *
     * @param value
     *            New <b>RecipeProcessElement</b> entity.
     */
    public void setRecipeProcessElement( final RecipeProcessElement value )
    {
        toRecipeProcessElement = value;
    }

    /**
     * Helper class to allow for fluent creation of RecipeFormulaItem instances.
     *
     */
    public final static class RecipeFormulaItemBuilder
    {

        private Recipe toRecipe;
        private String recipe = null;
        private Recipe toExplosionRecipe;
        private RecipeProcessElement toRecipeProcessElement;

        private RecipeFormulaItem.RecipeFormulaItemBuilder toRecipe( final Recipe value )
        {
            toRecipe = value;
            return this;
        }

        /**
         * Navigation property <b>to_Recipe</b> for <b>RecipeFormulaItem</b> to single <b>Recipe</b>.
         *
         * @param value
         *            The Recipe to build this RecipeFormulaItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeFormulaItem.RecipeFormulaItemBuilder recipe( final Recipe value )
        {
            return toRecipe(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 20
         * <p>
         * Original property name from the Odata EDM: <b>Recipe</b>
         * </p>
         *
         * @param value
         *            The recipe to build this RecipeFormulaItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeFormulaItem.RecipeFormulaItemBuilder recipe( final String value )
        {
            recipe = value;
            return this;
        }

        private RecipeFormulaItem.RecipeFormulaItemBuilder toExplosionRecipe( final Recipe value )
        {
            toExplosionRecipe = value;
            return this;
        }

        /**
         * Navigation property <b>to_ExplosionRecipe</b> for <b>RecipeFormulaItem</b> to single <b>Recipe</b>.
         *
         * @param value
         *            The Recipe to build this RecipeFormulaItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeFormulaItem.RecipeFormulaItemBuilder explosionRecipe( final Recipe value )
        {
            return toExplosionRecipe(value);
        }

        private RecipeFormulaItem.RecipeFormulaItemBuilder toRecipeProcessElement( final RecipeProcessElement value )
        {
            toRecipeProcessElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeFormulaItem</b> to single
         * <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElement to build this RecipeFormulaItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeFormulaItem.RecipeFormulaItemBuilder recipeProcessElement( final RecipeProcessElement value )
        {
            return toRecipeProcessElement(value);
        }

    }

}
