/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessElementOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Process Elements
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessElement extends VdmEntity<RecipeProcessElement>
{

    /**
     * Selector for all available fields of RecipeProcessElement.
     *
     */
    public final static RecipeProcessElementSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<Boolean> DELETE_MC =
        new RecipeProcessElementField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<Boolean> UPDATE_MC =
        new RecipeProcessElementField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @return Process Element GUID
     */
    @Key
    @SerializedName( "RecipeProcessElementUUID" )
    @JsonProperty( "RecipeProcessElementUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementUUID" )
    private UUID recipeProcessElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<UUID> RECIPE_PROCESS_ELEMENT_UUID =
        new RecipeProcessElementField<UUID>("RecipeProcessElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @return Process GUID
     */
    @SerializedName( "RecipeProcessUUID" )
    @JsonProperty( "RecipeProcessUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessUUID" )
    private UUID recipeProcessUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<UUID> RECIPE_PROCESS_UUID =
        new RecipeProcessElementField<UUID>("RecipeProcessUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementType</b>
     * </p>
     *
     * @return Type of Process Element
     */
    @SerializedName( "RecipeProcessElementType" )
    @JsonProperty( "RecipeProcessElementType" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementType" )
    private String recipeProcessElementType;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementType</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE_PROCESS_ELEMENT_TYPE =
        new RecipeProcessElementField<String>("RecipeProcessElementType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementParentUUID</b>
     * </p>
     *
     * @return Parent GUID
     */
    @SerializedName( "RecipeProcessElementParentUUID" )
    @JsonProperty( "RecipeProcessElementParentUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementParentUUID" )
    private UUID recipeProcessElementParentUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementParentUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<UUID> RECIPE_PROCESS_ELEMENT_PARENT_UUID =
        new RecipeProcessElementField<UUID>("RecipeProcessElementParentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessElementPosNmbr" )
    @JsonProperty( "RecipeProcessElementPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementPosNmbr" )
    private String recipeProcessElementPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE_PROCESS_ELEMENT_POS_NMBR =
        new RecipeProcessElementField<String>("RecipeProcessElementPosNmbr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeProcessElementField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<UUID> RECIPE_UUID = new RecipeProcessElementField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE = new RecipeProcessElementField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessStagePosNmbr" )
    @JsonProperty( "RecipeProcessStagePosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStagePosNmbr" )
    private String recipeProcessStagePosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStagePosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE_PROCESS_STAGE_POS_NMBR =
        new RecipeProcessElementField<String>("RecipeProcessStagePosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessOperationPosNmbr" )
    @JsonProperty( "RecipeProcessOperationPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationPosNmbr" )
    private String recipeProcessOperationPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE_PROCESS_OPERATION_POS_NMBR =
        new RecipeProcessElementField<String>("RecipeProcessOperationPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessActionPosNmbr" )
    @JsonProperty( "RecipeProcessActionPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionPosNmbr" )
    private String recipeProcessActionPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessElementField<String> RECIPE_PROCESS_ACTION_POS_NMBR =
        new RecipeProcessElementField<String>("RecipeProcessActionPosNmbr");
    /**
     * Navigation property <b>to_Recipe</b> for <b>RecipeProcessElement</b> to single <b>Recipe</b>.
     *
     */
    @SerializedName( "to_Recipe" )
    @JsonProperty( "to_Recipe" )
    @ODataField( odataName = "to_Recipe" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Recipe toRecipe;
    /**
     * Navigation property <b>to_FormulaItem</b> for <b>RecipeProcessElement</b> to multiple <b>RecipeFormulaItem</b>.
     *
     */
    @SerializedName( "to_FormulaItem" )
    @JsonProperty( "to_FormulaItem" )
    @ODataField( odataName = "to_FormulaItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeFormulaItem> toFormulaItem;
    /**
     * Navigation property <b>to_RecipeProcessElementChild</b> for <b>RecipeProcessElement</b> to multiple
     * <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElementChild" )
    @JsonProperty( "to_RecipeProcessElementChild" )
    @ODataField( odataName = "to_RecipeProcessElementChild" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessElement> toRecipeProcessElementChild;
    /**
     * Navigation property <b>to_RecipeProcessElementParent</b> for <b>RecipeProcessElement</b> to single
     * <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElementParent" )
    @JsonProperty( "to_RecipeProcessElementParent" )
    @ODataField( odataName = "to_RecipeProcessElementParent" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessElement toRecipeProcessElementParent;
    /**
     * Navigation property <b>to_RecipeProcessElementText</b> for <b>RecipeProcessElement</b> to multiple
     * <b>RecipeProcessElementText</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElementText" )
    @JsonProperty( "to_RecipeProcessElementText" )
    @ODataField( odataName = "to_RecipeProcessElementText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessElementText> toRecipeProcessElementText;
    /**
     * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>RecipeProcessElement</b> to multiple
     * <b>RecipeProcessEquipRqmt</b>.
     *
     */
    @SerializedName( "to_RecipeProcessEquipRqmt" )
    @JsonProperty( "to_RecipeProcessEquipRqmt" )
    @ODataField( odataName = "to_RecipeProcessEquipRqmt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessEquipRqmt> toRecipeProcessEquipRqmt;
    /**
     * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessElement</b> to multiple
     * <b>RecipeProcessParamValue</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamValue" )
    @JsonProperty( "to_RecipeProcessParamValue" )
    @ODataField( odataName = "to_RecipeProcessParamValue" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessParamValue> toRecipeProcessParamValue;
    /**
     * Use with available fluent helpers to apply the <b>to_Recipe</b> navigation property to query operations.
     *
     */
    public final static RecipeProcessElementOneToOneLink<Recipe> TO_RECIPE =
        new RecipeProcessElementOneToOneLink<Recipe>("to_Recipe");
    /**
     * Use with available fluent helpers to apply the <b>to_FormulaItem</b> navigation property to query operations.
     *
     */
    public final static RecipeProcessElementLink<RecipeFormulaItem> TO_FORMULA_ITEM =
        new RecipeProcessElementLink<RecipeFormulaItem>("to_FormulaItem");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElementChild</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessElementLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT_CHILD =
        new RecipeProcessElementLink<RecipeProcessElement>("to_RecipeProcessElementChild");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElementParent</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessElementOneToOneLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT_PARENT =
        new RecipeProcessElementOneToOneLink<RecipeProcessElement>("to_RecipeProcessElementParent");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElementText</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessElementLink<RecipeProcessElementText> TO_RECIPE_PROCESS_ELEMENT_TEXT =
        new RecipeProcessElementLink<RecipeProcessElementText>("to_RecipeProcessElementText");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessEquipRqmt</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessElementLink<RecipeProcessEquipRqmt> TO_RECIPE_PROCESS_EQUIP_RQMT =
        new RecipeProcessElementLink<RecipeProcessEquipRqmt>("to_RecipeProcessEquipRqmt");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamValue</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessElementLink<RecipeProcessParamValue> TO_RECIPE_PROCESS_PARAM_VALUE =
        new RecipeProcessElementLink<RecipeProcessParamValue>("to_RecipeProcessParamValue");

    @Nonnull
    @Override
    public Class<RecipeProcessElement> getType()
    {
        return RecipeProcessElement.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     */
    public void setRecipeProcessElementUUID( @Nullable final UUID recipeProcessElementUUID )
    {
        rememberChangedField("RecipeProcessElementUUID", this.recipeProcessElementUUID);
        this.recipeProcessElementUUID = recipeProcessElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @param recipeProcessUUID
     *            Process GUID
     */
    public void setRecipeProcessUUID( @Nullable final UUID recipeProcessUUID )
    {
        rememberChangedField("RecipeProcessUUID", this.recipeProcessUUID);
        this.recipeProcessUUID = recipeProcessUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementType</b>
     * </p>
     *
     * @param recipeProcessElementType
     *            Type of Process Element
     */
    public void setRecipeProcessElementType( @Nullable final String recipeProcessElementType )
    {
        rememberChangedField("RecipeProcessElementType", this.recipeProcessElementType);
        this.recipeProcessElementType = recipeProcessElementType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementParentUUID</b>
     * </p>
     *
     * @param recipeProcessElementParentUUID
     *            Parent GUID
     */
    public void setRecipeProcessElementParentUUID( @Nullable final UUID recipeProcessElementParentUUID )
    {
        rememberChangedField("RecipeProcessElementParentUUID", this.recipeProcessElementParentUUID);
        this.recipeProcessElementParentUUID = recipeProcessElementParentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementPosNmbr</b>
     * </p>
     *
     * @param recipeProcessElementPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessElementPosNmbr( @Nullable final String recipeProcessElementPosNmbr )
    {
        rememberChangedField("RecipeProcessElementPosNmbr", this.recipeProcessElementPosNmbr);
        this.recipeProcessElementPosNmbr = recipeProcessElementPosNmbr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @param recipeProcessStagePosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessStagePosNmbr( @Nullable final String recipeProcessStagePosNmbr )
    {
        rememberChangedField("RecipeProcessStagePosNmbr", this.recipeProcessStagePosNmbr);
        this.recipeProcessStagePosNmbr = recipeProcessStagePosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @param recipeProcessOperationPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessOperationPosNmbr( @Nullable final String recipeProcessOperationPosNmbr )
    {
        rememberChangedField("RecipeProcessOperationPosNmbr", this.recipeProcessOperationPosNmbr);
        this.recipeProcessOperationPosNmbr = recipeProcessOperationPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @param recipeProcessActionPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessActionPosNmbr( @Nullable final String recipeProcessActionPosNmbr )
    {
        rememberChangedField("RecipeProcessActionPosNmbr", this.recipeProcessActionPosNmbr);
        this.recipeProcessActionPosNmbr = recipeProcessActionPosNmbr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessElementUUID", getRecipeProcessElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RecipeProcessElementUUID", getRecipeProcessElementUUID());
        values.put("RecipeProcessUUID", getRecipeProcessUUID());
        values.put("RecipeProcessElementType", getRecipeProcessElementType());
        values.put("RecipeProcessElementParentUUID", getRecipeProcessElementParentUUID());
        values.put("RecipeProcessElementPosNmbr", getRecipeProcessElementPosNmbr());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("Recipe", getRecipe());
        values.put("RecipeProcessStagePosNmbr", getRecipeProcessStagePosNmbr());
        values.put("RecipeProcessOperationPosNmbr", getRecipeProcessOperationPosNmbr());
        values.put("RecipeProcessActionPosNmbr", getRecipeProcessActionPosNmbr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessElementUUID") ) {
                final Object value = values.remove("RecipeProcessElementUUID");
                if( (value == null) || (!value.equals(getRecipeProcessElementUUID())) ) {
                    setRecipeProcessElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessUUID") ) {
                final Object value = values.remove("RecipeProcessUUID");
                if( (value == null) || (!value.equals(getRecipeProcessUUID())) ) {
                    setRecipeProcessUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessElementType") ) {
                final Object value = values.remove("RecipeProcessElementType");
                if( (value == null) || (!value.equals(getRecipeProcessElementType())) ) {
                    setRecipeProcessElementType(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessElementParentUUID") ) {
                final Object value = values.remove("RecipeProcessElementParentUUID");
                if( (value == null) || (!value.equals(getRecipeProcessElementParentUUID())) ) {
                    setRecipeProcessElementParentUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessElementPosNmbr") ) {
                final Object value = values.remove("RecipeProcessElementPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessElementPosNmbr())) ) {
                    setRecipeProcessElementPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessStagePosNmbr") ) {
                final Object value = values.remove("RecipeProcessStagePosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessStagePosNmbr())) ) {
                    setRecipeProcessStagePosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationPosNmbr") ) {
                final Object value = values.remove("RecipeProcessOperationPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessOperationPosNmbr())) ) {
                    setRecipeProcessOperationPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessActionPosNmbr") ) {
                final Object value = values.remove("RecipeProcessActionPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessActionPosNmbr())) ) {
                    setRecipeProcessActionPosNmbr(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Recipe") ) {
                final Object value = (values).remove("to_Recipe");
                if( value instanceof Map ) {
                    if( toRecipe == null ) {
                        toRecipe = new Recipe();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipe.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_FormulaItem") ) {
                final Object value = (values).remove("to_FormulaItem");
                if( value instanceof Iterable ) {
                    if( toFormulaItem == null ) {
                        toFormulaItem = Lists.newArrayList();
                    } else {
                        toFormulaItem = Lists.newArrayList(toFormulaItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeFormulaItem entity;
                        if( toFormulaItem.size() > i ) {
                            entity = toFormulaItem.get(i);
                        } else {
                            entity = new RecipeFormulaItem();
                            toFormulaItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessElementChild") ) {
                final Object value = (values).remove("to_RecipeProcessElementChild");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessElementChild == null ) {
                        toRecipeProcessElementChild = Lists.newArrayList();
                    } else {
                        toRecipeProcessElementChild = Lists.newArrayList(toRecipeProcessElementChild);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessElement entity;
                        if( toRecipeProcessElementChild.size() > i ) {
                            entity = toRecipeProcessElementChild.get(i);
                        } else {
                            entity = new RecipeProcessElement();
                            toRecipeProcessElementChild.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessElementParent") ) {
                final Object value = (values).remove("to_RecipeProcessElementParent");
                if( value instanceof Map ) {
                    if( toRecipeProcessElementParent == null ) {
                        toRecipeProcessElementParent = new RecipeProcessElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessElementParent.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessElementText") ) {
                final Object value = (values).remove("to_RecipeProcessElementText");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessElementText == null ) {
                        toRecipeProcessElementText = Lists.newArrayList();
                    } else {
                        toRecipeProcessElementText = Lists.newArrayList(toRecipeProcessElementText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessElementText entity;
                        if( toRecipeProcessElementText.size() > i ) {
                            entity = toRecipeProcessElementText.get(i);
                        } else {
                            entity = new RecipeProcessElementText();
                            toRecipeProcessElementText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessEquipRqmt") ) {
                final Object value = (values).remove("to_RecipeProcessEquipRqmt");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessEquipRqmt == null ) {
                        toRecipeProcessEquipRqmt = Lists.newArrayList();
                    } else {
                        toRecipeProcessEquipRqmt = Lists.newArrayList(toRecipeProcessEquipRqmt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessEquipRqmt entity;
                        if( toRecipeProcessEquipRqmt.size() > i ) {
                            entity = toRecipeProcessEquipRqmt.get(i);
                        } else {
                            entity = new RecipeProcessEquipRqmt();
                            toRecipeProcessEquipRqmt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessParamValue") ) {
                final Object value = (values).remove("to_RecipeProcessParamValue");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessParamValue == null ) {
                        toRecipeProcessParamValue = Lists.newArrayList();
                    } else {
                        toRecipeProcessParamValue = Lists.newArrayList(toRecipeProcessParamValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessParamValue entity;
                        if( toRecipeProcessParamValue.size() > i ) {
                            entity = toRecipeProcessParamValue.get(i);
                        } else {
                            entity = new RecipeProcessParamValue();
                            toRecipeProcessParamValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeProcessElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipe != null ) {
            (values).put("to_Recipe", toRecipe);
        }
        if( toFormulaItem != null ) {
            (values).put("to_FormulaItem", toFormulaItem);
        }
        if( toRecipeProcessElementChild != null ) {
            (values).put("to_RecipeProcessElementChild", toRecipeProcessElementChild);
        }
        if( toRecipeProcessElementParent != null ) {
            (values).put("to_RecipeProcessElementParent", toRecipeProcessElementParent);
        }
        if( toRecipeProcessElementText != null ) {
            (values).put("to_RecipeProcessElementText", toRecipeProcessElementText);
        }
        if( toRecipeProcessEquipRqmt != null ) {
            (values).put("to_RecipeProcessEquipRqmt", toRecipeProcessEquipRqmt);
        }
        if( toRecipeProcessParamValue != null ) {
            (values).put("to_RecipeProcessParamValue", toRecipeProcessParamValue);
        }
        return values;
    }

    /**
     * Fetches the <b>Recipe</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Recipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Recipe</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe fetchRecipe()
    {
        return fetchFieldAsSingle("to_Recipe", Recipe.class);
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property <b>to_Recipe</b> of a queried <b>RecipeProcessElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Recipe</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe getRecipeOrFetch()
    {
        if( toRecipe == null ) {
            toRecipe = fetchRecipe();
        }
        return toRecipe;
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Recipe</b> is already loaded, the result will contain
     *         the <b>Recipe</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Recipe> getRecipeIfPresent()
    {
        return Option.of(toRecipe);
    }

    /**
     * Overwrites the associated <b>Recipe</b> entity for the loaded navigation property <b>to_Recipe</b>.
     *
     * @param value
     *            New <b>Recipe</b> entity.
     */
    public void setRecipe( final Recipe value )
    {
        toRecipe = value;
    }

    /**
     * Fetches the <b>RecipeFormulaItem</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_FormulaItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeFormulaItem</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeFormulaItem> fetchFormulaItem()
    {
        return fetchFieldAsList("to_FormulaItem", RecipeFormulaItem.class);
    }

    /**
     * Retrieval of associated <b>RecipeFormulaItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>RecipeProcessElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeFormulaItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeFormulaItem> getFormulaItemOrFetch()
    {
        if( toFormulaItem == null ) {
            toFormulaItem = fetchFormulaItem();
        }
        return toFormulaItem;
    }

    /**
     * Retrieval of associated <b>RecipeFormulaItem</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_FormulaItem</b> is already loaded, the result will
     *         contain the <b>RecipeFormulaItem</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeFormulaItem>> getFormulaItemIfPresent()
    {
        return Option.of(toFormulaItem);
    }

    /**
     * Overwrites the list of associated <b>RecipeFormulaItem</b> entities for the loaded navigation property
     * <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>RecipeProcessElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeFormulaItem</b> entities.
     */
    public void setFormulaItem( @Nonnull final List<RecipeFormulaItem> value )
    {
        if( toFormulaItem == null ) {
            toFormulaItem = Lists.newArrayList();
        }
        toFormulaItem.clear();
        toFormulaItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeFormulaItem</b> entities. This corresponds to the OData
     * navigation property <b>to_FormulaItem</b>.
     * <p>
     * If the navigation property <b>to_FormulaItem</b> of a queried <b>RecipeProcessElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeFormulaItem</b> entities.
     */
    public void addFormulaItem( RecipeFormulaItem... entity )
    {
        if( toFormulaItem == null ) {
            toFormulaItem = Lists.newArrayList();
        }
        toFormulaItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessElementChild</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessElement</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElement> fetchRecipeProcessElementChild()
    {
        return fetchFieldAsList("to_RecipeProcessElementChild", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementChild</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementChild</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElement> getRecipeProcessElementChildOrFetch()
    {
        if( toRecipeProcessElementChild == null ) {
            toRecipeProcessElementChild = fetchRecipeProcessElementChild();
        }
        return toRecipeProcessElementChild;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementChild</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElementChild</b> is already loaded, the
     *         result will contain the <b>RecipeProcessElement</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessElement>> getRecipeProcessElementChildIfPresent()
    {
        return Option.of(toRecipeProcessElementChild);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessElement</b> entities for the loaded navigation property
     * <b>to_RecipeProcessElementChild</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementChild</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessElement</b> entities.
     */
    public void setRecipeProcessElementChild( @Nonnull final List<RecipeProcessElement> value )
    {
        if( toRecipeProcessElementChild == null ) {
            toRecipeProcessElementChild = Lists.newArrayList();
        }
        toRecipeProcessElementChild.clear();
        toRecipeProcessElementChild.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessElement</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementChild</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementChild</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessElement</b> entities.
     */
    public void addRecipeProcessElementChild( RecipeProcessElement... entity )
    {
        if( toRecipeProcessElementChild == null ) {
            toRecipeProcessElementChild = Lists.newArrayList();
        }
        toRecipeProcessElementChild.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RecipeProcessElementParent</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessElement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement fetchRecipeProcessElementParent()
    {
        return fetchFieldAsSingle("to_RecipeProcessElementParent", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElementParent</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementParent</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement getRecipeProcessElementParentOrFetch()
    {
        if( toRecipeProcessElementParent == null ) {
            toRecipeProcessElementParent = fetchRecipeProcessElementParent();
        }
        return toRecipeProcessElementParent;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElementParent</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElementParent</b> is already loaded, the
     *         result will contain the <b>RecipeProcessElement</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessElement> getRecipeProcessElementParentIfPresent()
    {
        return Option.of(toRecipeProcessElementParent);
    }

    /**
     * Overwrites the associated <b>RecipeProcessElement</b> entity for the loaded navigation property
     * <b>to_RecipeProcessElementParent</b>.
     *
     * @param value
     *            New <b>RecipeProcessElement</b> entity.
     */
    public void setRecipeProcessElementParent( final RecipeProcessElement value )
    {
        toRecipeProcessElementParent = value;
    }

    /**
     * Fetches the <b>RecipeProcessElementText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RecipeProcessElementText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessElementText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElementText> fetchRecipeProcessElementText()
    {
        return fetchFieldAsList("to_RecipeProcessElementText", RecipeProcessElementText.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElementText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementText</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElementText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessElementText> getRecipeProcessElementTextOrFetch()
    {
        if( toRecipeProcessElementText == null ) {
            toRecipeProcessElementText = fetchRecipeProcessElementText();
        }
        return toRecipeProcessElementText;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElementText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementText</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElementText</b> is already loaded, the
     *         result will contain the <b>RecipeProcessElementText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessElementText>> getRecipeProcessElementTextIfPresent()
    {
        return Option.of(toRecipeProcessElementText);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessElementText</b> entities for the loaded navigation property
     * <b>to_RecipeProcessElementText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementText</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessElementText</b> entities.
     */
    public void setRecipeProcessElementText( @Nonnull final List<RecipeProcessElementText> value )
    {
        if( toRecipeProcessElementText == null ) {
            toRecipeProcessElementText = Lists.newArrayList();
        }
        toRecipeProcessElementText.clear();
        toRecipeProcessElementText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessElementText</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessElementText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElementText</b> of a queried <b>RecipeProcessElement</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessElementText</b> entities.
     */
    public void addRecipeProcessElementText( RecipeProcessElementText... entity )
    {
        if( toRecipeProcessElementText == null ) {
            toRecipeProcessElementText = Lists.newArrayList();
        }
        toRecipeProcessElementText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessEquipRqmt</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessEquipRqmt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmt> fetchRecipeProcessEquipRqmt()
    {
        return fetchFieldAsList("to_RecipeProcessEquipRqmt", RecipeProcessEquipRqmt.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessEquipRqmt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmt> getRecipeProcessEquipRqmtOrFetch()
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = fetchRecipeProcessEquipRqmt();
        }
        return toRecipeProcessEquipRqmt;
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessEquipRqmt</b> is already loaded, the result
     *         will contain the <b>RecipeProcessEquipRqmt</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessEquipRqmt>> getRecipeProcessEquipRqmtIfPresent()
    {
        return Option.of(toRecipeProcessEquipRqmt);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessEquipRqmt</b> entities for the loaded navigation property
     * <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessEquipRqmt</b> entities.
     */
    public void setRecipeProcessEquipRqmt( @Nonnull final List<RecipeProcessEquipRqmt> value )
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmt.clear();
        toRecipeProcessEquipRqmt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessEquipRqmt</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessEquipRqmt</b> entities.
     */
    public void addRecipeProcessEquipRqmt( RecipeProcessEquipRqmt... entity )
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessParamValue</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessParamValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> fetchRecipeProcessParamValue()
    {
        return fetchFieldAsList("to_RecipeProcessParamValue", RecipeProcessParamValue.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> getRecipeProcessParamValueOrFetch()
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = fetchRecipeProcessParamValue();
        }
        return toRecipeProcessParamValue;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessElement</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamValue</b> is already loaded, the
     *         result will contain the <b>RecipeProcessParamValue</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessParamValue>> getRecipeProcessParamValueIfPresent()
    {
        return Option.of(toRecipeProcessParamValue);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessParamValue</b> entities for the loaded navigation property
     * <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessParamValue</b> entities.
     */
    public void setRecipeProcessParamValue( @Nonnull final List<RecipeProcessParamValue> value )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.clear();
        toRecipeProcessParamValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessParamValue</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessElement</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessParamValue</b> entities.
     */
    public void addRecipeProcessParamValue( RecipeProcessParamValue... entity )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecipeProcessElement instances.
     *
     */
    public final static class RecipeProcessElementBuilder
    {

        private Recipe toRecipe;
        private String recipe = null;
        private List<RecipeFormulaItem> toFormulaItem = Lists.newArrayList();
        private List<RecipeProcessElement> toRecipeProcessElementChild = Lists.newArrayList();
        private RecipeProcessElement toRecipeProcessElementParent;
        private List<RecipeProcessElementText> toRecipeProcessElementText = Lists.newArrayList();
        private List<RecipeProcessEquipRqmt> toRecipeProcessEquipRqmt = Lists.newArrayList();
        private List<RecipeProcessParamValue> toRecipeProcessParamValue = Lists.newArrayList();

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipe( final Recipe value )
        {
            toRecipe = value;
            return this;
        }

        /**
         * Navigation property <b>to_Recipe</b> for <b>RecipeProcessElement</b> to single <b>Recipe</b>.
         *
         * @param value
         *            The Recipe to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipe( final Recipe value )
        {
            return toRecipe(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 20
         * <p>
         * Original property name from the Odata EDM: <b>Recipe</b>
         * </p>
         *
         * @param value
         *            The recipe to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipe( final String value )
        {
            recipe = value;
            return this;
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toFormulaItem( final List<RecipeFormulaItem> value )
        {
            toFormulaItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_FormulaItem</b> for <b>RecipeProcessElement</b> to multiple
         * <b>RecipeFormulaItem</b>.
         *
         * @param value
         *            The RecipeFormulaItems to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder formulaItem( RecipeFormulaItem... value )
        {
            return toFormulaItem(Lists.newArrayList(value));
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipeProcessElementChild(
            final List<RecipeProcessElement> value )
        {
            toRecipeProcessElementChild.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElementChild</b> for <b>RecipeProcessElement</b> to multiple
         * <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElements to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipeProcessElementChild(
            RecipeProcessElement... value )
        {
            return toRecipeProcessElementChild(Lists.newArrayList(value));
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipeProcessElementParent(
            final RecipeProcessElement value )
        {
            toRecipeProcessElementParent = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElementParent</b> for <b>RecipeProcessElement</b> to single
         * <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElement to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipeProcessElementParent(
            final RecipeProcessElement value )
        {
            return toRecipeProcessElementParent(value);
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipeProcessElementText(
            final List<RecipeProcessElementText> value )
        {
            toRecipeProcessElementText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElementText</b> for <b>RecipeProcessElement</b> to multiple
         * <b>RecipeProcessElementText</b>.
         *
         * @param value
         *            The RecipeProcessElementTexts to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipeProcessElementText(
            RecipeProcessElementText... value )
        {
            return toRecipeProcessElementText(Lists.newArrayList(value));
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipeProcessEquipRqmt(
            final List<RecipeProcessEquipRqmt> value )
        {
            toRecipeProcessEquipRqmt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>RecipeProcessElement</b> to multiple
         * <b>RecipeProcessEquipRqmt</b>.
         *
         * @param value
         *            The RecipeProcessEquipRqmts to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipeProcessEquipRqmt(
            RecipeProcessEquipRqmt... value )
        {
            return toRecipeProcessEquipRqmt(Lists.newArrayList(value));
        }

        private RecipeProcessElement.RecipeProcessElementBuilder toRecipeProcessParamValue(
            final List<RecipeProcessParamValue> value )
        {
            toRecipeProcessParamValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessElement</b> to multiple
         * <b>RecipeProcessParamValue</b>.
         *
         * @param value
         *            The RecipeProcessParamValues to build this RecipeProcessElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessElement.RecipeProcessElementBuilder recipeProcessParamValue(
            RecipeProcessParamValue... value )
        {
            return toRecipeProcessParamValue(Lists.newArrayList(value));
        }

    }

}
