/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessEquipRqmtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessEquipRqmtLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessEquipRqmtOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessEquipRqmtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Equipment Requirements
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessEquipRqmtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessEquipRqmt extends VdmEntity<RecipeProcessEquipRqmt>
{

    /**
     * Selector for all available fields of RecipeProcessEquipRqmt.
     *
     */
    public final static RecipeProcessEquipRqmtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<Boolean> DELETE_MC =
        new RecipeProcessEquipRqmtField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<Boolean> UPDATE_MC =
        new RecipeProcessEquipRqmtField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @return Equipment Requirement GUID
     */
    @Key
    @SerializedName( "RecipeProcessEquipRqmtUUID" )
    @JsonProperty( "RecipeProcessEquipRqmtUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtUUID" )
    private UUID recipeProcessEquipRqmtUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<UUID> RECIPE_PROCESS_EQUIP_RQMT_UUID =
        new RecipeProcessEquipRqmtField<UUID>("RecipeProcessEquipRqmtUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @return Process GUID
     */
    @SerializedName( "RecipeProcessUUID" )
    @JsonProperty( "RecipeProcessUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessUUID" )
    private UUID recipeProcessUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<UUID> RECIPE_PROCESS_UUID =
        new RecipeProcessEquipRqmtField<UUID>("RecipeProcessUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @return Process Element GUID
     */
    @SerializedName( "RecipeProcessElementUUID" )
    @JsonProperty( "RecipeProcessElementUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementUUID" )
    private UUID recipeProcessElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<UUID> RECIPE_PROCESS_ELEMENT_UUID =
        new RecipeProcessEquipRqmtField<UUID>("RecipeProcessElementUUID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "RecipeProcessEquipRqmtPosNmbr" )
    @JsonProperty( "RecipeProcessEquipRqmtPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtPosNmbr" )
    private String recipeProcessEquipRqmtPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE_PROCESS_EQUIP_RQMT_POS_NMBR =
        new RecipeProcessEquipRqmtField<String>("RecipeProcessEquipRqmtPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcEquipRqmtIsPrimRsce</b>
     * </p>
     *
     * @return Primary Resource
     */
    @SerializedName( "RecipeProcEquipRqmtIsPrimRsce" )
    @JsonProperty( "RecipeProcEquipRqmtIsPrimRsce" )
    @Nullable
    @ODataField( odataName = "RecipeProcEquipRqmtIsPrimRsce" )
    private String recipeProcEquipRqmtIsPrimRsce;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcEquipRqmtIsPrimRsce</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE_PROC_EQUIP_RQMT_IS_PRIM_RSCE =
        new RecipeProcessEquipRqmtField<String>("RecipeProcEquipRqmtIsPrimRsce");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeProcessEquipRqmtField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<UUID> RECIPE_UUID =
        new RecipeProcessEquipRqmtField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE = new RecipeProcessEquipRqmtField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessStagePosNmbr" )
    @JsonProperty( "RecipeProcessStagePosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStagePosNmbr" )
    private String recipeProcessStagePosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStagePosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE_PROCESS_STAGE_POS_NMBR =
        new RecipeProcessEquipRqmtField<String>("RecipeProcessStagePosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessOperationPosNmbr" )
    @JsonProperty( "RecipeProcessOperationPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationPosNmbr" )
    private String recipeProcessOperationPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE_PROCESS_OPERATION_POS_NMBR =
        new RecipeProcessEquipRqmtField<String>("RecipeProcessOperationPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessActionPosNmbr" )
    @JsonProperty( "RecipeProcessActionPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionPosNmbr" )
    private String recipeProcessActionPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtField<String> RECIPE_PROCESS_ACTION_POS_NMBR =
        new RecipeProcessEquipRqmtField<String>("RecipeProcessActionPosNmbr");
    /**
     * Navigation property <b>to_Recipe</b> for <b>RecipeProcessEquipRqmt</b> to single <b>Recipe</b>.
     *
     */
    @SerializedName( "to_Recipe" )
    @JsonProperty( "to_Recipe" )
    @ODataField( odataName = "to_Recipe" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Recipe toRecipe;
    /**
     * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeProcessEquipRqmt</b> to single
     * <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElement" )
    @JsonProperty( "to_RecipeProcessElement" )
    @ODataField( odataName = "to_RecipeProcessElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessElement toRecipeProcessElement;
    /**
     * Navigation property <b>to_RecipeProcessEquipRqmtText</b> for <b>RecipeProcessEquipRqmt</b> to multiple
     * <b>RecipeProcessEquipRqmtText</b>.
     *
     */
    @SerializedName( "to_RecipeProcessEquipRqmtText" )
    @JsonProperty( "to_RecipeProcessEquipRqmtText" )
    @ODataField( odataName = "to_RecipeProcessEquipRqmtText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessEquipRqmtText> toRecipeProcessEquipRqmtText;
    /**
     * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessEquipRqmt</b> to multiple
     * <b>RecipeProcessParamValue</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamValue" )
    @JsonProperty( "to_RecipeProcessParamValue" )
    @ODataField( odataName = "to_RecipeProcessParamValue" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessParamValue> toRecipeProcessParamValue;
    /**
     * Navigation property <b>to_RecProcEquipRqmtCharc</b> for <b>RecipeProcessEquipRqmt</b> to multiple
     * <b>RecProcEquipRqmtCharc</b>.
     *
     */
    @SerializedName( "to_RecProcEquipRqmtCharc" )
    @JsonProperty( "to_RecProcEquipRqmtCharc" )
    @ODataField( odataName = "to_RecProcEquipRqmtCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcEquipRqmtCharc> toRecProcEquipRqmtCharc;
    /**
     * Navigation property <b>to_RecProcEquipRqmtClass</b> for <b>RecipeProcessEquipRqmt</b> to multiple
     * <b>RecProcEquipRqmtClass</b>.
     *
     */
    @SerializedName( "to_RecProcEquipRqmtClass" )
    @JsonProperty( "to_RecProcEquipRqmtClass" )
    @ODataField( odataName = "to_RecProcEquipRqmtClass" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcEquipRqmtClass> toRecProcEquipRqmtClass;
    /**
     * Use with available fluent helpers to apply the <b>to_Recipe</b> navigation property to query operations.
     *
     */
    public final static RecipeProcessEquipRqmtOneToOneLink<Recipe> TO_RECIPE =
        new RecipeProcessEquipRqmtOneToOneLink<Recipe>("to_Recipe");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElement</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessEquipRqmtOneToOneLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT =
        new RecipeProcessEquipRqmtOneToOneLink<RecipeProcessElement>("to_RecipeProcessElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessEquipRqmtText</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessEquipRqmtLink<RecipeProcessEquipRqmtText> TO_RECIPE_PROCESS_EQUIP_RQMT_TEXT =
        new RecipeProcessEquipRqmtLink<RecipeProcessEquipRqmtText>("to_RecipeProcessEquipRqmtText");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamValue</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessEquipRqmtLink<RecipeProcessParamValue> TO_RECIPE_PROCESS_PARAM_VALUE =
        new RecipeProcessEquipRqmtLink<RecipeProcessParamValue>("to_RecipeProcessParamValue");
    /**
     * Use with available fluent helpers to apply the <b>to_RecProcEquipRqmtCharc</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessEquipRqmtLink<RecProcEquipRqmtCharc> TO_REC_PROC_EQUIP_RQMT_CHARC =
        new RecipeProcessEquipRqmtLink<RecProcEquipRqmtCharc>("to_RecProcEquipRqmtCharc");
    /**
     * Use with available fluent helpers to apply the <b>to_RecProcEquipRqmtClass</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessEquipRqmtLink<RecProcEquipRqmtClass> TO_REC_PROC_EQUIP_RQMT_CLASS =
        new RecipeProcessEquipRqmtLink<RecProcEquipRqmtClass>("to_RecProcEquipRqmtClass");

    @Nonnull
    @Override
    public Class<RecipeProcessEquipRqmt> getType()
    {
        return RecipeProcessEquipRqmt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     */
    public void setRecipeProcessEquipRqmtUUID( @Nullable final UUID recipeProcessEquipRqmtUUID )
    {
        rememberChangedField("RecipeProcessEquipRqmtUUID", this.recipeProcessEquipRqmtUUID);
        this.recipeProcessEquipRqmtUUID = recipeProcessEquipRqmtUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @param recipeProcessUUID
     *            Process GUID
     */
    public void setRecipeProcessUUID( @Nullable final UUID recipeProcessUUID )
    {
        rememberChangedField("RecipeProcessUUID", this.recipeProcessUUID);
        this.recipeProcessUUID = recipeProcessUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     */
    public void setRecipeProcessElementUUID( @Nullable final UUID recipeProcessElementUUID )
    {
        rememberChangedField("RecipeProcessElementUUID", this.recipeProcessElementUUID);
        this.recipeProcessElementUUID = recipeProcessElementUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtPosNmbr
     *            Sequence Number
     */
    public void setRecipeProcessEquipRqmtPosNmbr( @Nullable final String recipeProcessEquipRqmtPosNmbr )
    {
        rememberChangedField("RecipeProcessEquipRqmtPosNmbr", this.recipeProcessEquipRqmtPosNmbr);
        this.recipeProcessEquipRqmtPosNmbr = recipeProcessEquipRqmtPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcEquipRqmtIsPrimRsce</b>
     * </p>
     *
     * @param recipeProcEquipRqmtIsPrimRsce
     *            Primary Resource
     */
    public void setRecipeProcEquipRqmtIsPrimRsce( @Nullable final String recipeProcEquipRqmtIsPrimRsce )
    {
        rememberChangedField("RecipeProcEquipRqmtIsPrimRsce", this.recipeProcEquipRqmtIsPrimRsce);
        this.recipeProcEquipRqmtIsPrimRsce = recipeProcEquipRqmtIsPrimRsce;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @param recipeProcessStagePosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessStagePosNmbr( @Nullable final String recipeProcessStagePosNmbr )
    {
        rememberChangedField("RecipeProcessStagePosNmbr", this.recipeProcessStagePosNmbr);
        this.recipeProcessStagePosNmbr = recipeProcessStagePosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @param recipeProcessOperationPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessOperationPosNmbr( @Nullable final String recipeProcessOperationPosNmbr )
    {
        rememberChangedField("RecipeProcessOperationPosNmbr", this.recipeProcessOperationPosNmbr);
        this.recipeProcessOperationPosNmbr = recipeProcessOperationPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @param recipeProcessActionPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessActionPosNmbr( @Nullable final String recipeProcessActionPosNmbr )
    {
        rememberChangedField("RecipeProcessActionPosNmbr", this.recipeProcessActionPosNmbr);
        this.recipeProcessActionPosNmbr = recipeProcessActionPosNmbr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessEquipRqmt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessEquipRqmtUUID", getRecipeProcessEquipRqmtUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RecipeProcessEquipRqmtUUID", getRecipeProcessEquipRqmtUUID());
        values.put("RecipeProcessUUID", getRecipeProcessUUID());
        values.put("RecipeProcessElementUUID", getRecipeProcessElementUUID());
        values.put("RecipeProcessEquipRqmtPosNmbr", getRecipeProcessEquipRqmtPosNmbr());
        values.put("RecipeProcEquipRqmtIsPrimRsce", getRecipeProcEquipRqmtIsPrimRsce());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("Recipe", getRecipe());
        values.put("RecipeProcessStagePosNmbr", getRecipeProcessStagePosNmbr());
        values.put("RecipeProcessOperationPosNmbr", getRecipeProcessOperationPosNmbr());
        values.put("RecipeProcessActionPosNmbr", getRecipeProcessActionPosNmbr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessEquipRqmtUUID") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtUUID");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtUUID())) ) {
                    setRecipeProcessEquipRqmtUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessUUID") ) {
                final Object value = values.remove("RecipeProcessUUID");
                if( (value == null) || (!value.equals(getRecipeProcessUUID())) ) {
                    setRecipeProcessUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessElementUUID") ) {
                final Object value = values.remove("RecipeProcessElementUUID");
                if( (value == null) || (!value.equals(getRecipeProcessElementUUID())) ) {
                    setRecipeProcessElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessEquipRqmtPosNmbr") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtPosNmbr())) ) {
                    setRecipeProcessEquipRqmtPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcEquipRqmtIsPrimRsce") ) {
                final Object value = values.remove("RecipeProcEquipRqmtIsPrimRsce");
                if( (value == null) || (!value.equals(getRecipeProcEquipRqmtIsPrimRsce())) ) {
                    setRecipeProcEquipRqmtIsPrimRsce(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessStagePosNmbr") ) {
                final Object value = values.remove("RecipeProcessStagePosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessStagePosNmbr())) ) {
                    setRecipeProcessStagePosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationPosNmbr") ) {
                final Object value = values.remove("RecipeProcessOperationPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessOperationPosNmbr())) ) {
                    setRecipeProcessOperationPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessActionPosNmbr") ) {
                final Object value = values.remove("RecipeProcessActionPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessActionPosNmbr())) ) {
                    setRecipeProcessActionPosNmbr(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Recipe") ) {
                final Object value = (values).remove("to_Recipe");
                if( value instanceof Map ) {
                    if( toRecipe == null ) {
                        toRecipe = new Recipe();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipe.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessElement") ) {
                final Object value = (values).remove("to_RecipeProcessElement");
                if( value instanceof Map ) {
                    if( toRecipeProcessElement == null ) {
                        toRecipeProcessElement = new RecipeProcessElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessEquipRqmtText") ) {
                final Object value = (values).remove("to_RecipeProcessEquipRqmtText");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessEquipRqmtText == null ) {
                        toRecipeProcessEquipRqmtText = Lists.newArrayList();
                    } else {
                        toRecipeProcessEquipRqmtText = Lists.newArrayList(toRecipeProcessEquipRqmtText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessEquipRqmtText entity;
                        if( toRecipeProcessEquipRqmtText.size() > i ) {
                            entity = toRecipeProcessEquipRqmtText.get(i);
                        } else {
                            entity = new RecipeProcessEquipRqmtText();
                            toRecipeProcessEquipRqmtText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecipeProcessParamValue") ) {
                final Object value = (values).remove("to_RecipeProcessParamValue");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessParamValue == null ) {
                        toRecipeProcessParamValue = Lists.newArrayList();
                    } else {
                        toRecipeProcessParamValue = Lists.newArrayList(toRecipeProcessParamValue);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessParamValue entity;
                        if( toRecipeProcessParamValue.size() > i ) {
                            entity = toRecipeProcessParamValue.get(i);
                        } else {
                            entity = new RecipeProcessParamValue();
                            toRecipeProcessParamValue.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecProcEquipRqmtCharc") ) {
                final Object value = (values).remove("to_RecProcEquipRqmtCharc");
                if( value instanceof Iterable ) {
                    if( toRecProcEquipRqmtCharc == null ) {
                        toRecProcEquipRqmtCharc = Lists.newArrayList();
                    } else {
                        toRecProcEquipRqmtCharc = Lists.newArrayList(toRecProcEquipRqmtCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcEquipRqmtCharc entity;
                        if( toRecProcEquipRqmtCharc.size() > i ) {
                            entity = toRecProcEquipRqmtCharc.get(i);
                        } else {
                            entity = new RecProcEquipRqmtCharc();
                            toRecProcEquipRqmtCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecProcEquipRqmtClass") ) {
                final Object value = (values).remove("to_RecProcEquipRqmtClass");
                if( value instanceof Iterable ) {
                    if( toRecProcEquipRqmtClass == null ) {
                        toRecProcEquipRqmtClass = Lists.newArrayList();
                    } else {
                        toRecProcEquipRqmtClass = Lists.newArrayList(toRecProcEquipRqmtClass);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcEquipRqmtClass entity;
                        if( toRecProcEquipRqmtClass.size() > i ) {
                            entity = toRecProcEquipRqmtClass.get(i);
                        } else {
                            entity = new RecProcEquipRqmtClass();
                            toRecProcEquipRqmtClass.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeProcessEquipRqmtField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessEquipRqmtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessEquipRqmtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessEquipRqmtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipe != null ) {
            (values).put("to_Recipe", toRecipe);
        }
        if( toRecipeProcessElement != null ) {
            (values).put("to_RecipeProcessElement", toRecipeProcessElement);
        }
        if( toRecipeProcessEquipRqmtText != null ) {
            (values).put("to_RecipeProcessEquipRqmtText", toRecipeProcessEquipRqmtText);
        }
        if( toRecipeProcessParamValue != null ) {
            (values).put("to_RecipeProcessParamValue", toRecipeProcessParamValue);
        }
        if( toRecProcEquipRqmtCharc != null ) {
            (values).put("to_RecProcEquipRqmtCharc", toRecProcEquipRqmtCharc);
        }
        if( toRecProcEquipRqmtClass != null ) {
            (values).put("to_RecProcEquipRqmtClass", toRecProcEquipRqmtClass);
        }
        return values;
    }

    /**
     * Fetches the <b>Recipe</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Recipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Recipe</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe fetchRecipe()
    {
        return fetchFieldAsSingle("to_Recipe", Recipe.class);
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property <b>to_Recipe</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Recipe</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe getRecipeOrFetch()
    {
        if( toRecipe == null ) {
            toRecipe = fetchRecipe();
        }
        return toRecipe;
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Recipe</b> is already loaded, the result will contain
     *         the <b>Recipe</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Recipe> getRecipeIfPresent()
    {
        return Option.of(toRecipe);
    }

    /**
     * Overwrites the associated <b>Recipe</b> entity for the loaded navigation property <b>to_Recipe</b>.
     *
     * @param value
     *            New <b>Recipe</b> entity.
     */
    public void setRecipe( final Recipe value )
    {
        toRecipe = value;
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessElement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement fetchRecipeProcessElement()
    {
        return fetchFieldAsSingle("to_RecipeProcessElement", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement getRecipeProcessElementOrFetch()
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = fetchRecipeProcessElement();
        }
        return toRecipeProcessElement;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElement</b> is already loaded, the result
     *         will contain the <b>RecipeProcessElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessElement> getRecipeProcessElementIfPresent()
    {
        return Option.of(toRecipeProcessElement);
    }

    /**
     * Overwrites the associated <b>RecipeProcessElement</b> entity for the loaded navigation property
     * <b>to_RecipeProcessElement</b>.
     *
     * @param value
     *            New <b>RecipeProcessElement</b> entity.
     */
    public void setRecipeProcessElement( final RecipeProcessElement value )
    {
        toRecipeProcessElement = value;
    }

    /**
     * Fetches the <b>RecipeProcessEquipRqmtText</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RecipeProcessEquipRqmtText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessEquipRqmtText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmtText> fetchRecipeProcessEquipRqmtText()
    {
        return fetchFieldAsList("to_RecipeProcessEquipRqmtText", RecipeProcessEquipRqmtText.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmtText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmtText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmtText</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessEquipRqmtText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessEquipRqmtText> getRecipeProcessEquipRqmtTextOrFetch()
    {
        if( toRecipeProcessEquipRqmtText == null ) {
            toRecipeProcessEquipRqmtText = fetchRecipeProcessEquipRqmtText();
        }
        return toRecipeProcessEquipRqmtText;
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmtText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmtText</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessEquipRqmtText</b> is already loaded, the
     *         result will contain the <b>RecipeProcessEquipRqmtText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessEquipRqmtText>> getRecipeProcessEquipRqmtTextIfPresent()
    {
        return Option.of(toRecipeProcessEquipRqmtText);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessEquipRqmtText</b> entities for the loaded navigation property
     * <b>to_RecipeProcessEquipRqmtText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmtText</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessEquipRqmtText</b> entities.
     */
    public void setRecipeProcessEquipRqmtText( @Nonnull final List<RecipeProcessEquipRqmtText> value )
    {
        if( toRecipeProcessEquipRqmtText == null ) {
            toRecipeProcessEquipRqmtText = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmtText.clear();
        toRecipeProcessEquipRqmtText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessEquipRqmtText</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmtText</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmtText</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessEquipRqmtText</b> entities.
     */
    public void addRecipeProcessEquipRqmtText( RecipeProcessEquipRqmtText... entity )
    {
        if( toRecipeProcessEquipRqmtText == null ) {
            toRecipeProcessEquipRqmtText = Lists.newArrayList();
        }
        toRecipeProcessEquipRqmtText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecipeProcessParamValue</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessParamValue</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> fetchRecipeProcessParamValue()
    {
        return fetchFieldAsList("to_RecipeProcessParamValue", RecipeProcessParamValue.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamValue</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValue> getRecipeProcessParamValueOrFetch()
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = fetchRecipeProcessParamValue();
        }
        return toRecipeProcessParamValue;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamValue</b> is already loaded, the
     *         result will contain the <b>RecipeProcessParamValue</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessParamValue>> getRecipeProcessParamValueIfPresent()
    {
        return Option.of(toRecipeProcessParamValue);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessParamValue</b> entities for the loaded navigation property
     * <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessParamValue</b> entities.
     */
    public void setRecipeProcessParamValue( @Nonnull final List<RecipeProcessParamValue> value )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.clear();
        toRecipeProcessParamValue.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessParamValue</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessEquipRqmt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessParamValue</b> entities.
     */
    public void addRecipeProcessParamValue( RecipeProcessParamValue... entity )
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = Lists.newArrayList();
        }
        toRecipeProcessParamValue.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecProcEquipRqmtCharc</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecProcEquipRqmtCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcEquipRqmtCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtCharc> fetchRecProcEquipRqmtCharc()
    {
        return fetchFieldAsList("to_RecProcEquipRqmtCharc", RecProcEquipRqmtCharc.class);
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtCharc</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcEquipRqmtCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtCharc> getRecProcEquipRqmtCharcOrFetch()
    {
        if( toRecProcEquipRqmtCharc == null ) {
            toRecProcEquipRqmtCharc = fetchRecProcEquipRqmtCharc();
        }
        return toRecProcEquipRqmtCharc;
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtCharc</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecProcEquipRqmtCharc</b> is already loaded, the result
     *         will contain the <b>RecProcEquipRqmtCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcEquipRqmtCharc>> getRecProcEquipRqmtCharcIfPresent()
    {
        return Option.of(toRecProcEquipRqmtCharc);
    }

    /**
     * Overwrites the list of associated <b>RecProcEquipRqmtCharc</b> entities for the loaded navigation property
     * <b>to_RecProcEquipRqmtCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtCharc</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcEquipRqmtCharc</b> entities.
     */
    public void setRecProcEquipRqmtCharc( @Nonnull final List<RecProcEquipRqmtCharc> value )
    {
        if( toRecProcEquipRqmtCharc == null ) {
            toRecProcEquipRqmtCharc = Lists.newArrayList();
        }
        toRecProcEquipRqmtCharc.clear();
        toRecProcEquipRqmtCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcEquipRqmtCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtCharc</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcEquipRqmtCharc</b> entities.
     */
    public void addRecProcEquipRqmtCharc( RecProcEquipRqmtCharc... entity )
    {
        if( toRecProcEquipRqmtCharc == null ) {
            toRecProcEquipRqmtCharc = Lists.newArrayList();
        }
        toRecProcEquipRqmtCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecProcEquipRqmtClass</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecProcEquipRqmtClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcEquipRqmtClass</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtClass> fetchRecProcEquipRqmtClass()
    {
        return fetchFieldAsList("to_RecProcEquipRqmtClass", RecProcEquipRqmtClass.class);
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtClass</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcEquipRqmtClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcEquipRqmtClass> getRecProcEquipRqmtClassOrFetch()
    {
        if( toRecProcEquipRqmtClass == null ) {
            toRecProcEquipRqmtClass = fetchRecProcEquipRqmtClass();
        }
        return toRecProcEquipRqmtClass;
    }

    /**
     * Retrieval of associated <b>RecProcEquipRqmtClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtClass</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessEquipRqmt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecProcEquipRqmtClass</b> is already loaded, the result
     *         will contain the <b>RecProcEquipRqmtClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcEquipRqmtClass>> getRecProcEquipRqmtClassIfPresent()
    {
        return Option.of(toRecProcEquipRqmtClass);
    }

    /**
     * Overwrites the list of associated <b>RecProcEquipRqmtClass</b> entities for the loaded navigation property
     * <b>to_RecProcEquipRqmtClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtClass</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcEquipRqmtClass</b> entities.
     */
    public void setRecProcEquipRqmtClass( @Nonnull final List<RecProcEquipRqmtClass> value )
    {
        if( toRecProcEquipRqmtClass == null ) {
            toRecProcEquipRqmtClass = Lists.newArrayList();
        }
        toRecProcEquipRqmtClass.clear();
        toRecProcEquipRqmtClass.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcEquipRqmtClass</b> entities. This corresponds to the OData
     * navigation property <b>to_RecProcEquipRqmtClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcEquipRqmtClass</b> of a queried <b>RecipeProcessEquipRqmt</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcEquipRqmtClass</b> entities.
     */
    public void addRecProcEquipRqmtClass( RecProcEquipRqmtClass... entity )
    {
        if( toRecProcEquipRqmtClass == null ) {
            toRecProcEquipRqmtClass = Lists.newArrayList();
        }
        toRecProcEquipRqmtClass.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecipeProcessEquipRqmt instances.
     *
     */
    public final static class RecipeProcessEquipRqmtBuilder
    {

        private Recipe toRecipe;
        private String recipe = null;
        private RecipeProcessElement toRecipeProcessElement;
        private List<RecipeProcessEquipRqmtText> toRecipeProcessEquipRqmtText = Lists.newArrayList();
        private List<RecipeProcessParamValue> toRecipeProcessParamValue = Lists.newArrayList();
        private List<RecProcEquipRqmtCharc> toRecProcEquipRqmtCharc = Lists.newArrayList();
        private List<RecProcEquipRqmtClass> toRecProcEquipRqmtClass = Lists.newArrayList();

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecipe( final Recipe value )
        {
            toRecipe = value;
            return this;
        }

        /**
         * Navigation property <b>to_Recipe</b> for <b>RecipeProcessEquipRqmt</b> to single <b>Recipe</b>.
         *
         * @param value
         *            The Recipe to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recipe( final Recipe value )
        {
            return toRecipe(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 20
         * <p>
         * Original property name from the Odata EDM: <b>Recipe</b>
         * </p>
         *
         * @param value
         *            The recipe to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recipe( final String value )
        {
            recipe = value;
            return this;
        }

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecipeProcessElement(
            final RecipeProcessElement value )
        {
            toRecipeProcessElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeProcessEquipRqmt</b> to single
         * <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElement to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recipeProcessElement(
            final RecipeProcessElement value )
        {
            return toRecipeProcessElement(value);
        }

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecipeProcessEquipRqmtText(
            final List<RecipeProcessEquipRqmtText> value )
        {
            toRecipeProcessEquipRqmtText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessEquipRqmtText</b> for <b>RecipeProcessEquipRqmt</b> to multiple
         * <b>RecipeProcessEquipRqmtText</b>.
         *
         * @param value
         *            The RecipeProcessEquipRqmtTexts to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recipeProcessEquipRqmtText(
            RecipeProcessEquipRqmtText... value )
        {
            return toRecipeProcessEquipRqmtText(Lists.newArrayList(value));
        }

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecipeProcessParamValue(
            final List<RecipeProcessParamValue> value )
        {
            toRecipeProcessParamValue.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessEquipRqmt</b> to multiple
         * <b>RecipeProcessParamValue</b>.
         *
         * @param value
         *            The RecipeProcessParamValues to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recipeProcessParamValue(
            RecipeProcessParamValue... value )
        {
            return toRecipeProcessParamValue(Lists.newArrayList(value));
        }

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecProcEquipRqmtCharc(
            final List<RecProcEquipRqmtCharc> value )
        {
            toRecProcEquipRqmtCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecProcEquipRqmtCharc</b> for <b>RecipeProcessEquipRqmt</b> to multiple
         * <b>RecProcEquipRqmtCharc</b>.
         *
         * @param value
         *            The RecProcEquipRqmtCharcs to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recProcEquipRqmtCharc(
            RecProcEquipRqmtCharc... value )
        {
            return toRecProcEquipRqmtCharc(Lists.newArrayList(value));
        }

        private RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder toRecProcEquipRqmtClass(
            final List<RecProcEquipRqmtClass> value )
        {
            toRecProcEquipRqmtClass.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecProcEquipRqmtClass</b> for <b>RecipeProcessEquipRqmt</b> to multiple
         * <b>RecProcEquipRqmtClass</b>.
         *
         * @param value
         *            The RecProcEquipRqmtClasss to build this RecipeProcessEquipRqmt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessEquipRqmt.RecipeProcessEquipRqmtBuilder recProcEquipRqmtClass(
            RecProcEquipRqmtClass... value )
        {
            return toRecProcEquipRqmtClass(Lists.newArrayList(value));
        }

    }

}
