/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperUpdate;

/**
 * Fluent helper to update an existing
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
 * RecipeProcessEquipRqmtText} entity and save it to the S/4HANA system.
 * <p>
 * To perform execution, call the {@link #executeRequest executeRequest} method on the fluent helper object.
 *
 */
public class RecipeProcessEquipRqmtTextUpdateFluentHelper
    extends
    FluentHelperUpdate<RecipeProcessEquipRqmtTextUpdateFluentHelper, RecipeProcessEquipRqmtText>
{

    /**
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity object that will be updated in the S/4HANA system.
     *
     */
    private final RecipeProcessEquipRqmtText entity;

    /**
     * Creates a fluent helper object that will update a
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity on the OData endpoint. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param servicePath
     *            The service path to direct the update requests to.
     * @param entity
     *            The RecipeProcessEquipRqmtText to take the updated values from.
     */
    public RecipeProcessEquipRqmtTextUpdateFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final RecipeProcessEquipRqmtText entity,
        @Nonnull final String entityCollection )
    {
        super(servicePath, entityCollection);
        this.entity = entity;
    }

    @Override
    @Nonnull
    protected RecipeProcessEquipRqmtText getEntity()
    {
        return entity;
    }

}
