/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessParamSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Process Parameters
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessParamType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessParam extends VdmEntity<RecipeProcessParam>
{

    /**
     * Selector for all available fields of RecipeProcessParam.
     *
     */
    public final static RecipeProcessParamSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @return Process Parameter Master Data Key
     */
    @Key
    @SerializedName( "RecipeProcessParamUUID" )
    @JsonProperty( "RecipeProcessParamUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamUUID" )
    private UUID recipeProcessParamUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<UUID> RECIPE_PROCESS_PARAM_UUID =
        new RecipeProcessParamField<UUID>("RecipeProcessParamUUID");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParam</b>
     * </p>
     *
     * @return Process Parameter Master Data - Legible Name / ID
     */
    @SerializedName( "RecipeProcessParam" )
    @JsonProperty( "RecipeProcessParam" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParam" )
    private String recipeProcessParam;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParam</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM =
        new RecipeProcessParamField<String>("RecipeProcessParam");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "RecipeProcessParamUnit" )
    @JsonProperty( "RecipeProcessParamUnit" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamUnit" )
    private String recipeProcessParamUnit;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUnit</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_UNIT =
        new RecipeProcessParamField<String>("RecipeProcessParamUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnitIsFxd</b>
     * </p>
     *
     * @return Value Must Not Be Changed
     */
    @SerializedName( "RecipeProcessParamUnitIsFxd" )
    @JsonProperty( "RecipeProcessParamUnitIsFxd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamUnitIsFxd" )
    private Boolean recipeProcessParamUnitIsFxd;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUnitIsFxd</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_UNIT_IS_FXD =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamUnitIsFxd");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtVal</b>
     * </p>
     *
     * @return Target Value
     */
    @SerializedName( "RecipeProcessParamTgtVal" )
    @JsonProperty( "RecipeProcessParamTgtVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamTgtVal" )
    private String recipeProcessParamTgtVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamTgtVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_TGT_VAL =
        new RecipeProcessParamField<String>("RecipeProcessParamTgtVal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtValIsFxd</b>
     * </p>
     *
     * @return Value Must Not Be Changed
     */
    @SerializedName( "RecipeProcessParamTgtValIsFxd" )
    @JsonProperty( "RecipeProcessParamTgtValIsFxd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamTgtValIsFxd" )
    private Boolean recipeProcessParamTgtValIsFxd;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamTgtValIsFxd</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_TGT_VAL_IS_FXD =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamTgtValIsFxd");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinVal</b>
     * </p>
     *
     * @return Minimum Value
     */
    @SerializedName( "RecipeProcessParamMinVal" )
    @JsonProperty( "RecipeProcessParamMinVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamMinVal" )
    private String recipeProcessParamMinVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMinVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_MIN_VAL =
        new RecipeProcessParamField<String>("RecipeProcessParamMinVal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinValIsFxd</b>
     * </p>
     *
     * @return Value Must Not Be Changed
     */
    @SerializedName( "RecipeProcessParamMinValIsFxd" )
    @JsonProperty( "RecipeProcessParamMinValIsFxd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamMinValIsFxd" )
    private Boolean recipeProcessParamMinValIsFxd;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMinValIsFxd</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_MIN_VAL_IS_FXD =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamMinValIsFxd");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxVal</b>
     * </p>
     *
     * @return Maximum Value
     */
    @SerializedName( "RecipeProcessParamMaxVal" )
    @JsonProperty( "RecipeProcessParamMaxVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamMaxVal" )
    private String recipeProcessParamMaxVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMaxVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_MAX_VAL =
        new RecipeProcessParamField<String>("RecipeProcessParamMaxVal");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxValIsFxd</b>
     * </p>
     *
     * @return Value Must Not Be Changed
     */
    @SerializedName( "RecipeProcessParamMaxValIsFxd" )
    @JsonProperty( "RecipeProcessParamMaxValIsFxd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamMaxValIsFxd" )
    private Boolean recipeProcessParamMaxValIsFxd;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMaxValIsFxd</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_MAX_VAL_IS_FXD =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamMaxValIsFxd");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamDecPlaces</b>
     * </p>
     *
     * @return Decimal Places for Process Parameter Values
     */
    @SerializedName( "RecipeProcessParamDecPlaces" )
    @JsonProperty( "RecipeProcessParamDecPlaces" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamDecPlaces" )
    private String recipeProcessParamDecPlaces;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamDecPlaces</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_DEC_PLACES =
        new RecipeProcessParamField<String>("RecipeProcessParamDecPlaces");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamGroup</b>
     * </p>
     *
     * @return Process Parameter Group ID
     */
    @SerializedName( "RecipeProcessParamGroup" )
    @JsonProperty( "RecipeProcessParamGroup" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamGroup" )
    private String recipeProcessParamGroup;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamGroup</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_GROUP =
        new RecipeProcessParamField<String>("RecipeProcessParamGroup");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamClass</b>
     * </p>
     *
     * @return Class ID for Classification
     */
    @SerializedName( "RecipeProcessParamClass" )
    @JsonProperty( "RecipeProcessParamClass" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamClass" )
    private String recipeProcessParamClass;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamClass</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<String> RECIPE_PROCESS_PARAM_CLASS =
        new RecipeProcessParamField<String>("RecipeProcessParamClass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamIsObsolete</b>
     * </p>
     *
     * @return Obsolete
     */
    @SerializedName( "RecipeProcessParamIsObsolete" )
    @JsonProperty( "RecipeProcessParamIsObsolete" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamIsObsolete" )
    private Boolean recipeProcessParamIsObsolete;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamIsObsolete</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_IS_OBSOLETE =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamIsObsolete");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamIsDeleted</b>
     * </p>
     *
     * @return Process Parameter Deleted
     */
    @SerializedName( "RecipeProcessParamIsDeleted" )
    @JsonProperty( "RecipeProcessParamIsDeleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "RecipeProcessParamIsDeleted" )
    private Boolean recipeProcessParamIsDeleted;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamIsDeleted</b> field to query operations.
     *
     */
    public final static RecipeProcessParamField<Boolean> RECIPE_PROCESS_PARAM_IS_DELETED =
        new RecipeProcessParamField<Boolean>("RecipeProcessParamIsDeleted");
    /**
     * Navigation property <b>to_RecipeProcessParamDesc</b> for <b>RecipeProcessParam</b> to multiple
     * <b>RecipeProcessParamText</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamDesc" )
    @JsonProperty( "to_RecipeProcessParamDesc" )
    @ODataField( odataName = "to_RecipeProcessParamDesc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessParamText> toRecipeProcessParamDesc;
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamDesc</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamLink<RecipeProcessParamText> TO_RECIPE_PROCESS_PARAM_DESC =
        new RecipeProcessParamLink<RecipeProcessParamText>("to_RecipeProcessParamDesc");

    @Nonnull
    @Override
    public Class<RecipeProcessParam> getType()
    {
        return RecipeProcessParam.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @param recipeProcessParamUUID
     *            Process Parameter Master Data Key
     */
    public void setRecipeProcessParamUUID( @Nullable final UUID recipeProcessParamUUID )
    {
        rememberChangedField("RecipeProcessParamUUID", this.recipeProcessParamUUID);
        this.recipeProcessParamUUID = recipeProcessParamUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParam</b>
     * </p>
     *
     * @param recipeProcessParam
     *            Process Parameter Master Data - Legible Name / ID
     */
    public void setRecipeProcessParam( @Nullable final String recipeProcessParam )
    {
        rememberChangedField("RecipeProcessParam", this.recipeProcessParam);
        this.recipeProcessParam = recipeProcessParam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnit</b>
     * </p>
     *
     * @param recipeProcessParamUnit
     *            Unit of Measure
     */
    public void setRecipeProcessParamUnit( @Nullable final String recipeProcessParamUnit )
    {
        rememberChangedField("RecipeProcessParamUnit", this.recipeProcessParamUnit);
        this.recipeProcessParamUnit = recipeProcessParamUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnitIsFxd</b>
     * </p>
     *
     * @param recipeProcessParamUnitIsFxd
     *            Value Must Not Be Changed
     */
    public void setRecipeProcessParamUnitIsFxd( @Nullable final Boolean recipeProcessParamUnitIsFxd )
    {
        rememberChangedField("RecipeProcessParamUnitIsFxd", this.recipeProcessParamUnitIsFxd);
        this.recipeProcessParamUnitIsFxd = recipeProcessParamUnitIsFxd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtVal</b>
     * </p>
     *
     * @param recipeProcessParamTgtVal
     *            Target Value
     */
    public void setRecipeProcessParamTgtVal( @Nullable final String recipeProcessParamTgtVal )
    {
        rememberChangedField("RecipeProcessParamTgtVal", this.recipeProcessParamTgtVal);
        this.recipeProcessParamTgtVal = recipeProcessParamTgtVal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtValIsFxd</b>
     * </p>
     *
     * @param recipeProcessParamTgtValIsFxd
     *            Value Must Not Be Changed
     */
    public void setRecipeProcessParamTgtValIsFxd( @Nullable final Boolean recipeProcessParamTgtValIsFxd )
    {
        rememberChangedField("RecipeProcessParamTgtValIsFxd", this.recipeProcessParamTgtValIsFxd);
        this.recipeProcessParamTgtValIsFxd = recipeProcessParamTgtValIsFxd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinVal</b>
     * </p>
     *
     * @param recipeProcessParamMinVal
     *            Minimum Value
     */
    public void setRecipeProcessParamMinVal( @Nullable final String recipeProcessParamMinVal )
    {
        rememberChangedField("RecipeProcessParamMinVal", this.recipeProcessParamMinVal);
        this.recipeProcessParamMinVal = recipeProcessParamMinVal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinValIsFxd</b>
     * </p>
     *
     * @param recipeProcessParamMinValIsFxd
     *            Value Must Not Be Changed
     */
    public void setRecipeProcessParamMinValIsFxd( @Nullable final Boolean recipeProcessParamMinValIsFxd )
    {
        rememberChangedField("RecipeProcessParamMinValIsFxd", this.recipeProcessParamMinValIsFxd);
        this.recipeProcessParamMinValIsFxd = recipeProcessParamMinValIsFxd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxVal</b>
     * </p>
     *
     * @param recipeProcessParamMaxVal
     *            Maximum Value
     */
    public void setRecipeProcessParamMaxVal( @Nullable final String recipeProcessParamMaxVal )
    {
        rememberChangedField("RecipeProcessParamMaxVal", this.recipeProcessParamMaxVal);
        this.recipeProcessParamMaxVal = recipeProcessParamMaxVal;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxValIsFxd</b>
     * </p>
     *
     * @param recipeProcessParamMaxValIsFxd
     *            Value Must Not Be Changed
     */
    public void setRecipeProcessParamMaxValIsFxd( @Nullable final Boolean recipeProcessParamMaxValIsFxd )
    {
        rememberChangedField("RecipeProcessParamMaxValIsFxd", this.recipeProcessParamMaxValIsFxd);
        this.recipeProcessParamMaxValIsFxd = recipeProcessParamMaxValIsFxd;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamDecPlaces</b>
     * </p>
     *
     * @param recipeProcessParamDecPlaces
     *            Decimal Places for Process Parameter Values
     */
    public void setRecipeProcessParamDecPlaces( @Nullable final String recipeProcessParamDecPlaces )
    {
        rememberChangedField("RecipeProcessParamDecPlaces", this.recipeProcessParamDecPlaces);
        this.recipeProcessParamDecPlaces = recipeProcessParamDecPlaces;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamGroup</b>
     * </p>
     *
     * @param recipeProcessParamGroup
     *            Process Parameter Group ID
     */
    public void setRecipeProcessParamGroup( @Nullable final String recipeProcessParamGroup )
    {
        rememberChangedField("RecipeProcessParamGroup", this.recipeProcessParamGroup);
        this.recipeProcessParamGroup = recipeProcessParamGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamClass</b>
     * </p>
     *
     * @param recipeProcessParamClass
     *            Class ID for Classification
     */
    public void setRecipeProcessParamClass( @Nullable final String recipeProcessParamClass )
    {
        rememberChangedField("RecipeProcessParamClass", this.recipeProcessParamClass);
        this.recipeProcessParamClass = recipeProcessParamClass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamIsObsolete</b>
     * </p>
     *
     * @param recipeProcessParamIsObsolete
     *            Obsolete
     */
    public void setRecipeProcessParamIsObsolete( @Nullable final Boolean recipeProcessParamIsObsolete )
    {
        rememberChangedField("RecipeProcessParamIsObsolete", this.recipeProcessParamIsObsolete);
        this.recipeProcessParamIsObsolete = recipeProcessParamIsObsolete;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamIsDeleted</b>
     * </p>
     *
     * @param recipeProcessParamIsDeleted
     *            Process Parameter Deleted
     */
    public void setRecipeProcessParamIsDeleted( @Nullable final Boolean recipeProcessParamIsDeleted )
    {
        rememberChangedField("RecipeProcessParamIsDeleted", this.recipeProcessParamIsDeleted);
        this.recipeProcessParamIsDeleted = recipeProcessParamIsDeleted;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessParam";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessParamUUID", getRecipeProcessParamUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RecipeProcessParamUUID", getRecipeProcessParamUUID());
        values.put("RecipeProcessParam", getRecipeProcessParam());
        values.put("RecipeProcessParamUnit", getRecipeProcessParamUnit());
        values.put("RecipeProcessParamUnitIsFxd", getRecipeProcessParamUnitIsFxd());
        values.put("RecipeProcessParamTgtVal", getRecipeProcessParamTgtVal());
        values.put("RecipeProcessParamTgtValIsFxd", getRecipeProcessParamTgtValIsFxd());
        values.put("RecipeProcessParamMinVal", getRecipeProcessParamMinVal());
        values.put("RecipeProcessParamMinValIsFxd", getRecipeProcessParamMinValIsFxd());
        values.put("RecipeProcessParamMaxVal", getRecipeProcessParamMaxVal());
        values.put("RecipeProcessParamMaxValIsFxd", getRecipeProcessParamMaxValIsFxd());
        values.put("RecipeProcessParamDecPlaces", getRecipeProcessParamDecPlaces());
        values.put("RecipeProcessParamGroup", getRecipeProcessParamGroup());
        values.put("RecipeProcessParamClass", getRecipeProcessParamClass());
        values.put("RecipeProcessParamIsObsolete", getRecipeProcessParamIsObsolete());
        values.put("RecipeProcessParamIsDeleted", getRecipeProcessParamIsDeleted());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RecipeProcessParamUUID") ) {
                final Object value = values.remove("RecipeProcessParamUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamUUID())) ) {
                    setRecipeProcessParamUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessParam") ) {
                final Object value = values.remove("RecipeProcessParam");
                if( (value == null) || (!value.equals(getRecipeProcessParam())) ) {
                    setRecipeProcessParam(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamUnit") ) {
                final Object value = values.remove("RecipeProcessParamUnit");
                if( (value == null) || (!value.equals(getRecipeProcessParamUnit())) ) {
                    setRecipeProcessParamUnit(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamUnitIsFxd") ) {
                final Object value = values.remove("RecipeProcessParamUnitIsFxd");
                if( (value == null) || (!value.equals(getRecipeProcessParamUnitIsFxd())) ) {
                    setRecipeProcessParamUnitIsFxd(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamTgtVal") ) {
                final Object value = values.remove("RecipeProcessParamTgtVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamTgtVal())) ) {
                    setRecipeProcessParamTgtVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamTgtValIsFxd") ) {
                final Object value = values.remove("RecipeProcessParamTgtValIsFxd");
                if( (value == null) || (!value.equals(getRecipeProcessParamTgtValIsFxd())) ) {
                    setRecipeProcessParamTgtValIsFxd(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMinVal") ) {
                final Object value = values.remove("RecipeProcessParamMinVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamMinVal())) ) {
                    setRecipeProcessParamMinVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMinValIsFxd") ) {
                final Object value = values.remove("RecipeProcessParamMinValIsFxd");
                if( (value == null) || (!value.equals(getRecipeProcessParamMinValIsFxd())) ) {
                    setRecipeProcessParamMinValIsFxd(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMaxVal") ) {
                final Object value = values.remove("RecipeProcessParamMaxVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamMaxVal())) ) {
                    setRecipeProcessParamMaxVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMaxValIsFxd") ) {
                final Object value = values.remove("RecipeProcessParamMaxValIsFxd");
                if( (value == null) || (!value.equals(getRecipeProcessParamMaxValIsFxd())) ) {
                    setRecipeProcessParamMaxValIsFxd(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamDecPlaces") ) {
                final Object value = values.remove("RecipeProcessParamDecPlaces");
                if( (value == null) || (!value.equals(getRecipeProcessParamDecPlaces())) ) {
                    setRecipeProcessParamDecPlaces(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamGroup") ) {
                final Object value = values.remove("RecipeProcessParamGroup");
                if( (value == null) || (!value.equals(getRecipeProcessParamGroup())) ) {
                    setRecipeProcessParamGroup(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamClass") ) {
                final Object value = values.remove("RecipeProcessParamClass");
                if( (value == null) || (!value.equals(getRecipeProcessParamClass())) ) {
                    setRecipeProcessParamClass(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamIsObsolete") ) {
                final Object value = values.remove("RecipeProcessParamIsObsolete");
                if( (value == null) || (!value.equals(getRecipeProcessParamIsObsolete())) ) {
                    setRecipeProcessParamIsObsolete(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamIsDeleted") ) {
                final Object value = values.remove("RecipeProcessParamIsDeleted");
                if( (value == null) || (!value.equals(getRecipeProcessParamIsDeleted())) ) {
                    setRecipeProcessParamIsDeleted(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RecipeProcessParamDesc") ) {
                final Object value = (values).remove("to_RecipeProcessParamDesc");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessParamDesc == null ) {
                        toRecipeProcessParamDesc = Lists.newArrayList();
                    } else {
                        toRecipeProcessParamDesc = Lists.newArrayList(toRecipeProcessParamDesc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessParamText entity;
                        if( toRecipeProcessParamDesc.size() > i ) {
                            entity = toRecipeProcessParamDesc.get(i);
                        } else {
                            entity = new RecipeProcessParamText();
                            toRecipeProcessParamDesc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeProcessParamField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessParamField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessParamField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessParamField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipeProcessParamDesc != null ) {
            (values).put("to_RecipeProcessParamDesc", toRecipeProcessParamDesc);
        }
        return values;
    }

    /**
     * Fetches the <b>RecipeProcessParamText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessParamDesc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessParamText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamText> fetchRecipeProcessParamDesc()
    {
        return fetchFieldAsList("to_RecipeProcessParamDesc", RecipeProcessParamText.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamDesc</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamDesc</b> of a queried <b>RecipeProcessParam</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamText> getRecipeProcessParamDescOrFetch()
    {
        if( toRecipeProcessParamDesc == null ) {
            toRecipeProcessParamDesc = fetchRecipeProcessParamDesc();
        }
        return toRecipeProcessParamDesc;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamDesc</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParam</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamDesc</b> is already loaded, the result
     *         will contain the <b>RecipeProcessParamText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessParamText>> getRecipeProcessParamDescIfPresent()
    {
        return Option.of(toRecipeProcessParamDesc);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessParamText</b> entities for the loaded navigation property
     * <b>to_RecipeProcessParamDesc</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamDesc</b> of a queried <b>RecipeProcessParam</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessParamText</b> entities.
     */
    public void setRecipeProcessParamDesc( @Nonnull final List<RecipeProcessParamText> value )
    {
        if( toRecipeProcessParamDesc == null ) {
            toRecipeProcessParamDesc = Lists.newArrayList();
        }
        toRecipeProcessParamDesc.clear();
        toRecipeProcessParamDesc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessParamText</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamDesc</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamDesc</b> of a queried <b>RecipeProcessParam</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessParamText</b> entities.
     */
    public void addRecipeProcessParamDesc( RecipeProcessParamText... entity )
    {
        if( toRecipeProcessParamDesc == null ) {
            toRecipeProcessParamDesc = Lists.newArrayList();
        }
        toRecipeProcessParamDesc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecipeProcessParam instances.
     *
     */
    public final static class RecipeProcessParamBuilder
    {

        private List<RecipeProcessParamText> toRecipeProcessParamDesc = Lists.newArrayList();

        private RecipeProcessParam.RecipeProcessParamBuilder toRecipeProcessParamDesc(
            final List<RecipeProcessParamText> value )
        {
            toRecipeProcessParamDesc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamDesc</b> for <b>RecipeProcessParam</b> to multiple
         * <b>RecipeProcessParamText</b>.
         *
         * @param value
         *            The RecipeProcessParamTexts to build this RecipeProcessParam with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParam.RecipeProcessParamBuilder recipeProcessParamDesc( RecipeProcessParamText... value )
        {
            return toRecipeProcessParamDesc(Lists.newArrayList(value));
        }

    }

}
