/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessParamTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Recipe Process Parameter Descriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessParamTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessParamText extends VdmEntity<RecipeProcessParamText>
{

    /**
     * Selector for all available fields of RecipeProcessParamText.
     *
     */
    public final static RecipeProcessParamTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @return Process Parameter Master Data Key
     */
    @Key
    @SerializedName( "RecipeProcessParamUUID" )
    @JsonProperty( "RecipeProcessParamUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamUUID" )
    private UUID recipeProcessParamUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamTextField<UUID> RECIPE_PROCESS_PARAM_UUID =
        new RecipeProcessParamTextField<UUID>("RecipeProcessParamUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static RecipeProcessParamTextField<String> LANGUAGE =
        new RecipeProcessParamTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamDesc</b>
     * </p>
     *
     * @return Recipe Description
     */
    @SerializedName( "RecipeProcessParamDesc" )
    @JsonProperty( "RecipeProcessParamDesc" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamDesc" )
    private String recipeProcessParamDesc;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamDesc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamTextField<String> RECIPE_PROCESS_PARAM_DESC =
        new RecipeProcessParamTextField<String>("RecipeProcessParamDesc");

    @Nonnull
    @Override
    public Class<RecipeProcessParamText> getType()
    {
        return RecipeProcessParamText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @param recipeProcessParamUUID
     *            Process Parameter Master Data Key
     */
    public void setRecipeProcessParamUUID( @Nullable final UUID recipeProcessParamUUID )
    {
        rememberChangedField("RecipeProcessParamUUID", this.recipeProcessParamUUID);
        this.recipeProcessParamUUID = recipeProcessParamUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamDesc</b>
     * </p>
     *
     * @param recipeProcessParamDesc
     *            Recipe Description
     */
    public void setRecipeProcessParamDesc( @Nullable final String recipeProcessParamDesc )
    {
        rememberChangedField("RecipeProcessParamDesc", this.recipeProcessParamDesc);
        this.recipeProcessParamDesc = recipeProcessParamDesc;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessParamText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessParamUUID", getRecipeProcessParamUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("RecipeProcessParamUUID", getRecipeProcessParamUUID());
        values.put("Language", getLanguage());
        values.put("RecipeProcessParamDesc", getRecipeProcessParamDesc());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("RecipeProcessParamUUID") ) {
                final Object value = values.remove("RecipeProcessParamUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamUUID())) ) {
                    setRecipeProcessParamUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamDesc") ) {
                final Object value = values.remove("RecipeProcessParamDesc");
                if( (value == null) || (!value.equals(getRecipeProcessParamDesc())) ) {
                    setRecipeProcessParamDesc(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeProcessParamTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessParamTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessParamTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessParamTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

}
