/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamValueField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamValueLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamValueOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessParamValueSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Process Parameter Values
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessParamValueType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessParamValue extends VdmEntity<RecipeProcessParamValue>
{

    /**
     * Selector for all available fields of RecipeProcessParamValue.
     *
     */
    public final static RecipeProcessParamValueSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<Boolean> DELETE_MC =
        new RecipeProcessParamValueField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<Boolean> UPDATE_MC =
        new RecipeProcessParamValueField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @return Process Parameter Value Key
     */
    @Key
    @SerializedName( "RecipeProcessParamValUUID" )
    @JsonProperty( "RecipeProcessParamValUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamValUUID" )
    private UUID recipeProcessParamValUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamValUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_PROCESS_PARAM_VAL_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeProcessParamValUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @return Process GUID
     */
    @SerializedName( "RecipeProcessUUID" )
    @JsonProperty( "RecipeProcessUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessUUID" )
    private UUID recipeProcessUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_PROCESS_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeProcessUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @return Process Element GUID
     */
    @SerializedName( "RecipeProcessElementUUID" )
    @JsonProperty( "RecipeProcessElementUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessElementUUID" )
    private UUID recipeProcessElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessElementUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_PROCESS_ELEMENT_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeProcessElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @return Process Parameter Master Data Key
     */
    @SerializedName( "RecipeProcessParamUUID" )
    @JsonProperty( "RecipeProcessParamUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamUUID" )
    private UUID recipeProcessParamUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_PROCESS_PARAM_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeProcessParamUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @return Equipment Requirement GUID
     */
    @SerializedName( "RecipeProcessEquipRqmtUUID" )
    @JsonProperty( "RecipeProcessEquipRqmtUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtUUID" )
    private UUID recipeProcessEquipRqmtUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_PROCESS_EQUIP_RQMT_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeProcessEquipRqmtUUID");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnit</b>
     * </p>
     *
     * @return Unit of Measure
     */
    @SerializedName( "RecipeProcessParamUnit" )
    @JsonProperty( "RecipeProcessParamUnit" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamUnit" )
    private String recipeProcessParamUnit;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamUnit</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM_UNIT =
        new RecipeProcessParamValueField<String>("RecipeProcessParamUnit");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtVal</b>
     * </p>
     *
     * @return Target Value
     */
    @SerializedName( "RecipeProcessParamTgtVal" )
    @JsonProperty( "RecipeProcessParamTgtVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamTgtVal" )
    private String recipeProcessParamTgtVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamTgtVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM_TGT_VAL =
        new RecipeProcessParamValueField<String>("RecipeProcessParamTgtVal");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinVal</b>
     * </p>
     *
     * @return Minimum Value
     */
    @SerializedName( "RecipeProcessParamMinVal" )
    @JsonProperty( "RecipeProcessParamMinVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamMinVal" )
    private String recipeProcessParamMinVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMinVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM_MIN_VAL =
        new RecipeProcessParamValueField<String>("RecipeProcessParamMinVal");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxVal</b>
     * </p>
     *
     * @return Maximum Value
     */
    @SerializedName( "RecipeProcessParamMaxVal" )
    @JsonProperty( "RecipeProcessParamMaxVal" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamMaxVal" )
    private String recipeProcessParamMaxVal;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamMaxVal</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM_MAX_VAL =
        new RecipeProcessParamValueField<String>("RecipeProcessParamMaxVal");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamSqncNmbr</b>
     * </p>
     *
     * @return Sequence Number (Format NNNN)
     */
    @SerializedName( "RecipeProcessParamSqncNmbr" )
    @JsonProperty( "RecipeProcessParamSqncNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamSqncNmbr" )
    private String recipeProcessParamSqncNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamSqncNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM_SQNC_NMBR =
        new RecipeProcessParamValueField<String>("RecipeProcessParamSqncNmbr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeProcessParamValueField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<UUID> RECIPE_UUID =
        new RecipeProcessParamValueField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE =
        new RecipeProcessParamValueField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParam</b>
     * </p>
     *
     * @return Process Parameter Master Data - Legible Name / ID
     */
    @SerializedName( "RecipeProcessParam" )
    @JsonProperty( "RecipeProcessParam" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParam" )
    private String recipeProcessParam;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParam</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_PARAM =
        new RecipeProcessParamValueField<String>("RecipeProcessParam");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "RecipeProcessEquipRqmtPosNmbr" )
    @JsonProperty( "RecipeProcessEquipRqmtPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtPosNmbr" )
    private String recipeProcessEquipRqmtPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_EQUIP_RQMT_POS_NMBR =
        new RecipeProcessParamValueField<String>("RecipeProcessEquipRqmtPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessStagePosNmbr" )
    @JsonProperty( "RecipeProcessStagePosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStagePosNmbr" )
    private String recipeProcessStagePosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStagePosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_STAGE_POS_NMBR =
        new RecipeProcessParamValueField<String>("RecipeProcessStagePosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessOperationPosNmbr" )
    @JsonProperty( "RecipeProcessOperationPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationPosNmbr" )
    private String recipeProcessOperationPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_OPERATION_POS_NMBR =
        new RecipeProcessParamValueField<String>("RecipeProcessOperationPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessActionPosNmbr" )
    @JsonProperty( "RecipeProcessActionPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionPosNmbr" )
    private String recipeProcessActionPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueField<String> RECIPE_PROCESS_ACTION_POS_NMBR =
        new RecipeProcessParamValueField<String>("RecipeProcessActionPosNmbr");
    /**
     * Navigation property <b>to_Recipe</b> for <b>RecipeProcessParamValue</b> to single <b>Recipe</b>.
     *
     */
    @SerializedName( "to_Recipe" )
    @JsonProperty( "to_Recipe" )
    @ODataField( odataName = "to_Recipe" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Recipe toRecipe;
    /**
     * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeProcessParamValue</b> to single
     * <b>RecipeProcessElement</b>.
     *
     */
    @SerializedName( "to_RecipeProcessElement" )
    @JsonProperty( "to_RecipeProcessElement" )
    @ODataField( odataName = "to_RecipeProcessElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessElement toRecipeProcessElement;
    /**
     * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>RecipeProcessParamValue</b> to single
     * <b>RecipeProcessEquipRqmt</b>.
     *
     */
    @SerializedName( "to_RecipeProcessEquipRqmt" )
    @JsonProperty( "to_RecipeProcessEquipRqmt" )
    @ODataField( odataName = "to_RecipeProcessEquipRqmt" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessEquipRqmt toRecipeProcessEquipRqmt;
    /**
     * Navigation property <b>to_RecipeProcessParam</b> for <b>RecipeProcessParamValue</b> to single
     * <b>RecipeProcessParam</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParam" )
    @JsonProperty( "to_RecipeProcessParam" )
    @ODataField( odataName = "to_RecipeProcessParam" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessParam toRecipeProcessParam;
    /**
     * Navigation property <b>to_RecipeProcessParamValueTxt</b> for <b>RecipeProcessParamValue</b> to multiple
     * <b>RecipeProcessParamValueTxt</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamValueTxt" )
    @JsonProperty( "to_RecipeProcessParamValueTxt" )
    @ODataField( odataName = "to_RecipeProcessParamValueTxt" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecipeProcessParamValueTxt> toRecipeProcessParamValueTxt;
    /**
     * Navigation property <b>to_RecProcParamValCharc</b> for <b>RecipeProcessParamValue</b> to multiple
     * <b>RecProcParamValCharc</b>.
     *
     */
    @SerializedName( "to_RecProcParamValCharc" )
    @JsonProperty( "to_RecProcParamValCharc" )
    @ODataField( odataName = "to_RecProcParamValCharc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcParamValCharc> toRecProcParamValCharc;
    /**
     * Navigation property <b>to_RecProcParamValClass</b> for <b>RecipeProcessParamValue</b> to multiple
     * <b>RecProcParamValClass</b>.
     *
     */
    @SerializedName( "to_RecProcParamValClass" )
    @JsonProperty( "to_RecProcParamValClass" )
    @ODataField( odataName = "to_RecProcParamValClass" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<RecProcParamValClass> toRecProcParamValClass;
    /**
     * Use with available fluent helpers to apply the <b>to_Recipe</b> navigation property to query operations.
     *
     */
    public final static RecipeProcessParamValueOneToOneLink<Recipe> TO_RECIPE =
        new RecipeProcessParamValueOneToOneLink<Recipe>("to_Recipe");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessElement</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueOneToOneLink<RecipeProcessElement> TO_RECIPE_PROCESS_ELEMENT =
        new RecipeProcessParamValueOneToOneLink<RecipeProcessElement>("to_RecipeProcessElement");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessEquipRqmt</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueOneToOneLink<RecipeProcessEquipRqmt> TO_RECIPE_PROCESS_EQUIP_RQMT =
        new RecipeProcessParamValueOneToOneLink<RecipeProcessEquipRqmt>("to_RecipeProcessEquipRqmt");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParam</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueOneToOneLink<RecipeProcessParam> TO_RECIPE_PROCESS_PARAM =
        new RecipeProcessParamValueOneToOneLink<RecipeProcessParam>("to_RecipeProcessParam");
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamValueTxt</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueLink<RecipeProcessParamValueTxt> TO_RECIPE_PROCESS_PARAM_VALUE_TXT =
        new RecipeProcessParamValueLink<RecipeProcessParamValueTxt>("to_RecipeProcessParamValueTxt");
    /**
     * Use with available fluent helpers to apply the <b>to_RecProcParamValCharc</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueLink<RecProcParamValCharc> TO_REC_PROC_PARAM_VAL_CHARC =
        new RecipeProcessParamValueLink<RecProcParamValCharc>("to_RecProcParamValCharc");
    /**
     * Use with available fluent helpers to apply the <b>to_RecProcParamValClass</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueLink<RecProcParamValClass> TO_REC_PROC_PARAM_VAL_CLASS =
        new RecipeProcessParamValueLink<RecProcParamValClass>("to_RecProcParamValClass");

    @Nonnull
    @Override
    public Class<RecipeProcessParamValue> getType()
    {
        return RecipeProcessParamValue.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     */
    public void setRecipeProcessParamValUUID( @Nullable final UUID recipeProcessParamValUUID )
    {
        rememberChangedField("RecipeProcessParamValUUID", this.recipeProcessParamValUUID);
        this.recipeProcessParamValUUID = recipeProcessParamValUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @param recipeProcessUUID
     *            Process GUID
     */
    public void setRecipeProcessUUID( @Nullable final UUID recipeProcessUUID )
    {
        rememberChangedField("RecipeProcessUUID", this.recipeProcessUUID);
        this.recipeProcessUUID = recipeProcessUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessElementUUID</b>
     * </p>
     *
     * @param recipeProcessElementUUID
     *            Process Element GUID
     */
    public void setRecipeProcessElementUUID( @Nullable final UUID recipeProcessElementUUID )
    {
        rememberChangedField("RecipeProcessElementUUID", this.recipeProcessElementUUID);
        this.recipeProcessElementUUID = recipeProcessElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUUID</b>
     * </p>
     *
     * @param recipeProcessParamUUID
     *            Process Parameter Master Data Key
     */
    public void setRecipeProcessParamUUID( @Nullable final UUID recipeProcessParamUUID )
    {
        rememberChangedField("RecipeProcessParamUUID", this.recipeProcessParamUUID);
        this.recipeProcessParamUUID = recipeProcessParamUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtUUID</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtUUID
     *            Equipment Requirement GUID
     */
    public void setRecipeProcessEquipRqmtUUID( @Nullable final UUID recipeProcessEquipRqmtUUID )
    {
        rememberChangedField("RecipeProcessEquipRqmtUUID", this.recipeProcessEquipRqmtUUID);
        this.recipeProcessEquipRqmtUUID = recipeProcessEquipRqmtUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamUnit</b>
     * </p>
     *
     * @param recipeProcessParamUnit
     *            Unit of Measure
     */
    public void setRecipeProcessParamUnit( @Nullable final String recipeProcessParamUnit )
    {
        rememberChangedField("RecipeProcessParamUnit", this.recipeProcessParamUnit);
        this.recipeProcessParamUnit = recipeProcessParamUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamTgtVal</b>
     * </p>
     *
     * @param recipeProcessParamTgtVal
     *            Target Value
     */
    public void setRecipeProcessParamTgtVal( @Nullable final String recipeProcessParamTgtVal )
    {
        rememberChangedField("RecipeProcessParamTgtVal", this.recipeProcessParamTgtVal);
        this.recipeProcessParamTgtVal = recipeProcessParamTgtVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMinVal</b>
     * </p>
     *
     * @param recipeProcessParamMinVal
     *            Minimum Value
     */
    public void setRecipeProcessParamMinVal( @Nullable final String recipeProcessParamMinVal )
    {
        rememberChangedField("RecipeProcessParamMinVal", this.recipeProcessParamMinVal);
        this.recipeProcessParamMinVal = recipeProcessParamMinVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamMaxVal</b>
     * </p>
     *
     * @param recipeProcessParamMaxVal
     *            Maximum Value
     */
    public void setRecipeProcessParamMaxVal( @Nullable final String recipeProcessParamMaxVal )
    {
        rememberChangedField("RecipeProcessParamMaxVal", this.recipeProcessParamMaxVal);
        this.recipeProcessParamMaxVal = recipeProcessParamMaxVal;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamSqncNmbr</b>
     * </p>
     *
     * @param recipeProcessParamSqncNmbr
     *            Sequence Number (Format NNNN)
     */
    public void setRecipeProcessParamSqncNmbr( @Nullable final String recipeProcessParamSqncNmbr )
    {
        rememberChangedField("RecipeProcessParamSqncNmbr", this.recipeProcessParamSqncNmbr);
        this.recipeProcessParamSqncNmbr = recipeProcessParamSqncNmbr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParam</b>
     * </p>
     *
     * @param recipeProcessParam
     *            Process Parameter Master Data - Legible Name / ID
     */
    public void setRecipeProcessParam( @Nullable final String recipeProcessParam )
    {
        rememberChangedField("RecipeProcessParam", this.recipeProcessParam);
        this.recipeProcessParam = recipeProcessParam;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtPosNmbr
     *            Sequence Number
     */
    public void setRecipeProcessEquipRqmtPosNmbr( @Nullable final String recipeProcessEquipRqmtPosNmbr )
    {
        rememberChangedField("RecipeProcessEquipRqmtPosNmbr", this.recipeProcessEquipRqmtPosNmbr);
        this.recipeProcessEquipRqmtPosNmbr = recipeProcessEquipRqmtPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @param recipeProcessStagePosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessStagePosNmbr( @Nullable final String recipeProcessStagePosNmbr )
    {
        rememberChangedField("RecipeProcessStagePosNmbr", this.recipeProcessStagePosNmbr);
        this.recipeProcessStagePosNmbr = recipeProcessStagePosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @param recipeProcessOperationPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessOperationPosNmbr( @Nullable final String recipeProcessOperationPosNmbr )
    {
        rememberChangedField("RecipeProcessOperationPosNmbr", this.recipeProcessOperationPosNmbr);
        this.recipeProcessOperationPosNmbr = recipeProcessOperationPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @param recipeProcessActionPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessActionPosNmbr( @Nullable final String recipeProcessActionPosNmbr )
    {
        rememberChangedField("RecipeProcessActionPosNmbr", this.recipeProcessActionPosNmbr);
        this.recipeProcessActionPosNmbr = recipeProcessActionPosNmbr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessParamValue";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        values.put("RecipeProcessUUID", getRecipeProcessUUID());
        values.put("RecipeProcessElementUUID", getRecipeProcessElementUUID());
        values.put("RecipeProcessParamUUID", getRecipeProcessParamUUID());
        values.put("RecipeProcessEquipRqmtUUID", getRecipeProcessEquipRqmtUUID());
        values.put("RecipeProcessParamUnit", getRecipeProcessParamUnit());
        values.put("RecipeProcessParamTgtVal", getRecipeProcessParamTgtVal());
        values.put("RecipeProcessParamMinVal", getRecipeProcessParamMinVal());
        values.put("RecipeProcessParamMaxVal", getRecipeProcessParamMaxVal());
        values.put("RecipeProcessParamSqncNmbr", getRecipeProcessParamSqncNmbr());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("Recipe", getRecipe());
        values.put("RecipeProcessParam", getRecipeProcessParam());
        values.put("RecipeProcessEquipRqmtPosNmbr", getRecipeProcessEquipRqmtPosNmbr());
        values.put("RecipeProcessStagePosNmbr", getRecipeProcessStagePosNmbr());
        values.put("RecipeProcessOperationPosNmbr", getRecipeProcessOperationPosNmbr());
        values.put("RecipeProcessActionPosNmbr", getRecipeProcessActionPosNmbr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamValUUID") ) {
                final Object value = values.remove("RecipeProcessParamValUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamValUUID())) ) {
                    setRecipeProcessParamValUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessUUID") ) {
                final Object value = values.remove("RecipeProcessUUID");
                if( (value == null) || (!value.equals(getRecipeProcessUUID())) ) {
                    setRecipeProcessUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessElementUUID") ) {
                final Object value = values.remove("RecipeProcessElementUUID");
                if( (value == null) || (!value.equals(getRecipeProcessElementUUID())) ) {
                    setRecipeProcessElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessParamUUID") ) {
                final Object value = values.remove("RecipeProcessParamUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamUUID())) ) {
                    setRecipeProcessParamUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessEquipRqmtUUID") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtUUID");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtUUID())) ) {
                    setRecipeProcessEquipRqmtUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessParamUnit") ) {
                final Object value = values.remove("RecipeProcessParamUnit");
                if( (value == null) || (!value.equals(getRecipeProcessParamUnit())) ) {
                    setRecipeProcessParamUnit(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamTgtVal") ) {
                final Object value = values.remove("RecipeProcessParamTgtVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamTgtVal())) ) {
                    setRecipeProcessParamTgtVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMinVal") ) {
                final Object value = values.remove("RecipeProcessParamMinVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamMinVal())) ) {
                    setRecipeProcessParamMinVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamMaxVal") ) {
                final Object value = values.remove("RecipeProcessParamMaxVal");
                if( (value == null) || (!value.equals(getRecipeProcessParamMaxVal())) ) {
                    setRecipeProcessParamMaxVal(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamSqncNmbr") ) {
                final Object value = values.remove("RecipeProcessParamSqncNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessParamSqncNmbr())) ) {
                    setRecipeProcessParamSqncNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParam") ) {
                final Object value = values.remove("RecipeProcessParam");
                if( (value == null) || (!value.equals(getRecipeProcessParam())) ) {
                    setRecipeProcessParam(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessEquipRqmtPosNmbr") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtPosNmbr())) ) {
                    setRecipeProcessEquipRqmtPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessStagePosNmbr") ) {
                final Object value = values.remove("RecipeProcessStagePosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessStagePosNmbr())) ) {
                    setRecipeProcessStagePosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationPosNmbr") ) {
                final Object value = values.remove("RecipeProcessOperationPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessOperationPosNmbr())) ) {
                    setRecipeProcessOperationPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessActionPosNmbr") ) {
                final Object value = values.remove("RecipeProcessActionPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessActionPosNmbr())) ) {
                    setRecipeProcessActionPosNmbr(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Recipe") ) {
                final Object value = (values).remove("to_Recipe");
                if( value instanceof Map ) {
                    if( toRecipe == null ) {
                        toRecipe = new Recipe();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipe.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessElement") ) {
                final Object value = (values).remove("to_RecipeProcessElement");
                if( value instanceof Map ) {
                    if( toRecipeProcessElement == null ) {
                        toRecipeProcessElement = new RecipeProcessElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessElement.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessEquipRqmt") ) {
                final Object value = (values).remove("to_RecipeProcessEquipRqmt");
                if( value instanceof Map ) {
                    if( toRecipeProcessEquipRqmt == null ) {
                        toRecipeProcessEquipRqmt = new RecipeProcessEquipRqmt();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessEquipRqmt.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessParam") ) {
                final Object value = (values).remove("to_RecipeProcessParam");
                if( value instanceof Map ) {
                    if( toRecipeProcessParam == null ) {
                        toRecipeProcessParam = new RecipeProcessParam();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessParam.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_RecipeProcessParamValueTxt") ) {
                final Object value = (values).remove("to_RecipeProcessParamValueTxt");
                if( value instanceof Iterable ) {
                    if( toRecipeProcessParamValueTxt == null ) {
                        toRecipeProcessParamValueTxt = Lists.newArrayList();
                    } else {
                        toRecipeProcessParamValueTxt = Lists.newArrayList(toRecipeProcessParamValueTxt);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecipeProcessParamValueTxt entity;
                        if( toRecipeProcessParamValueTxt.size() > i ) {
                            entity = toRecipeProcessParamValueTxt.get(i);
                        } else {
                            entity = new RecipeProcessParamValueTxt();
                            toRecipeProcessParamValueTxt.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecProcParamValCharc") ) {
                final Object value = (values).remove("to_RecProcParamValCharc");
                if( value instanceof Iterable ) {
                    if( toRecProcParamValCharc == null ) {
                        toRecProcParamValCharc = Lists.newArrayList();
                    } else {
                        toRecProcParamValCharc = Lists.newArrayList(toRecProcParamValCharc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcParamValCharc entity;
                        if( toRecProcParamValCharc.size() > i ) {
                            entity = toRecProcParamValCharc.get(i);
                        } else {
                            entity = new RecProcParamValCharc();
                            toRecProcParamValCharc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_RecProcParamValClass") ) {
                final Object value = (values).remove("to_RecProcParamValClass");
                if( value instanceof Iterable ) {
                    if( toRecProcParamValClass == null ) {
                        toRecProcParamValClass = Lists.newArrayList();
                    } else {
                        toRecProcParamValClass = Lists.newArrayList(toRecProcParamValClass);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        RecProcParamValClass entity;
                        if( toRecProcParamValClass.size() > i ) {
                            entity = toRecProcParamValClass.get(i);
                        } else {
                            entity = new RecProcParamValClass();
                            toRecProcParamValClass.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> RecipeProcessParamValueField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessParamValueField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessParamValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessParamValueField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipe != null ) {
            (values).put("to_Recipe", toRecipe);
        }
        if( toRecipeProcessElement != null ) {
            (values).put("to_RecipeProcessElement", toRecipeProcessElement);
        }
        if( toRecipeProcessEquipRqmt != null ) {
            (values).put("to_RecipeProcessEquipRqmt", toRecipeProcessEquipRqmt);
        }
        if( toRecipeProcessParam != null ) {
            (values).put("to_RecipeProcessParam", toRecipeProcessParam);
        }
        if( toRecipeProcessParamValueTxt != null ) {
            (values).put("to_RecipeProcessParamValueTxt", toRecipeProcessParamValueTxt);
        }
        if( toRecProcParamValCharc != null ) {
            (values).put("to_RecProcParamValCharc", toRecProcParamValCharc);
        }
        if( toRecProcParamValClass != null ) {
            (values).put("to_RecProcParamValClass", toRecProcParamValClass);
        }
        return values;
    }

    /**
     * Fetches the <b>Recipe</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Recipe</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Recipe</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe fetchRecipe()
    {
        return fetchFieldAsSingle("to_Recipe", Recipe.class);
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property <b>to_Recipe</b> of a queried <b>RecipeProcessParamValue</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Recipe</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Recipe getRecipeOrFetch()
    {
        if( toRecipe == null ) {
            toRecipe = fetchRecipe();
        }
        return toRecipe;
    }

    /**
     * Retrieval of associated <b>Recipe</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Recipe</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Recipe</b> is already loaded, the result will contain
     *         the <b>Recipe</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Recipe> getRecipeIfPresent()
    {
        return Option.of(toRecipe);
    }

    /**
     * Overwrites the associated <b>Recipe</b> entity for the loaded navigation property <b>to_Recipe</b>.
     *
     * @param value
     *            New <b>Recipe</b> entity.
     */
    public void setRecipe( final Recipe value )
    {
        toRecipe = value;
    }

    /**
     * Fetches the <b>RecipeProcessElement</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RecipeProcessElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessElement</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement fetchRecipeProcessElement()
    {
        return fetchFieldAsSingle("to_RecipeProcessElement", RecipeProcessElement.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessElement</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessElement getRecipeProcessElementOrFetch()
    {
        if( toRecipeProcessElement == null ) {
            toRecipeProcessElement = fetchRecipeProcessElement();
        }
        return toRecipeProcessElement;
    }

    /**
     * Retrieval of associated <b>RecipeProcessElement</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessElement</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessElement</b> is already loaded, the result
     *         will contain the <b>RecipeProcessElement</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessElement> getRecipeProcessElementIfPresent()
    {
        return Option.of(toRecipeProcessElement);
    }

    /**
     * Overwrites the associated <b>RecipeProcessElement</b> entity for the loaded navigation property
     * <b>to_RecipeProcessElement</b>.
     *
     * @param value
     *            New <b>RecipeProcessElement</b> entity.
     */
    public void setRecipeProcessElement( final RecipeProcessElement value )
    {
        toRecipeProcessElement = value;
    }

    /**
     * Fetches the <b>RecipeProcessEquipRqmt</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessEquipRqmt</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessEquipRqmt fetchRecipeProcessEquipRqmt()
    {
        return fetchFieldAsSingle("to_RecipeProcessEquipRqmt", RecipeProcessEquipRqmt.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessEquipRqmt</b> of a queried <b>RecipeProcessParamValue</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessEquipRqmt</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessEquipRqmt getRecipeProcessEquipRqmtOrFetch()
    {
        if( toRecipeProcessEquipRqmt == null ) {
            toRecipeProcessEquipRqmt = fetchRecipeProcessEquipRqmt();
        }
        return toRecipeProcessEquipRqmt;
    }

    /**
     * Retrieval of associated <b>RecipeProcessEquipRqmt</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RecipeProcessEquipRqmt</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessEquipRqmt</b> is already loaded, the result
     *         will contain the <b>RecipeProcessEquipRqmt</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessEquipRqmt> getRecipeProcessEquipRqmtIfPresent()
    {
        return Option.of(toRecipeProcessEquipRqmt);
    }

    /**
     * Overwrites the associated <b>RecipeProcessEquipRqmt</b> entity for the loaded navigation property
     * <b>to_RecipeProcessEquipRqmt</b>.
     *
     * @param value
     *            New <b>RecipeProcessEquipRqmt</b> entity.
     */
    public void setRecipeProcessEquipRqmt( final RecipeProcessEquipRqmt value )
    {
        toRecipeProcessEquipRqmt = value;
    }

    /**
     * Fetches the <b>RecipeProcessParam</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_RecipeProcessParam</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessParam</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessParam fetchRecipeProcessParam()
    {
        return fetchFieldAsSingle("to_RecipeProcessParam", RecipeProcessParam.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParam</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessParam</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParam</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParam</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessParam getRecipeProcessParamOrFetch()
    {
        if( toRecipeProcessParam == null ) {
            toRecipeProcessParam = fetchRecipeProcessParam();
        }
        return toRecipeProcessParam;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParam</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_RecipeProcessParam</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParam</b> is already loaded, the result
     *         will contain the <b>RecipeProcessParam</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessParam> getRecipeProcessParamIfPresent()
    {
        return Option.of(toRecipeProcessParam);
    }

    /**
     * Overwrites the associated <b>RecipeProcessParam</b> entity for the loaded navigation property
     * <b>to_RecipeProcessParam</b>.
     *
     * @param value
     *            New <b>RecipeProcessParam</b> entity.
     */
    public void setRecipeProcessParam( final RecipeProcessParam value )
    {
        toRecipeProcessParam = value;
    }

    /**
     * Fetches the <b>RecipeProcessParamValueTxt</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_RecipeProcessParamValueTxt</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecipeProcessParamValueTxt</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValueTxt> fetchRecipeProcessParamValueTxt()
    {
        return fetchFieldAsList("to_RecipeProcessParamValueTxt", RecipeProcessParamValueTxt.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValueTxt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValueTxt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValueTxt</b> of a queried <b>RecipeProcessParamValue</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamValueTxt</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecipeProcessParamValueTxt> getRecipeProcessParamValueTxtOrFetch()
    {
        if( toRecipeProcessParamValueTxt == null ) {
            toRecipeProcessParamValueTxt = fetchRecipeProcessParamValueTxt();
        }
        return toRecipeProcessParamValueTxt;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValueTxt</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValueTxt</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamValueTxt</b> is already loaded, the
     *         result will contain the <b>RecipeProcessParamValueTxt</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecipeProcessParamValueTxt>> getRecipeProcessParamValueTxtIfPresent()
    {
        return Option.of(toRecipeProcessParamValueTxt);
    }

    /**
     * Overwrites the list of associated <b>RecipeProcessParamValueTxt</b> entities for the loaded navigation property
     * <b>to_RecipeProcessParamValueTxt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValueTxt</b> of a queried <b>RecipeProcessParamValue</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecipeProcessParamValueTxt</b> entities.
     */
    public void setRecipeProcessParamValueTxt( @Nonnull final List<RecipeProcessParamValueTxt> value )
    {
        if( toRecipeProcessParamValueTxt == null ) {
            toRecipeProcessParamValueTxt = Lists.newArrayList();
        }
        toRecipeProcessParamValueTxt.clear();
        toRecipeProcessParamValueTxt.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecipeProcessParamValueTxt</b> entities. This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValueTxt</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValueTxt</b> of a queried <b>RecipeProcessParamValue</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecipeProcessParamValueTxt</b> entities.
     */
    public void addRecipeProcessParamValueTxt( RecipeProcessParamValueTxt... entity )
    {
        if( toRecipeProcessParamValueTxt == null ) {
            toRecipeProcessParamValueTxt = Lists.newArrayList();
        }
        toRecipeProcessParamValueTxt.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecProcParamValCharc</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecProcParamValCharc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcParamValCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValCharc> fetchRecProcParamValCharc()
    {
        return fetchFieldAsList("to_RecProcParamValCharc", RecProcParamValCharc.class);
    }

    /**
     * Retrieval of associated <b>RecProcParamValCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcParamValCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValCharc</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcParamValCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValCharc> getRecProcParamValCharcOrFetch()
    {
        if( toRecProcParamValCharc == null ) {
            toRecProcParamValCharc = fetchRecProcParamValCharc();
        }
        return toRecProcParamValCharc;
    }

    /**
     * Retrieval of associated <b>RecProcParamValCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcParamValCharc</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecProcParamValCharc</b> is already loaded, the result
     *         will contain the <b>RecProcParamValCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcParamValCharc>> getRecProcParamValCharcIfPresent()
    {
        return Option.of(toRecProcParamValCharc);
    }

    /**
     * Overwrites the list of associated <b>RecProcParamValCharc</b> entities for the loaded navigation property
     * <b>to_RecProcParamValCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValCharc</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcParamValCharc</b> entities.
     */
    public void setRecProcParamValCharc( @Nonnull final List<RecProcParamValCharc> value )
    {
        if( toRecProcParamValCharc == null ) {
            toRecProcParamValCharc = Lists.newArrayList();
        }
        toRecProcParamValCharc.clear();
        toRecProcParamValCharc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcParamValCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_RecProcParamValCharc</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValCharc</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcParamValCharc</b> entities.
     */
    public void addRecProcParamValCharc( RecProcParamValCharc... entity )
    {
        if( toRecProcParamValCharc == null ) {
            toRecProcParamValCharc = Lists.newArrayList();
        }
        toRecProcParamValCharc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>RecProcParamValClass</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecProcParamValClass</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>RecProcParamValClass</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValClass> fetchRecProcParamValClass()
    {
        return fetchFieldAsList("to_RecProcParamValClass", RecProcParamValClass.class);
    }

    /**
     * Retrieval of associated <b>RecProcParamValClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcParamValClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValClass</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecProcParamValClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<RecProcParamValClass> getRecProcParamValClassOrFetch()
    {
        if( toRecProcParamValClass == null ) {
            toRecProcParamValClass = fetchRecProcParamValClass();
        }
        return toRecProcParamValClass;
    }

    /**
     * Retrieval of associated <b>RecProcParamValClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_RecProcParamValClass</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValue</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecProcParamValClass</b> is already loaded, the result
     *         will contain the <b>RecProcParamValClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<RecProcParamValClass>> getRecProcParamValClassIfPresent()
    {
        return Option.of(toRecProcParamValClass);
    }

    /**
     * Overwrites the list of associated <b>RecProcParamValClass</b> entities for the loaded navigation property
     * <b>to_RecProcParamValClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValClass</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>RecProcParamValClass</b> entities.
     */
    public void setRecProcParamValClass( @Nonnull final List<RecProcParamValClass> value )
    {
        if( toRecProcParamValClass == null ) {
            toRecProcParamValClass = Lists.newArrayList();
        }
        toRecProcParamValClass.clear();
        toRecProcParamValClass.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>RecProcParamValClass</b> entities. This corresponds to the OData
     * navigation property <b>to_RecProcParamValClass</b>.
     * <p>
     * If the navigation property <b>to_RecProcParamValClass</b> of a queried <b>RecipeProcessParamValue</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>RecProcParamValClass</b> entities.
     */
    public void addRecProcParamValClass( RecProcParamValClass... entity )
    {
        if( toRecProcParamValClass == null ) {
            toRecProcParamValClass = Lists.newArrayList();
        }
        toRecProcParamValClass.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of RecipeProcessParamValue instances.
     *
     */
    public final static class RecipeProcessParamValueBuilder
    {

        private Recipe toRecipe;
        private String recipe = null;
        private RecipeProcessElement toRecipeProcessElement;
        private RecipeProcessEquipRqmt toRecipeProcessEquipRqmt;
        private RecipeProcessParam toRecipeProcessParam;
        private String recipeProcessParam = null;
        private List<RecipeProcessParamValueTxt> toRecipeProcessParamValueTxt = Lists.newArrayList();
        private List<RecProcParamValCharc> toRecProcParamValCharc = Lists.newArrayList();
        private List<RecProcParamValClass> toRecProcParamValClass = Lists.newArrayList();

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecipe( final Recipe value )
        {
            toRecipe = value;
            return this;
        }

        /**
         * Navigation property <b>to_Recipe</b> for <b>RecipeProcessParamValue</b> to single <b>Recipe</b>.
         *
         * @param value
         *            The Recipe to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipe( final Recipe value )
        {
            return toRecipe(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 20
         * <p>
         * Original property name from the Odata EDM: <b>Recipe</b>
         * </p>
         *
         * @param value
         *            The recipe to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipe( final String value )
        {
            recipe = value;
            return this;
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecipeProcessElement(
            final RecipeProcessElement value )
        {
            toRecipeProcessElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessElement</b> for <b>RecipeProcessParamValue</b> to single
         * <b>RecipeProcessElement</b>.
         *
         * @param value
         *            The RecipeProcessElement to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipeProcessElement(
            final RecipeProcessElement value )
        {
            return toRecipeProcessElement(value);
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecipeProcessEquipRqmt(
            final RecipeProcessEquipRqmt value )
        {
            toRecipeProcessEquipRqmt = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessEquipRqmt</b> for <b>RecipeProcessParamValue</b> to single
         * <b>RecipeProcessEquipRqmt</b>.
         *
         * @param value
         *            The RecipeProcessEquipRqmt to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipeProcessEquipRqmt(
            final RecipeProcessEquipRqmt value )
        {
            return toRecipeProcessEquipRqmt(value);
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecipeProcessParam(
            final RecipeProcessParam value )
        {
            toRecipeProcessParam = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParam</b> for <b>RecipeProcessParamValue</b> to single
         * <b>RecipeProcessParam</b>.
         *
         * @param value
         *            The RecipeProcessParam to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipeProcessParam(
            final RecipeProcessParam value )
        {
            return toRecipeProcessParam(value);
        }

        /**
         * Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>RecipeProcessParam</b>
         * </p>
         *
         * @param value
         *            The recipeProcessParam to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipeProcessParam( final String value )
        {
            recipeProcessParam = value;
            return this;
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecipeProcessParamValueTxt(
            final List<RecipeProcessParamValueTxt> value )
        {
            toRecipeProcessParamValueTxt.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamValueTxt</b> for <b>RecipeProcessParamValue</b> to multiple
         * <b>RecipeProcessParamValueTxt</b>.
         *
         * @param value
         *            The RecipeProcessParamValueTxts to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recipeProcessParamValueTxt(
            RecipeProcessParamValueTxt... value )
        {
            return toRecipeProcessParamValueTxt(Lists.newArrayList(value));
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecProcParamValCharc(
            final List<RecProcParamValCharc> value )
        {
            toRecProcParamValCharc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecProcParamValCharc</b> for <b>RecipeProcessParamValue</b> to multiple
         * <b>RecProcParamValCharc</b>.
         *
         * @param value
         *            The RecProcParamValCharcs to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recProcParamValCharc(
            RecProcParamValCharc... value )
        {
            return toRecProcParamValCharc(Lists.newArrayList(value));
        }

        private RecipeProcessParamValue.RecipeProcessParamValueBuilder toRecProcParamValClass(
            final List<RecProcParamValClass> value )
        {
            toRecProcParamValClass.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_RecProcParamValClass</b> for <b>RecipeProcessParamValue</b> to multiple
         * <b>RecProcParamValClass</b>.
         *
         * @param value
         *            The RecProcParamValClasss to build this RecipeProcessParamValue with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValue.RecipeProcessParamValueBuilder recProcParamValClass(
            RecProcParamValClass... value )
        {
            return toRecProcParamValClass(Lists.newArrayList(value));
        }

    }

}
