/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessParamValueTxtField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessParamValueTxtOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeProcessParamValueTxtSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Recipe Process Parameter Value Descriptions
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_RecipeProcessParamValueTxtType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class RecipeProcessParamValueTxt extends VdmEntity<RecipeProcessParamValueTxt>
{

    /**
     * Selector for all available fields of RecipeProcessParamValueTxt.
     *
     */
    public final static RecipeProcessParamValueTxtSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<Boolean> DELETE_MC =
        new RecipeProcessParamValueTxtField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<Boolean> UPDATE_MC =
        new RecipeProcessParamValueTxtField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @return Process Parameter Value Key
     */
    @Key
    @SerializedName( "RecipeProcessParamValUUID" )
    @JsonProperty( "RecipeProcessParamValUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamValUUID" )
    private UUID recipeProcessParamValUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamValUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<UUID> RECIPE_PROCESS_PARAM_VAL_UUID =
        new RecipeProcessParamValueTxtField<UUID>("RecipeProcessParamValUUID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> LANGUAGE =
        new RecipeProcessParamValueTxtField<String>("Language");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @return Process GUID
     */
    @SerializedName( "RecipeProcessUUID" )
    @JsonProperty( "RecipeProcessUUID" )
    @Nullable
    @ODataField( odataName = "RecipeProcessUUID" )
    private UUID recipeProcessUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<UUID> RECIPE_PROCESS_UUID =
        new RecipeProcessParamValueTxtField<UUID>("RecipeProcessUUID");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValueDesc</b>
     * </p>
     *
     * @return Recipe Description
     */
    @SerializedName( "RecipeProcessParamValueDesc" )
    @JsonProperty( "RecipeProcessParamValueDesc" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamValueDesc" )
    private String recipeProcessParamValueDesc;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamValueDesc</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_PARAM_VALUE_DESC =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessParamValueDesc");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @return UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    @SerializedName( "RecipeLastChangeDateTime" )
    @JsonProperty( "RecipeLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "RecipeLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime recipeLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>RecipeLastChangeDateTime</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<ZonedDateTime> RECIPE_LAST_CHANGE_DATE_TIME =
        new RecipeProcessParamValueTxtField<ZonedDateTime>("RecipeLastChangeDateTime");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @return Common Recipe GUID
     */
    @SerializedName( "RecipeUUID" )
    @JsonProperty( "RecipeUUID" )
    @Nullable
    @ODataField( odataName = "RecipeUUID" )
    private UUID recipeUUID;
    /**
     * Use with available fluent helpers to apply the <b>RecipeUUID</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<UUID> RECIPE_UUID =
        new RecipeProcessParamValueTxtField<UUID>("RecipeUUID");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @return Recipe ID
     */
    @SerializedName( "Recipe" )
    @JsonProperty( "Recipe" )
    @Nullable
    @ODataField( odataName = "Recipe" )
    private String recipe;
    /**
     * Use with available fluent helpers to apply the <b>Recipe</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE =
        new RecipeProcessParamValueTxtField<String>("Recipe");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @return Sequence Number
     */
    @SerializedName( "RecipeProcessEquipRqmtPosNmbr" )
    @JsonProperty( "RecipeProcessEquipRqmtPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessEquipRqmtPosNmbr" )
    private String recipeProcessEquipRqmtPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessEquipRqmtPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_EQUIP_RQMT_POS_NMBR =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessEquipRqmtPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessStagePosNmbr" )
    @JsonProperty( "RecipeProcessStagePosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessStagePosNmbr" )
    private String recipeProcessStagePosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessStagePosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_STAGE_POS_NMBR =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessStagePosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessOperationPosNmbr" )
    @JsonProperty( "RecipeProcessOperationPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessOperationPosNmbr" )
    private String recipeProcessOperationPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessOperationPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_OPERATION_POS_NMBR =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessOperationPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @return ID of a Process Element
     */
    @SerializedName( "RecipeProcessActionPosNmbr" )
    @JsonProperty( "RecipeProcessActionPosNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessActionPosNmbr" )
    private String recipeProcessActionPosNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessActionPosNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_ACTION_POS_NMBR =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessActionPosNmbr");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamSqncNmbr</b>
     * </p>
     *
     * @return Sequence Number (Format NNNN)
     */
    @SerializedName( "RecipeProcessParamSqncNmbr" )
    @JsonProperty( "RecipeProcessParamSqncNmbr" )
    @Nullable
    @ODataField( odataName = "RecipeProcessParamSqncNmbr" )
    private String recipeProcessParamSqncNmbr;
    /**
     * Use with available fluent helpers to apply the <b>RecipeProcessParamSqncNmbr</b> field to query operations.
     *
     */
    public final static RecipeProcessParamValueTxtField<String> RECIPE_PROCESS_PARAM_SQNC_NMBR =
        new RecipeProcessParamValueTxtField<String>("RecipeProcessParamSqncNmbr");
    /**
     * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessParamValueTxt</b> to single
     * <b>RecipeProcessParamValue</b>.
     *
     */
    @SerializedName( "to_RecipeProcessParamValue" )
    @JsonProperty( "to_RecipeProcessParamValue" )
    @ODataField( odataName = "to_RecipeProcessParamValue" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private RecipeProcessParamValue toRecipeProcessParamValue;
    /**
     * Use with available fluent helpers to apply the <b>to_RecipeProcessParamValue</b> navigation property to query
     * operations.
     *
     */
    public final static RecipeProcessParamValueTxtOneToOneLink<RecipeProcessParamValue> TO_RECIPE_PROCESS_PARAM_VALUE =
        new RecipeProcessParamValueTxtOneToOneLink<RecipeProcessParamValue>("to_RecipeProcessParamValue");

    @Nonnull
    @Override
    public Class<RecipeProcessParamValueTxt> getType()
    {
        return RecipeProcessParamValueTxt.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValUUID</b>
     * </p>
     *
     * @param recipeProcessParamValUUID
     *            Process Parameter Value Key
     */
    public void setRecipeProcessParamValUUID( @Nullable final UUID recipeProcessParamValUUID )
    {
        rememberChangedField("RecipeProcessParamValUUID", this.recipeProcessParamValUUID);
        this.recipeProcessParamValUUID = recipeProcessParamValUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessUUID</b>
     * </p>
     *
     * @param recipeProcessUUID
     *            Process GUID
     */
    public void setRecipeProcessUUID( @Nullable final UUID recipeProcessUUID )
    {
        rememberChangedField("RecipeProcessUUID", this.recipeProcessUUID);
        this.recipeProcessUUID = recipeProcessUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamValueDesc</b>
     * </p>
     *
     * @param recipeProcessParamValueDesc
     *            Recipe Description
     */
    public void setRecipeProcessParamValueDesc( @Nullable final String recipeProcessParamValueDesc )
    {
        rememberChangedField("RecipeProcessParamValueDesc", this.recipeProcessParamValueDesc);
        this.recipeProcessParamValueDesc = recipeProcessParamValueDesc;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>RecipeLastChangeDateTime</b>
     * </p>
     *
     * @param recipeLastChangeDateTime
     *            UTC Time Stamp in Short Form (YYYYMMDDhhmmss)
     */
    public void setRecipeLastChangeDateTime( @Nullable final ZonedDateTime recipeLastChangeDateTime )
    {
        rememberChangedField("RecipeLastChangeDateTime", this.recipeLastChangeDateTime);
        this.recipeLastChangeDateTime = recipeLastChangeDateTime;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>RecipeUUID</b>
     * </p>
     *
     * @param recipeUUID
     *            Common Recipe GUID
     */
    public void setRecipeUUID( @Nullable final UUID recipeUUID )
    {
        rememberChangedField("RecipeUUID", this.recipeUUID);
        this.recipeUUID = recipeUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>Recipe</b>
     * </p>
     *
     * @param recipe
     *            Recipe ID
     */
    public void setRecipe( @Nullable final String recipe )
    {
        rememberChangedField("Recipe", this.recipe);
        this.recipe = recipe;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessEquipRqmtPosNmbr</b>
     * </p>
     *
     * @param recipeProcessEquipRqmtPosNmbr
     *            Sequence Number
     */
    public void setRecipeProcessEquipRqmtPosNmbr( @Nullable final String recipeProcessEquipRqmtPosNmbr )
    {
        rememberChangedField("RecipeProcessEquipRqmtPosNmbr", this.recipeProcessEquipRqmtPosNmbr);
        this.recipeProcessEquipRqmtPosNmbr = recipeProcessEquipRqmtPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessStagePosNmbr</b>
     * </p>
     *
     * @param recipeProcessStagePosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessStagePosNmbr( @Nullable final String recipeProcessStagePosNmbr )
    {
        rememberChangedField("RecipeProcessStagePosNmbr", this.recipeProcessStagePosNmbr);
        this.recipeProcessStagePosNmbr = recipeProcessStagePosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessOperationPosNmbr</b>
     * </p>
     *
     * @param recipeProcessOperationPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessOperationPosNmbr( @Nullable final String recipeProcessOperationPosNmbr )
    {
        rememberChangedField("RecipeProcessOperationPosNmbr", this.recipeProcessOperationPosNmbr);
        this.recipeProcessOperationPosNmbr = recipeProcessOperationPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessActionPosNmbr</b>
     * </p>
     *
     * @param recipeProcessActionPosNmbr
     *            ID of a Process Element
     */
    public void setRecipeProcessActionPosNmbr( @Nullable final String recipeProcessActionPosNmbr )
    {
        rememberChangedField("RecipeProcessActionPosNmbr", this.recipeProcessActionPosNmbr);
        this.recipeProcessActionPosNmbr = recipeProcessActionPosNmbr;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RecipeProcessParamSqncNmbr</b>
     * </p>
     *
     * @param recipeProcessParamSqncNmbr
     *            Sequence Number (Format NNNN)
     */
    public void setRecipeProcessParamSqncNmbr( @Nullable final String recipeProcessParamSqncNmbr )
    {
        rememberChangedField("RecipeProcessParamSqncNmbr", this.recipeProcessParamSqncNmbr);
        this.recipeProcessParamSqncNmbr = recipeProcessParamSqncNmbr;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_RecipeProcessParamValueTxt";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("RecipeProcessParamValUUID", getRecipeProcessParamValUUID());
        values.put("Language", getLanguage());
        values.put("RecipeProcessUUID", getRecipeProcessUUID());
        values.put("RecipeProcessParamValueDesc", getRecipeProcessParamValueDesc());
        values.put("RecipeLastChangeDateTime", getRecipeLastChangeDateTime());
        values.put("RecipeUUID", getRecipeUUID());
        values.put("Recipe", getRecipe());
        values.put("RecipeProcessEquipRqmtPosNmbr", getRecipeProcessEquipRqmtPosNmbr());
        values.put("RecipeProcessStagePosNmbr", getRecipeProcessStagePosNmbr());
        values.put("RecipeProcessOperationPosNmbr", getRecipeProcessOperationPosNmbr());
        values.put("RecipeProcessActionPosNmbr", getRecipeProcessActionPosNmbr());
        values.put("RecipeProcessParamSqncNmbr", getRecipeProcessParamSqncNmbr());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("RecipeProcessParamValUUID") ) {
                final Object value = values.remove("RecipeProcessParamValUUID");
                if( (value == null) || (!value.equals(getRecipeProcessParamValUUID())) ) {
                    setRecipeProcessParamValUUID(((UUID) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessUUID") ) {
                final Object value = values.remove("RecipeProcessUUID");
                if( (value == null) || (!value.equals(getRecipeProcessUUID())) ) {
                    setRecipeProcessUUID(((UUID) value));
                }
            }
            if( values.containsKey("RecipeProcessParamValueDesc") ) {
                final Object value = values.remove("RecipeProcessParamValueDesc");
                if( (value == null) || (!value.equals(getRecipeProcessParamValueDesc())) ) {
                    setRecipeProcessParamValueDesc(((String) value));
                }
            }
            if( values.containsKey("RecipeLastChangeDateTime") ) {
                final Object value = values.remove("RecipeLastChangeDateTime");
                if( (value == null) || (!value.equals(getRecipeLastChangeDateTime())) ) {
                    setRecipeLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("RecipeUUID") ) {
                final Object value = values.remove("RecipeUUID");
                if( (value == null) || (!value.equals(getRecipeUUID())) ) {
                    setRecipeUUID(((UUID) value));
                }
            }
            if( values.containsKey("Recipe") ) {
                final Object value = values.remove("Recipe");
                if( (value == null) || (!value.equals(getRecipe())) ) {
                    setRecipe(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessEquipRqmtPosNmbr") ) {
                final Object value = values.remove("RecipeProcessEquipRqmtPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessEquipRqmtPosNmbr())) ) {
                    setRecipeProcessEquipRqmtPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessStagePosNmbr") ) {
                final Object value = values.remove("RecipeProcessStagePosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessStagePosNmbr())) ) {
                    setRecipeProcessStagePosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessOperationPosNmbr") ) {
                final Object value = values.remove("RecipeProcessOperationPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessOperationPosNmbr())) ) {
                    setRecipeProcessOperationPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessActionPosNmbr") ) {
                final Object value = values.remove("RecipeProcessActionPosNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessActionPosNmbr())) ) {
                    setRecipeProcessActionPosNmbr(((String) value));
                }
            }
            if( values.containsKey("RecipeProcessParamSqncNmbr") ) {
                final Object value = values.remove("RecipeProcessParamSqncNmbr");
                if( (value == null) || (!value.equals(getRecipeProcessParamSqncNmbr())) ) {
                    setRecipeProcessParamSqncNmbr(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_RecipeProcessParamValue") ) {
                final Object value = (values).remove("to_RecipeProcessParamValue");
                if( value instanceof Map ) {
                    if( toRecipeProcessParamValue == null ) {
                        toRecipeProcessParamValue = new RecipeProcessParamValue();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toRecipeProcessParamValue.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> RecipeProcessParamValueTxtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new RecipeProcessParamValueTxtField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> RecipeProcessParamValueTxtField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new RecipeProcessParamValueTxtField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toRecipeProcessParamValue != null ) {
            (values).put("to_RecipeProcessParamValue", toRecipeProcessParamValue);
        }
        return values;
    }

    /**
     * Fetches the <b>RecipeProcessParamValue</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>RecipeProcessParamValue</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessParamValue fetchRecipeProcessParamValue()
    {
        return fetchFieldAsSingle("to_RecipeProcessParamValue", RecipeProcessParamValue.class);
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property <b>to_RecipeProcessParamValue</b> of a queried <b>RecipeProcessParamValueTxt</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>RecipeProcessParamValue</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public RecipeProcessParamValue getRecipeProcessParamValueOrFetch()
    {
        if( toRecipeProcessParamValue == null ) {
            toRecipeProcessParamValue = fetchRecipeProcessParamValue();
        }
        return toRecipeProcessParamValue;
    }

    /**
     * Retrieval of associated <b>RecipeProcessParamValue</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_RecipeProcessParamValue</b>.
     * <p>
     * If the navigation property for an entity <b>RecipeProcessParamValueTxt</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_RecipeProcessParamValue</b> is already loaded, the
     *         result will contain the <b>RecipeProcessParamValue</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<RecipeProcessParamValue> getRecipeProcessParamValueIfPresent()
    {
        return Option.of(toRecipeProcessParamValue);
    }

    /**
     * Overwrites the associated <b>RecipeProcessParamValue</b> entity for the loaded navigation property
     * <b>to_RecipeProcessParamValue</b>.
     *
     * @param value
     *            New <b>RecipeProcessParamValue</b> entity.
     */
    public void setRecipeProcessParamValue( final RecipeProcessParamValue value )
    {
        toRecipeProcessParamValue = value;
    }

    /**
     * Helper class to allow for fluent creation of RecipeProcessParamValueTxt instances.
     *
     */
    public final static class RecipeProcessParamValueTxtBuilder
    {

        private RecipeProcessParamValue toRecipeProcessParamValue;

        private RecipeProcessParamValueTxt.RecipeProcessParamValueTxtBuilder toRecipeProcessParamValue(
            final RecipeProcessParamValue value )
        {
            toRecipeProcessParamValue = value;
            return this;
        }

        /**
         * Navigation property <b>to_RecipeProcessParamValue</b> for <b>RecipeProcessParamValueTxt</b> to single
         * <b>RecipeProcessParamValue</b>.
         *
         * @param value
         *            The RecipeProcessParamValue to build this RecipeProcessParamValueTxt with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public RecipeProcessParamValueTxt.RecipeProcessParamValueTxtBuilder recipeProcessParamValue(
            final RecipeProcessParamValue value )
        {
            return toRecipeProcessParamValue(value);
        }

    }

}
