/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link RecipeHeaderAndFormulaServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService
 * RecipeHeaderAndFormulaService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultRecipeHeaderAndFormulaServiceBatch
    extends
    BatchFluentHelperBasic<RecipeHeaderAndFormulaServiceBatch, RecipeHeaderAndFormulaServiceBatchChangeSet>
    implements
    RecipeHeaderAndFormulaServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultRecipeHeaderAndFormulaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRecipeHeaderAndFormulaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultRecipeHeaderAndFormulaServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultRecipeHeaderAndFormulaServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultRecipeHeaderAndFormulaServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultRecipeHeaderAndFormulaServiceBatchChangeSet(this, service);
    }

}
