/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText;

/**
 * Implementation of the {@link RecipeHeaderAndFormulaServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService
 * RecipeHeaderAndFormulaService}.
 *
 */
public class DefaultRecipeHeaderAndFormulaServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<RecipeHeaderAndFormulaServiceBatch, RecipeHeaderAndFormulaServiceBatchChangeSet>
    implements
    RecipeHeaderAndFormulaServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService service;

    @SuppressWarnings( "deprecation" )
    DefaultRecipeHeaderAndFormulaServiceBatchChangeSet(
        @Nonnull final DefaultRecipeHeaderAndFormulaServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultRecipeHeaderAndFormulaServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipe( @Nonnull final Recipe recipe )
    {
        return addRequestCreate(service::createRecipe, recipe);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipe( @Nonnull final Recipe recipe )
    {
        return addRequestUpdate(service::updateRecipe, recipe);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipe( @Nonnull final Recipe recipe )
    {
        return addRequestDelete(service::deleteRecipe, recipe);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return addRequestCreate(service::createRecipeFormulaItem, recipeFormulaItem);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return addRequestUpdate(service::updateRecipeFormulaItem, recipeFormulaItem);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeFormulaItem(
        @Nonnull final RecipeFormulaItem recipeFormulaItem )
    {
        return addRequestDelete(service::deleteRecipeFormulaItem, recipeFormulaItem);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return addRequestCreate(service::createRecipeProcessElement, recipeProcessElement);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return addRequestUpdate(service::updateRecipeProcessElement, recipeProcessElement);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessElement(
        @Nonnull final RecipeProcessElement recipeProcessElement )
    {
        return addRequestDelete(service::deleteRecipeProcessElement, recipeProcessElement);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return addRequestCreate(service::createRecipeProcessElementText, recipeProcessElementText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return addRequestUpdate(service::updateRecipeProcessElementText, recipeProcessElementText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessElementText(
        @Nonnull final RecipeProcessElementText recipeProcessElementText )
    {
        return addRequestDelete(service::deleteRecipeProcessElementText, recipeProcessElementText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return addRequestCreate(service::createRecipeProcessEquipRqmt, recipeProcessEquipRqmt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return addRequestUpdate(service::updateRecipeProcessEquipRqmt, recipeProcessEquipRqmt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessEquipRqmt(
        @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt )
    {
        return addRequestDelete(service::deleteRecipeProcessEquipRqmt, recipeProcessEquipRqmt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return addRequestCreate(service::createRecipeProcessEquipRqmtText, recipeProcessEquipRqmtText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return addRequestUpdate(service::updateRecipeProcessEquipRqmtText, recipeProcessEquipRqmtText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessEquipRqmtText(
        @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText )
    {
        return addRequestDelete(service::deleteRecipeProcessEquipRqmtText, recipeProcessEquipRqmtText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return addRequestCreate(service::createRecipeProcessParamValue, recipeProcessParamValue);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return addRequestUpdate(service::updateRecipeProcessParamValue, recipeProcessParamValue);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessParamValue(
        @Nonnull final RecipeProcessParamValue recipeProcessParamValue )
    {
        return addRequestDelete(service::deleteRecipeProcessParamValue, recipeProcessParamValue);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return addRequestCreate(service::createRecipeProcessParamValueTxt, recipeProcessParamValueTxt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return addRequestUpdate(service::updateRecipeProcessParamValueTxt, recipeProcessParamValueTxt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeProcessParamValueTxt(
        @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt )
    {
        return addRequestDelete(service::deleteRecipeProcessParamValueTxt, recipeProcessParamValueTxt);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeText( @Nonnull final RecipeText recipeText )
    {
        return addRequestCreate(service::createRecipeText, recipeText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeText( @Nonnull final RecipeText recipeText )
    {
        return addRequestUpdate(service::updateRecipeText, recipeText);
    }

    @Nonnull
    @Override
    public RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeText( @Nonnull final RecipeText recipeText )
    {
        return addRequestDelete(service::deleteRecipeText, recipeText);
    }

}
