/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.RecipeHeaderAndFormulaService
 * RecipeHeaderAndFormulaService}.
 *
 */
public interface RecipeHeaderAndFormulaServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<RecipeHeaderAndFormulaServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<RecipeHeaderAndFormulaServiceBatch>
{

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     * entity and save it to the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet createRecipe( @Nonnull final Recipe recipe );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe
     * Recipe} entity and save it to the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipe( @Nonnull final Recipe recipe );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe
     * Recipe} entity in the S/4HANA system.
     *
     * @param recipe
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.Recipe Recipe}
     *            entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipe( @Nonnull final Recipe recipe );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity and save it to the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity and save it to the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     * RecipeFormulaItem} entity in the S/4HANA system.
     *
     * @param recipeFormulaItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
     *            RecipeFormulaItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeFormulaItem( @Nonnull final RecipeFormulaItem recipeFormulaItem );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     * RecipeProcessElement} entity in the S/4HANA system.
     *
     * @param recipeProcessElement
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
     *            RecipeProcessElement} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessElement( @Nonnull final RecipeProcessElement recipeProcessElement );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     * RecipeProcessElementText} entity in the S/4HANA system.
     *
     * @param recipeProcessElementText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElementText
     *            RecipeProcessElementText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessElementText( @Nonnull final RecipeProcessElementText recipeProcessElementText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     * RecipeProcessEquipRqmt} entity in the S/4HANA system.
     *
     * @param recipeProcessEquipRqmt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmt
     *            RecipeProcessEquipRqmt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessEquipRqmt( @Nonnull final RecipeProcessEquipRqmt recipeProcessEquipRqmt );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     * RecipeProcessEquipRqmtText} entity in the S/4HANA system.
     *
     * @param recipeProcessEquipRqmtText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessEquipRqmtText
     *            RecipeProcessEquipRqmtText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessEquipRqmtText( @Nonnull final RecipeProcessEquipRqmtText recipeProcessEquipRqmtText );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     * RecipeProcessParamValue} entity in the S/4HANA system.
     *
     * @param recipeProcessParamValue
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValue
     *            RecipeProcessParamValue} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessParamValue( @Nonnull final RecipeProcessParamValue recipeProcessParamValue );

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        createRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity and save it to the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        updateRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     * RecipeProcessParamValueTxt} entity in the S/4HANA system.
     *
     * @param recipeProcessParamValueTxt
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessParamValueTxt
     *            RecipeProcessParamValueTxt} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet
        deleteRecipeProcessParamValueTxt( @Nonnull final RecipeProcessParamValueTxt recipeProcessParamValueTxt );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity and save it to the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet createRecipeText( @Nonnull final RecipeText recipeText );

    /**
     * Update an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity and save it to the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet updateRecipeText( @Nonnull final RecipeText recipeText );

    /**
     * Deletes an existing {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     * RecipeText} entity in the S/4HANA system.
     *
     * @param recipeText
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeText
     *            RecipeText} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    RecipeHeaderAndFormulaServiceBatchChangeSet deleteRecipeText( @Nonnull final RecipeText recipeText );

}
