/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.EntityLink;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmObject;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable.RecipeCharcSelectable;

/**
 * Template class to represent entity navigation links of
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeCharc RecipeCharc} to other
 * entities. Instances of this object are used in query modifier methods of the entity fluent helpers. Contains methods
 * to compare a field's value with a provided value.
 *
 * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying OData
 * field names, so use the constructor with caution.
 *
 * @param <ObjectT>
 *            Entity type of subclasses from {@link com.sap.cloud.sdk.datamodel.odata.helper.VdmObject VdmObject}.
 *
 */
public class RecipeCharcLink<ObjectT extends VdmObject<?>>
    extends
    EntityLink<RecipeCharcLink<ObjectT>, RecipeCharc, ObjectT>
    implements
    RecipeCharcSelectable
{

    /**
     * Use the constants declared in each entity inner class. Instantiating directly requires knowing the underlying
     * OData field names, so use with caution.
     *
     * @param fieldName
     *            OData navigation field name. Must match the field returned by the underlying OData service.
     */
    public RecipeCharcLink( final String fieldName )
    {
        super(fieldName);
    }

    private RecipeCharcLink( final EntityLink<RecipeCharcLink<ObjectT>, RecipeCharc, ObjectT> toClone )
    {
        super(toClone);
    }

    @Nonnull
    @Override
    protected RecipeCharcLink<ObjectT> translateLinkType(
        final EntityLink<RecipeCharcLink<ObjectT>, RecipeCharc, ObjectT> link )
    {
        return new RecipeCharcLink<ObjectT>(link);
    }

}
