/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc
 * RecProcEquipRqmtClassCharc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecProcEquipRqmtClassCharcField
 * RecProcEquipRqmtClassCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecProcEquipRqmtClassCharcLink
 * RecProcEquipRqmtClassCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#RECIPE_PROCESS_EQUIP_RQMT_UUID
 * RECIPE_PROCESS_EQUIP_RQMT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcEquipRqmtClassCharc#TO_VALUATION
 * TO_VALUATION}</li>
 * </ul>
 *
 */
public interface RecProcEquipRqmtClassCharcSelectable extends EntitySelectable<RecProcEquipRqmtClassCharc>
{

}
