/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc
 * RecProcParamValCharc}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecProcParamValCharcField
 * RecProcParamValCharcField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecProcParamValCharcLink
 * RecProcParamValCharcLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc#RECIPE_PROCESS_PARAM_VAL_UUID
 * RECIPE_PROCESS_PARAM_VAL_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecProcParamValCharc#TO_VALUATION
 * TO_VALUATION}</li>
 * </ul>
 *
 */
public interface RecProcParamValCharcSelectable extends EntitySelectable<RecProcParamValCharc>
{

}
