/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem
 * RecipeFormulaItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeFormulaItemField
 * RecipeFormulaItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeFormulaItemLink
 * RecipeFormulaItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_UUID
 * RCP_FMLA_ITEM_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_UUID
 * RCP_FMLA_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_POSITION
 * RCP_FMLA_ITEM_POSITION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_TYPE
 * RCP_FMLA_ITEM_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#SPECIFICATION_INTERNAL_ID
 * SPECIFICATION_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#SPECIFICATION
 * SPECIFICATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#MATERIAL
 * MATERIAL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_COMPONENT_TYPE
 * RCP_FMLA_ITEM_COMPONENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_LOWER_LIMIT
 * RCP_FMLA_ITEM_LOWER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_UPPER_LIMIT
 * RCP_FMLA_ITEM_UPPER_LIMIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_QUANTITY
 * RCP_FMLA_ITEM_QUANTITY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_UNIT
 * RCP_FMLA_ITEM_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_EXCEPTION_CODE
 * RCP_FMLA_ITEM_EXCEPTION_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_SCRAP_IN_PERCENT
 * RCP_FMLA_ITEM_SCRAP_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_OVERRUN_IN_PERCENT
 * RCP_FMLA_ITEM_OVERRUN_IN_PERCENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_QUANTITY_IN_KILOGRAM
 * RCP_FMLA_ITEM_QUANTITY_IN_KILOGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_IS_SELECTED_FOR_CALC
 * RCP_FMLA_ITEM_IS_SELECTED_FOR_CALC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_EXPLOSION_RECIPE_UUID
 * RCP_FMLA_ITEM_EXPLOSION_RECIPE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_IS_BALANCING_ITEM
 * RCP_FMLA_ITEM_IS_BALANCING_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_FMLA_ITEM_ALTV_IS_USED
 * RECIPE_FMLA_ITEM_ALTV_IS_USED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_UUID
 * RECIPE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#SPECIFICATION_TYPE
 * SPECIFICATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#SPECIFICATION_AUTHZN_GROUP
 * SPECIFICATION_AUTHZN_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_ELEMENT_UUID
 * RECIPE_PROCESS_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_STAGE_UUID
 * RECIPE_PROCESS_STAGE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_OPERATION_UUID
 * RECIPE_PROCESS_OPERATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_ACTION_UUID
 * RECIPE_PROCESS_ACTION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_STAGE_POS_NMBR
 * RECIPE_PROCESS_STAGE_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_OPERATION_POS_NMBR
 * RECIPE_PROCESS_OPERATION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_PROCESS_ACTION_POS_NMBR
 * RECIPE_PROCESS_ACTION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE_LAST_CHANGE_DATE_TIME
 * RECIPE_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RECIPE
 * RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#RCP_FMLA_ITEM_ALTERNATIVE_ITEM_POS
 * RCP_FMLA_ITEM_ALTERNATIVE_ITEM_POS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#TO_RECIPE
 * TO_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#TO_EXPLOSION_RECIPE
 * TO_EXPLOSION_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeFormulaItem#TO_RECIPE_PROCESS_ELEMENT
 * TO_RECIPE_PROCESS_ELEMENT}</li>
 * </ul>
 *
 */
public interface RecipeFormulaItemSelectable extends EntitySelectable<RecipeFormulaItem>
{

}
