/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement
 * RecipeProcessElement}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.field.RecipeProcessElementField
 * RecipeProcessElementField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.link.RecipeProcessElementLink
 * RecipeProcessElementLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#DELETE_MC
 * DELETE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#UPDATE_MC
 * UPDATE_MC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_ELEMENT_UUID
 * RECIPE_PROCESS_ELEMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_UUID
 * RECIPE_PROCESS_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_ELEMENT_TYPE
 * RECIPE_PROCESS_ELEMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_ELEMENT_PARENT_UUID
 * RECIPE_PROCESS_ELEMENT_PARENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_ELEMENT_POS_NMBR
 * RECIPE_PROCESS_ELEMENT_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_LAST_CHANGE_DATE_TIME
 * RECIPE_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_UUID
 * RECIPE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE
 * RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_STAGE_POS_NMBR
 * RECIPE_PROCESS_STAGE_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_OPERATION_POS_NMBR
 * RECIPE_PROCESS_OPERATION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#RECIPE_PROCESS_ACTION_POS_NMBR
 * RECIPE_PROCESS_ACTION_POS_NMBR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE
 * TO_RECIPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_FORMULA_ITEM
 * TO_FORMULA_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE_PROCESS_ELEMENT_CHILD
 * TO_RECIPE_PROCESS_ELEMENT_CHILD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE_PROCESS_ELEMENT_PARENT
 * TO_RECIPE_PROCESS_ELEMENT_PARENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE_PROCESS_ELEMENT_TEXT
 * TO_RECIPE_PROCESS_ELEMENT_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE_PROCESS_EQUIP_RQMT
 * TO_RECIPE_PROCESS_EQUIP_RQMT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.recipeheaderandformula.RecipeProcessElement#TO_RECIPE_PROCESS_PARAM_VALUE
 * TO_RECIPE_PROCESS_PARAM_VALUE}</li>
 * </ul>
 *
 */
public interface RecipeProcessElementSelectable extends EntitySelectable<RecipeProcessElement>
{

}
